/*
 * Decompiled with CFR 0.152.
 */
package common.comunications;

import common.comunications.CNXSender;
import common.comunications.InfoSocket;
import common.comunications.PackageToXML;
import common.comunications.PingPackage;
import common.comunications.SocketConnector;
import common.misc.settings.ConfigFileHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class SocketWriterClient {
    public static int maxClosed = 0;
    private static PingPackage ping;
    private static ByteBuffer myAppData;
    private static ByteBuffer myNetData;
    private static ByteBuffer peerAppData;
    private static ByteBuffer peerNetData;
    private static ExecutorService executor;

    public static void writing(SocketChannel sock, String data) {
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(data.getBytes());
        SSLEngine engine = SocketConnector.getEngine();
        if (engine != null) {
            SocketWriterClient.sendBuffer(sock, engine, bufferIn);
        } else {
            SocketWriterClient.sendBuffer(sock, bufferIn);
        }
    }

    public static void writing(SocketChannel sock, ByteArrayOutputStream data) {
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(data.toByteArray());
        SSLEngine engine = SocketConnector.getEngine();
        if (engine != null) {
            SocketWriterClient.sendBuffer(sock, engine, bufferIn);
        } else {
            SocketWriterClient.sendBuffer(sock, bufferIn);
        }
    }

    public static boolean writing(SocketChannel sock, Document doc) {
        try {
            ByteArrayOutputStream bufferOut = new ByteArrayOutputStream();
            XMLOutputter xmlOutputter = new XMLOutputter();
            xmlOutputter.output(doc, (OutputStream)bufferOut);
            bufferOut.write(new String("\f").getBytes());
            ByteArrayInputStream bufferIn = new ByteArrayInputStream(bufferOut.toByteArray());
            bufferOut.close();
            bufferOut = null;
            SSLEngine engine = SocketConnector.getEngine();
            if (engine != null) {
                return SocketWriterClient.sendBuffer(sock, engine, bufferIn);
            }
            return SocketWriterClient.sendBuffer(sock, bufferIn);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean writing(SocketChannel sock, SSLEngine engine, Document doc) {
        try {
            SSLSession session = engine.getSession();
            myAppData = ByteBuffer.allocate(1024);
            myNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            peerAppData = ByteBuffer.allocate(1024);
            peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            myAppData.clear();
            ByteArrayOutputStream bufferOut = new ByteArrayOutputStream();
            XMLOutputter xmlOutputter = new XMLOutputter();
            xmlOutputter.output(doc, (OutputStream)bufferOut);
            bufferOut.write(new String("\f").getBytes());
            myAppData.put(bufferOut.toByteArray());
            myAppData.flip();
            block8: while (myAppData.hasRemaining()) {
                myNetData.clear();
                SSLEngineResult result = engine.wrap(myAppData, myNetData);
                switch (result.getStatus()) {
                    case OK: {
                        myNetData.flip();
                        while (myNetData.hasRemaining()) {
                            sock.write(myNetData);
                        }
                        continue block8;
                    }
                    case BUFFER_OVERFLOW: {
                        myNetData = SocketWriterClient.enlargePacketBuffer(engine, myNetData);
                        continue block8;
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                    }
                    case CLOSED: {
                        SocketWriterClient.closeConnection(sock, engine);
                        return false;
                    }
                }
                throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void closeConnection(SocketChannel socketChannel, SSLEngine engine) throws IOException {
        engine.closeOutbound();
        SocketWriterClient.doHandshake(socketChannel, engine);
        socketChannel.close();
    }

    public static ByteBuffer enlargePacketBuffer(SSLEngine engine, ByteBuffer buffer) {
        return SocketWriterClient.enlargeBuffer(buffer, engine.getSession().getPacketBufferSize());
    }

    public static ByteBuffer enlargeApplicationBuffer(SSLEngine engine, ByteBuffer buffer) {
        return SocketWriterClient.enlargeBuffer(buffer, engine.getSession().getApplicationBufferSize());
    }

    public static ByteBuffer enlargeBuffer(ByteBuffer buffer, int sessionProposedCapacity) {
        buffer = sessionProposedCapacity > buffer.capacity() ? ByteBuffer.allocate(sessionProposedCapacity) : ByteBuffer.allocate(buffer.capacity() * 2);
        return buffer;
    }

    public static boolean doHandshake(SocketChannel socketChannel, SSLEngine engine) throws IOException {
        System.out.println("About to do handshake...");
        int appBufferSize = engine.getSession().getApplicationBufferSize();
        ByteBuffer myAppData = ByteBuffer.allocate(appBufferSize);
        ByteBuffer peerAppData = ByteBuffer.allocate(appBufferSize);
        myNetData.clear();
        peerNetData.clear();
        SSLEngineResult.HandshakeStatus handshakeStatus = engine.getHandshakeStatus();
        block27: while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    SSLEngineResult result;
                    if (socketChannel.read(peerNetData) < 0) {
                        if (engine.isInboundDone() && engine.isOutboundDone()) {
                            return false;
                        }
                        try {
                            engine.closeInbound();
                        }
                        catch (SSLException e) {
                            System.out.println("This engine was forced to close inbound, without having received the proper SSL/TLS close notification message from the peer, due to end of stream.");
                        }
                        engine.closeOutbound();
                        handshakeStatus = engine.getHandshakeStatus();
                        continue block27;
                    }
                    peerNetData.flip();
                    try {
                        result = engine.unwrap(peerNetData, peerAppData);
                        peerNetData.compact();
                        handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException sslException) {
                        System.out.println("A problem was encountered while processing the data that caused the SSLEngine to abort. Will try to properly close connection...");
                        engine.closeOutbound();
                        handshakeStatus = engine.getHandshakeStatus();
                        continue block27;
                    }
                    switch (result.getStatus()) {
                        case OK: {
                            continue block27;
                        }
                        case BUFFER_OVERFLOW: {
                            peerAppData = SocketWriterClient.enlargeApplicationBuffer(engine, peerAppData);
                            continue block27;
                        }
                        case BUFFER_UNDERFLOW: {
                            peerNetData = SocketWriterClient.handleBufferUnderflow(engine, peerNetData);
                            continue block27;
                        }
                        case CLOSED: {
                            if (engine.isOutboundDone()) {
                                return false;
                            }
                            engine.closeOutbound();
                            handshakeStatus = engine.getHandshakeStatus();
                            continue block27;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
                case NEED_WRAP: {
                    SSLEngineResult result;
                    myNetData.clear();
                    try {
                        result = engine.wrap(myAppData, myNetData);
                        handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException sslException) {
                        System.out.println("A problem was encountered while processing the data that caused the SSLEngine to abort. Will try to properly close connection...");
                        engine.closeOutbound();
                        handshakeStatus = engine.getHandshakeStatus();
                        continue block27;
                    }
                    switch (result.getStatus()) {
                        case OK: {
                            myNetData.flip();
                            while (myNetData.hasRemaining()) {
                                socketChannel.write(myNetData);
                            }
                            continue block27;
                        }
                        case BUFFER_OVERFLOW: {
                            myNetData = SocketWriterClient.enlargePacketBuffer(engine, myNetData);
                            continue block27;
                        }
                        case BUFFER_UNDERFLOW: {
                            throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                        }
                        case CLOSED: {
                            try {
                                myNetData.flip();
                                while (myNetData.hasRemaining()) {
                                    socketChannel.write(myNetData);
                                }
                                peerNetData.clear();
                            }
                            catch (Exception e) {
                                System.out.println("Failed to send server's CLOSE message due to socket channel's failure.");
                                handshakeStatus = engine.getHandshakeStatus();
                            }
                            continue block27;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = engine.getDelegatedTask()) != null) {
                        executor.execute(task);
                    }
                    handshakeStatus = engine.getHandshakeStatus();
                    continue block27;
                }
                case FINISHED: {
                    continue block27;
                }
                case NOT_HANDSHAKING: {
                    continue block27;
                }
            }
            throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)handshakeStatus));
        }
        return true;
    }

    public static boolean sendBuffer(SocketChannel sock, SSLEngine engine, ByteArrayInputStream buffer) {
        try {
            SSLSession session = engine.getSession();
            myAppData = ByteBuffer.allocate(1024);
            myNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            peerAppData = ByteBuffer.allocate(1024);
            peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            int count = 0;
            while (count >= 0) {
                myAppData.clear();
                byte[] bytes = new byte[1024];
                count = buffer.read(bytes);
                for (int i = 0; i < count; ++i) {
                    myAppData.put(bytes[i]);
                }
                myAppData.flip();
                block10: while (myAppData.hasRemaining()) {
                    myNetData.clear();
                    SSLEngineResult result = engine.wrap(myAppData, myNetData);
                    switch (result.getStatus()) {
                        case OK: {
                            myNetData.flip();
                            while (myNetData.hasRemaining()) {
                                sock.write(myNetData);
                            }
                            continue block10;
                        }
                        case BUFFER_OVERFLOW: {
                            myNetData = SocketWriterClient.enlargePacketBuffer(engine, myNetData);
                            continue block10;
                        }
                        case BUFFER_UNDERFLOW: {
                            throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                        }
                        case CLOSED: {
                            SocketWriterClient.closeConnection(sock, engine);
                            return false;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean sendBuffer(SocketChannel sock, ByteArrayInputStream buffer) {
        try {
            ByteBuffer buf = ByteBuffer.allocate(8192);
            byte[] bytes = new byte[8192];
            int count = 0;
            while (count >= 0) {
                buf.clear();
                count = buffer.read(bytes);
                for (int i = 0; i < count; ++i) {
                    buf.put(bytes[i]);
                }
                buf.flip();
                ByteBuffer lastBuf = ByteBuffer.allocate(8192);
                ByteBuffer sameBuf = ByteBuffer.allocate(8192);
                boolean repeat = false;
                while (buf.remaining() > 0) {
                    lastBuf = buf;
                    sock.write(buf);
                }
                if (buf.remaining() <= 0) continue;
                System.out.println("Se cancelo escritura por problemas con el socket y se cerrara");
                InfoSocket.removeSock(sock);
                return false;
            }
            return true;
        }
        catch (NotYetConnectedException NYCEe) {
            System.out.println("El canal no tiene enlace de conexion");
            NYCEe.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            SocketWriterClient.reconect();
            buffer.reset();
            System.out.println("reenviando paquete");
            return SocketWriterClient.sendBuffer(SocketConnector.getSock(), buffer);
        }
        catch (ClosedByInterruptException CBIEe) {
            System.out.println("El canal fue interrumpido y se cerro mientras escribia");
            CBIEe.printStackTrace();
            return false;
        }
        catch (AsynchronousCloseException ACEe) {
            System.out.println("El canal fue cerrado mientras escribia");
            ACEe.printStackTrace();
            return false;
        }
        catch (ClosedChannelException e) {
            System.out.println("se a perdido la conexion y el canal estaba cerrado");
            e.printStackTrace();
            System.out.println("eliminando canal");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            if (maxClosed++ < 5) {
                if (ping != null) {
                    ping.stop();
                }
                SocketWriterClient.reconect();
                buffer.reset();
                System.out.println("reenviando paquete " + maxClosed);
                return SocketWriterClient.sendBuffer(SocketConnector.getSock(), buffer);
            }
            maxClosed = 0;
            System.out.println("maximo de 5 intentos, no se reintenta reconexion");
            return false;
        }
        catch (IOException e) {
            System.out.println("Error de entrada y salida en escritura de socket socket close");
            e.printStackTrace();
            SocketConnector.closeSocket();
            ping.stop();
            return false;
        }
    }

    public static ByteBuffer handleBufferUnderflow(SSLEngine engine, ByteBuffer buffer) {
        if (buffer.position() < buffer.limit()) {
            return buffer;
        }
        ByteBuffer replaceBuffer = SocketWriterClient.enlargePacketBuffer(engine, buffer);
        buffer.flip();
        replaceBuffer.put(buffer);
        return replaceBuffer;
    }

    public static synchronized boolean reconect() {
        SocketChannel sock = SocketConnector.getSock();
        System.out.println("esta conectado? " + sock.isConnected());
        if (!sock.isConnected()) {
            System.out.println("reconectando..");
            PackageToXML packageXML = new PackageToXML();
            System.out.println("instanciandos client y package ");
            SocketChannel socket = null;
            try {
                SocketConnector socketConnector;
                System.out.println("Reconectando..");
                while (true) {
                    try {
                        if (SocketConnector.getProtocol() != null) {
                            System.out.println("Reconectando TLSv1");
                            socketConnector = new SocketConnector("TLSv1", ConfigFileHandler.getHost(), ConfigFileHandler.getServerPort(), packageXML);
                            break;
                        }
                        System.out.println("Reconectando socket plano");
                        socketConnector = new SocketConnector(ConfigFileHandler.getHost(), ConfigFileHandler.getServerPort(), packageXML);
                    }
                    catch (ConnectException CEe) {
                        try {
                            Thread.sleep(500L);
                            System.out.print("*");
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
                System.out.println("Lanzando nuevo hilo");
                Thread threadSocket = new Thread(socketConnector);
                threadSocket.start();
                socket = SocketConnector.getSock();
                System.out.println("enviando paquete para reconexion en: " + socket.isConnected());
                SocketWriterClient.writing(socket, CNXSender.getPackage("RCNX", socketConnector.getDatabase(), socketConnector.getUser(), socketConnector.getPassword(), socketConnector.getIp(), socketConnector.getMac()));
                System.out.println("reescribiendo...");
                ping = new PingPackage(SocketConnector.getSock());
                ping.start();
            }
            catch (UnresolvedAddressException e1) {
                e1.printStackTrace();
                System.out.println("imposible reconectar por e1");
            }
            return true;
        }
        System.out.println("Reconeccion anterior exitosa...");
        return false;
    }

    static {
        executor = Executors.newSingleThreadExecutor();
    }
}

