/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import common.gui.components.AnswerEvent;
import common.gui.components.AnswerListener;
import common.gui.components.EmakuTouchField;
import common.gui.forms.GenericForm;
import common.transactions.TransactionServerException;
import common.transactions.TransactionServerResultSet;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import org.jdom.Document;

public class CreditCardButtons
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8559552850464433710L;
    private GenericForm genericForm;
    private EmakuTouchField emakuTouchField;
    private Vector<String> sqlCode;
    private Vector<AnswerListener> answerListener = new Vector();
    private JButton[][] ccButtons = new JButton[][]{{new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_american_express_100x65.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_diners_100x65.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_mastercard_100x65.png")))}, {new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_visa_100x65.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_visa_electron_100x65.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_american_debito_100x65.png")))}, {new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_maestro_debito_100x65.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_mastercard_debito_100x65.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_visa_debito_100x65.png")))}};
    private JButton[][] buttons = new JButton[][]{{new JButton("7"), new JButton("8"), new JButton("9")}, {new JButton("4"), new JButton("5"), new JButton("6")}, {new JButton("1"), new JButton("2"), new JButton("3")}, {new JButton("0"), new JButton("00"), new JButton("000")}, {new JButton("C"), new JButton("<<"), new JButton("X")}};
    private String importValueButton;
    private String keyValue;

    public CreditCardButtons(GenericForm genericForm, Vector<String> sqlCodeCard, EmakuTouchField emakuTouchField, Font font, String importValueButton, String keyValue) {
        this.genericForm = genericForm;
        this.emakuTouchField = emakuTouchField;
        this.importValueButton = importValueButton;
        this.keyValue = keyValue;
        this.sqlCode = sqlCodeCard;
        JPanel cards = new JPanel(new GridLayout(3, 3));
        int i = 0;
        JButton[][] jButtonArray = this.ccButtons;
        int n = jButtonArray.length;
        for (int j = 0; j < n; ++j) {
            JButton[] row;
            for (JButton col : row = jButtonArray[j]) {
                cards.add(col);
                col.addActionListener(this);
                col.setName(i++ + "");
            }
        }
        JPanel matriz = new JPanel(new GridLayout(5, 3));
        Font num = new Font("Dialog", 1, 30);
        JButton[][] jButtonArray2 = this.buttons;
        int n2 = jButtonArray2.length;
        for (int j = 0; j < n2; ++j) {
            JButton[] row;
            for (JButton col : row = jButtonArray2[j]) {
                if (col == null) continue;
                matriz.add(col);
                col.setFont(num);
                col.addActionListener(this);
            }
        }
        this.add((Component)cards, "East");
        this.add((Component)matriz, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton b = (JButton)e.getSource();
        String value = b.getText();
        if ("".equals(value)) {
            System.out.println("b.name: " + b.getName());
            this.genericForm.setExternalValues((Object)this.keyValue, b.getName());
            if (this.emakuTouchField.getText().equals("") || this.emakuTouchField.getText().equals("0")) {
                this.emakuTouchField.doFormat(this.genericForm.getExteralValues(this.importValueButton));
            } else {
                this.emakuTouchField.doFormat();
            }
            for (int i = 0; i < this.sqlCode.size(); ++i) {
                Document doc = null;
                String sql = this.sqlCode.get(i);
                try {
                    doc = TransactionServerResultSet.getResultSetST(sql, new String[]{b.getName()});
                }
                catch (TransactionServerException te) {
                    te.printStackTrace();
                }
                AnswerEvent event = new AnswerEvent(this, sql, doc);
                this.notificando(event);
            }
        } else if ("X".equals(value)) {
            this.emakuTouchField.setText("0");
            this.emakuTouchField.doFormat();
        } else if ("C".equals(value)) {
            this.emakuTouchField.setText("");
        } else if ("<<".equals(value)) {
            try {
                int offset = this.emakuTouchField.getText().length();
                this.emakuTouchField.getDocument().remove(offset - 1, 1);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                int offset = this.emakuTouchField.getText().length();
                this.emakuTouchField.getDocument().insertString(offset, value, null);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void addAnswerListener(AnswerListener listener) {
        this.answerListener.addElement(listener);
    }

    public void removeAnswerListener(AnswerListener listener) {
        this.answerListener.removeElement(listener);
    }

    private void notificando(AnswerEvent event) {
        for (AnswerListener l : this.answerListener) {
            if (!l.containSqlCode(event.getSqlCode())) continue;
            l.arriveAnswerEvent(event);
        }
    }
}

