/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import com.visa.tef.controller.IDataManager;
import com.visa.tef.controller.ITefAuthorizationManager;
import com.visa.tef.controller.PlainDataManager;
import com.visa.tef.controller.TEFTransactionManager;
import com.visa.tef.controller.comm.AuthorizationWorkerMonitor;
import com.visa.tef.controller.comm.TEFAuthorizationWorker;
import common.comunications.SocketConnector;
import common.gui.components.AnswerEvent;
import common.gui.components.AnswerListener;
import common.gui.components.Components;
import common.gui.components.Couplable;
import common.gui.components.CredibancoEvent;
import common.gui.components.CredibancoListener;
import common.gui.components.JSONXMLEvent;
import common.gui.components.RecordEvent;
import common.gui.components.RecordListener;
import common.gui.components.VoidPackageException;
import common.gui.forms.EndEventGenerator;
import common.gui.forms.GenericForm;
import common.gui.forms.NotFoundComponentException;
import common.misc.language.Language;
import common.services.CredibancoServices;
import common.transactions.TransactionServerException;
import common.transactions.TransactionServerResultSet;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class EmakuCredibancoButton
extends JPanel
implements Couplable,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton JBcredibanco;
    private JButton JBrecuperar;
    private GenericForm gfforma;
    private String importValueBase;
    private String importValueIVA;
    private String importValueTotal;
    private boolean notifySaved;
    private String sqlDatafono;
    private String exportFranquicia;
    private String exportReteFuente;
    private String exportReteIVA;
    private String exportComision;
    private String exportTarjeta;
    private String datafono;
    private String sqlCodeFranquicias;
    private String exportVoucher;
    private String exportCtaBanco;
    private String exportCtaGasto;
    private String exportCtaReteFuente;
    private String exportCtaReteIVA;
    private String exportIdTerceroBanco;
    private String exportOperador;
    private boolean annulVoucher;
    private String anullRequest;
    private String numberVoucher;
    private String transactionCode;
    private String messageStatus;
    private String barButtons;
    private String exportRRN;
    private String pagoParcial;
    private String exportFourNumbers;
    private String exportAuth;
    private boolean parcialPay;
    private boolean annulAndPay;
    private Vector<String> driverEvent;
    private Vector<String> keySQL;
    private boolean sendContabRecord;
    private boolean sendPrinterRecord;
    private String host;
    private Hashtable<String, InfoFranquicia> franquicias = new Hashtable();
    private Vector<CredibancoListener> credibancoListener = new Vector();
    private ArrayList<RecordListener> recordListener = new ArrayList();
    private ArrayList<String> cleanComponents = new ArrayList();
    private Vector<ValidComponents> validations = new Vector();
    private Vector<Components> externalValidations;

    public EmakuCredibancoButton(GenericForm form, Document doc) {
        this.gfforma = form;
        this.driverEvent = new Vector();
        this.externalValidations = new Vector();
        this.keySQL = new Vector();
        Iterator i = doc.getRootElement().getChildren("arg").iterator();
        Iterator v = doc.getRootElement().getChildren("validations").iterator();
        Iterator ev = doc.getRootElement().getChildren("externalValidations").iterator();
        while (i.hasNext()) {
            String id;
            Element elm = (Element)i.next();
            String atributo = elm.getAttributeValue("attribute");
            String valor = elm.getValue();
            if ("sqlCodeDatafono".equals(atributo)) {
                this.sqlDatafono = valor;
            }
            if ("driverEvent".equals(elm.getAttributeValue("attribute"))) {
                id = "";
                if (elm.getAttributeValue("id") != null) {
                    id = elm.getAttributeValue("id");
                }
                if (this.driverEvent.contains(elm.getValue() + id)) continue;
                this.driverEvent.addElement(elm.getValue() + id);
                continue;
            }
            if ("keySQL".equals(elm.getAttributeValue("attribute"))) {
                this.keySQL.addElement(elm.getValue());
                continue;
            }
            if ("importValueBase".equals(atributo)) {
                this.importValueBase = valor;
                continue;
            }
            if ("importValueIVA".equals(atributo)) {
                this.importValueIVA = valor;
                continue;
            }
            if ("importValueTotal".equals(atributo)) {
                this.importValueTotal = valor;
                continue;
            }
            if ("notifySaved".equals(atributo)) {
                this.notifySaved = Boolean.parseBoolean(valor);
                continue;
            }
            if ("exportValueFranquicia".equals(atributo)) {
                this.exportFranquicia = valor;
                continue;
            }
            if ("exportValueReteFuente".equals(atributo)) {
                this.exportReteFuente = valor;
                this.gfforma.setExternalValues((Object)this.exportReteFuente, 0.0);
                continue;
            }
            if ("exportValueReteIVA".equals(atributo)) {
                this.exportReteIVA = valor;
                this.gfforma.setExternalValues((Object)this.exportReteIVA, 0.0);
                continue;
            }
            if ("exportValueTarjeta".equals(atributo)) {
                this.exportTarjeta = valor;
                continue;
            }
            if ("exportValueOperador".equals(atributo)) {
                this.exportOperador = valor;
                this.gfforma.setExternalValues((Object)this.exportOperador, "CR");
                continue;
            }
            if ("exportValueComision".equals(atributo)) {
                this.exportComision = valor;
                this.gfforma.setExternalValues((Object)this.exportComision, 0.0);
                continue;
            }
            if ("exportValueCtaBanco".equals(atributo)) {
                this.exportCtaBanco = valor;
                continue;
            }
            if ("exportValueCtaGasto".equals(atributo)) {
                this.exportCtaGasto = valor;
                continue;
            }
            if ("exportValueCtaReteFuente".equals(atributo)) {
                this.exportCtaReteFuente = valor;
                continue;
            }
            if ("exportValueCtaReteIVA".equals(atributo)) {
                this.exportCtaReteIVA = valor;
                continue;
            }
            if ("exportValueIdTerceroBanco".equals(atributo)) {
                this.exportIdTerceroBanco = valor;
                continue;
            }
            if ("exportValueAuth".equals(atributo)) {
                this.exportAuth = valor;
                continue;
            }
            if ("exportValueFourNumbers".equals(atributo)) {
                this.exportFourNumbers = valor;
                continue;
            }
            if ("exportValueVoucher".equals(atributo)) {
                this.exportVoucher = valor;
                this.gfforma.setExternalValues((Object)this.exportVoucher, "");
                continue;
            }
            if ("sqlCodeFranquicias".equals(atributo)) {
                this.sqlCodeFranquicias = valor;
                continue;
            }
            if ("cleanComponent".equals(atributo)) {
                id = "";
                if (elm.getAttributeValue("id") != null) {
                    id = elm.getAttributeValue("id");
                }
                if (this.cleanComponents.contains(valor + id)) continue;
                this.cleanComponents.add(valor + id);
                continue;
            }
            if ("barButtons".equals(atributo)) {
                id = "";
                if (elm.getAttributeValue("id") != null) {
                    id = elm.getAttributeValue("id");
                    System.out.println("id: " + id);
                }
                this.barButtons = valor + id;
                System.out.println("barButtons: " + this.barButtons);
                continue;
            }
            if ("annulVoucher".equals(atributo)) {
                this.annulVoucher = Boolean.parseBoolean(valor);
                continue;
            }
            if ("exportValueRequest".equals(atributo)) {
                this.anullRequest = valor;
                continue;
            }
            if ("importValueVoucher".equals(atributo)) {
                this.numberVoucher = valor;
                continue;
            }
            if ("exportValueTransactionCode".equals(atributo)) {
                this.transactionCode = valor;
                continue;
            }
            if ("importValueTransactionCode".equals(atributo)) {
                this.transactionCode = valor;
                continue;
            }
            if ("exportValueDataphoneStatus".equals(atributo)) {
                this.messageStatus = valor;
                continue;
            }
            if ("exportValueRRN".equals(atributo)) {
                this.exportRRN = valor;
                continue;
            }
            if ("importValuePagoParcial".equals(atributo)) {
                this.pagoParcial = valor;
                continue;
            }
            if ("parcialPay".equals(atributo)) {
                this.parcialPay = Boolean.parseBoolean(valor);
                continue;
            }
            if ("annulAndPay".equals(atributo)) {
                this.annulAndPay = Boolean.parseBoolean(valor);
                continue;
            }
            if ("sendContabRecord".equals(atributo)) {
                this.sendContabRecord = Boolean.parseBoolean(valor);
                continue;
            }
            if (!"sendPrinterRecord".equals(atributo)) continue;
            this.sendPrinterRecord = Boolean.parseBoolean(valor);
        }
        this.gfforma.addInitiateFinishListener(this);
        this.loadValidations(v);
        this.setExternalValidations(ev);
        this.loadFranquicias();
        System.out.println("*********** Instanciando boton de credibanco...");
        this.JBcredibanco = new JButton(new ImageIcon(this.getClass().getResource("/icons/credibanco_32x32.png")));
        this.JBrecuperar = new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_recargar_32x32.png")));
        KeyStroke keyStroke = this.parcialPay ? KeyStroke.getKeyStroke("F10") : KeyStroke.getKeyStroke("F6");
        int condition = 2;
        InputMap inputMap = this.JBcredibanco.getInputMap(condition);
        ActionMap actionMap = this.JBcredibanco.getActionMap();
        inputMap.put(keyStroke, keyStroke.toString());
        actionMap.put(keyStroke.toString(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EmakuCredibancoButton.this.JBcredibanco.doClick();
            }
        });
        this.JBcredibanco.setActionCommand("save");
        this.JBcredibanco.addActionListener(this);
        this.JBrecuperar.addActionListener(this);
        this.JBrecuperar.setEnabled(false);
        this.JBrecuperar.setActionCommand("recover");
        this.setLayout(new FlowLayout());
        this.add(this.JBcredibanco);
        this.add(this.JBrecuperar);
        this.datafono = this.getDatafono();
        this.host = this.gfforma.getExternalValueString("hostName");
        if (this.host == null || this.host.equals("Sin registro")) {
            this.displayError("El equipo no se encuentra correctamente registrado", false);
        }
        if (this.datafono == null) {
            this.displayError("No existe datafono de credibanco registrado para esta caja", false);
        }
    }

    private void loadValidations(Iterator v) {
        while (v.hasNext()) {
            for (Element comp : ((Element)v.next()).getChildren("component")) {
                this.validations.add(this.loadComponent(comp));
            }
        }
    }

    private ValidComponents loadComponent(Element elm) {
        Iterator i = elm.getChildren().iterator();
        ValidComponents comp = new ValidComponents();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (name.equals("driver")) {
                if (e.getAttributeValue("id") != null) {
                    comp.setDriver(e.getValue() + e.getAttributeValue("id"));
                    continue;
                }
                comp.setDriver(e.getValue());
                continue;
            }
            if (name.equals("method")) {
                comp.setMethod(e.getValue());
                continue;
            }
            if (!name.equals("parameters")) continue;
            comp.setArgs(e);
        }
        return comp;
    }

    private void setExternalValidations(Iterator i) {
        while (i.hasNext()) {
            Element e = (Element)i.next();
            this.loadExternalValidations(e);
        }
    }

    private void loadExternalValidations(Element elm) {
        Iterator i = elm.getChildren().iterator();
        Components comp = null;
        while (i.hasNext()) {
            Element ecomp = (Element)i.next();
            Iterator j = ecomp.getChildren().iterator();
            comp = new Components();
            while (j.hasNext()) {
                Element e = (Element)j.next();
                String name = e.getName();
                if (name.equals("driver")) {
                    if (e.getAttributeValue("id") != null) {
                        comp.setDriver(e.getValue() + e.getAttributeValue("id"));
                        continue;
                    }
                    comp.setDriver(e.getValue());
                    continue;
                }
                if (name.equals("method")) {
                    comp.setMethod(e.getValue());
                    continue;
                }
                if (!name.equals("parameters")) continue;
                comp.setArgs(e);
            }
            this.externalValidations.add(comp);
        }
    }

    private void loadFranquicias() {
        try {
            Document doc = TransactionServerResultSet.getResultSetST(this.sqlCodeFranquicias);
            List data = doc.getRootElement().getChildren("row");
            for (Element e : data) {
                Iterator j = e.getChildren().iterator();
                String nombre = ((Element)j.next()).getValue();
                String tipo = ((Element)j.next()).getValue().trim();
                int idFranquicia = Integer.parseInt(((Element)j.next()).getValue().trim());
                double comision = Double.parseDouble(((Element)j.next()).getValue().trim());
                String ctaBanco = ((Element)j.next()).getValue().trim();
                String ctaGasto = ((Element)j.next()).getValue().trim();
                String ctaReteFuente = ((Element)j.next()).getValue().trim();
                String ctaReteIVA = ((Element)j.next()).getValue().trim();
                String idCtaBanco = ((Element)j.next()).getValue().trim();
                String idTerceroBanco = ((Element)j.next()).getValue().trim();
                double pretefuente = Double.parseDouble(((Element)j.next()).getValue());
                double preteiva = Double.parseDouble(((Element)j.next()).getValue());
                String key = nombre + "-" + tipo;
                InfoFranquicia infoFranquicia = new InfoFranquicia(nombre, comision, idFranquicia, ctaBanco, ctaGasto, ctaReteFuente, ctaReteIVA, idCtaBanco, idTerceroBanco, pretefuente, preteiva);
                this.franquicias.put(key, infoFranquicia);
            }
            System.out.println("----franquicias cargadas");
        }
        catch (TransactionServerException e) {
            e.printStackTrace();
        }
    }

    public void loadInfoCard(Document doc) {
        List data = doc.getRootElement().getChildren("row");
        Iterator i = data.iterator();
        String tarjeta = null;
        String voucher = null;
        double valor_tarjeta = 0.0;
        double comision = 0.0;
        double reteFuente = 0.0;
        double reteIVA = 0.0;
        String idTransaction = "CR" + TransactionServerResultSet.getId();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            Iterator j = e.getChildren().iterator();
            tarjeta = ((Element)j.next()).getValue();
            valor_tarjeta = Double.parseDouble(((Element)j.next()).getValue());
            comision = Double.parseDouble(((Element)j.next()).getValue());
            reteFuente = Double.parseDouble(((Element)j.next()).getValue());
            reteIVA = Double.parseDouble(((Element)j.next()).getValue());
            voucher = ((Element)j.next()).getValue();
        }
        InfoFranquicia infoFranquicia = this.franquicias.get(tarjeta);
        System.out.println("Cargando informaci\u00f3n de tarjetas para franquicia " + tarjeta);
        System.out.println("infoFranquicia: " + infoFranquicia);
        this.setExternalValues(infoFranquicia, valor_tarjeta, comision, reteFuente, reteIVA, idTransaction, voucher, null, null, null);
    }

    @Override
    public void arriveAnswerEvent(AnswerEvent e) {
        System.out.println("******llego query para credibanco");
        this.loadInfoCard(e.getDocument());
    }

    @Override
    public boolean containSqlCode(String sqlCode) {
        return this.keySQL.contains(sqlCode);
    }

    @Override
    public void initiateFinishEvent(EndEventGenerator e) {
        for (int i = 0; i < this.driverEvent.size(); ++i) {
            try {
                this.gfforma.invokeMethod(this.driverEvent.get(i), "addAnswerListener", new Class[]{AnswerListener.class}, new Object[]{this});
                continue;
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
                continue;
            }
            catch (NotFoundComponentException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public Component getPanel() {
        System.out.println("*****************Retornando boton de credibanco....");
        return this;
    }

    @Override
    public void clean() {
        if (this.datafono != null) {
            this.JBcredibanco.setEnabled(true);
        }
        this.JBrecuperar.setEnabled(false);
        if (this.exportReteFuente != null) {
            this.gfforma.setExternalValues((Object)this.exportReteFuente, 0.0);
        }
        if (this.exportReteIVA != null) {
            this.gfforma.setExternalValues((Object)this.exportReteIVA, 0.0);
        }
        if (this.exportTarjeta != null) {
            this.gfforma.setExternalValues((Object)this.exportTarjeta, 0.0);
        }
        if (this.exportComision != null) {
            this.gfforma.setExternalValues((Object)this.exportComision, 0.0);
        }
        if (this.exportVoucher != null) {
            this.gfforma.setExternalValues((Object)this.exportVoucher, "");
        }
        if (this.anullRequest != null) {
            this.gfforma.setExternalValues((Object)this.anullRequest, "FALSE");
        }
        if (this.messageStatus != null) {
            this.gfforma.setExternalValues((Object)this.messageStatus, ":");
        }
    }

    @Override
    public void validPackage(Element args) throws Exception {
    }

    @Override
    public Element getPackage(Element args) throws Exception {
        return null;
    }

    @Override
    public Element getPackage() throws VoidPackageException {
        return null;
    }

    @Override
    public Element getPrintPackage() {
        return null;
    }

    @Override
    public boolean containData() {
        return false;
    }

    private void validExternalComponents() throws InvocationTargetException, NotFoundComponentException {
        for (int i = 0; i < this.externalValidations.size(); ++i) {
            Components comp = this.externalValidations.get(i);
            this.gfforma.invokeMethod(comp.getDriver(), comp.getMethod());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.validExternalComponents();
            if (this.validations.size() > 0) {
                this.validar();
            }
            if (e.getActionCommand().equals("save") && this.annulVoucher) {
                if (this.messageStatus != null) {
                    this.gfforma.setExternalValues((Object)this.messageStatus, "Inicie anulacion con datafono credibanco...Press Tecla 1");
                }
                this.setEnableBarButtons("DELETE", false, this.barButtons);
                this.JBcredibanco.setEnabled(false);
                this.annulVoucher(false);
            } else if (e.getActionCommand().equals("save") && this.annulAndPay) {
                if (this.messageStatus != null) {
                    this.gfforma.setExternalValues((Object)this.messageStatus, "Inicie anulacion con datafono credibanco...Press Tecla 1");
                }
                this.setEnableBarButtons("PRINT", false, this.barButtons);
                this.JBcredibanco.setEnabled(false);
                this.annulVoucher(true);
            } else if (e.getActionCommand().equals("save")) {
                if (this.messageStatus != null) {
                    this.gfforma.setExternalValues((Object)this.messageStatus, "Inicie transaccion con datafono credibanco...Press Tecla verde");
                }
                if (this.notifySaved) {
                    this.setEnableBarButtons("PRINT", false, this.barButtons);
                }
                this.JBcredibanco.setEnabled(false);
                this.sendPayCredibanco(null);
            } else if (e.getActionCommand().equals("recover")) {
                if (this.messageStatus != null) {
                    this.gfforma.setExternalValues((Object)this.messageStatus, "Inicie recuperacion de transaccion credibanco... Press Tecla 9");
                }
                this.setEnableBarButtons("PRINT", false, this.barButtons);
                this.JBrecuperar.setEnabled(false);
                this.sendRecoverCredibanco();
            }
        }
        catch (InvocationTargetException ex) {
            JOptionPane.showMessageDialog(this.gfforma.getDesktopPane(), ex.getCause().getMessage(), Language.getWord("ERROR_MESSAGE"), 0);
            System.out.println("transfiriendo foco a ventana principal");
            this.gfforma.requestFocus();
        }
        catch (NotFoundComponentException ex) {
            JOptionPane.showMessageDialog(this.gfforma.getDesktopPane(), ex.getCause().getMessage(), Language.getWord("ERROR_MESSAGE"), 0);
            System.out.println("transfiriendo foco a ventana principal");
            this.gfforma.requestFocus();
        }
    }

    private void validar() throws InvocationTargetException, NotFoundComponentException {
        System.out.println("validando");
        for (int i = 0; i < this.validations.size(); ++i) {
            ValidComponents comp = this.validations.get(i);
            if (comp.getArgs() != null) {
                this.gfforma.invokeMethod(comp.getDriver(), comp.getMethod(), new Class[]{Element.class}, new Object[]{comp.getArgs()});
                continue;
            }
            this.gfforma.invokeMethod(comp.getDriver(), comp.getMethod());
        }
    }

    private void annulVoucher(final boolean pay) {
        class SendTransactionDataphone
        extends Thread {
            SendTransactionDataphone() {
            }

            @Override
            public void run() {
                TEFAuthorizationWorker taw_ = AuthorizationWorkerMonitor.getInstance((int)CredibancoServices.getPort()).getWorker(EmakuCredibancoButton.this.datafono);
                TEFTransactionManager ttm_ = new TEFTransactionManager(taw_.getWorkerID(), (IDataManager)new PlainDataManager(), (ITefAuthorizationManager)taw_);
                System.out.println("****************** ENVIANDO TRAMA PARA ANULACION **********************");
                String nvoucher = EmakuCredibancoButton.this.gfforma.getExternalValueString(EmakuCredibancoButton.this.numberVoucher);
                String cr = EmakuCredibancoButton.this.gfforma.getExternalValueString(EmakuCredibancoButton.this.transactionCode);
                String user = EmakuCredibancoButton.this.gfforma.getExternalValueString("userLogin");
                String trama = "02," + EmakuCredibancoButton.this.host + "," + nvoucher + "," + cr + "," + user + ",";
                trama = trama + EmakuCredibancoButton.this.calcularLRC(trama);
                System.out.println("trama con lcr: " + trama);
                Object response_ = ttm_.getTEFAuthorization((Object)trama);
                if (EmakuCredibancoButton.this.messageStatus != null) {
                    EmakuCredibancoButton.this.gfforma.setExternalValues((Object)EmakuCredibancoButton.this.messageStatus, "...");
                }
                System.out.println("************Obteniendo respuesta del datafono******************");
                System.out.println("Response: " + response_);
                String response = response_.toString().replace("Response: ", "");
                System.out.println("response filtrado: " + response);
                String codeResponse = response.substring(0, response.indexOf(","));
                String nombre = EmakuCredibancoButton.this.getTokenResponse(response, 11);
                String tipo = EmakuCredibancoButton.this.getTokenResponse(response, 12);
                String key = nombre + "-" + tipo;
                System.out.println("key para infofranquicia: " + key);
                InfoFranquicia infoFranquicia = (InfoFranquicia)EmakuCredibancoButton.this.franquicias.get(key);
                if (!"00".equals(codeResponse)) {
                    System.out.println("error code: " + codeResponse);
                    if ("05".equals(codeResponse)) {
                        EmakuCredibancoButton.this.displayError("Error de comunicacion, No hubo interaccion con el datafono, por favor cerciorese de estar utilizando el datafono de Credibanco");
                    } else if ("02".equals(codeResponse)) {
                        EmakuCredibancoButton.this.displayError("Transaccion rechazada, fondos insuficientes, tarjeta vencida, clave invalida o transaccion cancelada por el cajero");
                    } else if ("03".equals(codeResponse)) {
                        EmakuCredibancoButton.this.displayError("Error, Transacci\u00f3n Sin Respuesta Final de Datafono (Transacci\u00f3n por Recuperar).");
                        EmakuCredibancoButton.this.JBrecuperar.setEnabled(true);
                    } else if ("XX".equals(codeResponse)) {
                        EmakuCredibancoButton.this.displayError("Error, Transacci\u00f3n rechazada o declinada");
                    }
                    if (EmakuCredibancoButton.this.barButtons != null) {
                        EmakuCredibancoButton.this.setEnableBarButtons("DELETE", true, EmakuCredibancoButton.this.barButtons);
                    }
                } else {
                    String rrn = EmakuCredibancoButton.this.getTokenResponse(response, 6);
                    String auth = EmakuCredibancoButton.this.getTokenResponse(response, 1);
                    String fourNumber = EmakuCredibancoButton.this.getTokenResponse(response, 15);
                    EmakuCredibancoButton.this.gfforma.setExternalValues((Object)EmakuCredibancoButton.this.exportRRN, rrn);
                    EmakuCredibancoButton.this.gfforma.setExternalValues((Object)EmakuCredibancoButton.this.exportAuth, auth);
                    EmakuCredibancoButton.this.gfforma.setExternalValues((Object)EmakuCredibancoButton.this.exportFourNumbers, fourNumber);
                    EmakuCredibancoButton.this.gfforma.setExternalValues((Object)EmakuCredibancoButton.this.exportIdTerceroBanco, infoFranquicia.getIdTerceroBanco());
                    if (pay) {
                        if (EmakuCredibancoButton.this.notifySaved) {
                            EmakuCredibancoButton.this.setEnableBarButtons("PRINT", false, EmakuCredibancoButton.this.barButtons);
                        }
                        EmakuCredibancoButton.this.JBcredibanco.setEnabled(false);
                        double total = EmakuCredibancoButton.this.gfforma.getExteralValues(EmakuCredibancoButton.this.importValueTotal);
                        if (total > 0.0) {
                            if (EmakuCredibancoButton.this.messageStatus != null) {
                                EmakuCredibancoButton.this.gfforma.setExternalValues((Object)EmakuCredibancoButton.this.messageStatus, "Inicie transaccion con datafono credibanco...Press Tecla verde");
                            }
                            EmakuCredibancoButton.this.sendPayCredibanco(null);
                        } else {
                            System.out.println("lanzar evento de notificacion de guardado sin generacion de pago por reemplazo...");
                            CredibancoEvent credibancoEvent = new CredibancoEvent(this, "PRINT");
                            EmakuCredibancoButton.this.notificando(credibancoEvent);
                        }
                    } else {
                        String voucher = EmakuCredibancoButton.this.gfforma.getExternalValueString(EmakuCredibancoButton.this.numberVoucher);
                        EmakuCredibancoButton.this.gfforma.setExternalValues((Object)EmakuCredibancoButton.this.anullRequest, "TRUE");
                        System.out.println("voucher anulado");
                        if (EmakuCredibancoButton.this.notifySaved) {
                            System.out.println("lanzar evento de notificacion de guardado...");
                            CredibancoEvent credibancoEvent = new CredibancoEvent(this, "DELETE");
                            EmakuCredibancoButton.this.notificando(credibancoEvent);
                        }
                    }
                }
            }
        }
        new SendTransactionDataphone().start();
    }

    private void sendRecoverCredibanco() {
        class SendTransactionRecover
        extends Thread {
            SendTransactionRecover() {
            }

            @Override
            public void run() {
                TEFAuthorizationWorker taw_ = AuthorizationWorkerMonitor.getInstance((int)CredibancoServices.getPort()).getWorker(EmakuCredibancoButton.this.datafono);
                TEFTransactionManager ttm_ = new TEFTransactionManager(taw_.getWorkerID(), (IDataManager)new PlainDataManager(), (ITefAuthorizationManager)taw_);
                System.out.println("****************** ENVIANDO TRAMA PARA RECUPERACION **********************");
                String trama = "00,2c";
                Object response_ = ttm_.getTEFAuthorization((Object)trama);
                if (EmakuCredibancoButton.this.messageStatus != null) {
                    EmakuCredibancoButton.this.gfforma.setExternalValues((Object)EmakuCredibancoButton.this.messageStatus, "...");
                }
                System.out.println("************Obteniendo respuesta del datafono******************");
                EmakuCredibancoButton.this.sendPayCredibanco(response_.toString());
            }
        }
        new SendTransactionRecover().start();
    }

    private void sendPayCredibanco(final String recover) {
        class SendTransactionDataphone
        extends Thread {
            SendTransactionDataphone() {
            }

            @Override
            public void run() {
                double base = EmakuCredibancoButton.this.gfforma.getExteralValues(EmakuCredibancoButton.this.importValueBase);
                long iva = (long)EmakuCredibancoButton.this.gfforma.getExteralValues(EmakuCredibancoButton.this.importValueIVA);
                long total = (long)EmakuCredibancoButton.this.gfforma.getExteralValues(EmakuCredibancoButton.this.importValueTotal);
                long parcial = (long)EmakuCredibancoButton.this.gfforma.getExteralValues(EmakuCredibancoButton.this.pagoParcial);
                String user = EmakuCredibancoButton.this.gfforma.getExternalValueString("userLogin");
                EmakuCredibancoButton.this.host = EmakuCredibancoButton.this.gfforma.getExternalValueString("hostName");
                String idTransaction = "CR" + TransactionServerResultSet.getId();
                String response = null;
                long valor_tarjeta = parcial != 0L ? parcial : total;
                System.out.println("valor total: " + total + " valor parcial " + parcial);
                if (total > 0L && !EmakuCredibancoButton.this.parcialPay || EmakuCredibancoButton.this.parcialPay && parcial != 0L && parcial <= total) {
                    if (recover == null) {
                        TEFAuthorizationWorker taw_ = AuthorizationWorkerMonitor.getInstance((int)CredibancoServices.getPort()).getWorker(EmakuCredibancoButton.this.datafono);
                        TEFTransactionManager ttm_ = new TEFTransactionManager(taw_.getWorkerID(), (IDataManager)new PlainDataManager(), (ITefAuthorizationManager)taw_);
                        System.out.println("****************** ENVIANDO TRAMA **********************");
                        String trama = "01," + valor_tarjeta + "," + iva + ",0," + EmakuCredibancoButton.this.host + "," + idTransaction + ",0,0," + user + ",";
                        System.out.println("lcr: " + EmakuCredibancoButton.this.calcularLRC(trama));
                        trama = trama + EmakuCredibancoButton.this.calcularLRC(trama);
                        System.out.println("trama con lcr: " + trama);
                        Object response_ = ttm_.getTEFAuthorization((Object)trama);
                        if (EmakuCredibancoButton.this.messageStatus != null) {
                            EmakuCredibancoButton.this.gfforma.setExternalValues((Object)EmakuCredibancoButton.this.messageStatus, "...");
                        }
                        System.out.println("************Obteniendo respuesta del datafono******************");
                        System.out.println("Response: " + response_);
                        response = response_.toString().replace("Response: ", "");
                    } else {
                        response = recover.toString().replace("Response: ", "");
                    }
                    System.out.println("response filtrado: " + response);
                    String codeResponse = response.substring(0, response.indexOf(","));
                    if (!"00".equals(codeResponse)) {
                        System.out.println("error code: " + codeResponse);
                        if ("05".equals(codeResponse)) {
                            EmakuCredibancoButton.this.displayError("Error de comunicacion, No hubo interaccion con el datafono, por favor cerciorese de estar utilizando el datafono de Credibanco");
                        } else if ("02".equals(codeResponse)) {
                            EmakuCredibancoButton.this.displayError("Transaccion rechazada, fondos insuficientes, tarjeta vencida, clave invalida o transaccion cancelada por el cajero");
                        } else if ("03".equals(codeResponse)) {
                            EmakuCredibancoButton.this.displayError("Error, Transacci\u00f3n Sin Respuesta Final de Datafono (Transacci\u00f3n por Recuperar).");
                            EmakuCredibancoButton.this.JBrecuperar.setEnabled(true);
                        } else if ("XX".equals(codeResponse)) {
                            EmakuCredibancoButton.this.displayError("Error, Transacci\u00f3n rechazada o declinada");
                        }
                    } else {
                        CredibancoEvent credibancoEvent;
                        String key = EmakuCredibancoButton.this.getTokenResponse(response, 11) + "-" + EmakuCredibancoButton.this.getTokenResponse(response, 12);
                        InfoFranquicia infoFranquicia = (InfoFranquicia)EmakuCredibancoButton.this.franquicias.get(key);
                        if (infoFranquicia == null) {
                            System.out.println("Tarjeta " + key + " no encontrada, cargando informacion de tarjeta NOTFOUND");
                            infoFranquicia = (InfoFranquicia)EmakuCredibancoButton.this.franquicias.get("NOTFOUND-CR");
                        }
                        System.out.println("exportando: " + EmakuCredibancoButton.this.exportTarjeta + " valor " + valor_tarjeta);
                        double reteFuente = EmakuCredibancoButton.this.redondearDecimales(base * infoFranquicia.getPretefuente() / 100.0, 2);
                        double reteIVA = EmakuCredibancoButton.this.redondearDecimales((double)iva * infoFranquicia.getPreteiva() / 100.0, 2);
                        System.out.println("exportando: " + EmakuCredibancoButton.this.exportReteFuente + " valor " + reteFuente);
                        String voucher = EmakuCredibancoButton.this.getTokenResponse(response, 5);
                        String rrn = EmakuCredibancoButton.this.getTokenResponse(response, 6);
                        String auth = EmakuCredibancoButton.this.getTokenResponse(response, 1);
                        String fourNumbers = EmakuCredibancoButton.this.getTokenResponse(response, 15);
                        double porcentaje = infoFranquicia != null ? infoFranquicia.getComision() : 0.0;
                        double comision = EmakuCredibancoButton.this.redondearDecimales((double)valor_tarjeta * porcentaje / 100.0, 2);
                        System.out.println("Key: " + key);
                        System.out.println("value Key: " + EmakuCredibancoButton.this.franquicias.get(key));
                        if (EmakuCredibancoButton.this.notifySaved) {
                            EmakuCredibancoButton.this.setExternalValues(infoFranquicia, valor_tarjeta, comision, reteFuente, reteIVA, idTransaction, voucher, rrn, auth, fourNumbers);
                            System.out.println("lanzar evento de notificacion de guardado...");
                            credibancoEvent = new CredibancoEvent(this, "PRINT");
                            EmakuCredibancoButton.this.notificando(credibancoEvent);
                        }
                        if (EmakuCredibancoButton.this.recordListener.size() > 0) {
                            EmakuCredibancoButton.this.sendRecord(infoFranquicia, valor_tarjeta, voucher, rrn, comision, reteFuente, reteIVA, idTransaction, auth, fourNumbers);
                            if (EmakuCredibancoButton.this.sendContabRecord) {
                                EmakuCredibancoButton.this.sendContabRecord(infoFranquicia, valor_tarjeta, voucher, rrn, comision, reteFuente, reteIVA, idTransaction);
                            }
                            if (EmakuCredibancoButton.this.sendPrinterRecord) {
                                EmakuCredibancoButton.this.sendPrinterRecord(infoFranquicia, valor_tarjeta, voucher, rrn, comision, reteFuente, reteIVA, idTransaction);
                            }
                            EmakuCredibancoButton.this.JBcredibanco.setEnabled(true);
                        }
                        if (EmakuCredibancoButton.this.parcialPay && total == parcial) {
                            System.out.println("lanzar evento de notificacion de guardado por pago parcial...");
                            credibancoEvent = new CredibancoEvent(this, "PRINT");
                            EmakuCredibancoButton.this.notificando(credibancoEvent);
                        }
                        if (EmakuCredibancoButton.this.cleanComponents.size() > 0) {
                            EmakuCredibancoButton.this.cleanComponents();
                        }
                        long valorDT = Long.parseLong(EmakuCredibancoButton.this.getTokenResponse(response, 2));
                        System.out.println("valor a contravalidar " + valorDT + " contra " + valor_tarjeta);
                        if (valorDT != valor_tarjeta) {
                            EmakuCredibancoButton.this.displayError("Valores de pago errados, por favor anule el documento e informe inmediatamente al administrador");
                        }
                    }
                } else if (total < parcial) {
                    EmakuCredibancoButton.this.displayError("El valor a pagar no puede superar el valor de la transaccion");
                } else {
                    EmakuCredibancoButton.this.displayError("El valor a pagar debe ser mayor a 0");
                }
            }
        }
        new SendTransactionDataphone().start();
    }

    private void setExternalValues(InfoFranquicia infoFranquicia, double total, double comision, double reteFuente, double reteIVA, String idTransaction, String voucher, String rrn, String auth, String fourNumbers) {
        this.gfforma.setExternalValues((Object)this.exportTarjeta, total);
        this.gfforma.setExternalValues((Object)this.exportReteFuente, reteFuente);
        this.gfforma.setExternalValues((Object)this.exportReteIVA, reteIVA);
        this.gfforma.setExternalValues((Object)this.transactionCode, idTransaction);
        this.gfforma.setExternalValues((Object)this.exportVoucher, voucher);
        this.gfforma.setExternalValues((Object)this.exportOperador, "CR");
        if (auth != null) {
            this.gfforma.setExternalValues((Object)this.exportAuth, auth);
        }
        if (fourNumbers != null) {
            this.gfforma.setExternalValues((Object)this.exportFourNumbers, fourNumbers);
        }
        if (rrn != null) {
            this.gfforma.setExternalValues((Object)this.exportRRN, rrn);
        }
        if (infoFranquicia != null) {
            this.gfforma.setExternalValues((Object)this.exportComision, comision);
            this.gfforma.setExternalValues((Object)this.exportFranquicia, "" + infoFranquicia.getIdFranquicia());
            this.gfforma.setExternalValues((Object)this.exportCtaBanco, "" + infoFranquicia.getCtaBanco());
            this.gfforma.setExternalValues((Object)this.exportCtaGasto, "" + infoFranquicia.getCtaGasto());
            this.gfforma.setExternalValues((Object)this.exportCtaReteFuente, "" + infoFranquicia.getCtaReteFuente());
            this.gfforma.setExternalValues((Object)this.exportCtaReteIVA, "" + infoFranquicia.getCtaReteIVA());
            this.gfforma.setExternalValues((Object)this.exportIdTerceroBanco, "" + infoFranquicia.getIdTerceroBanco());
            System.out.println("franquicia :" + infoFranquicia.getIdFranquicia() + " comision: " + comision);
        } else {
            this.gfforma.setExternalValues((Object)this.exportComision, 0.0);
            this.gfforma.setExternalValues((Object)this.exportFranquicia, "57");
            System.out.println("no se encontro tarjeta");
        }
    }

    private void sendRecord(InfoFranquicia infoFranquicia, double total, String recibo, String rrn, double comision, double reteFuente, double reteIVA, String tcode, String auth, String fourNumbers) {
        Element pack = new Element("package");
        Element subpack = new Element("subpackage");
        Element entarjeta = new Element("field");
        entarjeta.setText(infoFranquicia.getNombre());
        Element evalor = new Element("field");
        evalor.setText("" + total);
        Element errn = new Element("field");
        errn.setText("" + rrn);
        Element erecibo = new Element("field");
        erecibo.setText(recibo);
        Element ecomision = new Element("field");
        ecomision.setText("" + comision);
        Element eretefuente = new Element("field");
        eretefuente.setText("" + reteFuente);
        Element ereteiva = new Element("field");
        ereteiva.setText("" + reteIVA);
        Element efranquicia = new Element("field");
        efranquicia.setText("" + infoFranquicia.getIdFranquicia());
        Element ebanco = new Element("field");
        ebanco.setText("" + infoFranquicia.getCtaBanco());
        Element egasto = new Element("field");
        egasto.setText("" + infoFranquicia.getCtaGasto());
        Element erfuente = new Element("field");
        erfuente.setText("" + infoFranquicia.getCtaReteFuente());
        Element eriva = new Element("field");
        eriva.setText("" + infoFranquicia.getCtaReteIVA());
        Element eoperador = new Element("field");
        eoperador.setText("CR");
        Element etcode = new Element("field");
        etcode.setText(tcode);
        Element eauth = new Element("field");
        eauth.setText(auth);
        Element efourNumbers = new Element("field");
        efourNumbers.setText(fourNumbers);
        Element eidtercerobanco = new Element("field");
        eidtercerobanco.setText("" + infoFranquicia.getIdTerceroBanco());
        subpack.addContent((Content)entarjeta);
        subpack.addContent((Content)evalor);
        subpack.addContent((Content)erecibo);
        subpack.addContent((Content)errn);
        subpack.addContent((Content)ecomision);
        subpack.addContent((Content)eretefuente);
        subpack.addContent((Content)ereteiva);
        subpack.addContent((Content)efranquicia);
        subpack.addContent((Content)ebanco);
        subpack.addContent((Content)egasto);
        subpack.addContent((Content)erfuente);
        subpack.addContent((Content)eriva);
        subpack.addContent((Content)eoperador);
        subpack.addContent((Content)etcode);
        subpack.addContent((Content)eauth);
        subpack.addContent((Content)efourNumbers);
        subpack.addContent((Content)eidtercerobanco);
        pack.addContent((Content)subpack);
        this.notificando(pack, "tarjeta");
    }

    private void sendContabRecord(InfoFranquicia infoFranquicia, double total, String recibo, String rrn, double comision, double reteFuente, double reteIVA, String tcode) {
        Element pack = new Element("package");
        Element subpack = new Element("subpackage");
        Element ebanco = new Element("field");
        ebanco.setText("" + infoFranquicia.getCtaBanco());
        Element nombreCta = new Element("field");
        nombreCta.setText("ABONO CON TARJETA " + infoFranquicia.getNombre() + " " + recibo);
        Element debe = new Element("field");
        debe.setText("" + total);
        Element haber = new Element("field");
        haber.setText("0");
        Element etcode = new Element("field");
        etcode.setText(tcode);
        Element etercero = new Element("field");
        etercero.setText("NULL");
        Element eidcta = new Element("field");
        eidcta.setText(infoFranquicia.getIdCtaBanco());
        Element econdicion = new Element("field");
        econdicion.setText("1");
        Element encuenta = new Element("field");
        encuenta.setText("BANCOS");
        Element evinculo = new Element("field");
        evinculo.setText("NULL");
        Element eedocumento = new Element("field");
        eedocumento.setText("FALSE");
        Element ecc = new Element("field");
        ecc.setText(this.gfforma.getExternalValueString("id_centrocosto"));
        Element escc = new Element("field");
        escc.setText("0");
        Element endocumentoc = new Element("field");
        endocumentoc.setText("NULL");
        subpack.addContent((Content)ebanco);
        subpack.addContent((Content)nombreCta);
        subpack.addContent((Content)debe);
        subpack.addContent((Content)haber);
        subpack.addContent((Content)etcode);
        subpack.addContent((Content)etercero);
        subpack.addContent((Content)eidcta);
        subpack.addContent((Content)econdicion);
        subpack.addContent((Content)encuenta);
        subpack.addContent((Content)evinculo);
        subpack.addContent((Content)eedocumento);
        subpack.addContent((Content)ecc);
        subpack.addContent((Content)escc);
        subpack.addContent((Content)endocumentoc);
        pack.addContent((Content)subpack);
        this.notificando(pack, "contab");
    }

    private void sendPrinterRecord(InfoFranquicia infoFranquicia, double total, String recibo, String rrn, double comision, double reteFuente, double reteIVA, String tcode) {
        Element pack = new Element("package");
        Element subpack = new Element("subpackage");
        Element ebanco = new Element("field");
        ebanco.setText("" + infoFranquicia.getCtaBanco());
        Element nombreCta = new Element("field");
        nombreCta.setText("ABONO CON TARJETA " + infoFranquicia.getNombre() + " " + recibo);
        Element debe = new Element("field");
        debe.setText("" + total);
        Element haber = new Element("field");
        haber.setText("0");
        Element etcode = new Element("field");
        etcode.setText(tcode);
        subpack.addContent((Content)ebanco);
        subpack.addContent((Content)nombreCta);
        subpack.addContent((Content)debe);
        subpack.addContent((Content)haber);
        subpack.addContent((Content)etcode);
        pack.addContent((Content)subpack);
        this.notificando(pack, "printer");
    }

    private void setEnableBarButtons(String name, boolean status, String component) {
        try {
            this.gfforma.invokeMethod(component, "setEnabled", new Class[]{String.class, Boolean.TYPE}, new Object[]{name, status});
        }
        catch (NotFoundComponentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void cleanComponents() {
        for (String component : this.cleanComponents) {
            try {
                this.gfforma.invokeMethod(component, "clean");
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NotFoundComponentException e) {
                e.printStackTrace();
            }
        }
    }

    private double redondearDecimales(double valorInicial, int numeroDecimales) {
        double resultado = valorInicial;
        double parteEntera = Math.floor(resultado);
        resultado = (resultado - parteEntera) * Math.pow(10.0, numeroDecimales);
        resultado = Math.round(resultado);
        resultado = resultado / Math.pow(10.0, numeroDecimales) + parteEntera;
        return resultado;
    }

    private String getTokenResponse(String response, int index) {
        StringTokenizer responseToken = new StringTokenizer(response, ",");
        ArrayList<String> listResponse = new ArrayList<String>();
        while (responseToken.hasMoreTokens()) {
            listResponse.add(responseToken.nextToken().trim());
        }
        return (String)listResponse.get(index);
    }

    public void addCredibancoListener(CredibancoListener listener) {
        System.out.println("Adicionando oyente " + listener);
        this.credibancoListener.addElement(listener);
    }

    public void removeAnswerListener(CredibancoListener listener) {
        this.credibancoListener.removeElement(listener);
    }

    private void notificando(CredibancoEvent event) {
        System.out.println("notificando..." + this.credibancoListener.size());
        for (CredibancoListener l : this.credibancoListener) {
            System.out.println("notificando a " + l);
            l.credibancoSuccessEvent(event);
        }
    }

    private String getDatafono() {
        String ip = SocketConnector.getIpConnect();
        try {
            Iterator i;
            Document doc = TransactionServerResultSet.getResultSetST(this.sqlDatafono, new String[]{ip});
            List data = doc.getRootElement().getChildren("row");
            if (data.size() > 0 && (i = data.iterator()).hasNext()) {
                Element e = (Element)i.next();
                Iterator j = e.getChildren().iterator();
                String name = ((Element)j.next()).getValue();
                return name;
            }
        }
        catch (TransactionServerException e) {
            e.printStackTrace();
        }
        System.out.println("no existe datafono registrado en este equipo");
        return null;
    }

    public String calcularLRC(String pi_sCadena) {
        String vl_sLRC = "";
        if (pi_sCadena.length() > 0) {
            int vl_iLRC = pi_sCadena.charAt(0);
            for (int i = 1; i < pi_sCadena.length(); ++i) {
                vl_iLRC ^= pi_sCadena.charAt(i);
            }
            vl_sLRC = Integer.toString(vl_iLRC, 16);
        }
        if (vl_sLRC.length() == 1) {
            vl_sLRC = "0" + vl_sLRC;
        }
        return vl_sLRC;
    }

    private void displayError(String msg) {
        this.displayError(msg, true);
    }

    private void displayError(final String msg, boolean status) {
        this.JBcredibanco.setEnabled(status);
        if (this.messageStatus != null) {
            this.gfforma.setExternalValues((Object)this.messageStatus, ":");
        }
        if (this.barButtons != null) {
            this.setEnableBarButtons("PRINT", true, this.barButtons);
        }
        Runnable showModalDialog = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, msg, "", 0);
            }
        };
        SwingUtilities.invokeLater(showModalDialog);
        System.out.println("ERROR: " + msg);
    }

    public void addRecordListener(RecordListener listener) {
        this.recordListener.add(listener);
    }

    public void removeRecordListener(RecordListener listener) {
        this.recordListener.remove(listener);
    }

    public void notificando(Element element, String idRecord) {
        RecordEvent event = new RecordEvent(this, element, idRecord);
        event.setRecalculable(false);
        for (RecordListener l : this.recordListener) {
            l.arriveRecordEvent(event);
        }
        event = null;
    }

    @Override
    public void close() {
    }

    @Override
    public void arriveJSONTOXMLEvent(JSONXMLEvent e) {
    }

    @Override
    public boolean containWSElement(String wsElement) {
        return false;
    }

    class ValidComponents {
        private String driver;
        private String method;
        private Element args;

        ValidComponents() {
        }

        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public Element getArgs() {
            return this.args;
        }

        public void setArgs(Element args) {
            this.args = args;
        }
    }

    class InfoFranquicia {
        private double comision;
        private int idFranquicia;
        private String ctaBanco;
        private String ctaGasto;
        private String ctaReteFuente;
        private String ctaReteIVA;
        private String nombre;
        private String idCtaBanco;
        private String idTerceroBanco;
        private double pretefuente;
        private double preteiva;

        public InfoFranquicia(String nombre, double comision, int idFranquicia, String ctaBanco, String ctaGasto, String ctaReteFuente, String ctaReteIVA, String idCtaBanco, String idTerceroBanco, double pretefuente, double preteiva) {
            this.nombre = nombre;
            this.comision = comision;
            this.idFranquicia = idFranquicia;
            this.ctaBanco = ctaBanco;
            this.ctaGasto = ctaGasto;
            this.ctaReteFuente = ctaReteFuente;
            this.ctaReteIVA = ctaReteIVA;
            this.idCtaBanco = idCtaBanco;
            this.idTerceroBanco = idTerceroBanco;
            this.pretefuente = pretefuente;
            this.preteiva = preteiva;
        }

        public String getIdTerceroBanco() {
            return this.idTerceroBanco;
        }

        public double getPretefuente() {
            return this.pretefuente;
        }

        public double getPreteiva() {
            return this.preteiva;
        }

        public String getCtaBanco() {
            return this.ctaBanco;
        }

        public String getIdCtaBanco() {
            return this.idCtaBanco;
        }

        public String getCtaGasto() {
            return this.ctaGasto;
        }

        public String getCtaReteFuente() {
            return this.ctaReteFuente;
        }

        public String getCtaReteIVA() {
            return this.ctaReteIVA;
        }

        public String getNombre() {
            return this.nombre;
        }

        public double getComision() {
            return this.comision;
        }

        public int getIdFranquicia() {
            return this.idFranquicia;
        }

        public String toString() {
            return "comision: " + this.comision + " idFranquicia: " + this.idFranquicia;
        }
    }
}

