/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import common.gui.components.AnswerEvent;
import common.gui.components.Couplable;
import common.gui.components.JSONXMLEvent;
import common.gui.components.RecordEvent;
import common.gui.components.RecordListener;
import common.gui.components.VoidPackageException;
import common.gui.forms.EndEventGenerator;
import common.gui.forms.GenericForm;
import common.misc.ZipHandler;
import common.misc.language.Language;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import jxl.Cell;
import jxl.CellType;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class EmakuImportExcelFile
extends JPanel
implements Couplable,
ActionListener {
    private static final long serialVersionUID = -9137825185914807588L;
    private JButton JBopen;
    private JFileChooser filechooser = new JFileChooser();
    private GenericForm GFforma;
    private Vector<RecordListener> recordListener = new Vector();
    private File file;
    private Workbook workbook;
    private Element element;
    private Element rows = null;
    private boolean distinctTypeData;

    public EmakuImportExcelFile(GenericForm GFforma, Document doc) {
        this.GFforma = GFforma;
        this.setLayout(new FlowLayout(2));
        this.JBopen = new JButton();
        this.JBopen.setIcon(new ImageIcon(this.getClass().getResource("/icons/ico_excel.png")));
        this.JBopen.setToolTipText(Language.getWord("IMPORT_EXCEL_FILE"));
        this.add(this.JBopen);
        Element parameters = doc.getRootElement();
        for (Element subargs : parameters.getChildren()) {
            String value = subargs.getValue();
            if (!"distinctTypeData".equals(subargs.getAttributeValue("attribute"))) continue;
            this.distinctTypeData = Boolean.parseBoolean(value);
        }
        this.JBopen.addActionListener(this);
    }

    @Override
    public void clean() {
    }

    @Override
    public boolean containData() {
        return false;
    }

    @Override
    public Element getPackage(Element args) throws Exception {
        return null;
    }

    @Override
    public Element getPackage() throws VoidPackageException {
        return null;
    }

    @Override
    public Component getPanel() {
        return this;
    }

    @Override
    public Element getPrintPackage() {
        return null;
    }

    @Override
    public void validPackage(Element args) throws Exception {
    }

    @Override
    public void arriveAnswerEvent(AnswerEvent e) {
    }

    @Override
    public void initiateFinishEvent(EndEventGenerator e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal = this.filechooser.showSaveDialog(this.GFforma.getParent());
        if (returnVal == 0) {
            this.readExcelFile(this.filechooser.getSelectedFile());
        }
    }

    private String getImage(String nameImage) {
        String ruta = this.filechooser.getCurrentDirectory() + System.getProperty("file.separator") + nameImage;
        System.out.println("ruta de archivo: " + ruta);
        File file = new File(ruta);
        try {
            String fileType = nameImage.substring(nameImage.indexOf(".") + 1);
            ImageIcon im = new ImageIcon(ImageIO.read(file));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedImage bufferedImage = new BufferedImage(800, 600, 1);
            Graphics2D g2 = bufferedImage.createGraphics();
            g2.drawImage(im.getImage(), 0, 0, 800, 600, null);
            ImageIO.write((RenderedImage)bufferedImage, fileType, out);
            ZipHandler zip = new ZipHandler(out, nameImage);
            String image = new String(zip.getDataEncode());
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void readExcelFile(File file) {
        class ImportarExcel
        extends Thread {
            private File file;

            public ImportarExcel(File file) {
                this.file = file;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WorkbookSettings ws = new WorkbookSettings();
                    ws.setEncoding("Cp1252");
                    EmakuImportExcelFile.this.workbook = Workbook.getWorkbook((File)this.file, (WorkbookSettings)ws);
                    EmakuImportExcelFile.this.element = new Element("table");
                    Sheet sheet = EmakuImportExcelFile.this.workbook.getSheet(0);
                    for (int i = 3; i < sheet.getRows(); ++i) {
                        Cell[] celdas = sheet.getRow(i);
                        EmakuImportExcelFile.this.rows = new Element("row");
                        for (Cell celda : celdas) {
                            if (EmakuImportExcelFile.this.distinctTypeData) {
                                if (celda.getType() == CellType.NUMBER) {
                                    NumberCell nc = (NumberCell)celda;
                                    EmakuImportExcelFile.this.rows.addContent((Content)new Element("col").setText("" + nc.getValue()));
                                    continue;
                                }
                                EmakuImportExcelFile.this.rows.addContent((Content)new Element("col").setText(celda.getContents()));
                                continue;
                            }
                            if (celda.getContents().toLowerCase().contains(".jpg") || celda.getContents().toLowerCase().contains(".png")) {
                                System.out.println("viene una foto");
                                EmakuImportExcelFile.this.rows.addContent((Content)new Element("col").setText(EmakuImportExcelFile.this.getImage(celda.getContents())));
                                continue;
                            }
                            EmakuImportExcelFile.this.rows.addContent((Content)new Element("col").setText(celda.getContents()));
                        }
                        EmakuImportExcelFile.this.element.addContent((Content)EmakuImportExcelFile.this.rows);
                    }
                    EmakuImportExcelFile.this.notificando();
                }
                catch (BiffException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    this.file = null;
                    EmakuImportExcelFile.this.workbook = null;
                    EmakuImportExcelFile.this.element = null;
                    EmakuImportExcelFile.this.rows = null;
                    System.gc();
                }
            }
        }
        new ImportarExcel(file).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notificando() {
        RecordEvent event = new RecordEvent(this, this.element);
        Vector<RecordListener> vector = this.recordListener;
        synchronized (vector) {
            for (RecordListener l : this.recordListener) {
                l.arriveRecordEvent(event);
            }
        }
        event = null;
    }

    public void addRecordListener(RecordListener listener) {
        this.recordListener.addElement(listener);
    }

    public void removeRecordListener(RecordListener listener) {
        this.recordListener.removeElement(listener);
    }

    @Override
    public boolean containSqlCode(String sqlCode) {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public void arriveJSONTOXMLEvent(JSONXMLEvent e) {
    }

    @Override
    public boolean containWSElement(String wsElement) {
        return false;
    }
}

