/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import common.gui.components.EmakuTouchField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;

public class TouchButtons
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 5953946428251386838L;
    private JButton JBOk = new JButton("OK");
    private JButton[] bills = new JButton[]{new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_billete_100000_100x50.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_billete_50000_100x50.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_billete_20000_100x50.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_billete_10000_100x50.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_billete_5000_100x50.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_billete_2000_100x50.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_billete_1000_100x50.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_moneda_500_50x50.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_moneda_200_50x50.png"))), new JButton(new ImageIcon(this.getClass().getResource("/icons/ico_moneda_100_50x50.png")))};
    private JButton[][] buttons = new JButton[][]{{new JButton("7"), new JButton("8"), new JButton("9")}, {new JButton("4"), new JButton("5"), new JButton("6")}, {new JButton("1"), new JButton("2"), new JButton("3")}, {new JButton("0"), new JButton("00"), new JButton(".")}, {new JButton("C"), new JButton("<<"), this.JBOk}};
    private EmakuTouchField touchField;

    public TouchButtons(EmakuTouchField emakuTouchField, Font font, boolean withBill) {
        this.touchField = emakuTouchField;
        this.setLayout(new BorderLayout());
        JPanel mbills = new JPanel(new GridLayout(5, 2));
        int i = 0;
        for (JButton col : this.bills) {
            mbills.add(col);
            col.addActionListener(this);
            col.setName(i++ + "M");
        }
        JPanel matriz = new JPanel(new GridLayout(5, 3));
        JButton[][] jButtonArray = this.buttons;
        int n = jButtonArray.length;
        for (int j = 0; j < n; ++j) {
            JButton[] row;
            for (JButton col : row = jButtonArray[j]) {
                matriz.add(col);
                col.setFont(font);
                col.addActionListener(this);
            }
        }
        if (withBill) {
            this.add((Component)mbills, "West");
        }
        this.add((Component)matriz, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String value;
        JButton b = (JButton)e.getSource();
        String string = value = !b.getText().equals("") ? b.getText() : b.getName();
        if ("OK".equals(value)) {
            this.touchField.doFormat();
            this.touchField.cleanImportComponentes();
        } else if ("C".equals(value)) {
            this.touchField.setText("");
            this.touchField.setNumberValue(0.0);
        } else if ("<<".equals(value)) {
            try {
                int offset = this.touchField.getText().length();
                this.touchField.getDocument().remove(offset - 1, 1);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        } else if ("0M".equals(value)) {
            this.touchField.setText(String.valueOf(this.touchField.getNumberValue() + 100000.0));
        } else if ("1M".equals(value)) {
            this.touchField.setText(String.valueOf(this.touchField.getNumberValue() + 50000.0));
        } else if ("2M".equals(value)) {
            this.touchField.setText(String.valueOf(this.touchField.getNumberValue() + 20000.0));
        } else if ("3M".equals(value)) {
            this.touchField.setText(String.valueOf(this.touchField.getNumberValue() + 10000.0));
        } else if ("4M".equals(value)) {
            this.touchField.setText(String.valueOf(this.touchField.getNumberValue() + 5000.0));
        } else if ("5M".equals(value)) {
            this.touchField.setText(String.valueOf(this.touchField.getNumberValue() + 2000.0));
        } else if ("6M".equals(value)) {
            this.touchField.setText(String.valueOf(this.touchField.getNumberValue() + 1000.0));
        } else if ("7M".equals(value)) {
            this.touchField.setText(String.valueOf(this.touchField.getNumberValue() + 500.0));
        } else if ("8M".equals(value)) {
            this.touchField.setText(String.valueOf(this.touchField.getNumberValue() + 200.0));
        } else if ("9M".equals(value)) {
            this.touchField.setText(String.valueOf(this.touchField.getNumberValue() + 100.0));
        } else {
            try {
                int offset = this.touchField.getText().length();
                this.touchField.getDocument().insertString(offset, value, null);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }

    public JButton getJBOk() {
        return this.JBOk;
    }
}

