/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import common.gui.components.AnswerEvent;
import common.gui.components.AnswerListener;
import common.gui.components.Couplable;
import common.gui.components.JSONXMLEvent;
import common.gui.components.VoidPackageException;
import common.gui.forms.EndEventGenerator;
import common.gui.forms.ExternalValueChangeEvent;
import common.gui.forms.ExternalValueChangeListener;
import common.gui.forms.GenericForm;
import common.gui.forms.NotFoundComponentException;
import common.misc.Icons;
import common.misc.ZipHandler;
import common.misc.language.Language;
import common.transactions.TransactionServerException;
import common.transactions.TransactionServerResultSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class XMLLabel
extends JLabel
implements Couplable,
MouseListener,
ExternalValueChangeListener {
    private static final long serialVersionUID = -3279052585377122227L;
    private JPanel panel;
    private GenericForm GFforma;
    private Vector<String> driverEvent;
    private Vector<String> keySQL;
    private String mode;
    private String namebutton = "SAVE";
    private String exportValue;
    private boolean havePanel = true;
    private int preferredLength = 0;
    private boolean queryImage;
    private ZipHandler zip;
    private int width = 0;
    private int height = 0;
    ImageIcon im = null;
    JFileChooser loadFile = null;
    private String fileType;
    private String nameFile;
    private boolean keepImageSize = false;
    private boolean resizable = true;
    private String getVal;
    private String sqlInit;
    Vector<String> importValue = null;

    public XMLLabel(GenericForm GFforma, Document doc) {
        Iterator parameters = doc.getRootElement().getChildren().iterator();
        this.GFforma = GFforma;
        this.zip = new ZipHandler();
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        this.driverEvent = new Vector();
        this.keySQL = new Vector();
        while (parameters.hasNext()) {
            Element e = (Element)parameters.next();
            String name = e.getName();
            if ("arg".equals(name) && e.getAttributeValue("attribute").equals("text")) {
                String text = Language.getWord(e.getValue());
                this.setText(!text.equals("") ? text : e.getValue());
                continue;
            }
            if ("arg".equals(name) && e.getAttributeValue("attribute").equals("alignment")) {
                if (e.getValue().equals("CENTER")) {
                    layout.setAlignment(1);
                    continue;
                }
                if (e.getValue().equals("LEFT")) {
                    layout.setAlignment(0);
                    continue;
                }
                if (!e.getValue().equals("RIGTH")) continue;
                layout.setAlignment(2);
                continue;
            }
            if ("driverEvent".equals(e.getAttributeValue("attribute"))) {
                String id = "";
                if (e.getAttributeValue("id") != null) {
                    id = e.getAttributeValue("id");
                }
                if (this.driverEvent.contains(e.getValue() + id)) continue;
                this.driverEvent.addElement(e.getValue() + id);
                continue;
            }
            if ("keySQL".equals(e.getAttributeValue("attribute"))) {
                this.keySQL.addElement(e.getValue());
                continue;
            }
            if ("sqlInit".equals(e.getAttributeValue("attribute"))) {
                this.sqlInit = e.getValue();
                continue;
            }
            if ("importValue".equals(e.getAttributeValue("attribute"))) {
                if (this.importValue == null) {
                    this.importValue = new Vector();
                }
                this.importValue.addElement(e.getValue());
                continue;
            }
            if ("mode".equals(e.getAttributeValue("attribute"))) {
                this.mode = e.getValue();
                continue;
            }
            if ("image".equals(e.getAttributeValue("attribute"))) {
                this.setIcon(new ImageIcon(this.getClass().getResource(e.getValue())));
                continue;
            }
            if ("keepImageSize".equals(e.getAttributeValue("attribute"))) {
                System.out.println("tiene keepImage");
                this.keepImageSize = true;
                continue;
            }
            if ("queryImage".equals(e.getAttributeValue("attribute"))) {
                this.queryImage = Boolean.parseBoolean(e.getValue());
                continue;
            }
            if ("widthImage".equals(e.getAttributeValue("attribute"))) {
                this.width = Integer.parseInt(e.getValue());
                continue;
            }
            if ("resizable".equals(e.getAttributeValue("attribute"))) {
                this.resizable = Boolean.parseBoolean(e.getValue());
                continue;
            }
            if ("heightImage".equals(e.getAttributeValue("attribute"))) {
                this.height = Integer.parseInt(e.getValue());
                continue;
            }
            if ("arg".equals(name) && e.getAttributeValue("attribute").equals("font")) {
                try {
                    StringTokenizer STfont = new StringTokenizer(e.getValue(), ",");
                    Font font = new Font(STfont.nextToken(), Integer.parseInt(STfont.nextToken()), Integer.parseInt(STfont.nextToken()));
                    this.setFont(font);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NoSuchElementException noSuchElementException) {}
                continue;
            }
            if ("Panel".equals(e.getAttributeValue("attribute"))) {
                this.havePanel = Boolean.getBoolean(e.getValue());
                continue;
            }
            if ("preferredLength".equals(e.getAttributeValue("attribute"))) {
                this.preferredLength = Integer.parseInt(e.getValue());
                continue;
            }
            if (!"getValue".equals(e.getAttributeValue("attribute"))) continue;
            this.getVal = e.getValue();
        }
        if (this.queryImage) {
            Border border = BorderFactory.createEtchedBorder();
            this.setBorder(border);
            this.addMouseListener(this);
        }
        if (this.width > 0 && this.height > 0) {
            this.setPreferredSize(new Dimension(this.width, this.height));
        }
        if (this.sqlInit != null) {
            System.out.println("llamando a sqlInit");
            this.initSQL();
        }
        this.panel = new JPanel(layout);
        this.panel.add(this);
        GFforma.addInitiateFinishListener(this);
    }

    @Override
    public Component getPanel() {
        if (this.havePanel) {
            return this.panel;
        }
        return this;
    }

    private void initSQL() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    if (XMLLabel.this.importValue != null) {
                        String[] iargs = XMLLabel.this.importValue.toArray(new String[XMLLabel.this.importValue.size()]);
                        String[] args = new String[iargs.length];
                        for (int i = 0; i < args.length; ++i) {
                            args[i] = XMLLabel.this.GFforma.getExternalValueString(iargs[i]);
                        }
                        System.out.println("Generando Query de Label para " + args[0]);
                        doc = TransactionServerResultSet.getResultSetST(XMLLabel.this.sqlInit, args);
                    } else {
                        doc = TransactionServerResultSet.getResultSetST(XMLLabel.this.sqlInit);
                    }
                    Element el = doc.getRootElement().getChild("row");
                    int row = el.getChildren().size();
                    System.out.println("Cargando " + row + " resultado");
                    if (row > 0) {
                        Element printPack = new Element("package");
                        Iterator it = el.getChildren().iterator();
                        while (it.hasNext()) {
                            String val = ((Element)it.next()).getValue().trim();
                            if (XMLLabel.this.queryImage) {
                                System.out.println("Es una imagen ");
                                try {
                                    byte[] bytesImage = XMLLabel.this.zip.getDataDecode(val);
                                    XMLLabel.this.nameFile = XMLLabel.this.zip.getCurrentFile();
                                    System.out.println("nombre del archivo: " + XMLLabel.this.nameFile);
                                    XMLLabel.this.fileType = XMLLabel.this.nameFile.substring(XMLLabel.this.nameFile.indexOf(".") + 1);
                                    ByteArrayInputStream image = new ByteArrayInputStream(bytesImage);
                                    XMLLabel.this.im = new ImageIcon(ImageIO.read(image));
                                    System.out.println("imagen: " + XMLLabel.this.im.toString());
                                    int width = XMLLabel.this.im.getIconWidth();
                                    int height = XMLLabel.this.im.getIconHeight();
                                    XMLLabel.this.setIcon(XMLLabel.this.im);
                                    image.close();
                                    XMLLabel.this.setResize(width, height);
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                                continue;
                            }
                            System.out.println("es texto");
                            Element field = new Element("field");
                            field.setText(val);
                            printPack.addContent((Content)field);
                            XMLLabel.this.setText(val);
                        }
                        if (XMLLabel.this.mode != null) {
                            if ("NEW".equals(XMLLabel.this.mode)) {
                                XMLLabel.this.GFforma.setEnabledButton(XMLLabel.this.namebutton, false);
                            } else {
                                XMLLabel.this.GFforma.setEnabledButton(XMLLabel.this.namebutton, true);
                            }
                        }
                        if (XMLLabel.this.exportValue != null && !XMLLabel.this.queryImage) {
                            XMLLabel.this.GFforma.setExternalValues((Object)XMLLabel.this.exportValue, XMLLabel.this.getText());
                        }
                    }
                }
                catch (NullPointerException NPEe) {
                    XMLLabel.this.clean();
                    if (XMLLabel.this.mode != null) {
                        if ("NEW".equals(XMLLabel.this.mode)) {
                            XMLLabel.this.GFforma.setEnabledButton(XMLLabel.this.namebutton, true);
                        } else {
                            XMLLabel.this.GFforma.setEnabledButton(XMLLabel.this.namebutton, false);
                        }
                    }
                }
                catch (TransactionServerException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void setResize(int width, int height) {
        if (this.resizable) {
            System.out.println("Redimensionando a " + width + "x" + height);
            this.setPreferredSize(new Dimension(width, height));
        } else {
            System.out.println("La imagen no se redimensiona");
        }
    }

    @Override
    public void clean() {
        this.setText("");
        if (this.queryImage) {
            this.im = null;
            this.setIcon(null);
            this.revalidate();
        }
    }

    @Override
    public boolean containData() {
        try {
            Element elm = this.getPackage();
            if (elm.getChildren().size() > 0) {
                return true;
            }
        }
        catch (VoidPackageException e) {
            return false;
        }
        return false;
    }

    @Override
    public Element getPackage(Element args) throws Exception {
        return null;
    }

    @Override
    public Element getPackage() throws VoidPackageException {
        Element pack = new Element("package");
        Element field = null;
        if (!this.queryImage) {
            if (!this.getText().equals("")) {
                field = new Element("field");
                field.setText(this.getText());
                pack.addContent((Content)field);
            }
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedImage bufferedImage = null;
            bufferedImage = this.keepImageSize && this.im != null ? new BufferedImage(this.im.getIconWidth(), this.im.getIconHeight(), 1) : new BufferedImage(800, 600, 1);
            Graphics2D g2 = bufferedImage.createGraphics();
            try {
                if (this.keepImageSize) {
                    g2.drawImage(this.im.getImage(), 0, 0, this.im.getIconWidth(), this.im.getIconHeight(), null);
                } else {
                    g2.drawImage(this.im.getImage(), 0, 0, 800, 600, null);
                }
                field = new Element("field");
                field.setAttribute("saveImage", "true");
                ImageIO.write((RenderedImage)bufferedImage, this.fileType, out);
                ZipHandler zip = new ZipHandler(out, this.nameFile);
                Element file = new Element("field");
                file.setText(this.nameFile);
                pack.addContent((Content)file);
                field.setText(new String(zip.getDataEncode()));
                pack.addContent((Content)field);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        return pack;
    }

    @Override
    public Element getPrintPackage() {
        try {
            if (!this.queryImage) {
                return this.getPackage();
            }
            Element pack = new Element("package");
            Element field = null;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedImage bufferedImage = null;
            bufferedImage = this.keepImageSize && this.im != null ? new BufferedImage(this.im.getIconWidth(), this.im.getIconHeight(), 1) : new BufferedImage(800, 600, 1);
            Graphics2D g2 = bufferedImage.createGraphics();
            try {
                if (this.keepImageSize) {
                    g2.drawImage(this.im.getImage(), 0, 0, this.im.getIconWidth(), this.im.getIconHeight(), null);
                } else {
                    g2.drawImage(this.im.getImage(), 0, 0, 800, 600, null);
                }
                field = new Element("field");
                field.setAttribute("saveImage", "true");
                ImageIO.write((RenderedImage)bufferedImage, this.fileType, out);
                ZipHandler zip = new ZipHandler(out, this.nameFile);
                field.setText(new String(zip.getDataEncode()));
                pack.addContent((Content)field);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return pack;
        }
        catch (VoidPackageException e) {
            return null;
        }
    }

    @Override
    public void validPackage(Element args) throws Exception {
        this.getPackage(args);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.queryImage && this.im != null) {
            g.drawImage(this.im.getImage(), 0, 0, this.width, this.height, null);
        } else {
            super.paintComponent(g);
        }
    }

    @Override
    public void arriveAnswerEvent(AnswerEvent e) {
        block12: {
            try {
                Document doc = e.getDocument();
                Element el = doc.getRootElement().getChild("row");
                int row = el.getChildren().size();
                this.clean();
                if (row > 0) {
                    Element printPack = new Element("package");
                    Iterator it = el.getChildren().iterator();
                    while (it.hasNext()) {
                        String val = ((Element)it.next()).getValue().trim();
                        if (this.queryImage) {
                            try {
                                byte[] bytesImage = this.zip.getDataDecode(val);
                                this.nameFile = this.zip.getCurrentFile();
                                System.out.println("nombre del archivo: " + this.nameFile);
                                this.fileType = this.nameFile.substring(this.nameFile.indexOf(".") + 1);
                                ByteArrayInputStream image = new ByteArrayInputStream(bytesImage);
                                this.im = new ImageIcon(ImageIO.read(image));
                                System.out.println("imagen: " + this.im.toString());
                                int width = this.im.getIconWidth();
                                int height = this.im.getIconHeight();
                                this.setIcon(this.im);
                                image.close();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            continue;
                        }
                        System.out.println("es texto");
                        Element field = new Element("field");
                        field.setText(val);
                        printPack.addContent((Content)field);
                        this.setText(val);
                    }
                    if (this.mode != null) {
                        if ("NEW".equals(this.mode)) {
                            this.GFforma.setEnabledButton(this.namebutton, false);
                        } else {
                            this.GFforma.setEnabledButton(this.namebutton, true);
                        }
                    }
                    if (this.exportValue != null && !this.queryImage) {
                        this.GFforma.setExternalValues((Object)this.exportValue, this.getText());
                    }
                }
            }
            catch (NullPointerException NPEe) {
                this.clean();
                if (this.mode == null) break block12;
                if ("NEW".equals(this.mode)) {
                    this.GFforma.setEnabledButton(this.namebutton, true);
                }
                this.GFforma.setEnabledButton(this.namebutton, false);
            }
        }
    }

    @Override
    public void initiateFinishEvent(EndEventGenerator e) {
        try {
            for (int i = 0; i < this.driverEvent.size(); ++i) {
                this.GFforma.invokeMethod(this.driverEvent.get(i), "addAnswerListener", new Class[]{AnswerListener.class}, new Object[]{this});
            }
            this.GFforma.addChangeExternalValueListener(this);
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    if (XMLLabel.this.preferredLength > 0) {
                        XMLLabel.this.setPreferredSize(new Dimension(XMLLabel.this.preferredLength, XMLLabel.this.getHeight()));
                        XMLLabel.this.updateUI();
                    }
                }
            });
        }
        catch (NotFoundComponentException NFCEe) {
            NFCEe.printStackTrace();
        }
        catch (InvocationTargetException ITEe) {
            ITEe.printStackTrace();
        }
    }

    @Override
    public boolean containSqlCode(String sqlCode) {
        return this.keySQL.contains(sqlCode);
    }

    private void loadImage() {
        this.loadFile = new JFileChooser(System.getProperty("user.home"));
        this.loadFile.setFileSelectionMode(0);
        this.loadFile.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Imagenes";
            }

            @Override
            public boolean accept(File f) {
                String ext = null;
                String s = f.getName();
                int i = s.lastIndexOf(46);
                if (i > 0 && i < s.length() - 1) {
                    ext = s.substring(i + 1).toLowerCase();
                }
                return "png".equals(ext) || "jpg".equals(ext) || f.isDirectory();
            }
        });
        int op = this.loadFile.showOpenDialog(this);
        GregorianCalendar calendario = new GregorianCalendar();
        File file = this.loadFile.getSelectedFile();
        this.nameFile = calendario.getTimeInMillis() + "-" + file.getName();
        System.out.println("nombre del archivo: " + this.nameFile);
        this.fileType = this.nameFile.substring(this.nameFile.indexOf(".") + 1);
        try {
            this.im = new ImageIcon(ImageIO.read(file));
            int width = this.im.getIconWidth();
            int height = this.im.getIconHeight();
            this.setResize(width, height);
            this.setIcon(this.im);
            System.out.println("tama\u00f1o en jlabel: " + this.getIcon().getIconWidth() + "," + this.getIcon().getIconHeight());
            this.repaint();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        System.out.println("boton: " + e.getButton());
        if (e.getButton() == 1) {
            this.loadImage();
        } else if (this.im != null) {
            JInternalFrame JFimage = new JInternalFrame(this.nameFile != null ? this.nameFile : "", false, true);
            JFimage.setLayout(new FlowLayout());
            JFimage.setFrameIcon(new ImageIcon(this.getClass().getResource(Icons.getIcon("NART"))));
            if (this.keepImageSize) {
                JFimage.setBounds(10, 10, this.im.getIconWidth(), this.im.getIconHeight());
            } else {
                JFimage.setBounds(10, 10, 800, 600);
            }
            JLabel JLImage = new JLabel(this.im){

                @Override
                public void paintComponent(Graphics g) {
                    if (XMLLabel.this.keepImageSize) {
                        g.drawImage(XMLLabel.this.im.getImage(), 0, 0, XMLLabel.this.im.getIconWidth(), XMLLabel.this.im.getIconHeight(), null);
                    } else {
                        g.drawImage(XMLLabel.this.im.getImage(), 0, 0, 800, 600, null);
                    }
                }
            };
            if (this.keepImageSize) {
                JLImage.setPreferredSize(new Dimension(this.im.getIconWidth(), this.im.getIconHeight()));
            } else {
                JLImage.setPreferredSize(new Dimension(800, 600));
            }
            JFimage.add(JLImage);
            this.GFforma.getDesktopPane().add(JFimage);
            JFimage.setVisible(true);
        } else {
            this.loadImage();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void changeExternalValue(ExternalValueChangeEvent e) {
        if (this.getVal != null && this.getVal.equals(e.getExternalValue())) {
            System.out.println("seteando mensaje de " + this.getVal + " texto " + this.GFforma.getExternalValueString(this.getVal));
            this.setText(this.GFforma.getExternalValueString(this.getVal));
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void arriveJSONTOXMLEvent(JSONXMLEvent e) {
    }

    @Override
    public boolean containWSElement(String wsElement) {
        return false;
    }
}

