/*
 * Decompiled with CFR 0.152.
 */
package common.misc.settings;

import common.comunications.SocketConnector;
import common.gui.forms.Splash;
import common.misc.ClientConstants;
import common.misc.Icons;
import common.misc.language.Language;
import common.misc.parameters.EmakuParametersStructure;
import common.misc.settings.ConfigFileNotLoadException;
import common.misc.settings.HostConnection;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ConfigFileHandler
extends EmakuParametersStructure {
    private static SAXBuilder builder;
    private static Document doc;
    private static Element root;
    private static Language lang;
    private static String JWT;
    private static String language;
    private static String logMode;
    private static String jarDirectory;
    private static String lookAndFeel;
    private static String cash;
    private static int disconnectedWaitingTime;
    private static Color color;
    private static ArrayList<Element> companies;
    private static Hashtable<String, HostConnection> HTHostConnections;
    private static String currentCompany;

    public static void buildNewFile(String language, String log, String cash, String theme, Vector<Element> companiesVector) {
        Element rootNode = new Element("configuration");
        doc = new Document(rootNode);
        rootNode.addContent((Content)new Element("language").setText(language));
        rootNode.addContent((Content)new Element("log").setText(log));
        rootNode.addContent((Content)new Element("cash").setText(cash));
        rootNode.addContent((Content)new Element("lookAndFeel").setText(theme));
        for (Element element : companiesVector) {
            ConfigFileHandler.loadHostConnections(element);
            rootNode.addContent((Content)element);
        }
        XMLOutputter out = new XMLOutputter();
        out.setFormat(Format.getPrettyFormat());
        File file = new File(ClientConstants.CONF);
        try {
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory()) {
                file = new File(ClientConstants.CONF, "client.conf");
                FileOutputStream outFile = new FileOutputStream(file);
                out.output(doc, (OutputStream)outFile);
                outFile.close();
                try {
                    ConfigFileHandler.loadSettings();
                }
                catch (ConfigFileNotLoadException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadSettings() throws ConfigFileNotLoadException {
        try {
            companies = new ArrayList();
            builder = new SAXBuilder(false);
            String path = ClientConstants.CONF + "client.conf";
            System.out.println("path: " + path);
            if (ClientConstants.WEBSTART) {
                doc = builder.build(new URL(path));
                root = doc.getRootElement();
            } else {
                File file = new File(path);
                doc = builder.build(file);
                root = doc.getRootElement();
            }
            List configList = root.getChildren();
            Iterator i = configList.iterator();
            int counter = 0;
            while (i.hasNext()) {
                Element data = (Element)i.next();
                String name = data.getName();
                if (name.equals("language")) {
                    language = data.getValue();
                    ++counter;
                } else if (name.equals("log")) {
                    logMode = data.getValue();
                    ++counter;
                } else if (name.equals("lookAndFeel")) {
                    lookAndFeel = data.getValue();
                    ++counter;
                } else if (name.equals("cash")) {
                    cash = data.getValue();
                    ++counter;
                } else if (name.equals("company")) {
                    ConfigFileHandler.loadHostConnections(data);
                    companies.add((Element)data.clone());
                    ++counter;
                }
                EmakuParametersStructure.addParameter(name, data.getValue());
            }
            if (counter < 5) {
                System.out.println(Language.getWord("MISS_CONFIG"));
                System.out.println(Language.getWord("MISS_CONFIG2"));
                System.exit(0);
            }
            lang.loadLanguage(language);
        }
        catch (FileNotFoundException FNFEe) {
            FNFEe.printStackTrace();
            throw new ConfigFileNotLoadException();
        }
        catch (JDOMException JDOMEe) {
            JDOMEe.printStackTrace();
            throw new ConfigFileNotLoadException();
        }
        catch (IOException IOEe) {
            IOEe.printStackTrace();
            throw new ConfigFileNotLoadException();
        }
    }

    private static void loadHostConnections(Element e) {
        Iterator it = e.getChildren().iterator();
        HostConnection hostConnection = new HostConnection();
        String key = null;
        while (it.hasNext()) {
            Element config = (Element)it.next();
            String name = config.getName();
            String value = config.getValue();
            if (name.equals("name")) {
                key = value.trim();
                continue;
            }
            if (name.equals("host")) {
                hostConnection.setHost(value);
                continue;
            }
            if (name.equals("serverport")) {
                hostConnection.setPort(Integer.parseInt(value));
                continue;
            }
            if (name.equals("runningCredibancoService")) {
                hostConnection.setRunningCredibancoService(Boolean.parseBoolean(value));
                continue;
            }
            if (!name.equals("disconnectedWaitingTime")) continue;
            try {
                disconnectedWaitingTime = Integer.parseInt(value);
            }
            catch (NumberFormatException NFEe) {
                disconnectedWaitingTime = 10;
            }
        }
        if (key != null) {
            HTHostConnections.put(key, hostConnection);
        }
    }

    public static void loadJarFile(String nameCompany) {
        Iterator i = root.getChildren("company").iterator();
        boolean isCompany = false;
        String jarFile = null;
        String directory = "";
        while (i.hasNext() && !isCompany) {
            Element data = (Element)i.next();
            Iterator j = data.getChildren().iterator();
            jarFile = "";
            directory = "";
            while (j.hasNext()) {
                Element config = (Element)j.next();
                String name = config.getName();
                String value = config.getValue();
                if (name.equals("name") && value.trim().equals(nameCompany.trim())) {
                    isCompany = true;
                    continue;
                }
                if (name.equals("jarFile")) {
                    jarFile = value;
                    continue;
                }
                if (name.equals("directory")) {
                    directory = value;
                    continue;
                }
                if (!name.equals("colorBackground")) continue;
                String scolor = value;
                try {
                    StringTokenizer stcolor = new StringTokenizer(scolor, ",");
                    int r = Integer.parseInt(stcolor.nextToken());
                    int g = Integer.parseInt(stcolor.nextToken());
                    int b = Integer.parseInt(stcolor.nextToken());
                    color = new Color(r, g, b);
                }
                catch (NoSuchElementException e) {
                    e.printStackTrace();
                }
            }
        }
        String jarBytes = ClientConstants.COMPANIES + jarFile;
        File file = new File(jarBytes);
        if (!file.exists() && !ClientConstants.WEBSTART) {
            Splash.hide();
            JOptionPane.showMessageDialog(new JFrame(), Language.getWord("JAR_ERROR1") + " \"" + nameCompany + "\"\n" + Language.getWord("JAR_ERROR2") + " " + ClientConstants.COMPANIES + "\n" + Language.getWord("JAR_ERROR3") + " \"" + jarFile + "\" " + Language.getWord("JAR_ERROR4") + "\n" + Language.getWord("JAR_ERROR5"), Language.getWord("ERROR"), 0);
            try {
                SocketConnector.getSock().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.exit(0);
        } else {
            String jar = null;
            jar = ClientConstants.WEBSTART ? "jar:" + jarBytes + "!/" : "jar:file:" + jarBytes + "!/";
            jarDirectory = jar + directory;
            EmakuParametersStructure.setJarDirectoryTemplates(jarDirectory + "/printer-templates");
            EmakuParametersStructure.addParameter("jarFile", jarFile);
            EmakuParametersStructure.addParameter("jarDirectory", directory);
            EmakuParametersStructure.addParameter("jarPath", jarDirectory);
            lang.loadLanguage(jarDirectory + "/lang/", language);
            new Icons().loadIcons(jarDirectory + "/conf");
        }
    }

    public static int disconnectedWaitingTime() {
        return disconnectedWaitingTime;
    }

    public static String getHost() {
        HostConnection hc = HTHostConnections.get(currentCompany);
        if (hc != null) {
            return hc.getHost();
        }
        System.out.println("Host not set in the client.conf");
        return null;
    }

    public static Boolean isRunningCredibancoService() {
        HostConnection hc = HTHostConnections.get(currentCompany);
        if (hc != null) {
            return hc.isRunningCredibancoService();
        }
        return false;
    }

    public static String getLanguage() {
        return language;
    }

    public static String getLogMode() {
        return logMode;
    }

    public static ArrayList<Element> getCompanies() {
        return companies;
    }

    public static String getCash() {
        return cash;
    }

    public static String getLookAndFeel() {
        return lookAndFeel;
    }

    public static int getServerPort() {
        HostConnection hc = HTHostConnections.get(currentCompany);
        if (hc != null) {
            return hc.getPort();
        }
        System.out.println("Port not set in the client.conf");
        return -1;
    }

    public static void setHost(String newhost) {
        root.getChild("host").setText(newhost);
    }

    public static void setPort(int newport) {
        root.getChild("serverport").setText(Integer.toString(newport));
    }

    public static String getJarDirectory() {
        return jarDirectory;
    }

    public static void setCurrentCompany(String company) {
        currentCompany = company;
    }

    public static Color getColor() {
        return color;
    }

    public static String getJWT() {
        return JWT;
    }

    public static void setJWT(String jwt) {
        JWT = jwt;
    }

    static {
        lang = new Language();
        disconnectedWaitingTime = 5;
        color = Color.lightGray;
        HTHostConnections = new Hashtable();
        currentCompany = "";
    }
}

