/*
 * Decompiled with CFR 0.152.
 */
package common.misc.settings;

import common.gui.forms.ConfigDialog;
import common.misc.language.Language;
import common.misc.log.LogAdmin;
import common.misc.parameters.ParametersMarketPlace;
import common.misc.parameters.ParametersRNDC;
import common.misc.settings.ConfigFileNotLoadException;
import common.misc.settings.Connections;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ServerConfigFileHandler {
    private static SAXBuilder builder;
    private static Document doc;
    private static Element root;
    private static Language appLang;
    private static Vector<Connections> VConnectionsPool;
    private static int clientSocket;
    private static int adminSocket;
    private static int MaxClients;
    private static String local;
    private static int minDataBaseConnections;
    private static int maxDataBaseConnections;
    private static int webPort;
    private static String dbWeb;
    private static String rootWebDirectory;
    private static String httpsCert;
    private static String httpsPassword;
    private static String httpsKey;
    private static List<String> webservices;
    private static String location;

    public static void loadConfigFile(String emakuConfigFile) throws ConfigFileNotLoadException {
        try {
            builder = new SAXBuilder(false);
            System.out.println("INFO: Config -> " + emakuConfigFile);
            File file = new File(emakuConfigFile);
            doc = builder.build(file);
            root = doc.getRootElement();
            List Lconfig = root.getChildren();
            for (Element records : Lconfig) {
                if (records.getName().equals("PoolConnection")) {
                    ServerConfigFileHandler.loadConnectionsPool(records.getChildren());
                    continue;
                }
                if (records.getName().equals("webservices")) {
                    ServerConfigFileHandler.loadWebservices(records.getChildren());
                    continue;
                }
                if (records.getName().equals("Lenguaje")) {
                    local = records.getValue();
                    appLang.loadLanguage(local);
                    continue;
                }
                if (records.getName().equals("Log")) {
                    new LogAdmin(records.getValue(), "emaku");
                    continue;
                }
                if (records.getName().equals("SocketJClient")) {
                    clientSocket = Integer.parseInt(records.getValue());
                    continue;
                }
                if (records.getName().equals("SocketJAdmin")) {
                    adminSocket = Integer.parseInt(records.getValue());
                    continue;
                }
                if (records.getName().equals("MaxClients")) {
                    MaxClients = Integer.parseInt(records.getValue());
                    continue;
                }
                if (records.getName().equals("MinDataBaseConnections")) {
                    minDataBaseConnections = Integer.parseInt(records.getValue());
                    continue;
                }
                if (records.getName().equals("MaxDataBaseConnections")) {
                    maxDataBaseConnections = Integer.parseInt(records.getValue());
                    continue;
                }
                if (records.getName().equals("WebPort")) {
                    webPort = Integer.parseInt(records.getValue());
                    continue;
                }
                if (records.getName().equals("dbWeb")) {
                    dbWeb = records.getValue();
                    continue;
                }
                if (records.getName().equals("httpsCert")) {
                    httpsCert = records.getValue();
                    continue;
                }
                if (records.getName().equals("httpsPassword")) {
                    httpsPassword = records.getValue();
                    continue;
                }
                if (records.getName().equals("httpsKey")) {
                    httpsKey = records.getValue();
                    continue;
                }
                if (records.getName().equals("RootWebDirectory")) {
                    rootWebDirectory = records.getValue();
                    continue;
                }
                if (!records.getName().equals("location")) continue;
                location = records.getValue();
            }
            LogAdmin.setMessage(Language.getWord("LOADING_CF"), 2);
        }
        catch (FileNotFoundException FNFEe) {
            throw new ConfigFileNotLoadException();
        }
        catch (JDOMException JDOMEe) {
            throw new ConfigFileNotLoadException();
        }
        catch (IOException IOEe) {
            throw new ConfigFileNotLoadException();
        }
    }

    private static void loadConnectionsPool(List LPoolConexiones) {
        for (Element records : LPoolConexiones) {
            VConnectionsPool.addElement(ServerConfigFileHandler.loadBD(records.getChildren()));
        }
    }

    private static void loadWebservices(List listWebservices) {
        webservices = new ArrayList<String>();
        for (Element name : listWebservices) {
            webservices.add(name.getValue());
        }
    }

    public static List<String> getWebservices() {
        return webservices;
    }

    public static String getLocation() {
        return location;
    }

    private static Connections loadBD(List LBD) {
        Iterator i = LBD.iterator();
        Connections connection = new Connections();
        while (i.hasNext()) {
            Element records = (Element)i.next();
            System.out.println("cargando " + records.getName());
            if (records.getName().equals("name")) {
                connection.setName(records.getValue());
                continue;
            }
            if (records.getName().equals("driver")) {
                connection.setDriver(records.getValue());
                continue;
            }
            if (records.getName().equals("url")) {
                connection.setUrl(records.getValue());
                continue;
            }
            if (records.getName().equals("username")) {
                connection.setUser(records.getValue());
                continue;
            }
            if (records.getName().equals("password")) {
                connection.setPassword(records.getValue());
                continue;
            }
            if (records.getName().equals("smtpserver")) {
                connection.setSmtpserver(records.getValue());
                continue;
            }
            if (records.getName().equals("smtpaccount")) {
                connection.setSmtpaccount(records.getValue());
                continue;
            }
            if (records.getName().equals("smtppassword")) {
                connection.setSmtppassword(records.getValue());
                continue;
            }
            if (records.getName().equals("certfile")) {
                connection.setCertfile("/home/emaku/certs/" + records.getValue());
                continue;
            }
            if (records.getName().equals("certpassword")) {
                connection.setCertpassword(records.getValue());
                continue;
            }
            if (records.getName().equals("certPolicy")) {
                connection.setCertPolicy(records.getValue());
                continue;
            }
            if (records.getName().equals("localFilePolicy")) {
                connection.setLocalFilePolicy(records.getValue());
                continue;
            }
            if (records.getName().equals("notifyMail")) {
                connection.addNotifyMail(records.getValue());
                continue;
            }
            if (records.getName().equals("sendBashElectronicDocument")) {
                connection.setSendBashElectronicDocuments(Boolean.parseBoolean(records.getValue()));
                continue;
            }
            if (records.getName().equals("mercadolibre_secret_key")) {
                ParametersMarketPlace.setMercadolibreParameter("mercadolibre_secret_key", records.getValue());
                continue;
            }
            if (records.getName().equals("mercadolibre_id")) {
                ParametersMarketPlace.setMercadolibreParameter("mercadolibre_id", records.getValue());
                continue;
            }
            if (records.getName().equals("mercadolibre_resources")) {
                ParametersMarketPlace.setMercadolibreParameter("mercadolibre_resources", records.getValue());
                continue;
            }
            if (records.getName().equals("mercadolibre_auth_url")) {
                ParametersMarketPlace.setMercadolibreParameter("mercadolibre_auth_url", records.getValue());
                continue;
            }
            if (records.getName().equals("mercadolibre_token_url")) {
                ParametersMarketPlace.setMercadolibreParameter("mercadolibre_token_url", records.getValue());
                continue;
            }
            if (records.getName().equals("mercadolibre_redirect_url")) {
                ParametersMarketPlace.setMercadolibreParameter("mercadolibre_redirect_url", records.getValue());
                continue;
            }
            if (records.getName().equals("loadingTokenOnServer")) {
                ParametersMarketPlace.setMercadolibreParameter("loadingTokenOnServer", records.getValue());
                continue;
            }
            if (records.getName().equals("rndc_url")) {
                System.out.println("Cargando url RNDC: " + records.getValue());
                ParametersRNDC.setUrl(records.getValue());
                continue;
            }
            if (records.getName().equals("rndc_action")) {
                ParametersRNDC.setAction(records.getValue());
                continue;
            }
            if (records.getName().equals("rndc_username")) {
                ParametersRNDC.setUsername(records.getValue());
                continue;
            }
            if (!records.getName().equals("rndc_password")) continue;
            ParametersRNDC.setPassword(records.getValue());
        }
        return connection;
    }

    public static void newConfigFile(String emakuConfigFile) {
        String lang = "es_CO";
        String clientPort = "9117";
        String adminPort = "28124";
        String maxClients = "500";
        String logType = "Verbose";
        String company = "mi_empresa";
        String jdbcDriver = "org.postgresql.Driver";
        String url = "jdbc:postgresql://localhost:5432/mi_empresa";
        String user = "emaku";
        String password = "";
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            int MAX_WIN_SIZE_HEIGHT = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            int MAX_WIN_SIZE_WIDTH = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            ConfigDialog newConfigDialog = new ConfigDialog(new JFrame());
            newConfigDialog.pack();
            newConfigDialog.setLocation(MAX_WIN_SIZE_WIDTH / 2 - newConfigDialog.getWidth() / 2, MAX_WIN_SIZE_HEIGHT / 2 - newConfigDialog.getHeight() / 2);
            newConfigDialog.setVisible(true);
            lang = newConfigDialog.getLanguage();
            clientPort = newConfigDialog.getClientPort();
            adminPort = newConfigDialog.getAdminPort();
            maxClients = newConfigDialog.getMaxClients();
            logType = newConfigDialog.getLogType();
            company = newConfigDialog.getCompany();
            jdbcDriver = newConfigDialog.getJDBCDriver();
            url = newConfigDialog.getUrl();
            user = newConfigDialog.getUser();
            password = newConfigDialog.getPasswd();
        }
        try {
            FileOutputStream serverConfFile = new FileOutputStream(emakuConfigFile);
            PrintStream FOSServerConf = new PrintStream(serverConfFile);
            FOSServerConf.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            FOSServerConf.println("<!--\n");
            FOSServerConf.println("    Document   : server.conf.xml");
            FOSServerConf.println("    Created on : 29 de junio de 2004, 14:29");
            FOSServerConf.println("    Author     : Luis Felipe Hernandes, Cristian David Cepeda");
            FOSServerConf.println("-->");
            FOSServerConf.println();
            FOSServerConf.println("<Config>");
            FOSServerConf.println("    <Lenguaje>" + lang + "</Lenguaje>");
            FOSServerConf.println("    <SocketJClient>" + clientPort + "</SocketJClient>");
            FOSServerConf.println("    <SocketJAdmin>" + adminPort + "</SocketJAdmin>");
            FOSServerConf.println("        <MaxClients>" + maxClients + "</MaxClients>");
            FOSServerConf.println("    <!-- Valores posibles:");
            FOSServerConf.println("    Default:     Muestra solo mensajes de error");
            FOSServerConf.println("    Verbose:     Muestra todos los mensajes");
            FOSServerConf.println("    VerboseFile: Muestra todos los mensajes por la consola y genera un");
            FOSServerConf.println("                 archivo log");
            FOSServerConf.println("    LogFile:     Solo genera un archivo log con todos los mensajes");
            FOSServerConf.println("    -->");
            FOSServerConf.println("    <Log>" + logType + "</Log>");
            FOSServerConf.println("    <PoolConnection>");
            FOSServerConf.println("        <DataBase>");
            FOSServerConf.println("            <name>" + company + "</name>");
            FOSServerConf.println("            <driver>" + jdbcDriver + "</driver>");
            FOSServerConf.println("            <url>" + url + "</url>");
            FOSServerConf.println("            <username>" + user + "</username>");
            FOSServerConf.println("            <password>" + password + "</password>");
            FOSServerConf.println("        </DataBase>");
            FOSServerConf.println("    </PoolConnection>");
            FOSServerConf.println("</Config>");
            FOSServerConf.close();
        }
        catch (SecurityException ex) {
            System.out.println("ERROR: El usuario emaku no tiene permisos para crear el archivo de configuraci\u00f3n.");
        }
        catch (IOException e) {
            System.out.println("ERROR: No se pudo crear el archivo de configuraci\u00f3n.");
        }
    }

    public static String getRootWebDirectory() {
        return rootWebDirectory;
    }

    public static int getWebPort() {
        return webPort;
    }

    public static String getHttpsCert() {
        return httpsCert;
    }

    public static String getHttpsPassword() {
        return httpsPassword;
    }

    public static String getHttpsKey() {
        return httpsKey;
    }

    public static String getDbWeb() {
        return dbWeb;
    }

    public static int getDBSize() {
        return VConnectionsPool.size();
    }

    public static String getDriver(int index) {
        return VConnectionsPool.get(index).getDriver();
    }

    public static ArrayList<String> getNotifyMail(String bd) {
        return VConnectionsPool.get(ServerConfigFileHandler.getIdBd(bd)).getNotifyMail();
    }

    public static String getDBName(int index) {
        return VConnectionsPool.get(index).getName();
    }

    public static String getSmtpserver(String bd) {
        return VConnectionsPool.get(ServerConfigFileHandler.getIdBd(bd)).getSmtpserver();
    }

    private static int getIdBd(String bd) {
        int size = VConnectionsPool.size();
        for (int i = 0; i < size; ++i) {
            if (!VConnectionsPool.get(i).getName().equals(bd)) continue;
            return i;
        }
        return -1;
    }

    public static String getCertfile(String bd) {
        return VConnectionsPool.get(ServerConfigFileHandler.getIdBd(bd)).getCertfile();
    }

    public static boolean isSendBashElectronicDocuments(String bd) {
        return VConnectionsPool.get(ServerConfigFileHandler.getIdBd(bd)).isSendBashElectronicDocuments();
    }

    public static String getCertpassword(String bd) {
        return VConnectionsPool.get(ServerConfigFileHandler.getIdBd(bd)).getCertpassword();
    }

    public static String getCertPolicy(String bd) {
        return VConnectionsPool.get(ServerConfigFileHandler.getIdBd(bd)).getCertPolicy();
    }

    public static String getLocalFilePolicy(String bd) {
        return VConnectionsPool.get(ServerConfigFileHandler.getIdBd(bd)).getLocalFilePolicy();
    }

    public static String getSmtpaccount(String bd) {
        return VConnectionsPool.get(ServerConfigFileHandler.getIdBd(bd)).getSmtpaccount();
    }

    public static String getSmtppassword(String bd) {
        return VConnectionsPool.get(ServerConfigFileHandler.getIdBd(bd)).getSmtppassword();
    }

    public static String getUrl(int index) {
        return VConnectionsPool.get(index).getUrl();
    }

    public static String getUser(int index) {
        return VConnectionsPool.get(index).getUser();
    }

    public static String getPassword(int index) {
        return VConnectionsPool.get(index).getPassword();
    }

    public static int getAdminSocket() {
        return adminSocket;
    }

    public static int getClientSocket() {
        return clientSocket;
    }

    public static int getMaxClients() {
        return MaxClients;
    }

    public static String getLocal() {
        return local;
    }

    public static int getMinDataBaseConnections() {
        return minDataBaseConnections;
    }

    public static int getMaxDataBaseConnections() {
        return maxDataBaseConnections;
    }

    static {
        appLang = new Language();
        VConnectionsPool = new Vector();
        minDataBaseConnections = 20;
        maxDataBaseConnections = 40;
        webPort = 9150;
        rootWebDirectory = "/home/emaku/web";
        location = "es_CO";
    }
}

