/*
 * Decompiled with CFR 0.152.
 */
package common.pdf.pdfviewer;

import common.control.ClientHeaderValidator;
import common.control.ReportEvent;
import common.control.ReportListener;
import common.gui.forms.GenericForm;
import common.misc.ClientConstants;
import common.misc.ZipHandler;
import common.pdf.pdfviewer.Values;
import common.pdf.pdfviewer.utils.Printer;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.border.SoftBevelBorder;
import org.icepdf.ri.common.ComponentKeyBinding;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.jdom.Element;

public class PDFViewer
implements ReportListener {
    private JInternalFrame frame = new JInternalFrame();
    protected Values commonValues = new Values();
    private boolean painted = true;
    protected Printer currentPrinter = new Printer();
    private SwingController controller = new SwingController();
    private SwingViewBuilder factory = new SwingViewBuilder(this.controller);
    JPanel viewerComponentPanel = this.factory.buildViewerPanel();
    protected String[] scalingValues;
    private Element data;
    private ZipHandler zip;
    private String idReport;
    private JProgressBar progressBar;
    private JWindow frameBar;
    private GenericForm GFforma;

    public PDFViewer(GenericForm GFforma, String idReport) {
        this.GFforma = GFforma;
        this.frame.setMaximizable(true);
        this.frame.setResizable(true);
        this.frame.setIconifiable(true);
        this.frame.setClosable(true);
        this.frame.setSize(800, 600);
        this.frame.setFrameIcon(new ImageIcon(this.getClass().getResource("/icons/ico_reporte.png")));
        this.zip = new ZipHandler();
        this.idReport = idReport;
        this.frameBar = new JWindow();
        this.progressBar = new JProgressBar();
        int x = ClientConstants.MAX_WIN_SIZE_WIDTH / 2 - 70;
        int y = ClientConstants.MAX_WIN_SIZE_HEIGHT / 2 - 7;
        this.frameBar.setLocation(x, y);
        this.frameBar.setSize(140, 15);
        this.progressBar.setBorder(new SoftBevelBorder(1));
        this.progressBar.setStringPainted(false);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setForeground(new Color(255, 162, 0));
        this.frameBar.add((Component)this.progressBar, "Center");
        ClientHeaderValidator.addReportListener(this);
        ComponentKeyBinding.install((SwingController)this.controller, (JComponent)this.viewerComponentPanel);
        this.controller.getDocumentViewController().setAnnotationCallback((AnnotationCallback)new MyAnnotationCallback(this.controller.getDocumentViewController()));
        this.frame.add(this.viewerComponentPanel);
    }

    public void viewProgressVar() {
        this.frameBar.setVisible(true);
    }

    public void openReport(String reportTitle, byte[] bytes) {
        String memFlag;
        this.frame.setTitle(reportTitle);
        String hiresFlag = System.getProperty("hires");
        if (hiresFlag != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((memFlag = System.getProperty("memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        this.commonValues.setUseHiresImage(false);
        this.commonValues.maxViewY = 0;
        if (bytes != null) {
            this.commonValues.setPdfArray(bytes);
            this.commonValues.setFileSize(bytes.length);
            String page = System.getProperty("Page");
            if (page != null) {
                int pageNum = -1;
                try {
                    pageNum = Integer.parseInt(page);
                    if (pageNum < 1) {
                        pageNum = -1;
                        System.err.println(page + " must be 1 or larger. Opening on page 1");
                    }
                }
                catch (Exception e) {
                    System.err.println(page + "is not a valid number for a page number. Opening on page 1");
                }
            } else {
                this.controller.openDocument(bytes, 0, bytes.length, reportTitle, null);
            }
            bytes = null;
        }
        this.frame.repaint();
        this.GFforma.getJDPpanel().repaint();
    }

    public void setEnabled(boolean value) {
        this.frame.setEnabled(value);
    }

    public JPanel getJPanel() {
        return this.viewerComponentPanel;
    }

    public JInternalFrame getJInternalFrame() {
        System.out.println("llamando panel...");
        return this.frame;
    }

    @Override
    public void arriveReport(ReportEvent e) {
        if (e.getIdReport().equals(this.idReport) && !e.isPlainReport() && this.painted) {
            try {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum(10);
                this.progressBar.setValue(10);
                this.frameBar.setVisible(false);
                this.painted = false;
                this.data = e.getData();
                if (this.data != null) {
                    byte[] bytesReport = this.zip.getDataDecode(this.data.getValue());
                    this.openReport(e.getTitleReport(), bytesReport);
                }
            }
            catch (IOException IOEe) {
                IOEe.printStackTrace();
            }
        }
    }
}

