/*
 * Decompiled with CFR 0.152.
 */
package common.printer;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import common.control.ClientHeaderValidator;
import common.control.SuccessEvent;
import common.control.SuccessListener;
import common.gui.forms.GenericForm;
import common.misc.ZipHandler;
import common.misc.text.NumberToLetterConversor;
import common.printer.AbstractManager;
import common.printer.CalculatePages;
import common.printer.PrintingManager;
import common.printer.QRGenerator;
import common.printer.TagPrintersDB;
import common.transactions.TransactionServerException;
import common.transactions.TransactionServerResultSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.BarcodeFactory;
import net.sourceforge.barbecue.BarcodeImageHandler;
import net.sourceforge.barbecue.output.OutputException;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class GraphicsPrintManager
implements AbstractManager,
SuccessListener {
    private PrintingManager.ImpresionType impresionType = PrintingManager.ImpresionType.PDF;
    private String bd = "";
    private String ndocument;
    private String fecha;
    private String qr;
    private String cufe;
    private String idTransaction = "";
    private Element rootTemplate;
    private Element rootTransact;
    private Document document;
    private PdfContentByte cb;
    private Graphics2D g2d;
    private PdfTemplate template;
    private boolean success = false;
    private boolean successful;
    private Hashtable<String, String> hcufe;
    private String claveAcceso;
    private ByteArrayOutputStream outPut = new ByteArrayOutputStream();
    private ProcessTemplate processTemplate;
    private GenericForm gfforma;
    private int countPacks;
    private float width;
    private float height;

    public GraphicsPrintManager(GenericForm gfforma) {
        System.out.println("*************************************Instanciando con nuevo motor de impresion desde cliente...");
        ClientHeaderValidator.addSuccessListener(this);
        this.gfforma = gfforma;
    }

    public GraphicsPrintManager(GenericForm gfforma, String iddoc) {
        ClientHeaderValidator.addSuccessListener(this);
        this.ndocument = iddoc;
        this.gfforma = gfforma;
    }

    public GraphicsPrintManager(String bd, GenericForm gfforma, Element template, Element packages, String iddoc, String fecha, String qr, String cufe) {
        ClientHeaderValidator.addSuccessListener(this);
        this.ndocument = iddoc;
        this.fecha = fecha;
        this.qr = qr;
        this.cufe = cufe;
        this.bd = bd;
        this.rootTemplate = template;
        this.rootTransact = packages;
        this.gfforma = gfforma;
        System.out.println("*************************************Instanciando con nuevo motor de impresion...");
    }

    public void processPDF() {
        try {
            System.out.println("***************************************Procesando con nuevo motor de impresion...");
            Attribute ATTRequesNumeration = this.rootTemplate.getAttribute("requestNumeration");
            if (ATTRequesNumeration != null && ATTRequesNumeration.getBooleanValue()) {
                int times = 0;
                while (!this.success) {
                    try {
                        if (times > 100) {
                            System.out.println("No se pudo obtner la numeracion de " + this.rootTemplate.getAttributeValue("name"));
                            return;
                        }
                        Thread.sleep(100L);
                        ++times;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            Calendar calendar = Calendar.getInstance();
            long init = calendar.getTimeInMillis();
            Element settings = this.rootTemplate.getChild("settings");
            this.width = settings.getAttribute("width").getFloatValue();
            this.height = settings.getAttribute("height").getFloatValue();
            Attribute ATorientation = this.rootTemplate.getAttribute("orientation");
            String orientation = ATorientation != null ? ATorientation.getValue() : null;
            this.document = new Document(new Rectangle(this.width, this.height));
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.outPut);
            this.document.addTitle("outout.pdf");
            this.document.open();
            this.cb = pdfWriter.getDirectContent();
            this.document.newPage();
            System.out.println("----tama\u00f1o width: " + this.width + " x " + this.height);
            this.template = this.cb.createTemplate(this.width, this.height);
            this.g2d = new PdfGraphics2D((PdfContentByte)this.template, this.width, this.height);
            this.cb.addTemplate(this.template, 0.0f, 0.0f);
            int totalPage = CalculatePages.getPagesNumber(this.rootTemplate, this.rootTransact);
            this.processTemplate = new ProcessTemplate(totalPage);
            this.processTemplate.processMetadata(this.rootTemplate.getChild("metadata"));
            Iterator itTemplate = this.rootTemplate.getChildren("package").iterator();
            List itTransact = this.rootTransact.getChildren("package");
            int j = 0;
            while (itTemplate.hasNext()) {
                boolean validate;
                Element elmTemplate = (Element)itTemplate.next();
                System.out.println("Template: " + elmTemplate);
                Element elmTransact = (Element)itTransact.get(j);
                System.out.println("Transac: " + elmTransact.getValue());
                boolean nspk = false;
                try {
                    Element nextTransact = (Element)itTransact.get(j + 1);
                    if (nextTransact != null) {
                        nspk = this.validOtherSubPackage(nextTransact);
                    }
                }
                catch (IndexOutOfBoundsException nextTransact) {
                    // empty catch block
                }
                Attribute attr = elmTemplate.getAttribute("validate");
                this.countPacks += elmTransact.getChildren().size();
                boolean bl = validate = attr != null ? attr.getBooleanValue() : false;
                if (validate) {
                    if (elmTransact.getChildren().size() > 0) {
                        this.processTemplate.processElement(elmTemplate, elmTransact, nspk);
                    }
                } else {
                    this.processTemplate.processElement(elmTemplate, elmTransact, nspk);
                }
                ++j;
            }
            if (this.countPacks > 0) {
                this.successful = true;
                calendar = Calendar.getInstance();
                long end = calendar.getTimeInMillis();
                System.out.println("Generador en " + (end - init) + " milisegundos ");
            }
            this.g2d.dispose();
            this.cb.addTemplate(this.template, 0.0f, 0.0f);
            this.outPut.close();
            this.document.close();
        }
        catch (DataConversionException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentException e1) {
            e1.printStackTrace();
        }
    }

    private boolean validOtherSubPackage(Element elm) {
        Iterator spk = elm.getChildren("subpackage").iterator();
        if (spk.hasNext()) {
            Element e = (Element)spk.next();
            System.out.println("elemento: " + e.getValue());
            return true;
        }
        return false;
    }

    @Override
    public void cathSuccesEvent(SuccessEvent e) {
        String numeration = e.getNdocument();
        String fecha = e.getDate();
        System.out.println("llego paquete success: " + numeration + " transaction " + this.idTransaction + " idpackage " + e.getIdPackage());
        if (numeration != null && !"".equals(numeration) && this.idTransaction.equals(e.getIdPackage())) {
            this.success = true;
            this.ndocument = numeration;
            this.fecha = fecha;
            System.out.println("cargando cufe");
            this.hcufe = e.getCufe();
            this.claveAcceso = e.getClaveAcceso();
        }
    }

    public void setIdTransaction(String idTransaction) {
        this.idTransaction = idTransaction;
    }

    public void setNdocument(String lastNumber) {
        this.ndocument = lastNumber;
    }

    public void setQr(String qr) {
        this.qr = qr;
    }

    public void setCUFE(String CUFE) {
        this.cufe = CUFE;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    @Override
    public ByteArrayInputStream getStream() {
        System.out.println("----CountPacks: " + this.countPacks);
        if (this.countPacks > 0) {
            ByteArrayInputStream in = new ByteArrayInputStream(this.outPut.toByteArray());
            return in;
        }
        return null;
    }

    @Override
    public boolean isSuccessful() {
        return false;
    }

    @Override
    public PrintingManager.ImpresionType getImpresionType() {
        return this.impresionType;
    }

    @Override
    public void processPDF(Element template, Element packages) {
        this.rootTemplate = template;
        this.rootTransact = packages;
        this.processPDF();
    }

    @Override
    public void processPostScript(Element template, Element packages) {
    }

    class ProcessTemplate {
        private int currentRow = 1;
        private int rowAcum = 0;
        private int pageCount = 1;
        private int totalPages;
        private int index = 0;
        private String documentPrefix;
        private Vector<Query> sqlData = new Vector();
        private Vector<ElementMultiPage> multiPageField = new Vector();
        private int rowNextPage = 0;
        final BasicStroke stroke = new BasicStroke(0.3f);

        public ProcessTemplate(int totalPages) {
            this.totalPages = totalPages;
        }

        protected void processMetadata(Element elm) throws DataConversionException {
            this.processMetadata(elm, true);
        }

        private void processMetadata(Element element, boolean newpage) throws DataConversionException {
            if (element != null) {
                System.out.println("procesando metadata");
                for (Element e : element.getChildren()) {
                    String value;
                    String name = e.getName();
                    Iterator itAttribs = e.getAttributes().iterator();
                    HashMap<String, Attribute> attribs = new HashMap<String, Attribute>();
                    while (itAttribs.hasNext()) {
                        Attribute attribute = (Attribute)itAttribs.next();
                        attribs.put(attribute.getName(), attribute);
                    }
                    Attribute attr = (Attribute)attribs.get("row");
                    Attribute color = (Attribute)attribs.get("color");
                    Attribute type = (Attribute)attribs.get("type");
                    Attribute center = (Attribute)attribs.get("center");
                    Attribute impValue = (Attribute)attribs.get("importValue");
                    Attribute fontSize = e.getAttribute("fontSize");
                    Attribute fontName = e.getAttribute("fontName");
                    Attribute fontStyle = e.getAttribute("fontStyle");
                    if (fontSize != null && fontName != null && fontStyle != null) {
                        Font newFont = new Font(fontName.getValue(), fontStyle.getIntValue(), fontSize.getIntValue());
                        GraphicsPrintManager.this.g2d.setFont(newFont);
                    }
                    if (color != null) {
                        StringTokenizer st = new StringTokenizer(color.getValue(), ",");
                        int r = Integer.parseInt(st.nextToken());
                        int g = Integer.parseInt(st.nextToken());
                        int b = Integer.parseInt(st.nextToken());
                        Color fcolor = new Color(r, g, b);
                        GraphicsPrintManager.this.g2d.setColor(fcolor);
                    } else {
                        GraphicsPrintManager.this.g2d.setColor(Color.BLACK);
                    }
                    boolean lrow = true;
                    try {
                        lrow = ((Attribute)attribs.get("incrementRow")).getBooleanValue();
                    }
                    catch (NullPointerException r) {
                        // empty catch block
                    }
                    int row = 0;
                    String srow = attr.getValue();
                    row = srow.equals("last") ? this.currentRow : Integer.valueOf(srow);
                    int col = attribs.get("col") != null ? ((Attribute)attribs.get("col")).getIntValue() : -1;
                    GraphicsPrintManager.this.g2d.setStroke(this.stroke);
                    if ("line".equals(name)) {
                        int row2 = 0;
                        String srow2 = ((Attribute)attribs.get("row2")).getValue();
                        row2 = srow2.equals("last") ? row : Integer.parseInt(srow2);
                        int col2 = ((Attribute)attribs.get("col2")).getIntValue();
                        GraphicsPrintManager.this.g2d.drawLine(col, row, col2, row2);
                    } else if ("roundedRectangle".equals(name)) {
                        int width = ((Attribute)attribs.get("width")).getIntValue();
                        int height = ((Attribute)attribs.get("height")).getIntValue();
                        Attribute background = (Attribute)attribs.get("background");
                        if (background != null) {
                            StringTokenizer back = new StringTokenizer(background.getValue(), ",");
                            int r = Integer.parseInt(back.nextToken());
                            int g = Integer.parseInt(back.nextToken());
                            int b = Integer.parseInt(back.nextToken());
                            GraphicsPrintManager.this.g2d.setColor(new Color(r, g, b));
                            GraphicsPrintManager.this.g2d.fill(new RoundRectangle2D.Double(col, row, width, height, 10.0, 10.0));
                            GraphicsPrintManager.this.g2d.setColor(Color.BLACK);
                        }
                        GraphicsPrintManager.this.g2d.draw(new RoundRectangle2D.Double(col, row, width, height, 10.0, 10.0));
                    } else if ("froundedRectangle".equals(name)) {
                        int width = ((Attribute)attribs.get("width")).getIntValue();
                        int height = ((Attribute)attribs.get("height")).getIntValue();
                        GraphicsPrintManager.this.g2d.setColor(Color.WHITE);
                        GraphicsPrintManager.this.g2d.fill(new RoundRectangle2D.Double(col, row, width, height, 10.0, 10.0));
                        GraphicsPrintManager.this.g2d.setColor(Color.BLACK);
                        GraphicsPrintManager.this.g2d.draw(new RoundRectangle2D.Double(col, row, width, height, 10.0, 10.0));
                    } else if ("rectangle".equals(name)) {
                        int width = ((Attribute)attribs.get("width")).getIntValue();
                        int height = ((Attribute)attribs.get("height")).getIntValue();
                        Attribute background = (Attribute)attribs.get("background");
                        if (background != null) {
                            StringTokenizer back = new StringTokenizer(background.getValue(), ",");
                            int r = Integer.parseInt(back.nextToken());
                            int g = Integer.parseInt(back.nextToken());
                            int b = Integer.parseInt(back.nextToken());
                            GraphicsPrintManager.this.g2d.setColor(new Color(r, g, b));
                            GraphicsPrintManager.this.g2d.fillRect(col, row, width, height);
                            GraphicsPrintManager.this.g2d.setColor(Color.BLACK);
                        }
                        GraphicsPrintManager.this.g2d.drawRect(col, row, width, height);
                    } else if ("image".equals(name)) {
                        try {
                            BufferedImage image;
                            try {
                                System.out.println("getClass: " + this.getClass().getResource(e.getTextTrim()));
                                image = ImageIO.read(this.getClass().getResource(e.getTextTrim()));
                                GraphicsPrintManager.this.g2d.drawImage(image, col, row, image.getWidth(), image.getHeight(), null);
                            }
                            catch (IllegalArgumentException ie) {
                                try {
                                    System.out.println("tag: " + GraphicsPrintManager.this.bd + e.getTextTrim());
                                    System.out.println("valor: " + TagPrintersDB.getTag(GraphicsPrintManager.this.bd + e.getTextTrim()));
                                    image = ImageIO.read(this.getClass().getResource(TagPrintersDB.getTag(GraphicsPrintManager.this.bd + e.getTextTrim())));
                                    GraphicsPrintManager.this.g2d.drawImage(image, col, row, image.getWidth(), image.getHeight(), null);
                                }
                                catch (NullPointerException npe) {
                                    npe.printStackTrace();
                                }
                            }
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    } else if ("barcodeImage".equals(name)) {
                        try {
                            value = GraphicsPrintManager.this.ndocument == null ? "" : GraphicsPrintManager.this.ndocument;
                            String val = "0000000000" + value;
                            val = val.substring(val.length() - 10, val.length());
                            Barcode barcode = BarcodeFactory.createCode128B((String)val);
                            barcode.setBarHeight(5);
                            barcode.setBarWidth(1);
                            barcode.setDrawingText(false);
                            BufferedImage image = BarcodeImageHandler.getImage((Barcode)barcode);
                            System.out.println("Tama\u00f1o de la imagen, ancho: " + (double)image.getWidth() * 0.9 + " alto " + (double)image.getHeight() * 0.9);
                            GraphicsPrintManager.this.g2d.drawImage(image, col, row, (int)((double)image.getWidth() * 0.9), (int)((double)image.getHeight() * 0.9), null);
                        }
                        catch (BarcodeException BEe) {
                            BEe.printStackTrace();
                        }
                        catch (OutputException Oe) {
                            Oe.printStackTrace();
                        }
                    } else if ("dbimage".equals(name)) {
                        try {
                            System.out.println("es una imagen");
                            ZipHandler zip = new ZipHandler();
                            byte[] bytesImage = zip.getDataDecode(e.getTextTrim());
                            String nameFile = zip.getCurrentFile();
                            System.out.println("nombre del archivo: " + nameFile);
                            String fileType = nameFile.substring(nameFile.indexOf(".") + 1);
                            ByteArrayInputStream image = new ByteArrayInputStream(bytesImage);
                            BufferedImage img = ImageIO.read(image);
                            System.out.println("Imprimiendo imangen en " + col + "," + row);
                            GraphicsPrintManager.this.g2d.drawImage(img, col, row, img.getWidth(), img.getHeight(), null);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    } else if ("field".equals(name)) {
                        value = e.getTextTrim();
                        value = " ".equals(value) || "".equals(value) ? "  " : value;
                        int length = -1;
                        if (center != null) {
                            length = center.getIntValue();
                        }
                        if (type != null && type.getValue().equals("NAMEDB")) {
                            System.out.println("value: " + value);
                            if (length > 0) {
                                FontMetrics fm = GraphicsPrintManager.this.g2d.getFontMetrics();
                                int centerPage = length / 2;
                                System.out.println("bd+value: " + GraphicsPrintManager.this.bd + value);
                                int wordLength = fm.stringWidth(TagPrintersDB.getTag(GraphicsPrintManager.this.bd + value));
                                col = centerPage - wordLength / 2;
                            }
                            try {
                                GraphicsPrintManager.this.g2d.drawString(TagPrintersDB.getTag(GraphicsPrintManager.this.bd + value), col, row);
                            }
                            catch (NullPointerException NPEe) {
                                System.out.println("No existe en TagPrintersDB: " + GraphicsPrintManager.this.bd + value);
                                NPEe.printStackTrace();
                            }
                        } else {
                            boolean importValue = impValue != null ? impValue.getBooleanValue() : false;
                            String val = null;
                            String string = val = GraphicsPrintManager.this.gfforma != null && importValue ? GraphicsPrintManager.this.gfforma.getExternalValueString(value) : value;
                            if (val == null || "".equals(val)) {
                                val = value;
                            }
                            if (length > 0) {
                                FontMetrics fm = GraphicsPrintManager.this.g2d.getFontMetrics();
                                int centerPage = length / 2;
                                int wordLength = fm.stringWidth(val);
                                col = centerPage - wordLength / 2;
                            }
                            GraphicsPrintManager.this.g2d.drawString(val, col, row);
                        }
                    } else if ("ndocument".equals(name)) {
                        Attribute att = (Attribute)attribs.get("mask");
                        String mask = null;
                        if (att != null) {
                            mask = att.getValue();
                        }
                        String value2 = null;
                        String format = e.getAttributeValue("format");
                        System.out.println("formato: " + format);
                        if (format != null && format.equals("Integer")) {
                            value2 = GraphicsPrintManager.this.ndocument == null ? "" : "" + Integer.parseInt(GraphicsPrintManager.this.ndocument);
                        } else {
                            String string = value2 = GraphicsPrintManager.this.ndocument == null ? "" : GraphicsPrintManager.this.ndocument;
                        }
                        if (mask != null) {
                            DecimalFormat formatter = new DecimalFormat(mask);
                            value2 = !"NULL".equals(value2) && !"".equals(value2) ? formatter.format(Double.parseDouble(value2)) : "";
                        }
                        int length = -1;
                        if (center != null) {
                            length = center.getIntValue();
                            FontMetrics fm = GraphicsPrintManager.this.g2d.getFontMetrics();
                            int centerPage = length / 2;
                            int wordLength = fm.stringWidth(value2);
                            col = centerPage - wordLength / 2;
                        }
                        GraphicsPrintManager.this.g2d.drawString(value2, col, row);
                    } else if ("cufe".equals(name)) {
                        value = null;
                        String format = e.getAttributeValue("format");
                        System.out.println("formato: " + format);
                        int length = -1;
                        if (center != null) {
                            length = center.getIntValue();
                        }
                        value = GraphicsPrintManager.this.cufe != null ? GraphicsPrintManager.this.cufe : "CUFE: " + (String)GraphicsPrintManager.this.hcufe.get("cufe");
                        if (length > 0) {
                            FontMetrics fm = GraphicsPrintManager.this.g2d.getFontMetrics();
                            int centerPage = length / 2;
                            int wordLength = fm.stringWidth(value);
                            col = centerPage - wordLength / 2;
                        }
                        GraphicsPrintManager.this.g2d.drawString(value, col, row);
                    } else if ("claveAcceso".equals(name)) {
                        GraphicsPrintManager.this.g2d.drawString(GraphicsPrintManager.this.claveAcceso, col, row);
                    } else if ("qr".equals(name)) {
                        String cufe = null;
                        if (GraphicsPrintManager.this.qr != null && !"".equals(GraphicsPrintManager.this.qr)) {
                            System.out.println("qr!=null: " + GraphicsPrintManager.this.qr);
                            cufe = GraphicsPrintManager.this.qr;
                        } else {
                            cufe = "NumFac: " + (String)GraphicsPrintManager.this.hcufe.get("numfac") + "\nFecFac: " + (String)GraphicsPrintManager.this.hcufe.get("fecfac") + "\nHorFac: " + (String)GraphicsPrintManager.this.hcufe.get("horfac") + "\nNitFac: " + (String)GraphicsPrintManager.this.hcufe.get("nitfac") + "\nDocAdq: " + (String)GraphicsPrintManager.this.hcufe.get("docadq") + "\nValFac: " + (String)GraphicsPrintManager.this.hcufe.get("valfac") + "\nValIva: " + (String)GraphicsPrintManager.this.hcufe.get("valiva") + "\nValOtroIm: " + (String)GraphicsPrintManager.this.hcufe.get("valotroim") + "\nValTolFac: " + (String)GraphicsPrintManager.this.hcufe.get("valfacim") + "\nCUFE: " + (String)GraphicsPrintManager.this.hcufe.get("cufe") + "\nqr:" + (String)GraphicsPrintManager.this.hcufe.get("qr");
                        }
                        System.out.println("CUFE : " + cufe + " QR: " + GraphicsPrintManager.this.qr);
                        QRGenerator qr = new QRGenerator();
                        int width = ((Attribute)attribs.get("width")).getIntValue();
                        int height = ((Attribute)attribs.get("height")).getIntValue();
                        GraphicsPrintManager.this.g2d.drawImage(qr.generateQR(cufe), col, row, width, height, null);
                    } else if ("date".equals(name)) {
                        String mask = ((Attribute)attribs.get("mask")).getValue();
                        SimpleDateFormat sdf = new SimpleDateFormat(mask);
                        Calendar c = Calendar.getInstance();
                        int year = Integer.valueOf(GraphicsPrintManager.this.fecha.substring(0, 4));
                        int month = Integer.valueOf(GraphicsPrintManager.this.fecha.substring(5, 7));
                        int day = Integer.valueOf(GraphicsPrintManager.this.fecha.substring(8, 10));
                        c.set(1, year);
                        c.set(2, month - 1);
                        c.set(5, day);
                        String value3 = sdf.format(c.getTime());
                        System.out.println("fecha de impresion: " + GraphicsPrintManager.this.fecha);
                        GraphicsPrintManager.this.g2d.drawString(value3, col, row);
                    } else if ("time".equals(name)) {
                        if (GraphicsPrintManager.this.fecha == null || GraphicsPrintManager.this.fecha.equals("")) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:SS");
                            GraphicsPrintManager.this.fecha = sdf.format(new Date());
                        }
                        value = GraphicsPrintManager.this.fecha.substring(11, 19);
                        GraphicsPrintManager.this.g2d.drawString(value, col, row);
                    } else if ("pagenumber".equals(name)) {
                        value = "Pag. " + this.pageCount + " de " + this.totalPages;
                        int length = -1;
                        if (center != null) {
                            length = center.getIntValue();
                        }
                        if (length > 0) {
                            FontMetrics fm = GraphicsPrintManager.this.g2d.getFontMetrics();
                            int centerPage = length / 2;
                            int wordLength = fm.stringWidth(value);
                            col = centerPage - wordLength / 2;
                        }
                        GraphicsPrintManager.this.g2d.drawString(value, col, row);
                    } else if ("font".equals(name)) {
                        GraphicsPrintManager.this.g2d.setFont(new Font(((Attribute)attribs.get("name")).getValue(), 0, ((Attribute)attribs.get("size")).getIntValue()));
                    } else if ("documentPrefix".equals(name)) {
                        this.documentPrefix = e.getValue();
                    } else if ("sqlData".equals(name)) {
                        this.sqlData.add(new Query(e.getTextTrim(), col, row));
                    }
                    if (!newpage) continue;
                    if (lrow) {
                        this.currentRow = row + this.rowAcum;
                        continue;
                    }
                    this.currentRow = row;
                }
                Iterator<Query> sqls = this.sqlData.iterator();
                if (GraphicsPrintManager.this.ndocument != null) {
                    System.out.println("ndocumento NO es nulo");
                    org.jdom.Document request = null;
                    while (sqls.hasNext()) {
                        Query query = sqls.next();
                        String sql = query.getSql();
                        String[] args = new String[]{GraphicsPrintManager.this.ndocument, this.documentPrefix};
                        try {
                            request = TransactionServerResultSet.getResultSetST(sql, args);
                            Element rootElement = request.getRootElement();
                            Element row = rootElement.getChild("row");
                            String strVal = row.getChildText("col");
                            GraphicsPrintManager.this.g2d.drawString(strVal, query.getX(), query.getY());
                            request = null;
                        }
                        catch (TransactionServerException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    System.out.println("ndocumento es nulo");
                }
            }
        }

        protected void processElement(Element pack_template, Element pack_transaction, boolean nspk) throws DataConversionException {
            Iterator it_template = pack_template.getChildren().iterator();
            List l_transaction = pack_transaction.getChildren();
            Iterator it_transaction = l_transaction.iterator();
            System.out.println("numero de elementos: " + l_transaction.size());
            int enters = 1;
            int sbpks = 0;
            int tsbpks = l_transaction.size();
            while (it_template.hasNext() && it_transaction.hasNext()) {
                int col;
                String srow1;
                Element el_template = (Element)it_template.next();
                if (el_template.getName().equals("subpackage")) {
                    int rowInit = 0;
                    String srowInit = el_template.getAttribute("rowInit").getValue();
                    this.rowAcum = el_template.getAttribute("rowAcum").getIntValue();
                    rowInit = srowInit.equals("last") ? (this.currentRow == this.rowAcum ? this.currentRow + this.rowAcum : this.currentRow) : Integer.valueOf(srowInit);
                    int rowInitNewPage = this.loadIntAttributes(el_template, "rowInitNewPage");
                    int maxRowsAcumNewPage = this.loadIntAttributes(el_template, "maxRowsAcumNewPage");
                    int maxRowsFootPage = this.loadIntAttributes(el_template, "maxRowsFootPage");
                    int maxRowsFootNewPage = this.loadIntAttributes(el_template, "maxRowsFootNewPage");
                    int maxAcum = this.pageCount == 1 ? this.loadIntAttributes(el_template, "maxRowsAcum") : maxRowsAcumNewPage;
                    System.out.println("+++++++++++++++++++++++++++++++++++pageCount: " + this.pageCount + " maxAcum: " + maxAcum);
                    System.out.println("maxRowsAcumNewPage: " + maxRowsAcumNewPage);
                    int colCounter = this.loadIntAttributes(el_template, "colCounter");
                    int counter = 0;
                    Attribute atcolTextTotalGroup = el_template.getAttribute("colTextTotalGroup");
                    Attribute attextTotalGroup = el_template.getAttribute("textTotalGroup");
                    int colAcumGroup = this.loadIntAttributes(el_template, "colAcumGroup");
                    int colTotalGroup = this.loadIntAttributes(el_template, "colTotalGroup");
                    int colTextTotalGroup = atcolTextTotalGroup != null ? atcolTextTotalGroup.getIntValue() : 0;
                    String textTotalGroup = attextTotalGroup != null ? attextTotalGroup.getValue() : "";
                    Iterator it = el_template.getChildren("field").iterator();
                    ArrayList<HashMap<String, Attribute>> AttCols = this.loadAttributes(it);
                    if (it_transaction.hasNext()) {
                        String groupAcum = null;
                        double totalGroup = 0.0;
                        Element element = null;
                        Iterator iterator = null;
                        String next = null;
                        while (it_transaction.hasNext()) {
                            ++this.index;
                            element = (Element)it_transaction.next();
                            iterator = element.getChildren().iterator();
                            if (groupAcum != null && colAcumGroup != -1) {
                                if (it_transaction.hasNext()) {
                                    next = ((Element)element.getChildren().get(colAcumGroup)).getValue();
                                }
                                if (!groupAcum.equals(next)) {
                                    this.addInfoSubGrupo(AttCols.get(colTotalGroup), textTotalGroup, colTextTotalGroup, totalGroup, colTotalGroup, rowInit);
                                    this.currentRow = (rowInit += this.rowAcum + this.rowAcum) < this.currentRow ? this.currentRow : rowInit;
                                    ++this.index;
                                    ++this.index;
                                    groupAcum = null;
                                    totalGroup = 0.0;
                                    if (this.index >= maxAcum && maxAcum != -1) {
                                        System.out.println("************************* paginando por groupAcum: ");
                                        this.newPage();
                                        rowInit = rowInitNewPage;
                                        maxAcum = maxRowsAcumNewPage;
                                        this.index = 0;
                                    }
                                }
                            }
                            int i = 0;
                            ++sbpks;
                            while (iterator.hasNext()) {
                                Attribute att = new Attribute("row", String.valueOf(rowInit));
                                AttCols.get(i).put("row", att);
                                System.out.println("Imprimiendo columna counter " + counter + " i: " + i + " colCounter: " + colCounter);
                                if (i == 0 && colCounter != -1) {
                                    Attribute attCol = new Attribute("col", String.valueOf(colCounter));
                                    System.out.println("Imprimiendo contador de linea");
                                    Attribute attColOk = AttCols.get(0).get("col");
                                    AttCols.get(i).put("col", attCol);
                                    AttCols.get(i).put("row", att);
                                    this.addValue(String.valueOf(++counter), AttCols.get(0));
                                    AttCols.get(i).put("col", attColOk);
                                }
                                Element elmt = (Element)iterator.next();
                                System.out.println("rowInit ++++++++++" + rowInit + " valor " + elmt.getValue());
                                enters = this.addValue(elmt.getValue(), AttCols.get(i));
                                Attribute incrementRow = AttCols.get(i).get("incrementRow");
                                if (incrementRow != null && Boolean.parseBoolean(incrementRow.getValue())) {
                                    int n = this.currentRow = (rowInit += this.rowAcum) < this.currentRow ? this.currentRow : rowInit;
                                }
                                if (colAcumGroup == i) {
                                    groupAcum = elmt.getValue();
                                }
                                if (colTotalGroup == i) {
                                    totalGroup += Double.parseDouble(elmt.getValue());
                                }
                                ++i;
                            }
                            if (this.index >= maxAcum && maxAcum != -1) {
                                System.out.println("******************paginando index>maxAcum " + this.index + ">" + maxAcum);
                                this.newPage();
                                rowInit = rowInitNewPage;
                                maxAcum = maxRowsAcumNewPage;
                                this.index = 0;
                                tsbpks -= sbpks;
                                sbpks = 0;
                            }
                            System.out.println("****************************** item " + sbpks + " de " + tsbpks);
                            if (maxRowsFootNewPage != -1 && maxRowsFootPage != -1 && maxAcum != -1 && this.pageCount == 1 && this.index >= maxRowsFootPage && this.index < maxAcum && sbpks + 1 == tsbpks) {
                                System.out.println("******************************paginando gran validacion primera pagina... item " + sbpks + " de " + tsbpks);
                                this.newPage();
                                rowInit = rowInitNewPage;
                                maxAcum = maxRowsAcumNewPage;
                                this.index = 0;
                                tsbpks -= sbpks;
                                sbpks = 0;
                            } else if (maxRowsFootNewPage != -1 && this.index >= maxRowsFootNewPage && this.index < maxAcum && sbpks + 1 == tsbpks) {
                                System.out.println("******************************paginando gran validacion siguiente pagina...");
                                this.newPage();
                                rowInit = rowInitNewPage;
                                maxAcum = maxRowsAcumNewPage;
                                this.index = 0;
                                tsbpks -= sbpks;
                                sbpks = 0;
                            }
                            this.currentRow = (rowInit += this.rowAcum * enters) < this.currentRow ? this.currentRow : rowInit;
                        }
                        if (!nspk) {
                            this.processMetadata(GraphicsPrintManager.this.rootTemplate.getChild("endofpage"), false);
                        }
                        if (groupAcum != null && colAcumGroup != -1) {
                            this.addInfoSubGrupo(AttCols.get(colTotalGroup), textTotalGroup, colTextTotalGroup, totalGroup, colTotalGroup, rowInit);
                        }
                    }
                    while (it_transaction.hasNext() && maxAcum == -1 || rowInit < maxAcum) {
                        Element element = (Element)it_transaction.next();
                        Iterator iterator = element.getChildren().iterator();
                        int i = 0;
                        while (iterator.hasNext()) {
                            Element elmt = (Element)iterator.next();
                            Attribute incrementRow = AttCols.get(i).get("incrementRow");
                            Attribute att = new Attribute("row", String.valueOf(rowInit));
                            AttCols.get(i).put("row", att);
                            this.addValue(elmt.getValue(), AttCols.get(i));
                            ++i;
                            if (incrementRow == null || !Boolean.parseBoolean(incrementRow.getValue())) continue;
                            this.currentRow = (rowInit += this.rowAcum) < this.currentRow ? this.currentRow : rowInit;
                        }
                        this.currentRow = (rowInit += this.rowAcum) < this.currentRow ? this.currentRow : rowInit;
                    }
                    continue;
                }
                if (el_template.getName().equals("field")) {
                    Element el_transaction = (Element)it_transaction.next();
                    Iterator itAttribs = el_template.getAttributes().iterator();
                    HashMap<String, Attribute> attribs = new HashMap<String, Attribute>();
                    boolean attNewPage = false;
                    while (itAttribs.hasNext()) {
                        Attribute attribute = (Attribute)itAttribs.next();
                        attribs.put(attribute.getName(), attribute);
                        if (!"multipage".equals(attribute.getName()) || !attribute.getValue().equals("true")) continue;
                        attNewPage = true;
                    }
                    this.addValue(el_transaction.getValue(), attribs);
                    if (!attNewPage) continue;
                    attribs.remove("row");
                    attribs.remove("col");
                    Attribute row = attribs.get("rownewpage");
                    Attribute col2 = attribs.get("colnewpage");
                    Attribute colCenter = attribs.get("colcenternewpage");
                    attribs.put("row", row);
                    attribs.put("col", col2);
                    attribs.put("colCenter", colCenter);
                    this.multiPageField.add(new ElementMultiPage(el_transaction.getValue(), attribs));
                    continue;
                }
                if (el_template.getName().equals("line")) {
                    int row1 = 0;
                    int row2 = 0;
                    String srow12 = el_template.getAttributeValue("row");
                    String srow2 = el_template.getAttributeValue("row2");
                    int col1 = Integer.parseInt(el_template.getAttributeValue("col"));
                    int col2 = Integer.parseInt(el_template.getAttributeValue("col2"));
                    row1 = srow12.equals("last") ? this.currentRow : Integer.parseInt(srow12);
                    row2 = srow2.equals("last") ? this.currentRow : Integer.parseInt(srow2);
                    GraphicsPrintManager.this.g2d.drawLine(col1, row1, col2, row2);
                    this.currentRow += Integer.parseInt(el_template.getAttributeValue("rowAcum"));
                    continue;
                }
                if ("ndocument".equals(el_template.getName())) {
                    Attribute att = el_template.getAttribute("mask");
                    Attribute fontSize = el_template.getAttribute("fontSize");
                    Attribute fontName = el_template.getAttribute("fontName");
                    Attribute fontStyle = el_template.getAttribute("fontStyle");
                    Attribute center = el_template.getAttribute("center");
                    int length = -1;
                    if (fontSize != null && fontName != null && fontStyle != null) {
                        Font newFont = new Font(fontName.getValue(), fontStyle.getIntValue(), fontSize.getIntValue());
                        GraphicsPrintManager.this.g2d.setFont(newFont);
                    }
                    String mask = null;
                    if (att != null) {
                        mask = att.getValue();
                    }
                    String value = null;
                    String format = el_template.getAttributeValue("format");
                    System.out.println("formato: " + format);
                    if (format != null && format.equals("Integer")) {
                        value = GraphicsPrintManager.this.ndocument == null ? "" : "" + Integer.parseInt(GraphicsPrintManager.this.ndocument);
                    } else {
                        String string = value = GraphicsPrintManager.this.ndocument == null ? "" : GraphicsPrintManager.this.ndocument;
                    }
                    if (mask != null) {
                        DecimalFormat formatter = new DecimalFormat(mask);
                        value = !"NULL".equals(value) && !"".equals(value) ? formatter.format(Double.parseDouble(value)) : "";
                    }
                    int row = 0;
                    srow1 = el_template.getAttributeValue("row");
                    col = Integer.parseInt(el_template.getAttributeValue("col"));
                    row = srow1.equals("last") ? this.currentRow : Integer.parseInt(srow1);
                    if (center != null) {
                        length = center.getIntValue();
                        FontMetrics fm = GraphicsPrintManager.this.g2d.getFontMetrics();
                        int centerPage = length / 2;
                        int wordLength = fm.stringWidth(value);
                        col = centerPage - wordLength / 2;
                    }
                    GraphicsPrintManager.this.g2d.drawString(value, col, row);
                    continue;
                }
                if ("vndocument".equals(el_template.getName())) {
                    Attribute att = el_template.getAttribute("mask");
                    Attribute fontSize = el_template.getAttribute("fontSize");
                    Attribute fontName = el_template.getAttribute("fontName");
                    Attribute fontStyle = el_template.getAttribute("fontStyle");
                    if (fontSize != null && fontName != null && fontStyle != null) {
                        Font newFont = new Font(fontName.getValue(), fontStyle.getIntValue(), fontSize.getIntValue());
                        GraphicsPrintManager.this.g2d.setFont(newFont);
                    }
                    String mask = null;
                    if (att != null) {
                        mask = att.getValue();
                    }
                    String value = null;
                    String format = el_template.getAttributeValue("format");
                    System.out.println("formato: " + format);
                    if (format != null && format.equals("Integer")) {
                        value = GraphicsPrintManager.this.ndocument == null ? "" : "" + Integer.parseInt(GraphicsPrintManager.this.ndocument);
                    } else {
                        String string = value = GraphicsPrintManager.this.ndocument == null ? "" : GraphicsPrintManager.this.ndocument;
                    }
                    if (mask != null) {
                        DecimalFormat formatter = new DecimalFormat(mask);
                        value = !"NULL".equals(value) && !"".equals(value) ? formatter.format(Double.parseDouble(value)) : "";
                    }
                    int row = 0;
                    String srow13 = el_template.getAttributeValue("row");
                    int col3 = Integer.parseInt(el_template.getAttributeValue("col"));
                    row = srow13.equals("last") ? this.currentRow : Integer.parseInt(srow13);
                    AffineTransform at = new AffineTransform();
                    at.rotate(1.5707963267948966);
                    GraphicsPrintManager.this.g2d.setTransform(at);
                    System.out.println("********************imprimiendo vertical " + value + "en " + col3 + "," + row);
                    GraphicsPrintManager.this.g2d.drawString(value, row, col3 * -1);
                    at.rotate(Math.PI * 2);
                    GraphicsPrintManager.this.g2d.setTransform(at);
                    continue;
                }
                if (el_template.getName().equals("text")) {
                    Attribute fontSize = el_template.getAttribute("fontSize");
                    Attribute fontName = el_template.getAttribute("fontName");
                    Attribute fontStyle = el_template.getAttribute("fontStyle");
                    Attribute textLine = el_template.getAttribute("textLine");
                    Attribute textCol = el_template.getAttribute("textCol");
                    Attribute srowAcum = el_template.getAttribute("rowAcum");
                    Attribute impValue = el_template.getAttribute("importValue");
                    boolean importValue = impValue != null ? impValue.getBooleanValue() : false;
                    System.out.println("importValue " + importValue + " texto " + el_template.getValue() + " valor " + el_template.getValue() + " valor importado " + GraphicsPrintManager.this.gfforma.getExternalValueString(el_template.getValue()));
                    int rowAcum = 0;
                    if (srowAcum != null) {
                        rowAcum = srowAcum.getIntValue();
                    }
                    if (fontSize != null && fontName != null && fontStyle != null) {
                        Font newFont = new Font(fontName.getValue(), fontStyle.getIntValue(), fontSize.getIntValue());
                        GraphicsPrintManager.this.g2d.setFont(newFont);
                    }
                    int row = 0;
                    srow1 = el_template.getAttributeValue("row");
                    col = Integer.parseInt(el_template.getAttributeValue("col"));
                    row = srow1.equals("last") ? this.currentRow : Integer.parseInt(srow1);
                    if (importValue && GraphicsPrintManager.this.gfforma != null && GraphicsPrintManager.this.gfforma.getExternalValueString(el_template.getValue()) != null) {
                        GraphicsPrintManager.this.g2d.drawString(GraphicsPrintManager.this.gfforma.getExternalValueString(el_template.getValue()), col, row);
                    } else {
                        GraphicsPrintManager.this.g2d.drawString(el_template.getValue(), col, row);
                    }
                    this.currentRow += Integer.parseInt(el_template.getAttributeValue("rowAcum"));
                    continue;
                }
                if (el_template.getName().equals("dbimage")) {
                    try {
                        Element el_transaction = (Element)it_transaction.next();
                        System.out.println("element limitado a 20 : " + el_transaction.getTextTrim().substring(1, 20));
                        int row = Integer.parseInt(el_template.getAttributeValue("row"));
                        int col4 = Integer.parseInt(el_template.getAttributeValue("col"));
                        int width = Integer.parseInt(el_template.getAttributeValue("width"));
                        int height = Integer.parseInt(el_template.getAttributeValue("height"));
                        ZipHandler zip = new ZipHandler();
                        byte[] bytesImage = zip.getDataDecode(el_transaction.getTextTrim());
                        String nameFile = zip.getCurrentFile();
                        String fileType = nameFile.substring(nameFile.indexOf(".") + 1);
                        ByteArrayInputStream image = new ByteArrayInputStream(bytesImage);
                        BufferedImage img = ImageIO.read(image);
                        System.out.println("imagen impresa en " + row + "," + col4);
                        GraphicsPrintManager.this.g2d.drawImage(img, col4, row, width, height, null);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (el_template.getName().equals("image")) {
                    Attribute srowAcum = el_template.getAttribute("rowAcum");
                    int rowAcum = 0;
                    if (srowAcum != null) {
                        rowAcum = srowAcum.getIntValue();
                    }
                    int row = 0;
                    String srow14 = el_template.getAttributeValue("row");
                    int col5 = Integer.parseInt(el_template.getAttributeValue("col"));
                    row = srow14.equals("last") ? this.currentRow : Integer.parseInt(srow14);
                    try {
                        BufferedImage image = null;
                        try {
                            System.out.println("getClass: " + this.getClass().getResource(el_template.getValue()));
                            image = ImageIO.read(this.getClass().getResource(el_template.getValue()));
                            GraphicsPrintManager.this.g2d.drawImage(image, col5, row, image.getWidth(), image.getHeight(), null);
                        }
                        catch (IllegalArgumentException ie) {
                            try {
                                System.out.println("tag: " + GraphicsPrintManager.this.bd + el_template.getValue());
                                System.out.println("valor: " + TagPrintersDB.getTag(GraphicsPrintManager.this.bd + el_template.getValue()));
                                image = ImageIO.read(this.getClass().getResource(TagPrintersDB.getTag(GraphicsPrintManager.this.bd + el_template.getValue())));
                                GraphicsPrintManager.this.g2d.drawImage(image, col5, row, image.getWidth(), image.getHeight(), null);
                            }
                            catch (NullPointerException npe) {
                                npe.printStackTrace();
                            }
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    this.currentRow += Integer.parseInt(el_template.getAttributeValue("rowAcum"));
                    continue;
                }
                if (!"generateBarCodeImage".equals(el_template.getName())) continue;
                try {
                    Element el_transaction = (Element)it_transaction.next();
                    String value = "0000000000" + el_transaction.getValue();
                    value = value.substring(value.length() - 10, value.length());
                    Barcode barcode = BarcodeFactory.createCode128B((String)value);
                    barcode.setBarHeight(5);
                    barcode.setBarWidth(1);
                    barcode.setDrawingText(false);
                    BufferedImage image = BarcodeImageHandler.getImage((Barcode)barcode);
                    int row = 0;
                    String srow15 = el_template.getAttributeValue("row");
                    int col6 = Integer.parseInt(el_template.getAttributeValue("col"));
                    row = srow15.equals("last") ? this.currentRow : Integer.parseInt(srow15);
                    System.out.println("Tama\u00f1o de la imagen, ancho: " + (double)image.getWidth() * 0.9 + " alto " + (double)image.getHeight() * 0.9);
                    GraphicsPrintManager.this.g2d.drawImage(image, col6, row, (int)((double)image.getWidth() * 0.9), (int)((double)image.getHeight() * 0.9), null);
                }
                catch (BarcodeException BEe) {
                    BEe.printStackTrace();
                }
                catch (OutputException Oe) {
                    Oe.printStackTrace();
                }
            }
        }

        private void newPage() throws DataConversionException {
            GraphicsPrintManager.this.g2d.dispose();
            GraphicsPrintManager.this.document.newPage();
            GraphicsPrintManager.this.template = GraphicsPrintManager.this.cb.createTemplate(GraphicsPrintManager.this.width, GraphicsPrintManager.this.height);
            GraphicsPrintManager.this.g2d = (Graphics2D)new PdfGraphics2D((PdfContentByte)GraphicsPrintManager.this.template, GraphicsPrintManager.this.width, GraphicsPrintManager.this.height);
            GraphicsPrintManager.this.cb.addTemplate(GraphicsPrintManager.this.template, 0.0f, 0.0f);
            this.printElementsMultiPage();
            ++this.pageCount;
            this.processMetadata(GraphicsPrintManager.this.rootTemplate.getChild("newpage"));
        }

        private int loadIntAttributes(Element el_template, String name) {
            Attribute att = el_template.getAttribute(name);
            try {
                return att != null ? att.getIntValue() : -1;
            }
            catch (DataConversionException e) {
                e.printStackTrace();
                return -1;
            }
        }

        private ArrayList<HashMap<String, Attribute>> loadAttributes(Iterator it) {
            ArrayList<HashMap<String, Attribute>> AttCols = new ArrayList<HashMap<String, Attribute>>();
            while (it.hasNext()) {
                HashMap<String, Attribute> attribs = new HashMap<String, Attribute>();
                Element element = (Element)it.next();
                for (Attribute attribute : element.getAttributes()) {
                    attribs.put(attribute.getName(), attribute);
                }
                AttCols.add(attribs);
            }
            return AttCols;
        }

        private void printElementsMultiPage() {
            for (ElementMultiPage elm : this.multiPageField) {
                try {
                    this.addValue(elm.getValue(), elm.getAtts());
                }
                catch (DataConversionException e) {
                    e.printStackTrace();
                }
            }
        }

        private void addInfoSubGrupo(HashMap<String, Attribute> AttCols, String textTotalGroup, int colTextTotalGroup, double totalGroup, int colTotalGroup, int rowInit) throws DataConversionException {
            HashMap<String, Attribute> att = new HashMap<String, Attribute>();
            Attribute attrow = new Attribute("row", String.valueOf(rowInit));
            Attribute attcol = new Attribute("col", String.valueOf(colTextTotalGroup));
            Attribute atttype = new Attribute("type", "STRING");
            att.put("row", attrow);
            att.put("col", attcol);
            att.put("type", atttype);
            this.addValue(textTotalGroup, att);
            AttCols.remove("row");
            AttCols.put("row", attrow);
            this.addValue(String.valueOf(totalGroup), AttCols);
        }

        private int addValue(String value, HashMap<String, Attribute> attribs) throws DataConversionException {
            String mask;
            Attribute atl;
            Font newFont;
            int enters = 1;
            if (attribs.size() == 0) {
                return 1;
            }
            int row = 0;
            String srow = attribs.get("row").getValue();
            row = srow.equals("last") ? this.currentRow : attribs.get("row").getIntValue() + this.rowNextPage;
            Attribute color = attribs.get("color");
            if (color != null) {
                StringTokenizer st = new StringTokenizer(color.getValue(), ",");
                int r = Integer.parseInt(st.nextToken());
                int g = Integer.parseInt(st.nextToken());
                int b = Integer.parseInt(st.nextToken());
                Color fcolor = new Color(r, g, b);
                GraphicsPrintManager.this.g2d.setColor(fcolor);
            } else {
                GraphicsPrintManager.this.g2d.setColor(Color.BLACK);
            }
            int col = 0;
            Attribute attribute = attribs.get("type");
            Attribute fontSize = attribs.get("fontSize");
            Attribute fontName = attribs.get("fontName");
            Attribute fontStyle = attribs.get("fontStyle");
            Attribute textLine = attribs.get("textLine");
            Attribute validZero = attribs.get("validZero");
            Attribute textCol = attribs.get("textCol");
            Attribute srowAcum = attribs.get("rowAcum");
            Attribute fullJustify = attribs.get("fullJustify");
            Attribute maxWritenSize = attribs.get("maxWritenSize");
            Attribute rowNewPage = attribs.get("rowNewPage");
            Attribute center = attribs.get("center");
            Attribute acol = attribs.get("col");
            System.out.println("type: " + attribute.getValue());
            int length = -1;
            if (center != null) {
                length = center.getIntValue();
            } else {
                col = acol.getIntValue();
            }
            boolean printZero = true;
            double val = 0.0;
            try {
                val = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (validZero != null && validZero.getBooleanValue() && attribute != null && "NUMERIC".equals(attribute.getValue()) && val == 0.0) {
                printZero = false;
            }
            int maxWriten = -1;
            int newPage = -1;
            try {
                maxWriten = maxWritenSize.getIntValue();
                newPage = rowNewPage.getIntValue();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            int rowAcum = 0;
            if (srowAcum != null) {
                rowAcum = srowAcum.getIntValue();
            }
            String type = attribute != null ? attribute.getValue() : null;
            value = !"NULL".equals(value) && !"".equals(value) ? value : "";
            Font currentFont = GraphicsPrintManager.this.g2d.getFont();
            if (fontSize != null && fontName != null && fontStyle != null) {
                newFont = new Font(fontName.getValue(), fontStyle.getIntValue(), fontSize.getIntValue());
                GraphicsPrintManager.this.g2d.setFont(newFont);
            } else if (fontSize != null && fontName != null && fontStyle == null) {
                newFont = new Font(fontName.getValue(), 0, fontSize.getIntValue());
                GraphicsPrintManager.this.g2d.setFont(newFont);
            } else if (fontSize != null && fontName == null) {
                newFont = new Font(currentFont.getFamily(), 0, currentFont.getSize());
                GraphicsPrintManager.this.g2d.setFont(newFont);
            }
            if (textLine != null && textCol != null && printZero) {
                GraphicsPrintManager.this.g2d.drawString(textLine.getValue(), textCol.getIntValue(), row);
            }
            if ("TEXT".equals(type)) {
                int width = attribs.get("width").getIntValue();
                int height = attribs.get("height").getIntValue();
                StringBuffer buf = new StringBuffer(value);
                int lastspace = -1;
                int linestart = 0;
                for (int i = 0; i < buf.length(); ++i) {
                    if (buf.charAt(i) == ' ') {
                        lastspace = i;
                    }
                    if (buf.charAt(i) == '\n') {
                        lastspace = -1;
                        linestart = i + 1;
                        ++enters;
                    }
                    if (i <= linestart + width) continue;
                    if (lastspace != -1) {
                        buf.delete(lastspace, lastspace + 1);
                        buf.insert(lastspace, "\n");
                        linestart = lastspace;
                        lastspace = -1;
                        ++enters;
                        continue;
                    }
                    buf.insert(i, '\n');
                    linestart = i + 1;
                    ++enters;
                }
                String buffer = buf.toString();
                StringTokenizer st = new StringTokenizer(buffer, "\n");
                System.out.println("numero de tokens en observaciones: " + st.countTokens() + " observacion: {" + buffer + "}");
                for (int h = 0; h < buffer.length(); ++h) {
                    System.out.println("char: " + buffer.charAt(h));
                }
                for (int j = 0; j < height && st.hasMoreElements(); ++j) {
                    String tok = st.nextToken();
                    System.out.println(tok);
                    double sizeJustify = Double.parseDouble(fullJustify != null ? fullJustify.getValue() : "0");
                    GraphicsPrintManager.this.g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                    Font font = GraphicsPrintManager.this.g2d.getFont();
                    Rectangle2D r2d = GraphicsPrintManager.this.g2d.getFontMetrics(font).getStringBounds(tok, GraphicsPrintManager.this.g2d);
                    font = font.deriveFont((float)((double)font.getSize2D() * sizeJustify / r2d.getWidth()));
                    HashMap<TextAttribute, Integer> atts = new HashMap<TextAttribute, Integer>();
                    atts.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
                    font = font.deriveFont(atts);
                    String ultimo = tok.length() - 2 > 0 ? tok.substring(tok.length() - 2, tok.length()) : "";
                    System.out.println("ultimo: [" + ultimo + "]");
                    if (sizeJustify != 0.0 && !ultimo.equals("\\n")) {
                        GraphicsPrintManager.this.g2d.setFont(font);
                        System.out.println("alargando..");
                        GraphicsPrintManager.this.g2d.drawString(tok, col, row);
                        row += rowAcum;
                    } else {
                        System.out.println("no alargando");
                        if (fullJustify == null) {
                            System.out.println("full");
                            GraphicsPrintManager.this.g2d.drawString(tok.substring(0, tok.length()), col, row);
                        } else {
                            System.out.println("no full");
                            GraphicsPrintManager.this.g2d.drawString(tok.substring(0, tok.length() - 2), col, row);
                        }
                        if (ultimo.equals("\\n")) {
                            row += rowAcum * 2;
                        } else {
                            System.out.println("asignando enters por renglon adicional");
                            row += rowAcum;
                        }
                    }
                    System.out.println("----------------------row en text: " + row);
                    if (maxWriten == -1 || row <= maxWriten) continue;
                    System.out.println("------------------ paginando por Text");
                    this.newPage();
                    row = newPage;
                }
            } else if ("STRING".equals(type)) {
                boolean alignLeft;
                System.out.println("rowAccount en String: " + row);
                atl = attribs.get("lengthFill");
                Attribute atf = attribs.get("charFill");
                Attribute align = attribs.get("align");
                Attribute ATimportValue = attribs.get("importValue");
                Attribute vertical = attribs.get("vertical");
                if (atl != null && atf != null) {
                    int lengthFill = atl.getIntValue();
                    while (value.length() < lengthFill) {
                        value = value + atf.getValue();
                    }
                }
                boolean bl = alignLeft = align != null && align.getValue().equals("LEFT");
                if (alignLeft) {
                    System.out.println("Alineacion Izquierda");
                } else {
                    System.out.println("Alineacion Derecha");
                }
                boolean importValue = ATimportValue != null ? ATimportValue.getBooleanValue() : false;
                AffineTransform at = new AffineTransform();
                if (vertical != null && vertical.getBooleanValue()) {
                    System.out.println("Texto vertical");
                    at.rotate(1.5707963267948966);
                    GraphicsPrintManager.this.g2d.setTransform(at);
                    System.out.println("********************imprimiendo vertical " + value + "en " + col + "," + row);
                }
                if (importValue) {
                    String getvalexternal = GraphicsPrintManager.this.gfforma.getExternalValueString(value);
                    if (length > 0) {
                        FontMetrics fm = GraphicsPrintManager.this.g2d.getFontMetrics();
                        int centerPage = length / 2;
                        int wordLength = fm.stringWidth(getvalexternal);
                        col = centerPage - wordLength / 2;
                    }
                    if (vertical != null && vertical.getBooleanValue()) {
                        GraphicsPrintManager.this.g2d.drawString(getvalexternal, row, col * -1);
                        at.rotate(Math.PI * 2);
                        GraphicsPrintManager.this.g2d.setTransform(at);
                    } else {
                        GraphicsPrintManager.this.g2d.drawString(getvalexternal, col, row);
                    }
                    System.out.println("valor: " + getvalexternal);
                } else {
                    int width = 0;
                    if (alignLeft) {
                        width = GraphicsPrintManager.this.g2d.getFontMetrics().stringWidth(value);
                    } else if (length > 0) {
                        FontMetrics fm = GraphicsPrintManager.this.g2d.getFontMetrics();
                        int centerPage = length / 2;
                        int wordLength = fm.stringWidth(value);
                        col = centerPage - wordLength / 2;
                    }
                    if (vertical != null && vertical.getBooleanValue()) {
                        GraphicsPrintManager.this.g2d.drawString(value, row, (col - width) * -1);
                    } else {
                        System.out.println("imprimiendo " + value + " en " + (col - width) + "," + row);
                        GraphicsPrintManager.this.g2d.drawString(value, col - width, row);
                    }
                    System.out.println("valor: " + value);
                }
                if (vertical != null && vertical.getBooleanValue()) {
                    System.out.println("Texto vertical");
                    at.rotate(1.5707963267948966);
                    GraphicsPrintManager.this.g2d.setTransform(at);
                }
                System.out.println("----------------------------");
                row += rowAcum;
            } else if ("NAMEDB".equals(type)) {
                atl = attribs.get("lengthFill");
                Attribute atf = attribs.get("charFill");
                if (atl != null && atf != null) {
                    int lengthFill = atl.getIntValue();
                    while (value.length() < lengthFill) {
                        value = value + atf.getValue();
                    }
                }
                System.out.println("tag: " + value + " value: " + TagPrintersDB.getTag(GraphicsPrintManager.this.bd + value));
                GraphicsPrintManager.this.g2d.drawString(TagPrintersDB.getTag(GraphicsPrintManager.this.bd + value), col, row);
                row += rowAcum;
            } else if ("TEXTQR".equals(type)) {
                QRGenerator qr = new QRGenerator();
                int width = attribs.get("width").getIntValue();
                int height = attribs.get("height").getIntValue();
                System.out.println("Texto QR: " + value);
                GraphicsPrintManager.this.g2d.drawImage(qr.generateQR(value), col, row, width, height, null);
            } else if ("DATE".equals(type) && value.length() >= 10) {
                mask = attribs.get("mask").getValue();
                SimpleDateFormat sdf = new SimpleDateFormat(mask);
                Calendar c = Calendar.getInstance();
                int year = Integer.valueOf(value.substring(0, 4));
                int month = Integer.valueOf(value.substring(5, 7));
                int day = Integer.valueOf(value.substring(8, 10));
                c.set(1, year);
                c.set(2, month - 1);
                c.set(5, day);
                value = sdf.format(c.getTime());
                GraphicsPrintManager.this.g2d.drawString(value, col, row);
                row += rowAcum;
            } else if ("TIME".equals(type) && value.length() >= 19) {
                GraphicsPrintManager.this.g2d.drawString(value.substring(11, 19), col, row);
            } else if ("NUMERIC".equals(type)) {
                mask = attribs.get("mask").getValue();
                DecimalFormat formatter = new DecimalFormat(mask);
                value = !"NULL".equals(value) && !"".equals(value) ? formatter.format(Double.parseDouble(value)) : "";
                FontMetrics m = GraphicsPrintManager.this.g2d.getFontMetrics();
                if (printZero) {
                    GraphicsPrintManager.this.g2d.drawString(value, col - m.stringWidth(value), row);
                    row += rowAcum;
                }
            } else if ("NUMTOLETTERS".equals(type)) {
                try {
                    int width = attribs.get("width").getIntValue();
                    int height = attribs.get("height").getIntValue();
                    Double d = Double.parseDouble(value);
                    String letters = String.valueOf(d.intValue());
                    letters = NumberToLetterConversor.letters(letters, null);
                    value = value.replaceAll("\n", " ");
                    StringBuffer buf = new StringBuffer(letters);
                    int lastspace = -1;
                    int linestart = 0;
                    for (int i = 0; i < buf.length(); ++i) {
                        if (buf.charAt(i) == ' ') {
                            lastspace = i;
                        }
                        if (buf.charAt(i) == '\n') {
                            lastspace = -1;
                            linestart = i + 1;
                        }
                        if (i <= linestart + width) continue;
                        if (lastspace != -1) {
                            buf.delete(lastspace, lastspace + 1);
                            buf.insert(lastspace, "\n");
                            linestart = lastspace;
                            lastspace = -1;
                            continue;
                        }
                        buf.insert(i, '\n');
                        linestart = i + 1;
                    }
                    StringTokenizer st = new StringTokenizer(buf.toString(), "\n");
                    for (int j = 0; j < height && st.hasMoreElements(); ++j) {
                        String tok = st.nextToken();
                        GraphicsPrintManager.this.g2d.drawString(tok, col, row);
                        row += rowAcum;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            GraphicsPrintManager.this.g2d.setFont(currentFont);
            this.currentRow = row < this.currentRow ? this.currentRow : row;
            return enters;
        }

        class ElementMultiPage {
            HashMap<String, Attribute> atts = null;
            private String value;

            ElementMultiPage(String value, HashMap atts) {
                this.atts = atts;
                this.value = value;
            }

            private HashMap getAtts() {
                return this.atts;
            }

            private String getValue() {
                return this.value;
            }
        }

        class Query {
            private int x;
            private int y;
            private String sql;

            Query(String sql, int x, int y) {
                this.x = x;
                this.y = y;
                this.sql = sql;
            }

            protected String getSql() {
                return this.sql;
            }

            protected int getX() {
                return this.x;
            }

            protected int getY() {
                return this.y;
            }
        }
    }
}

