/*
 * Decompiled with CFR 0.152.
 */
package common.printer;

import common.control.ClientHeaderValidator;
import common.control.SuccessEvent;
import common.control.SuccessListener;
import common.gui.forms.GenericForm;
import common.misc.text.NumberToLetterConversor;
import common.printer.AbstractManager;
import common.printer.PrintingManager;
import common.printer.TagPrintersDB;
import common.printer.TextPrinterBuffer;
import java.io.ByteArrayInputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class PlainPrintingManager
implements AbstractManager,
SuccessListener {
    private TextPrinterBuffer textPrinterBuffer = new TextPrinterBuffer();
    private HashMap<Integer, String[]> concatData = new HashMap();
    private int currentRow = 1;
    private boolean success = false;
    private String idTransaction = "";
    private HashMap<String, String> vars = new HashMap();
    private int width;
    private int height;
    private ByteArrayInputStream in;
    private boolean successful;
    private PrintingManager.ImpresionType impresionType = PrintingManager.ImpresionType.PLAIN;
    private boolean withHeader;
    private Element header;
    private int rowPageSeparator;
    private int pageNumeration = 1;
    private Element newPage;
    private StringBuilder stringDocument = new StringBuilder();
    private boolean mailPrinter;
    private GenericForm gfforma;

    public PlainPrintingManager() {
        ClientHeaderValidator.addSuccessListener(this);
        this.textPrinterBuffer.clear();
    }

    public PlainPrintingManager(GenericForm gfforma) {
        this.gfforma = gfforma;
        ClientHeaderValidator.addSuccessListener(this);
        this.textPrinterBuffer.clear();
    }

    public PlainPrintingManager(String ndocument, GenericForm gfforma) {
        this(gfforma);
        this.impresionType = PrintingManager.ImpresionType.PLAIN;
        this.vars.put("ndocument", ndocument);
        this.textPrinterBuffer.clear();
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public void processPDF(Element rootTemplate, Element rootTransact) {
        this.processPostScript(rootTemplate, rootTransact);
    }

    public void processPostScript(Element rootTemplate, Element rootTransact, boolean mailPrinter) {
        this.mailPrinter = mailPrinter;
        this.processPostScript(rootTemplate, rootTransact);
    }

    @Override
    public void processPostScript(Element rootTemplate, Element rootTransact) {
        this.textPrinterBuffer.clear();
        this.currentRow = 1;
        try {
            Attribute ATTRequesNumeration = rootTemplate.getAttribute("requestNumeration");
            if (ATTRequesNumeration != null && ATTRequesNumeration.getBooleanValue()) {
                int times = 0;
                while (!this.success) {
                    try {
                        if (times > 100) {
                            System.out.println("No se pudo obtner la numeracion de " + rootTemplate.getAttributeValue("name"));
                            return;
                        }
                        Thread.sleep(100L);
                        ++times;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            Calendar calendar = Calendar.getInstance();
            long init = calendar.getTimeInMillis();
            Element settings = rootTemplate.getChild("settings");
            Attribute atw = settings != null ? settings.getAttribute("width") : null;
            Attribute ath = settings != null ? settings.getAttribute("height") : null;
            this.width = atw != null ? atw.getIntValue() : 0;
            this.height = ath != null ? ath.getIntValue() : 0;
            Iterator itTemplate = rootTemplate.getChildren().iterator();
            Iterator itTransact = rootTransact.getChildren("package").iterator();
            int countPacks = 0;
            while (itTemplate.hasNext()) {
                Element elmTemplate = (Element)itTemplate.next();
                String name = elmTemplate.getName();
                if ("metadata".equals(name)) {
                    System.out.println("procesando metadata ..");
                    this.processMetadata(elmTemplate);
                    continue;
                }
                if ("package".equals(name) && itTransact.hasNext()) {
                    Element elmTransact = (Element)itTransact.next();
                    Attribute attr = elmTemplate.getAttribute("validate");
                    Attribute attrn = elmTemplate.getAttribute("validZero");
                    Attribute attrInv = elmTemplate.getAttribute("invalidate");
                    String value = "";
                    try {
                        value = ((Element)elmTransact.getChildren().get(0)).getValue();
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    double nvalue = 0.0;
                    try {
                        nvalue = Double.parseDouble(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (attrInv == null || attrInv != null && !attrInv.getBooleanValue()) {
                        countPacks += elmTransact.getChildren().size();
                    }
                    if (attr != null && attr.getBooleanValue() || attrn != null && attrn.getBooleanValue()) {
                        if (elmTransact.getChildren().size() > 0 && attr != null && attr.getBooleanValue()) {
                            System.out.println("validate");
                            this.processElement(elmTemplate, elmTransact);
                            continue;
                        }
                        if (nvalue == 0.0 || attrn == null || !attrn.getBooleanValue()) continue;
                        this.processElement(elmTemplate, elmTransact);
                        continue;
                    }
                    this.processElement(elmTemplate, elmTransact);
                    continue;
                }
                this.processSingleTag(elmTemplate);
            }
            if (countPacks > 0) {
                this.stringDocument.append(this.getBufferString());
                System.out.println("================final buffer========================");
                System.out.println(this.stringDocument.toString());
                System.out.println("-----------------------------------------------------");
                this.in = new ByteArrayInputStream(this.stringDocument.toString().getBytes());
                this.successful = true;
                calendar = Calendar.getInstance();
                long end = calendar.getTimeInMillis();
                System.out.println("Generador en " + (end - init) + " milisegundos ");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            System.out.println(this.textPrinterBuffer.getBufferString());
        }
        catch (DataConversionException e) {
            e.printStackTrace();
            System.out.println(this.textPrinterBuffer.getBufferString());
        }
    }

    private void processMetadata(Element element) throws DataConversionException {
        for (Element e : element.getChildren()) {
            this.processSingleTag(e);
        }
    }

    private void processSingleTag(Element e) throws DataConversionException {
        int col;
        String name = e.getName();
        Iterator itAttribs = e.getAttributes().iterator();
        HashMap<String, Attribute> attribs = new HashMap<String, Attribute>();
        while (itAttribs.hasNext()) {
            Attribute attribute = (Attribute)itAttribs.next();
            attribs.put(attribute.getName(), attribute);
        }
        Attribute incrementRow = (Attribute)attribs.get("incrementRow");
        Attribute attrRow = (Attribute)attribs.get("row");
        Attribute attrCol = (Attribute)attribs.get("col");
        Attribute type = (Attribute)attribs.get("type");
        Attribute attrCenter = (Attribute)attribs.get("center");
        int row = -1;
        boolean isValidate = false;
        boolean passed = false;
        if (attrRow != null) {
            if (attrRow.getValue().equals("last")) {
                row = this.currentRow;
                isValidate = true;
            } else if (attrRow.getValue().equals("final")) {
                row = this.height;
                if (this.pageNumeration > 1) {
                    row = this.height * this.pageNumeration;
                }
                isValidate = true;
            } else {
                row = attrRow.getIntValue();
            }
        }
        if (this.withHeader) {
            row = this.currentRow;
            isValidate = true;
        }
        int n = col = attrCol != null ? attrCol.getIntValue() : -1;
        if ("line".equals(name)) {
            int length = ((Attribute)attribs.get("length")).getIntValue();
            String charfill = ((Attribute)attribs.get("charfill")).getValue();
            String align = ((Attribute)attribs.get("align")).getValue();
            for (int i = 0; i < length; ++i) {
                if ("horizontal".equals(align)) {
                    this.textPrinterBuffer.insertString(charfill, row, col++, null);
                    continue;
                }
                if (!"vertical".equals(align)) continue;
                this.textPrinterBuffer.insertString(charfill, row++, col, null);
            }
            passed = true;
        } else if ("field".equals(name)) {
            String value = e.getTextTrim();
            value = " ".equals(value) || "".equals(value) ? "  " : value;
            int length = -1;
            if (attrCenter != null) {
                length = Integer.parseInt(attrCenter.getValue());
            }
            if (type != null && type.getValue().equals("NAMEDB")) {
                System.out.println("value: " + value);
                try {
                    if (length > 0) {
                        int wordLength = TagPrintersDB.getTag(value).length();
                        int centerPage = length / 2;
                        col = centerPage - wordLength / 2;
                    }
                    this.textPrinterBuffer.insertString(TagPrintersDB.getTag(value), row, col, null);
                }
                catch (NullPointerException NPEe) {
                    System.out.println("No existe en TagPrintersDB: " + value);
                    NPEe.printStackTrace();
                }
            } else if (type != null && type.getValue().equals("IMPORTVALUE")) {
                System.out.println("Es un importValue");
                System.out.println("variable a importar: " + value);
                String importValue = this.gfforma.getExternalValueString(value);
                if (length > 0) {
                    int wordLength = importValue.length();
                    int centerPage = length / 2;
                    col = centerPage - wordLength / 2;
                }
                System.out.println("valor importado: " + importValue + "col: " + col + ",row: " + row);
                this.textPrinterBuffer.insertString(importValue, row, col, null);
            } else {
                if (length > 0) {
                    int wordLength = value.length();
                    int centerPage = length / 2;
                    col = centerPage - wordLength / 2;
                }
                this.textPrinterBuffer.insertString(value, row, col, null);
            }
            passed = true;
        } else if ("time".equals(name)) {
            GregorianCalendar calendario = new GregorianCalendar();
            int hora = calendario.get(11);
            int minutos = calendario.get(12);
            int segundos = calendario.get(13);
            this.textPrinterBuffer.insertString(hora + ":" + minutos + ":" + segundos, row, col, null);
        } else if ("ndocument".equals(name)) {
            String value = "";
            String format = e.getAttributeValue("format");
            System.out.println("formato: " + format);
            value = format != null && format.equals("Integer") ? String.valueOf(Integer.parseInt(this.vars.get(name))) : this.vars.get(name);
            this.textPrinterBuffer.insertString(value, row, col, null);
            passed = true;
        } else if ("abstract".equals(name)) {
            String value = e.getText();
            int height = ((Attribute)attribs.get("height")).getIntValue();
            this.textPrinterBuffer.insertTextArea(value, row, col, null, height, false);
            if (incrementRow == null || incrementRow.getBooleanValue()) {
                this.currentRow += height;
            }
            passed = false;
        } else if ("scp".equals(name)) {
            String value = e.getValue();
            String converted = this.textPrinterBuffer.Convert(value);
            if (converted != null) {
                this.textPrinterBuffer.insertString(this.textPrinterBuffer.Convert(value), row, col, null);
            }
            passed = true;
        } else if ("header".equals(name)) {
            this.withHeader = true;
            this.header = (Element)e.clone();
            this.rowPageSeparator = ((Attribute)attribs.get("repeatEach")).getIntValue();
            passed = true;
        } else if ("var".equals(name)) {
            String varName = ((Attribute)attribs.get("name")).getValue();
            String value = this.vars.get(varName);
            this.textPrinterBuffer.insertString(value, row, col, null);
            passed = true;
        } else if ("pageNumeration".equals(name)) {
            this.textPrinterBuffer.insertString(String.valueOf(this.pageNumeration), row, col, null);
            passed = true;
        } else if ("pagenumber".equals(name)) {
            this.textPrinterBuffer.insertString(String.valueOf(this.pageNumeration), row, col, null);
            passed = true;
        } else if ("newpage".equals(name)) {
            this.newPage = (Element)e.clone();
        }
        if (isValidate && passed && (incrementRow == null || incrementRow.getBooleanValue())) {
            ++this.currentRow;
        }
    }

    private void processElement(Element pack_template, Element pack_transaction) throws DataConversionException {
        Iterator it_template = pack_template.getChildren().iterator();
        Iterator it_transaction = pack_transaction.getChildren().iterator();
        while (it_template.hasNext()) {
            int rowInit = -1;
            Element el_template = (Element)it_template.next();
            if (el_template.getName().equals("subpackage") && it_transaction.hasNext()) {
                Attribute attr = el_template.getAttribute("rowInit");
                Attribute attMaxAcum = el_template.getAttribute("maxRowsAcum");
                int maxAcum = attMaxAcum != null ? attMaxAcum.getIntValue() : -1;
                Attribute attrowInitNewPage = el_template.getAttribute("rowInitNewPage");
                int rowInitNewPage = attrowInitNewPage != null ? attrowInitNewPage.getIntValue() : -1;
                Attribute attmaxRowsAcumNewPage = el_template.getAttribute("maxRowsAcumNewPage");
                int maxRowsAcumNewPage = attmaxRowsAcumNewPage != null ? attmaxRowsAcumNewPage.getIntValue() : -1;
                boolean firstPage = true;
                boolean isValidate = false;
                if (attr.getValue().equals("last")) {
                    rowInit = this.currentRow;
                    isValidate = true;
                } else {
                    rowInit = attr.getIntValue();
                }
                for (Element element : el_template.getChildren("metadata")) {
                    this.processMetadata(element);
                    rowInit = this.currentRow;
                }
                Iterator it = el_template.getChildren("field").iterator();
                ArrayList AttCols = new ArrayList();
                while (it.hasNext()) {
                    HashMap<String, Attribute> attribs = new HashMap<String, Attribute>();
                    Element element = (Element)it.next();
                    for (Attribute attribute : element.getAttributes()) {
                        attribs.put(attribute.getName(), attribute);
                    }
                    AttCols.add(attribs);
                }
                int count = 0;
                int times = 1;
                while (it_transaction.hasNext()) {
                    Element element = (Element)it_transaction.next();
                    Iterator iterator = element.getChildren().iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        Element elmt = (Element)iterator.next();
                        Attribute att = new Attribute("row", String.valueOf(rowInit));
                        ((HashMap)AttCols.get(i)).put("row", att);
                        this.addValue(elmt.getValue(), (HashMap)AttCols.get(i));
                        ++i;
                    }
                    ++count;
                    ++rowInit;
                    if (isValidate || maxAcum > 0) {
                        this.currentRow = rowInit + 1;
                    }
                    if (this.withHeader && this.currentRow % this.rowPageSeparator == 0) {
                        ++this.pageNumeration;
                        Element ff = new Element("scp");
                        ff.setText("FF");
                        ff.setAttribute("row", "last");
                        ff.setAttribute("col", "2");
                        this.processSingleTag(ff);
                        this.processMetadata(this.header);
                        rowInit = this.currentRow;
                    }
                    if (maxAcum > 0 && firstPage && maxAcum == count && it_transaction.hasNext()) {
                        rowInit += this.height * times - rowInit;
                        this.currentRow = rowInit + 1;
                        rowInit += rowInitNewPage;
                        System.out.println("llamando nueva pagina por if1");
                        this.newPageElement();
                        count = 0;
                        ++times;
                        firstPage = false;
                        continue;
                    }
                    if (maxAcum <= 0 || firstPage || maxRowsAcumNewPage != count || !it_transaction.hasNext()) continue;
                    rowInit += this.height * times - rowInit;
                    this.currentRow = rowInit + 1;
                    rowInit += rowInitNewPage;
                    System.out.println("llamando nueva pagina por if2");
                    this.newPageElement();
                    count = 0;
                    ++times;
                }
                continue;
            }
            if (el_template.getName().equals("metadata")) {
                this.processMetadata(el_template);
                continue;
            }
            if (!it_transaction.hasNext()) break;
            Element el_transaction = (Element)it_transaction.next();
            Iterator itAttribs = el_template.getAttributes().iterator();
            HashMap<String, Attribute> attribs = new HashMap<String, Attribute>();
            while (itAttribs.hasNext()) {
                Attribute attribute = (Attribute)itAttribs.next();
                attribs.put(attribute.getName(), attribute);
            }
            if (this.withHeader && this.currentRow % this.rowPageSeparator == 0) {
                ++this.pageNumeration;
                Element ff = new Element("scp");
                ff.setText("FF");
                ff.setAttribute("row", "last");
                ff.setAttribute("col", "2");
                this.processSingleTag(ff);
                this.processMetadata(this.header);
                rowInit = this.currentRow;
            }
            this.addValue(el_transaction.getValue(), attribs);
        }
    }

    private void newPageElement() {
        ++this.pageNumeration;
        try {
            System.out.println("procesando nueva pagina por newPageElement()");
            this.stringDocument.append(this.getBufferString());
            this.processMetadata(this.newPage);
        }
        catch (DataConversionException e) {
            e.printStackTrace();
        }
    }

    private void addValue(String value, HashMap<String, Attribute> attribs) throws DataConversionException {
        int height;
        int width;
        int row = -1;
        boolean last = false;
        try {
            row = attribs.get("row").getIntValue();
        }
        catch (DataConversionException e) {
            if (attribs.get("row").getValue().equals("last")) {
                row = this.currentRow;
                last = true;
            }
            row = this.currentRow--;
        }
        int col = attribs.get("col").getIntValue();
        Attribute attrCenter = attribs.get("center");
        int length = -1;
        if (attrCenter != null) {
            length = Integer.parseInt(attrCenter.getValue());
        }
        Attribute attrIncrement = attribs.get("incrementRow");
        boolean passed = false;
        Attribute attribute = attribs.get("type");
        String type = attribute != null ? attribute.getValue() : null;
        String string = value = !"NULL".equals(value) && !"".equals(value) ? value : "";
        if ("TEXT".equals(type)) {
            width = attribs.get("width").getIntValue();
            height = attribs.get("height").getIntValue();
            this.textPrinterBuffer.insertTextArea(value, row, col, width, height, true);
            if (last) {
                this.currentRow += height;
            }
            passed = true;
        } else if ("STRING".equals(type)) {
            if (!"".equals(value.trim())) {
                this.textPrinterBuffer.insertString(value, row, col, null);
                if (attribs.containsKey("var")) {
                    String var = attribs.get("var").getValue();
                    this.vars.put(var, value);
                }
            }
            if (attribs.containsKey("separatorchar")) {
                Attribute att = attribs.get("separatorchar");
                int colCharSeparator = attribs.get("separatorcol").getIntValue();
                this.textPrinterBuffer.insertString(att.getValue(), row, colCharSeparator, null);
            }
            passed = true;
        }
        if (type != null && type.equals("IMPORTVALUE")) {
            System.out.println("Es un importValue");
            System.out.println("variable a importar: " + value);
            String importValue = this.gfforma.getExternalValueString(value);
            if (length > 0) {
                int wordLength = importValue.length();
                int centerPage = length / 2;
                col = centerPage - wordLength / 2;
            }
            System.out.println("valor importado: " + importValue + "col: " + col + ",row: " + row);
            this.textPrinterBuffer.insertString(importValue, row, col, null);
        } else if ("DATE".equals(type)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = sdf.parse(value);
                String mask = attribs.get("mask").getValue();
                sdf.applyLocalizedPattern(mask);
                value = sdf.format(date);
            }
            catch (ParseException e) {
                try {
                    sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date = sdf.parse(value);
                    String mask = attribs.get("mask").getValue();
                    sdf.applyLocalizedPattern(mask);
                    value = sdf.format(date);
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
            }
            if (!"".equals(value.trim())) {
                this.textPrinterBuffer.insertString(value, row, col, null);
            }
            if (attribs.containsKey("separatorchar")) {
                Attribute att = attribs.get("separatorchar");
                int colCharSeparator = attribs.get("separatorcol").getIntValue();
                this.textPrinterBuffer.insertString(att.getValue(), row, colCharSeparator, null);
            }
            passed = true;
        } else if ("STRINGCONCAT".equals(type)) {
            if (this.concatData.containsKey(row)) {
                String[] acumString = this.concatData.get(row);
                if (acumString[0].equals(attribs.get("link").getValue())) {
                    String addVal = attribs.get("char").getValue() + value;
                    this.textPrinterBuffer.insertString(addVal, row, acumString[1].length() + 2, null);
                    acumString[1] = acumString[1] + addVal;
                    this.concatData.put(row, acumString);
                }
            } else {
                this.textPrinterBuffer.insertString(value, row, col, null);
                this.concatData.put(row, new String[]{String.valueOf(col), value});
            }
            passed = true;
        } else if ("NUMERIC".equals(type)) {
            String mask = attribs.get("mask").getValue();
            DecimalFormat formatter = new DecimalFormat(mask);
            value = !"NULL".equals(value) && !"".equals(value) ? formatter.format(Double.parseDouble(value)) : "";
            this.textPrinterBuffer.insertString(value, row, col, attribs.get("width").getIntValue());
            if (attribs.containsKey("var")) {
                String var = attribs.get("var").getValue();
                this.vars.put(var, value);
            }
            if (attribs.containsKey("separatorchar")) {
                Attribute att = attribs.get("separatorchar");
                int colCharSeparator = attribs.get("separatorcol").getIntValue();
                this.textPrinterBuffer.insertString(att.getValue(), row, colCharSeparator, null);
            }
            passed = true;
        } else if ("ABSTRACT".equals(type)) {
            int height2 = attribs.get("height").getIntValue();
            this.textPrinterBuffer.insertTextArea(value, row, col, null, height2, false);
        } else if ("NUMTOLETTERS".equals(type)) {
            try {
                width = attribs.get("width").getIntValue();
                height = attribs.get("height").getIntValue();
                Double d = Double.parseDouble(value);
                String letters = String.valueOf(d.intValue());
                letters = NumberToLetterConversor.letters(letters, null);
                this.textPrinterBuffer.insertTextArea(letters, row, col, width, height, true);
                if (attrIncrement != null && attrIncrement.getBooleanValue()) {
                    this.currentRow += height;
                }
            }
            catch (NumberFormatException NFE) {
                System.out.printf("No se puede convertir %s  a letras\n%s", value, NFE.getMessage());
            }
        }
        if (passed && attrIncrement != null && attrIncrement.getBooleanValue()) {
            ++this.currentRow;
        }
    }

    public String getBufferString() {
        return this.textPrinterBuffer.getBufferString();
    }

    public String toString() {
        return this.textPrinterBuffer.getBufferString();
    }

    @Override
    public synchronized void cathSuccesEvent(SuccessEvent e) {
        String numeration = e.getNdocument();
        if (numeration != null && !"".equals(numeration) && this.idTransaction.equals(e.getIdPackage())) {
            this.success = true;
            this.vars.put("ndocument", numeration);
        }
    }

    @Override
    public PrintingManager.ImpresionType getImpresionType() {
        return this.impresionType;
    }

    @Override
    public ByteArrayInputStream getStream() {
        System.out.println("Retornando in :" + this.in.toString());
        return this.in;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    public String getNdocument() {
        return this.vars.get("ndocument");
    }

    public void setIdTransaction(String idTransaction) {
        this.idTransaction = idTransaction;
    }

    public void setNdocument(String lastNumber) {
        this.vars.put("ndocument", lastNumber);
    }
}

