/*
 * Decompiled with CFR 0.152.
 */
package common.printer;

import common.misc.CommonConstants;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.print.attribute.standard.JobName;
import javax.swing.JOptionPane;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.printing.Scaling;

public class PrintingManager {
    private ImpresionType type;
    private DocFlavor docFlavor;
    private PrintService[] jps;
    private static int count = 0;
    private String jobName;
    private boolean silent;
    private String printer;
    private float width;
    private float height;
    private String namefile;

    public PrintingManager(ImpresionType type, ByteArrayInputStream is, boolean silent, int copies, String printer, float width, float height) throws FileNotFoundException, PrintException {
        this(type, is, silent, copies, printer, width, height, null);
    }

    public PrintingManager(ImpresionType type, ByteArrayInputStream is, boolean silent, int copies, String printer, float width, float height, String namefile) throws FileNotFoundException, PrintException {
        this.silent = silent;
        this.type = type;
        this.printer = printer;
        this.width = width;
        this.height = height;
        this.namefile = namefile;
        HashPrintRequestAttributeSet hpras = new HashPrintRequestAttributeSet();
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.jobName = "empj" + sdf.format(date) + ++count;
        hpras.add(new JobName(this.jobName, Locale.getDefault()));
        this.jps = CommonConstants.printServices;
        if (this.jps == null || this.jps.length == 0) {
            this.showErroDialog();
            return;
        }
        if (this.type.equals((Object)ImpresionType.PLAIN)) {
            this.docFlavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            this.printTextPlain(is, copies, hpras);
        } else if (type.equals((Object)ImpresionType.PDF)) {
            try {
                System.out.println("Imprimiendo PDF");
                String os = System.getProperty("os.name");
                System.out.println("os: " + os);
                if (os.contains("Windows")) {
                    this.printGraphicsWindows(is, hpras, copies, silent);
                } else {
                    this.docFlavor = DocFlavor.INPUT_STREAM.PDF;
                    if (namefile != null) {
                        this.nativePrinter(copies);
                    } else {
                        this.printGraphics(is, hpras, copies, silent);
                    }
                }
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }

    private void printTextPlain(ByteArrayInputStream is, int copies, PrintRequestAttributeSet pras) throws PrintException {
        PrintService defaultService = null;
        PrintService ps = this.selectPrinservice(this.printer);
        if (this.silent && ps != null) {
            String os = System.getProperty("os.name");
            System.out.println("El os es: " + os.substring(0, 3));
            if (os.substring(0, 3).equals("Win") && copies > 1) {
                System.out.println("intentando imprimir postscript");
                DocPrintJob job = ps.createPrintJob();
                SimpleDoc doc = new SimpleDoc(is, this.docFlavor, null);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                for (int i = 0; i < copies; ++i) {
                    int b;
                    System.out.println("cargando copia 1");
                    is.reset();
                    while ((b = is.read()) != -1) {
                        out.write(b);
                    }
                }
                ByteArrayInputStream bin = new ByteArrayInputStream(out.toByteArray());
                this.print(this.docFlavor, ps, bin, pras, copies);
            } else {
                this.print(this.docFlavor, ps, is, pras, copies);
            }
            System.out.println("fin de la impresion");
        } else {
            try {
                defaultService = ServiceUI.printDialog(null, 200, 200, this.jps, ps, null, pras);
                if (defaultService != null) {
                    CommonConstants.printSelect = defaultService;
                    this.print(this.docFlavor, defaultService, is, pras, copies);
                }
                is.close();
            }
            catch (NullPointerException NPEe) {
                NPEe.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        is = null;
    }

    private void printGraphics(ByteArrayInputStream is, PrintRequestAttributeSet pras, int copies, boolean silent) throws PrinterException {
        PrintService defaultService = null;
        boolean printerOk = false;
        if (!silent) {
            try {
                defaultService = ServiceUI.printDialog(null, 200, 200, this.jps, this.selectPrinservice(this.printer), this.docFlavor, pras);
            }
            catch (IllegalArgumentException e) {
                defaultService = ServiceUI.printDialog(null, 200, 200, this.jps, this.selectPrinservice(this.printer), null, pras);
            }
            if (defaultService != null) {
                printerOk = true;
                System.out.println("Impresion Graphics con dialog");
                CommonConstants.printSelect = defaultService;
            }
        } else {
            defaultService = this.selectPrinservice(this.printer);
            if (defaultService != null) {
                printerOk = true;
                System.out.println("Impresion Graphics silenciosa " + defaultService);
                CommonConstants.printSelect = defaultService;
            } else {
                System.out.println("Impresora " + this.printer + "no encontrada");
            }
        }
        System.out.println(" +++++++++++ IMPRIMIENDO PARA LINUX +++++++++++++++++++++++");
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintService(defaultService);
        try {
            PDDocument document = PDDocument.load((InputStream)is);
            System.out.println("creando book");
            Book book = new Book();
            System.out.println("Seteando book");
            PageFormat pf = printJob.defaultPage();
            Paper paper = new Paper();
            System.out.println("Tama\u00f1o del Papel: " + this.width + "x" + this.height);
            paper.setSize(this.width, this.height);
            paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
            pf.setPaper(paper);
            book.append((Printable)new PDFPrintable(document, Scaling.SCALE_TO_FIT), pf, document.getNumberOfPages());
            PDFPrintable pr = new PDFPrintable(document, Scaling.SCALE_TO_FIT);
            printJob.setPageable(book);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long inittime = System.currentTimeMillis();
        if (printerOk) {
            int copies_dialog = 1;
            if (silent) {
                copies_dialog = copies;
                System.out.println("Imprimiendo con parametros de la plantilla por impresion silecionsa");
                System.out.println("numero de copias: " + copies_dialog);
                System.out.println("Pasando trabajo al servicio de impresion");
                printJob.print(pras);
                for (int i = 1; i < copies_dialog; ++i) {
                    System.out.println("Imprimiendo copia");
                    printJob.print(pras);
                }
            } else {
                System.out.println("Imprimiendo con parametros del dialogo de impresion....");
                printJob.print(pras);
            }
        } else {
            System.out.println("No existen medios de impresion");
        }
        long finaltime = System.currentTimeMillis();
        long printertime = finaltime - inittime;
        System.out.println("Impresion finalizada en " + printertime + " milisegundos");
    }

    private void nativePrinter(int copies) {
        System.out.println("impresion nativa por comando lpr");
        try {
            String cmd = "lpr " + this.namefile;
            for (int i = 0; i < copies; ++i) {
                Runtime.getRuntime().exec(cmd);
            }
        }
        catch (IOException ioe) {
            System.out.println("Error, no se pudo imprimir desde linea de comandos");
            System.out.println(ioe);
        }
    }

    private void printGraphicsWindows(ByteArrayInputStream is, PrintRequestAttributeSet pras, int copies, boolean silent) throws PrinterException {
        PrintService defaultService = null;
        boolean printerOk = false;
        pras.add(DialogTypeSelection.NATIVE);
        PrinterJob printJob = PrinterJob.getPrinterJob();
        boolean buttonDialog = false;
        if (!silent) {
            buttonDialog = printJob.printDialog(pras);
            printerOk = true;
            if (defaultService != null) {
                printerOk = true;
                System.out.println("Impresion Graphics con dialog");
                CommonConstants.printSelect = defaultService;
            }
        } else {
            defaultService = this.selectPrinservice(this.printer);
            if (defaultService != null) {
                printerOk = true;
                System.out.println("Impresion Graphics silenciosa " + defaultService);
                CommonConstants.printSelect = defaultService;
                printJob.setPrintService(defaultService);
            } else {
                System.out.println("Impresora " + this.printer + "no econtrada");
            }
        }
        System.out.println(" +++++++++++ IMPRIMIENDO PARA WINDOWS +++++++++++++++++++++++");
        try {
            PDDocument document = PDDocument.load((InputStream)is);
            System.out.println("creando book");
            Book book = new Book();
            System.out.println("Seteando book");
            PageFormat pf = printJob.defaultPage();
            Paper paper = new Paper();
            System.out.println("Tama\u00c3\u00b1o del Papel: " + this.width + "x" + this.height);
            paper.setSize(this.width, this.height);
            paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
            pf.setPaper(paper);
            book.append((Printable)new PDFPrintable(document, Scaling.SCALE_TO_FIT), pf, document.getNumberOfPages());
            PDFPrintable pr = new PDFPrintable(document, Scaling.SCALE_TO_FIT);
            printJob.setPrintable((Printable)pr, pf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (printerOk) {
            System.out.println("Imprimiendo en windows, numero de copias: " + copies);
            if (!silent && buttonDialog) {
                System.out.println("Impresion con dialogo, button: " + buttonDialog);
                printJob.print();
            } else if (silent) {
                for (int i = 0; i < copies; ++i) {
                    System.out.println("Imprimiendo copia " + i);
                    printJob.print();
                }
            }
        } else {
            System.out.println("No existen medios de impresion");
        }
    }

    private void print(DocFlavor docFlavor, PrintService ps, Object printData, PrintRequestAttributeSet pras, int copies) {
        System.out.println("intentando imprimir postscript");
        System.out.println("printer name=>" + ps.getName());
        System.out.println("printData=>" + printData);
        System.out.println("docFlavor=>" + docFlavor);
        System.out.println("pras=>" + pras);
        System.out.println("ps=>" + ps);
        SimpleDoc doc = new SimpleDoc(printData, docFlavor, null);
        try {
            for (int i = 0; i < copies; ++i) {
                DocPrintJob pj = ps.createPrintJob();
                pj.print(doc, pras);
            }
        }
        catch (PrintException e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Impresion Finalizada...");
    }

    private PrintService selectPrinservice(String printer) {
        for (PrintService ps : this.jps) {
            if (ps == null || !ps.getName().equals(printer)) continue;
            return ps;
        }
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    private void showErroDialog() {
        JOptionPane.showMessageDialog(null, "No existen medios de impresion\ndisponibles, debe configurar una\nimpresora en su sistema, y reiniciar\nel programa para que se apliquen los cambios");
    }

    public static enum ImpresionType {
        PLAIN,
        POSTSCRIPT,
        PDF;

    }
}

