/*
 * Decompiled with CFR 0.152.
 */
package common.transactions;

import common.comunications.SocketConnector;
import common.comunications.SocketWriterClient;
import common.transactions.TransactionServerException;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class TransactionServerWS {
    private static Hashtable<String, Document> HspoolTransactions = new Hashtable();
    private static long id = 0L;

    public static Document getWsST(String codigo, String[] args) throws TransactionServerException {
        Document doc = new Document();
        doc.setRootElement(new Element("GET-WEBSERVICE"));
        doc.getRootElement().addContent((Content)new Element("ws").setText(codigo));
        if (args != null) {
            Element params = new Element("params");
            for (String argumento : args) {
                params.addContent((Content)new Element("arg").setText(argumento));
            }
            doc.getRootElement().addContent((Content)params);
        }
        return TransactionServerWS.getWsST(doc);
    }

    private static Document getWsST(Document doc) throws TransactionServerException {
        String id = "WS" + TransactionServerWS.getId();
        doc.getRootElement().addContent((Content)new Element("id").setText(id));
        System.out.println("Enviando solicitud ws al ST");
        SocketChannel socket = SocketConnector.getSock();
        SocketWriterClient.writing(socket, doc);
        int i = 0;
        while (!HspoolTransactions.containsKey(id)) {
            try {
                Thread.sleep(10L);
                if (++i <= 90000) continue;
                throw new TransactionServerException();
            }
            catch (InterruptedException e) {
                doc = new Document();
                doc.setRootElement(new Element("ERROR"));
                SocketWriterClient.writing(socket, doc);
                throw new TransactionServerException();
            }
        }
        Document retorno = HspoolTransactions.get(id);
        HspoolTransactions.remove(id);
        return retorno;
    }

    public static synchronized String getId() {
        return String.valueOf(++id);
    }

    public static void putSpoolXML(String id, Document doc) {
        HspoolTransactions.put(id, doc);
    }
}

