/*
 * Decompiled with CFR 0.152.
 */
package server.database.sql;

import common.comunications.SocketWriter;
import common.misc.language.Language;
import common.misc.log.LogAdmin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import server.comunications.EmakuServerSocket;
import server.control.UPDATECODESender;
import server.database.connection.ConnectionsPool;
import server.database.sql.BusinessRulesStructure;
import server.database.sql.DontHaveKeyException;
import server.database.sql.InfoInventario;
import server.database.sql.PerfilCta;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLFormatAgent;
import server.database.sql.SQLNotFoundException;
import server.database.sql.StatementsClosingHandler;
import server.misc.settings.ConfigFileHandler;

public class LinkingCache {
    private static Hashtable<String, String> HcompanyData = new Hashtable();
    private static Hashtable<String, Object> Hinstrucciones = new Hashtable();
    private static Hashtable<String, Object> Htransacciones = new Hashtable();
    private static Hashtable<String, Object> Hpermisos = new Hashtable();
    private static Hashtable<String, Object> Hasientos_pr = new Hashtable();
    private static Hashtable<String, Object> Hctas_asientos = new Hashtable();
    private static Hashtable<String, Object> Hlibro_aux = new Hashtable();
    private static Hashtable<String, BusinessRulesStructure> Hlogica_drivers = new Hashtable();
    private static Hashtable<String, InfoInventario> Hinventarios = new Hashtable();
    private static Hashtable<String, String> Hconsecutive = new Hashtable();
    private static Hashtable<String, PerfilCta> Hperfil_cta = new Hashtable();
    private static Hashtable<String, Date> lockDate = new Hashtable();

    public static void cargar() {
        int max = ConfigFileHandler.getDBSize();
        LogAdmin.setMessage((String)Language.getWord((String)"LOADING_SL"), (int)2);
        for (int i = 0; i < max; ++i) {
            class LoadDB
            extends Thread {
                private int i;

                LoadDB(int i) {
                    this.i = i;
                }

                @Override
                public void run() {
                    LinkingCache.loadDB(ConfigFileHandler.getDBName(this.i));
                }
            }
            new LoadDB(i).start();
        }
    }

    private static void loadDB(String bd) {
        Statement st = null;
        ResultSet rs = null;
        try {
            LogAdmin.setMessage((String)(Language.getWord((String)"LOADING_CACHE") + " " + bd), (int)2);
            st = ConnectionsPool.getConnection(bd).createStatement();
            LogAdmin.setMessage((String)Language.getWord((String)"INIT_BDS"), (int)2);
            LogAdmin.setMessage((String)(Language.getWord((String)"LOADING_ST") + " " + bd), (int)2);
            rs = st.executeQuery("SELECT trim(codigo) as codigo,sentencia FROM sentencia_sql ORDER BY codigo desc");
            while (rs.next()) {
                Hinstrucciones.put("K-" + bd + "-" + rs.getString("codigo"), rs.getString("sentencia"));
            }
            Htransacciones.putAll(LinkingCache.loadCache(bd, "SCS0001", new String[]{"login", "codigo", "password"}, "ok"));
            Hpermisos.putAll(LinkingCache.loadCache(bd, "SCS0002", new String[]{"login", "codigo", "password"}, "ok"));
            rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0015"));
            SAXBuilder builder = new SAXBuilder(false);
            while (rs.next()) {
                try {
                    Document docDrv = null;
                    Document docMth = null;
                    try {
                        ByteArrayInputStream bufferInDrv = new ByteArrayInputStream(rs.getString("args_driver").getBytes());
                        docDrv = builder.build((InputStream)bufferInDrv);
                    }
                    catch (NullPointerException NPEe) {
                        // empty catch block
                    }
                    try {
                        ByteArrayInputStream bufferInMth = new ByteArrayInputStream(rs.getString("args_metodo").getBytes());
                        docMth = builder.build((InputStream)bufferInMth);
                    }
                    catch (NullPointerException NPEe) {
                        // empty catch block
                    }
                    Hlogica_drivers.put("K-" + bd + "-" + rs.getString("codigo").trim(), new BusinessRulesStructure(rs.getString("driver"), docDrv, rs.getString("metodo"), docMth));
                }
                catch (IOException IOEe) {
                    LogAdmin.setMessage((String)(Language.getWord((String)"ERR_LOADING_LG") + " " + bd + " " + rs.getString("codigo") + " " + IOEe.getMessage()), (int)0);
                }
                catch (JDOMException JDOMEe) {
                    LogAdmin.setMessage((String)(Language.getWord((String)"ERR_LOADING_LG") + " " + bd + " " + rs.getString("codigo") + " " + JDOMEe.getMessage()), (int)0);
                }
            }
            rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0054"));
            while (rs.next()) {
                HcompanyData.put("K-" + bd + "-company", String.valueOf(rs.getString("nombre")));
                HcompanyData.put("K-" + bd + "-companyID", String.valueOf(rs.getString("id_char")));
                HcompanyData.put("K-" + bd + "-address", String.valueOf(rs.getString("direccion")));
                HcompanyData.put("K-" + bd + "-phone", String.valueOf(rs.getString("numero")));
                HcompanyData.put("K-" + bd + "-city", String.valueOf(rs.getString("ciudad")));
            }
            rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0088"));
            while (rs.next()) {
                lockDate.put("K-" + bd, rs.getTimestamp("fecha"));
            }
            rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0023"));
            while (rs.next()) {
                Hconsecutive.put("K-" + bd + "-" + rs.getString("codigo_tipo").trim(), LinkingCache.consecutive(bd, rs.getString("max")));
            }
            rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0037"));
            while (rs.next()) {
                Hinventarios.put("K-" + bd + "-" + rs.getInt("id_bodega") + "-" + rs.getInt("id_prod_serv"), new InfoInventario(rs.getDouble("pinventario"), rs.getDouble("saldo"), rs.getDouble("valor_saldo")));
            }
            try {
                st.execute(SQLFormatAgent.getSentencia(bd, "SCS0063"));
            }
            catch (SQLNotFoundException SQLNFEe) {
                // empty catch block
            }
            LinkingCache.loadPerfilCta(bd, "SCS0038", null);
            LinkingCache.loadAsientosPredefinidos(bd);
            Hlibro_aux.putAll(LinkingCache.loadCache(bd, "SCS0041", new String[]{"centro", "id_cta", "id_tercero", "id_prod_serv"}, "saldo"));
        }
        catch (SQLException SQLEe) {
            SQLEe.printStackTrace();
            LogAdmin.setMessage((String)(Language.getWord((String)"ERROR_LOADING_SL") + " " + bd + SQLEe.getMessage()), (int)0);
        }
        catch (SQLNotFoundException SQLNFEe) {
            SQLNFEe.printStackTrace();
            LogAdmin.setMessage((String)(Language.getWord((String)"ERROR_LOADING_SL") + " " + bd + SQLNFEe.getMessage()), (int)0);
        }
        catch (SQLBadArgumentsException SQLBAEe) {
            SQLBAEe.printStackTrace();
            LogAdmin.setMessage((String)(Language.getWord((String)"ERROR_LOADING_SL") + " " + bd + SQLBAEe.getMessage()), (int)0);
        }
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
    }

    public static void removePerfilCta(String bd, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Statement st = ConnectionsPool.getConnection(bd).createStatement();
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0057", args));
        while (rs.next()) {
            String key = "K-" + bd + "-" + rs.getString(1).trim();
            Hperfil_cta.remove(key);
        }
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
    }

    public static void removeAsientosPr(String bd, String sql, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Statement st = ConnectionsPool.getConnection(bd).createStatement();
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, sql, args));
        while (rs.next()) {
            String key = "K-" + bd + "-" + rs.getString(1).trim() + "-" + rs.getString(2).trim();
            Hasientos_pr.remove(key);
        }
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
    }

    public static void removeCtasAsientos(String bd, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Statement st = ConnectionsPool.getConnection(bd).createStatement();
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0055", args));
        while (rs.next()) {
            String key = "K-" + bd + "-" + rs.getString(1).trim() + "-" + rs.getString(2).trim();
            Hctas_asientos.remove(key);
        }
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
    }

    public static void reloadAsientosPr(String bd, String sql, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Hasientos_pr.putAll(LinkingCache.loadCache(bd, sql, args, new String[]{"id_prod_serv", "id_asientos_prod_serv"}, "id_asientos_pr"));
    }

    public static void reloadCtasAsientos(String bd, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Hctas_asientos.putAll(LinkingCache.loadCache(bd, "SCS0055", args, new String[]{"id_asientos_pr", "char_cta"}, "naturaleza"));
    }

    public static void loadAsientosPredefinidos(String bd) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Hasientos_pr.putAll(LinkingCache.loadCache(bd, "SCS0039", new String[]{"id_prod_serv", "id_asientos_prod_serv"}, "id_asientos_pr"));
        Hctas_asientos.putAll(LinkingCache.loadCache(bd, "SCS0040", new String[]{"id_asientos_pr", "char_cta"}, "naturaleza"));
    }

    public static void loadPerfilCta(String bd, String sqlPerfil, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Statement st = ConnectionsPool.getConnection(bd).createStatement();
        ResultSet rs = args == null ? st.executeQuery(SQLFormatAgent.getSentencia(bd, sqlPerfil)) : st.executeQuery(SQLFormatAgent.getSentencia(bd, sqlPerfil, args));
        while (rs.next()) {
            Hperfil_cta.put("K-" + bd + "-" + rs.getString("char_cta").trim(), new PerfilCta(rs.getString("id_cta"), rs.getBoolean("naturaleza"), rs.getBoolean("terceros"), rs.getBoolean("inventarios"), rs.getBoolean("centro"), rs.getBoolean("ajuste"), rs.getBoolean("depreciacion"), rs.getDouble("base"), rs.getDouble("porcentaje")));
        }
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
    }

    private static synchronized Hashtable<String, Object> loadCache(String bd, String sql, String[] key, String rsValue) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        return LinkingCache.loadCache(bd, sql, null, key, rsValue);
    }

    private static synchronized Hashtable<String, Object> loadCache(String bd, String sql, String[] args, String[] key, String rsValue) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Statement st = ConnectionsPool.getConnection(bd).createStatement();
        ResultSet rs = args != null ? st.executeQuery(SQLFormatAgent.getSentencia(bd, sql, args)) : st.executeQuery(SQLFormatAgent.getSentencia(bd, sql));
        Hashtable<String, Object> tabla = new Hashtable<String, Object>();
        while (rs.next()) {
            String subkey = "";
            for (String subData : key) {
                subkey = subkey + rs.getString(subData).trim() + "-";
            }
            tabla.put("K-" + bd + "-" + subkey.substring(0, subkey.length() - 1), rs.getObject(rsValue));
        }
        rs.last();
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
        return tabla;
    }

    public static String getCompanyData(String key) {
        return HcompanyData.get(key);
    }

    public static String getAddress(String bd) {
        return HcompanyData.get("K-" + bd + "-address");
    }

    public static String getPhone(String bd) {
        return HcompanyData.get("K-" + bd + "-phone");
    }

    public static String getCity(String bd) {
        return HcompanyData.get("K-" + bd + "-city");
    }

    private static String consecutive(String nombreBD, String value) {
        if (value != null && !value.equals("")) {
            try {
                long nextValue = Long.parseLong(value.trim()) + 1L;
                String sNextValue = "0000000000" + nextValue;
                return sNextValue.substring(sNextValue.length() - 10);
            }
            catch (NumberFormatException NFEe) {
                LogAdmin.setMessage((String)(Language.getWord((String)"ERR_CONSECUTIVE") + " " + nombreBD + NFEe.getMessage()), (int)0);
                return "0000000001";
            }
        }
        return "0000000001";
    }

    public static double getSaldoInventario(String bd, String bodega, String id_prod_serv) {
        if (Hinventarios.containsKey("K-" + bd + "-" + bodega + "-" + id_prod_serv)) {
            return Hinventarios.get("K-" + bd + "-" + bodega + "-" + id_prod_serv).getSaldo();
        }
        return 0.0;
    }

    public static void setSaldoInventario(String bd, String bodega, String id_prod_serv, double saldo) {
        String ktmp = "K-" + bd + "-" + bodega + "-" + id_prod_serv;
        try {
            Statement st = ConnectionsPool.getConnection(bd).createStatement();
            if (Hinventarios.containsKey(ktmp)) {
                Hinventarios.get(ktmp).setSaldo(saldo);
                st.execute(SQLFormatAgent.getSentencia(bd, "SCS0064", new String[]{id_prod_serv, bodega}));
                st.execute(SQLFormatAgent.getSentencia(bd, "SCS0065", new String[]{String.valueOf(saldo), id_prod_serv, bodega}));
            } else {
                Hinventarios.put(ktmp, new InfoInventario(0.0, saldo, 0.0));
                st.execute(SQLFormatAgent.getSentencia(bd, "SCS0065", new String[]{String.valueOf(saldo), id_prod_serv, bodega}));
            }
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
    }

    public static double getVSaldoInventario(String bd, String bodega, String id_prod_serv) {
        if (Hinventarios.containsKey("K-" + bd + "-" + bodega + "-" + id_prod_serv)) {
            return Hinventarios.get("K-" + bd + "-" + bodega + "-" + id_prod_serv).getVsaldo();
        }
        return 0.0;
    }

    public static Date getLockDate(String bd) {
        return lockDate.get("K-" + bd);
    }

    public static void setLockDate(String bd, String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:SS");
        lockDate.remove("K-" + bd);
        try {
            lockDate.put("K-" + bd, sdf.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static void reloadLockDate(String bd) {
        lockDate.remove("k-" + bd);
        try {
            Statement st = ConnectionsPool.getConnection(bd).createStatement();
            ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0088"));
            while (rs.next()) {
                lockDate.put("K-" + bd, rs.getTimestamp("fecha"));
            }
            StatementsClosingHandler.close(st);
            StatementsClosingHandler.close(rs);
            st = null;
            rs = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void setVSaldoInventario(String bd, String bodega, String id_prod_serv, double saldo) {
        String ktmp = "K-" + bd + "-" + bodega + "-" + id_prod_serv;
        if (Hinventarios.containsKey(ktmp)) {
            Hinventarios.get(ktmp).setVsaldo(saldo);
        } else {
            Hinventarios.put(ktmp, new InfoInventario(0.0, 0.0, saldo));
        }
    }

    public static void setVSaldoInventario(String key, double saldo) {
        if (Hinventarios.containsKey(key)) {
            Hinventarios.get(key).setVsaldo(saldo);
        } else {
            Hinventarios.put(key, new InfoInventario(0.0, 0.0, saldo));
        }
    }

    public static double getPCosto(String bd, String bodega, String id_prod_serv) {
        if (Hinventarios.containsKey("K-" + bd + "-" + bodega + "-" + id_prod_serv)) {
            return Hinventarios.get("K-" + bd + "-" + bodega + "-" + id_prod_serv).getPcosto();
        }
        return 0.0;
    }

    public static void setPCosto(String bd, String bodega, String id_prod_serv, double saldo) {
        String ktmp = "K-" + bd + "-" + bodega + "-" + id_prod_serv;
        if (Hinventarios.containsKey(ktmp)) {
            Hinventarios.get(ktmp).setPcosto(saldo);
        } else {
            Hinventarios.put(ktmp, new InfoInventario(saldo, 0.0, 0.0));
        }
    }

    public static double getSaldoLibroAux(String bd, String centro, String cta, String id_tercero, String id_prod_serv) {
        if (Hlibro_aux.containsKey("K-" + bd + "-" + centro + "-" + cta + "-" + id_tercero + "-" + id_prod_serv)) {
            return (Double)Hlibro_aux.get("K-" + bd + "-" + centro + "-" + cta + "-" + id_tercero + "-" + id_prod_serv);
        }
        return 0.0;
    }

    public static void setSaldoLibroAux(String bd, String centro, String cta, String id_tercero, String id_prod_serv, Double saldo) {
        String ktmp = "K-" + bd + "-" + centro + "-" + cta + "-" + id_tercero + "-" + id_prod_serv;
        Hlibro_aux.remove(ktmp);
        Hlibro_aux.put(ktmp, saldo);
    }

    public static void setSaldoLibroAux(String key, Double saldo) {
        Hlibro_aux.remove(key);
        Hlibro_aux.put(key, saldo);
    }

    public static BusinessRulesStructure getDriver(String bd, String id_transaction) {
        return Hlogica_drivers.get("K-" + bd + "-" + id_transaction);
    }

    public static String getSentenciaSQL(String key) {
        return (String)Hinstrucciones.get(key);
    }

    public static boolean getPermisosSQL(String key) {
        return Hpermisos.containsKey(key);
    }

    public static void setPermisosSQL(String bd, String login) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Hpermisos.putAll(LinkingCache.loadCache(bd, "SCS0091", new String[]{login}, new String[]{"login", "codigo", "password"}, "ok"));
    }

    public static void removePermisosSQL(String key) {
        Hpermisos.remove(key);
    }

    public static boolean getPermisosTransaccion(String key) {
        return Htransacciones.containsKey(key);
    }

    public static void setPermisosTransacciones(String key) {
        Htransacciones.put(key, true);
    }

    public static void removePermisosTransacciones(String key) {
        Htransacciones.remove(key);
    }

    public static void setConsecutive(String bd, String key, String value) {
        String ktmp = "K-" + bd + "-" + key;
        Hconsecutive.remove(ktmp);
        Hconsecutive.put(ktmp, value);
    }

    public static void reloadConsecutive(String bd, String key) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Connection cn = ConnectionsPool.getConnection(bd);
        Statement st = cn.createStatement();
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0046", new String[]{key}));
        String consecutive = "";
        while (rs.next()) {
            consecutive = rs.getString(1);
        }
        Hconsecutive.remove("K-" + bd + "-" + key);
        if (consecutive != null) {
            Hconsecutive.put("K-" + bd + "-" + key, consecutive);
        }
        LinkingCache.incrementeConsecutive(bd, key);
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
    }

    public static void incrementeConsecutive(String bd, String key) {
        String consecutive = LinkingCache.getConsecutive(bd, key);
        try {
            long nextValue = Long.parseLong(consecutive.trim()) + 1L;
            String sNextValue = "0000000000" + nextValue;
            LinkingCache.setConsecutive(bd, key, sNextValue.substring(sNextValue.length() - 10));
            Hashtable clientes = EmakuServerSocket.getHchannelclients();
            Enumeration sockets = clientes.keys();
            while (sockets.hasMoreElements()) {
                SocketChannel sock = (SocketChannel)sockets.nextElement();
                if (!EmakuServerSocket.getBd(sock).equals(bd)) continue;
                SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (Document)UPDATECODESender.getPackage(key, LinkingCache.getConsecutive(bd, key)));
            }
        }
        catch (NumberFormatException NFEe) {
            NFEe.printStackTrace();
            LogAdmin.setMessage((String)(Language.getWord((String)"ERR_CONSECUTIVE") + " " + bd + NFEe.getMessage()), (int)0);
        }
    }

    public static String getConsecutive(String bd, String key) {
        if (Hconsecutive.containsKey("K-" + bd + "-" + key)) {
            return Hconsecutive.get("K-" + bd + "-" + key);
        }
        return "0000000001";
    }

    public static boolean isPCTerceros(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isTerceros();
        }
        throw new DontHaveKeyException(account);
    }

    public static boolean isPCCentro(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isCentro();
        }
        throw new DontHaveKeyException(account);
    }

    public static boolean isPCInventarios(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isInventarios();
        }
        throw new DontHaveKeyException(account);
    }

    public static boolean isPCAjuste(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isAjuste();
        }
        throw new DontHaveKeyException(account);
    }

    public static boolean isPCNaturaleza(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isNaturaleza();
        }
        throw new DontHaveKeyException(account);
    }

    public static double getPCBase(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).getBase();
        }
        throw new DontHaveKeyException(account);
    }

    public static double getPCPorcentaje(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).getPorcentaje();
        }
        throw new DontHaveKeyException(account);
    }

    public static String getPCIdCta(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).getId_cta();
        }
        throw new DontHaveKeyException(account);
    }

    public static String getIdAsientosPr(String bd, String id_prod_serv, String id_asientos_prod_serv) throws DontHaveKeyException {
        if (Hasientos_pr.containsKey("K-" + bd + "-" + id_prod_serv + "-" + id_asientos_prod_serv)) {
            return String.valueOf(Hasientos_pr.get("K-" + bd + "-" + id_prod_serv + "-" + id_asientos_prod_serv));
        }
        throw new DontHaveKeyException("K-" + bd + "-" + id_prod_serv + "-" + id_asientos_prod_serv);
    }

    public static boolean isAsientoDebito(String bd, String id_asiento_pr, String cta) throws DontHaveKeyException {
        if (Hctas_asientos.containsKey("K-" + bd + "-" + id_asiento_pr + "-" + cta)) {
            return (Boolean)Hctas_asientos.get("K-" + bd + "-" + id_asiento_pr + "-" + cta);
        }
        throw new DontHaveKeyException("K-" + bd + "-" + id_asiento_pr + "-" + cta);
    }
}

