/*
 * Decompiled with CFR 0.152.
 */
package server.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import server.gui.FlagRenderer;

public class ConfigDialog
extends JDialog {
    private static final long serialVersionUID = 7799638277510459773L;
    private JComboBox JCBLang;
    private JTextField JTPortForClients;
    private JTextField JTPortForAdmin;
    private JTextField JTMaxClients;
    private JComboBox JCBLogs;
    private JTextField JTCompany;
    private JComboBox JTDriver;
    private JTextField JTUrl;
    private JTextField JTDBPort;
    private JTextField JTUser;
    private JPasswordField JTPasswd;
    public boolean noFile = true;
    public String lang = "es_CO";
    public String clientPort = "9117";
    public String adminPort = "28124";
    public String maxClients = "500";
    public String logType = "Verbose";
    public String company = "mi_empresa";
    public String jdbcDriver = "org.postgresql.Driver";
    public String url = "jdbc:postgresql://localhost:5432/mi_empresa";
    public String user = "emaku";
    public String password = "";

    public ConfigDialog(JFrame parent) {
        super((Frame)parent, true);
        this.setTitle("Configuraci\u00f3n");
        this.setResizable(false);
        Object[] items = new Object[]{"es_CO", "es_ES", "en_US"};
        JPanel JPlabels = new JPanel();
        JPanel JPfields = new JPanel();
        JPlabels.setLayout(new GridLayout(11, 1));
        JPfields.setLayout(new GridLayout(11, 1));
        JLabel JLLang = new JLabel("Idioma: ");
        JPanel JPLLang = new JPanel(new FlowLayout(0));
        JPLLang.add(JLLang);
        JLabel JLPortForClients = new JLabel("Puerto para Clientes: ");
        JPanel JPPFClients = new JPanel(new FlowLayout(0));
        JPPFClients.add(JLPortForClients);
        JLabel JLPortForAdmins = new JLabel("Puerto para Admins: ");
        JPanel JPPortForAdmins = new JPanel(new FlowLayout(0));
        JPPortForAdmins.add(JLPortForAdmins);
        JLabel JLMaxClients = new JLabel("Max N\u00famero de Clientes: ");
        JPanel JPMaxClients = new JPanel(new FlowLayout(0));
        JPMaxClients.add(JLMaxClients);
        JLabel JLLog = new JLabel("Tipo de Log:");
        JPanel JPJLLog = new JPanel(new FlowLayout(0));
        JPJLLog.add(JLLog);
        JLabel JLCompany = new JLabel("Empresa:");
        JPanel JPJLCompany = new JPanel(new FlowLayout(0));
        JPJLCompany.add(JLCompany);
        JLabel JLDriver = new JLabel("Driver:");
        JPanel JPJLDriver = new JPanel(new FlowLayout(0));
        JPJLDriver.add(JLDriver);
        JLabel JLUrl = new JLabel("Servidor DB:");
        JPanel JPJLUrl = new JPanel(new FlowLayout(0));
        JPJLUrl.add(JLUrl);
        JLabel JLDBPort = new JLabel("Puerto DB:");
        JPanel JPJLDBPort = new JPanel(new FlowLayout(0));
        JPJLDBPort.add(JLDBPort);
        JLabel JLUser = new JLabel("Usuario:");
        JPanel JPJLUser = new JPanel(new FlowLayout(0));
        JPJLUser.add(JLUser);
        JLabel JLPasswd = new JLabel("Clave:");
        JPanel JPJLPasswd = new JPanel(new FlowLayout(0));
        JPJLPasswd.add(JLPasswd);
        JPlabels.add(JPLLang);
        JPlabels.add(JPPFClients);
        JPlabels.add(JPPortForAdmins);
        JPlabels.add(JPMaxClients);
        JPlabels.add(JPJLLog);
        JPlabels.add(JPJLCompany);
        JPlabels.add(JPJLDriver);
        JPlabels.add(JPJLUrl);
        JPlabels.add(JPJLDBPort);
        JPlabels.add(JPJLUser);
        JPlabels.add(JPJLPasswd);
        this.JCBLang = new JComboBox<Object>(items);
        this.JCBLang.setRenderer(new FlagRenderer());
        this.JCBLang.setSelectedItem(this.lang);
        JPanel JPJCLang = new JPanel(new FlowLayout(0));
        JPJCLang.add(this.JCBLang);
        this.JTPortForClients = new JTextField(10);
        this.JTPortForClients.setText(this.clientPort);
        this.JTPortForClients.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.JTPortForClients.transferFocus();
            }
        });
        JPanel JPJTPortForClients = new JPanel(new FlowLayout(0));
        JPJTPortForClients.add(this.JTPortForClients);
        this.JTPortForAdmin = new JTextField(10);
        this.JTPortForAdmin.setText(this.adminPort);
        JPanel JPJTPortForAdmin = new JPanel(new FlowLayout(0));
        JPJTPortForAdmin.add(this.JTPortForAdmin);
        this.JTMaxClients = new JTextField(10);
        this.JTMaxClients.setText(this.maxClients);
        JPanel JPJTMaxClients = new JPanel(new FlowLayout(0));
        JPJTMaxClients.add(this.JTMaxClients);
        Object[] logItems = new Object[]{"Default", "Verbose", "VerboseFile", "None"};
        this.JCBLogs = new JComboBox<Object>(logItems);
        this.JCBLogs.setSelectedItem(this.logType);
        JPanel JPCBLogs = new JPanel(new FlowLayout(0));
        JPCBLogs.add(this.JCBLogs);
        this.JTCompany = new JTextField(10);
        this.JTCompany.setText(this.company);
        JPanel JPJTCompany = new JPanel(new FlowLayout(0));
        JPJTCompany.add(this.JTCompany);
        Object[] driverItems = new Object[]{"PostgreSQL", "Mysql"};
        this.JTDriver = new JComboBox<Object>(driverItems);
        this.JTDriver.setSelectedItem(this.jdbcDriver);
        JPanel JPJTDriver = new JPanel(new FlowLayout(0));
        JPJTDriver.add(this.JTDriver);
        this.JTUrl = new JTextField(10);
        this.JTUrl.setText("localhost");
        JPanel JPJTUrl = new JPanel(new FlowLayout(0));
        JPJTUrl.add(this.JTUrl);
        this.JTDBPort = new JTextField(10);
        this.JTDBPort.setText("5432");
        JPanel JPJTDBPort = new JPanel(new FlowLayout(0));
        JPJTDBPort.add(this.JTDBPort);
        this.JTUser = new JTextField(10);
        this.JTUser.setText(this.user);
        JPanel JPJTUser = new JPanel(new FlowLayout(0));
        JPJTUser.add(this.JTUser);
        this.JTPasswd = new JPasswordField(10);
        this.JTPasswd.setText(this.password);
        JPanel JPJTPasswd = new JPanel(new FlowLayout(0));
        JPJTPasswd.add(this.JTPasswd);
        JPfields.add(JPJCLang);
        JPfields.add(JPJTPortForClients);
        JPfields.add(JPJTPortForAdmin);
        JPfields.add(JPJTMaxClients);
        JPfields.add(JPCBLogs);
        JPfields.add(JPJTCompany);
        JPfields.add(JPJTDriver);
        JPfields.add(JPJTUrl);
        JPfields.add(JPJTDBPort);
        JPfields.add(JPJTUser);
        JPfields.add(JPJTPasswd);
        JPanel JBase = new JPanel();
        JBase.setLayout(new BorderLayout());
        JBase.add((Component)new JPanel(), "North");
        JBase.add((Component)JPlabels, "West");
        JBase.add((Component)JPfields, "Center");
        JBase.add((Component)new JPanel(), "South");
        JPanel JPsouth = new JPanel();
        JPsouth.setLayout(new FlowLayout(1));
        JButton JBAccept = new JButton("Aceptar");
        JBAccept.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ConfigDialog.this.packingData()) {
                    ConfigDialog.this.setVisible(false);
                }
            }
        });
        JBAccept.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 && ConfigDialog.this.packingData()) {
                    ConfigDialog.this.setVisible(false);
                }
            }
        });
        JPsouth.add(JBAccept);
        JButton JBCancel = new JButton("Cancelar");
        JBCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JPsouth.add(JBCancel);
        this.add((Component)JPsouth, "South");
        this.add((Component)JBase, "Center");
        this.add((Component)new JPanel(), "West");
        this.add((Component)new JPanel(), "East");
    }

    public String getLanguage() {
        return this.lang;
    }

    public String getClientPort() {
        return this.clientPort;
    }

    public String getAdminPort() {
        return this.adminPort;
    }

    public String getMaxClients() {
        return this.maxClients;
    }

    public String getLogType() {
        return this.logType;
    }

    public String getCompany() {
        return this.company;
    }

    public String getJDBCDriver() {
        return this.jdbcDriver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPasswd() {
        return this.password;
    }

    public void cleanField(JTextField field) {
        field.setText("");
        field.requestFocus();
    }

    private boolean packingData() {
        this.lang = this.JCBLang.getSelectedItem().toString();
        this.clientPort = this.JTPortForClients.getText();
        if (this.clientPort.length() > 0) {
            if (!this.isNumber(this.clientPort)) {
                JOptionPane.showMessageDialog(this, "El puerto del cliente debe ser de tipo num\u00e9rico!", "Error!", 0);
                return false;
            }
        } else {
            this.clientPort = "9117";
        }
        this.adminPort = this.JTPortForAdmin.getText();
        if (this.adminPort.length() > 0) {
            if (!this.isNumber(this.adminPort)) {
                JOptionPane.showMessageDialog(this, "El puerto del admin debe ser de tipo num\u00e9rico!", "Error!", 0);
                return false;
            }
        } else {
            this.adminPort = "28124";
        }
        this.maxClients = this.JTMaxClients.getText();
        if (this.maxClients.length() > 0) {
            if (!this.isNumber(this.maxClients)) {
                JOptionPane.showMessageDialog(this, "El n\u00famero m\u00e1ximo de clientes debe ser de tipo num\u00e9rico!", "Error!", 0);
                return false;
            }
        } else {
            this.maxClients = "500";
        }
        this.logType = this.JCBLogs.getSelectedItem().toString();
        this.company = this.JTCompany.getText();
        if (this.company.length() > 0) {
            if (this.company.indexOf(" ") != -1) {
                JOptionPane.showMessageDialog(this, "El nombre de la empresa no puede incluir espacios", "Error!", 0);
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "El campo del nombre de la empresa se encuentra vacio!", "Error!", 0);
            return false;
        }
        String dbEngine = this.JTDriver.getSelectedItem().toString();
        String urlEngine = "";
        if (dbEngine.equals("PostgreSQL")) {
            this.jdbcDriver = "org.postgresql.Driver";
            urlEngine = "postgresql";
        } else if (dbEngine.equals("Mysql")) {
            this.jdbcDriver = "com.mysql.jdbc.Driver";
            urlEngine = "mysql";
        }
        String server = this.JTUrl.getText();
        if (server.length() == 0) {
            JOptionPane.showMessageDialog(this, "Ingrese el nombre o la direcci\u00f3n ip del servidor de bases de datos", "Error!", 0);
            return false;
        }
        String enginePort = this.JTDBPort.getText();
        if (enginePort.length() > 0) {
            if (!this.isNumber(enginePort)) {
                JOptionPane.showMessageDialog(this, "El puerto del servidor de bases de datos debe ser num\u00e9rico!", "Error!", 0);
                return false;
            }
        } else {
            enginePort = "5432";
        }
        this.url = "jdbc:" + urlEngine + "://" + server + ":" + enginePort + "/" + this.company;
        this.user = this.JTUser.getText();
        if (this.user.length() == 0) {
            JOptionPane.showMessageDialog(this, "Ingrese el nombre del usuario de la base de datos", "Error!", 0);
            return false;
        }
        this.password = new String(this.JTPasswd.getPassword());
        if (this.password.length() == 0) {
            JOptionPane.showMessageDialog(this, "Ingrese la clave del usuario de la base de datos", "Error!", 0);
            return false;
        }
        return true;
    }

    public boolean isNumber(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

