/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SOAPClientSample {
    private final String PREFERRED_PREFIX = "soap";
    private final String SOAP_ENV_NAMESPACE = "http://www.w3.org/2003/05/soap-envelope";
    private final String DIAN_PREFIX = "wcf";
    private final String DIAN_NAMESPACE = "http://wcf.dian.colombia";
    private final String WSA_PREFIX = "wsa";
    private final String WSA_NAMESAPCE = "http://www.w3.org/2005/08/addressing";
    private final String WSSE_PREFIX = "wsse";
    private final String WSSE_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private final String WSU_PREFIX = "wsu";
    private final String WSU_NAMESAPCE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private final String DS_PREFIX = "ds";
    private final String DS_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";

    public static void main(String[] args) throws Exception {
        SOAPClientSample client = new SOAPClientSample();
        System.setProperty("javax.xml.soap.MessageFactory", "com.sun.xml.internal.messaging.saaj.soap.ver1_2.SOAPMessageFactory1_2Impl");
        System.setProperty("javax.xml.bind.JAXBContext", "com.sun.xml.internal.bind.v2.ContextFactory");
        Document doc = client.readInXMLFile();
        SOAPMessage msg = client.createSOAPEnvelope(doc);
        msg = client.signSOAPMessage(msg);
        client.outputSOAPMessageToFile(msg);
    }

    private Document readInXMLFile() throws ParserConfigurationException, SAXException, IOException {
        File requestFile = new File("/home/felipe/xmls/SendBillSync1.xml");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(requestFile);
        return doc;
    }

    private SOAPMessage createSOAPEnvelope(Document xmlDocument) throws SOAPException {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        soapEnvelope.removeNamespaceDeclaration(soapEnvelope.getPrefix());
        soapEnvelope.addNamespaceDeclaration("soap", "http://www.w3.org/2003/05/soap-envelope");
        soapEnvelope.addNamespaceDeclaration("wcf", "http://wcf.dian.colombia");
        soapEnvelope.setPrefix("soap");
        SOAPBody soapBody = soapMessage.getSOAPBody();
        soapBody.setPrefix("soap");
        soapBody.addDocument(xmlDocument);
        return soapMessage;
    }

    private SOAPMessage signSOAPMessage(SOAPMessage soapMessage) throws Exception {
        SOAPHeader soapHeader = soapMessage.getSOAPHeader();
        soapHeader.setPrefix("soap");
        soapHeader.addNamespaceDeclaration("wsa", "http://www.w3.org/2005/08/addressing");
        SOAPElement securityElement = soapHeader.addChildElement("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        securityElement.addNamespaceDeclaration("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Certificate cert = this.getCertificate();
        SOAPElement timestamp = this.addTimestamp(securityElement, soapMessage);
        this.addBinarySecurityToken(securityElement, cert);
        SOAPElement to = this.addTo((SOAPElement)soapHeader, soapMessage);
        this.addSignature(securityElement, soapMessage.getSOAPBody(), to);
        this.addAction((SOAPElement)soapHeader);
        return soapMessage;
    }

    private SOAPElement addTimestamp(SOAPElement securityElement, SOAPMessage soapMessage) throws SOAPException {
        SOAPElement timestamp = securityElement.addChildElement("Timestamp", "wsu");
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        timestamp.addAttribute(soapEnvelope.createName("Id", "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"), "TS");
        String DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
        DateTimeFormatter timeStampFormatter = DateTimeFormatter.ofPattern(DATE_TIME_PATTERN);
        timestamp.addChildElement("Created", "wsu").setValue(timeStampFormatter.format(ZonedDateTime.now().toInstant().atZone(ZoneId.of("UTC"))));
        timestamp.addChildElement("Expires", "wsu").setValue(timeStampFormatter.format(ZonedDateTime.now().plusSeconds(6000L).toInstant().atZone(ZoneId.of("UTC"))));
        return timestamp;
    }

    private void addAction(SOAPElement soapHeader) throws SOAPException {
        SOAPElement action = soapHeader.addChildElement("Action", "wsa");
        action.setValue("http://wcf.dian.colombia/IWcfDianCustomerServices/SendBillSync");
    }

    private SOAPElement addTo(SOAPElement soapHeader, SOAPMessage soapMessage) throws SOAPException {
        SOAPElement to = soapHeader.addChildElement("To", "wsa");
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        to.addAttribute(soapEnvelope.createName("Id", "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"), "id");
        to.setValue("https://vpfe-hab.dian.gov.co/WcfDianCustomerServices.svc");
        return to;
    }

    private Certificate getCertificate() throws Exception {
        String password = "HW5c6WbRXC";
        byte[] passwordByte = password.getBytes();
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] passwordHashed = digest.digest(passwordByte);
        String passwordHashedbase64 = Base64.getEncoder().encodeToString(passwordHashed);
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        keystore.load(new FileInputStream(new File("/home/emaku/certs/Certificado.p12")), "HW5c6WbRXC".toCharArray());
        Certificate cert = keystore.getCertificate(" grama group sas");
        return cert;
    }

    private SOAPElement addBinarySecurityToken(SOAPElement securityElement, Certificate cert) throws Exception {
        byte[] certByte = cert.getEncoded();
        SOAPElement binarySecurityToken = securityElement.addChildElement("BinarySecurityToken", "wsse");
        binarySecurityToken.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        binarySecurityToken.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        binarySecurityToken.setAttribute("wsu:Id", "X509");
        binarySecurityToken.addTextNode(Base64.getEncoder().encodeToString(certByte));
        return securityElement;
    }

    private SOAPElement addSignature(SOAPElement securityElement, SOAPBody soapBody, SOAPElement to) throws Exception {
        PrivateKey key = this.getKeyFormCert();
        SOAPElement securityTokenReference = this.addSecurityToken(securityElement);
        this.createDetachedSignature(securityElement, key, securityTokenReference, soapBody, to);
        return securityElement;
    }

    private PrivateKey getKeyFormCert() throws Exception {
        String password = "HW5c6WbRXC";
        byte[] passwordByte = password.getBytes();
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] passwordHashed = digest.digest(passwordByte);
        String passwordHashedBase64 = Base64.getEncoder().encodeToString(passwordHashed);
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        keystore.load(new FileInputStream(new File("/home/emaku/certs/Certificado.p12")), "HW5c6WbRXC".toCharArray());
        PrivateKey key = (PrivateKey)keystore.getKey(" grama group sas", "HW5c6WbRXC".toCharArray());
        return key;
    }

    private SOAPElement addSecurityToken(SOAPElement signature) throws SOAPException {
        SOAPElement securityTokenReference = signature.addChildElement("SecurityTokenReference", "wsse");
        securityTokenReference.setAttribute("wsu:Id", "STR");
        SOAPElement reference = securityTokenReference.addChildElement("Reference", "wsse");
        reference.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        reference.setAttribute("URI", "#X509");
        return securityTokenReference;
    }

    private void createDetachedSignature(SOAPElement signatureElement, PrivateKey privateKey, SOAPElement securityTokenReference, SOAPBody soapBody, SOAPElement to) throws Exception {
        String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
        XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
        DigestMethod digestMethod = xmlSignatureFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        ArrayList<String> transformListNamespaces = new ArrayList<String>();
        transformListNamespaces.add("soap wcf");
        ExcC14NParameterSpec inclusiveTransforms = new ExcC14NParameterSpec(transformListNamespaces);
        Transform envTransform = xmlSignatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", inclusiveTransforms);
        transformList.add(envTransform);
        ArrayList<Reference> refList = new ArrayList<Reference>();
        Reference refTS = xmlSignatureFactory.newReference("#id", digestMethod, transformList, null, null);
        refList.add(refTS);
        ArrayList<String> prefixList = new ArrayList<String>();
        prefixList.add("wsa soap wcf");
        ExcC14NParameterSpec inclusiveNamespace = new ExcC14NParameterSpec(prefixList);
        CanonicalizationMethod cm = xmlSignatureFactory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", inclusiveNamespace);
        SignatureMethod sm = xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
        SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(cm, sm, refList);
        DOMSignContext signContext = new DOMSignContext(privateKey, (Node)signatureElement);
        signContext.setDefaultNamespacePrefix("ds");
        signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
        signContext.setIdAttributeNS((Element)to, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        KeyInfoFactory keyFactory = KeyInfoFactory.getInstance();
        DOMStructure domKeyInfo = new DOMStructure((Node)securityTokenReference);
        KeyInfo keyInfo = keyFactory.newKeyInfo(Collections.singletonList(domKeyInfo), "KI");
        XMLSignature signature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo, null, "SIG", null);
        signContext.setBaseURI("");
        signature.sign(signContext);
    }

    private void outputSOAPMessageToFile(SOAPMessage soapMessage) throws SOAPException, IOException {
        File outputFile = new File("/home/felipe/xmls/output.xml");
        FileOutputStream fos = new FileOutputStream(outputFile);
        soapMessage.writeTo((OutputStream)fos);
        fos.close();
        System.out.println("Archivo escrito");
    }

    private void callTheWebServiceFromFile() throws IOException, SOAPException {
        File soapFile = new File("/home/felipe/xmls/output.soap");
        FileInputStream fis = new FileInputStream(soapFile);
        StreamSource ss = new StreamSource(fis);
        SOAPMessage msg = MessageFactory.newInstance().createMessage();
        SOAPPart soapPart = msg.getSOAPPart();
        soapPart.setContent((Source)ss);
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection soapConnection = soapConnectionFactory.createConnection();
        String soapEndpointUrl = "https://softwaretest.ros.ie/paye-employers/v1/soap";
        SOAPMessage resp = soapConnection.call(msg, (Object)soapEndpointUrl);
        resp.writeTo((OutputStream)System.out);
        fis.close();
        soapConnection.close();
    }
}

