/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.misc.settings.ServerConfigFileHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import nl.captcha.servlet.SimpleCaptchaServlet;
import org.apache.http.HttpVersion;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.eclipse.jetty.apache.jsp.JettyJasperInitializer;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.Configuration;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import server.SpringConfig;
import server.webserver.felectronica.AuthFElectronica;
import server.webserver.felectronica.JSONAnnullCreditNote;
import server.webserver.felectronica.JSONCloseConnection;
import server.webserver.felectronica.JSONDebitNote;
import server.webserver.felectronica.JSONInvoice;
import server.webserver.felectronica.JSONReturnCreditNote;
import server.webserver.felectronica.JSONUnlockElectronicDocument;
import server.webserver.marketplace.mercadolibre.MercadolibreAuthCode;
import server.webserver.marketplace.mercadolibre.NotifyMercadolibre;
import server.webserver.marketplace.mercadolibre.SendMercadolibreCode;
import server.webserver.servlets.felectronica.ChangePasswordServlet;
import server.webserver.servlets.felectronica.DownloadCertificateServlet;
import server.webserver.servlets.felectronica.DownloadEfacturaWithDatesServlet;
import server.webserver.servlets.felectronica.DownloadEfacturaWithNumberServlet;
import server.webserver.servlets.felectronica.DownloadEfacturaZipServlet;
import server.webserver.servlets.felectronica.GetResponseDianXML;
import server.webserver.servlets.felectronica.GetXMLDocumentServlet;
import server.webserver.servlets.felectronica.ListObjectInvoiceServlet;
import server.webserver.servlets.felectronica.LogInServlet;
import server.webserver.servlets.felectronica.MailLogoServlet;
import server.webserver.servlets.felectronica.ObjectEfacturaServlet;
import server.webserver.servlets.felectronica.RecoverPasswordServlet;
import server.webserver.servlets.felectronica.UserRegisterServlet;

public class WebServer
implements Runnable {
    private static final String WEBROOT_INDEX = "/webroot/";
    private Server server;

    @Override
    public void run() {
        try {
            ServerConnector https = null;
            if (ServerConfigFileHandler.getHttpsCert() != null) {
                this.server = new Server();
                HttpConfiguration http_config = new HttpConfiguration();
                http_config.setSecureScheme("https");
                http_config.setSecurePort(ServerConfigFileHandler.getWebPort());
                http_config.setOutputBufferSize(32768);
                SslContextFactory sslContextFactory = new SslContextFactory();
                sslContextFactory.setKeyStoreType("PKCS12");
                sslContextFactory.setKeyStorePath(ServerConfigFileHandler.getHttpsCert());
                sslContextFactory.setKeyStorePassword(ServerConfigFileHandler.getHttpsPassword());
                sslContextFactory.setKeyManagerPassword(ServerConfigFileHandler.getHttpsPassword());
                HttpConfiguration https_config = new HttpConfiguration(http_config);
                SecureRequestCustomizer src = new SecureRequestCustomizer();
                src.setStsMaxAge(2000L);
                src.setStsIncludeSubDomains(true);
                https_config.addCustomizer((HttpConfiguration.Customizer)src);
                https = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.toString()), new HttpConnectionFactory(https_config)});
                https.setPort(ServerConfigFileHandler.getWebPort());
                https.setIdleTimeout(500000L);
            } else {
                this.server = new Server(ServerConfigFileHandler.getWebPort());
            }
            System.out.println("puerto jetty: " + ServerConfigFileHandler.getWebPort());
            Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)this.server);
            classlist.addBefore("org.eclipse.jetty.webapp.JettyWebXmlConfiguration", new String[]{"org.eclipse.jetty.annotations.AnnotationConfiguration"});
            URI baseUri = this.getWebRootResourceUri();
            System.out.println("Base URI: " + baseUri);
            ServletContextHandler servletJerseyContextHandler = new ServletContextHandler(0);
            servletJerseyContextHandler.setContextPath("/api");
            List webservices = ServerConfigFileHandler.getWebservices();
            if (webservices != null) {
                servletJerseyContextHandler.addEventListener((EventListener)new ContextLoaderListener(WebServer.getWac()));
                ResourceConfig config = new ResourceConfig().packages(new String[]{(String)webservices.get(0)});
                ServletHolder jerseyServlet = new ServletHolder((Servlet)new ServletContainer(config));
                jerseyServlet.setInitOrder(0);
                servletJerseyContextHandler.addServlet(jerseyServlet, "/*");
            }
            ServletContextHandler servletContextHandler = new ServletContextHandler(1);
            servletContextHandler.setContextPath("/");
            servletContextHandler.setResourceBase(baseUri.toASCIIString());
            this.enableEmbeddedJspSupport(servletContextHandler);
            SimpleCaptchaServlet scaptcha = new SimpleCaptchaServlet();
            servletContextHandler.addServlet(new ServletHolder((Servlet)scaptcha), "/sc/simpleImg");
            LogInServlet login = new LogInServlet(ServerConfigFileHandler.getDbWeb());
            servletContextHandler.addServlet(new ServletHolder((Servlet)login), "/LogInServlet");
            UserRegisterServlet registro = new UserRegisterServlet(ServerConfigFileHandler.getDbWeb());
            servletContextHandler.addServlet(new ServletHolder((Servlet)registro), "/RegisterServlet");
            ListObjectInvoiceServlet objectInvoice = new ListObjectInvoiceServlet(ServerConfigFileHandler.getDbWeb());
            servletContextHandler.addServlet(new ServletHolder((Servlet)objectInvoice), "/ListObjectInvoiceServlet");
            DownloadEfacturaWithNumberServlet downloadEfacturaNumber = new DownloadEfacturaWithNumberServlet(ServerConfigFileHandler.getDbWeb());
            servletContextHandler.addServlet(new ServletHolder((Servlet)downloadEfacturaNumber), "/DownloadEfacturaWithNumber");
            DownloadEfacturaWithDatesServlet downloadEfacturaDates = new DownloadEfacturaWithDatesServlet(ServerConfigFileHandler.getDbWeb());
            servletContextHandler.addServlet(new ServletHolder((Servlet)downloadEfacturaDates), "/DownloadEfacturaWithDates");
            DownloadEfacturaZipServlet downloadEfacturaZip = new DownloadEfacturaZipServlet(ServerConfigFileHandler.getDbWeb());
            servletContextHandler.addServlet(new ServletHolder((Servlet)downloadEfacturaZip), "/DownloadEfacturaZip");
            ChangePasswordServlet changePass = new ChangePasswordServlet(ServerConfigFileHandler.getDbWeb());
            servletContextHandler.addServlet(new ServletHolder((Servlet)changePass), "/ChangePassword");
            DownloadCertificateServlet downloadCertificate = new DownloadCertificateServlet(ServerConfigFileHandler.getDbWeb());
            servletContextHandler.addServlet(new ServletHolder((Servlet)downloadCertificate), "/DownloadCertificate");
            RecoverPasswordServlet recoverPassword = new RecoverPasswordServlet(ServerConfigFileHandler.getDbWeb());
            servletContextHandler.addServlet(new ServletHolder((Servlet)recoverPassword), "/RecoverPassword");
            ObjectEfacturaServlet objectEfactura = new ObjectEfacturaServlet(ServerConfigFileHandler.getDbWeb());
            servletContextHandler.addServlet(new ServletHolder((Servlet)objectEfactura), "/ObjectEfactura");
            MailLogoServlet mailLogoServlet = new MailLogoServlet(ServerConfigFileHandler.getDbWeb());
            servletContextHandler.addServlet(new ServletHolder((Servlet)mailLogoServlet), "/images/*");
            MercadolibreAuthCode mercadolibreAuthCode = new MercadolibreAuthCode();
            servletContextHandler.addServlet(new ServletHolder((Servlet)mercadolibreAuthCode), "/mercadolibreAuthCode");
            SendMercadolibreCode sendMercadolibreCode = new SendMercadolibreCode(ServerConfigFileHandler.getDbWeb());
            servletContextHandler.addServlet(new ServletHolder((Servlet)sendMercadolibreCode), "/sendMercadolibreCode");
            NotifyMercadolibre notifyMercadolibre = new NotifyMercadolibre();
            servletContextHandler.addServlet(new ServletHolder((Servlet)notifyMercadolibre), "/notifyMercadolibre");
            ServletHolder holderDefault = new ServletHolder("default", DefaultServlet.class);
            holderDefault.setInitParameter("resourceBase", baseUri.toASCIIString());
            holderDefault.setInitParameter("dirAllowed", "true");
            servletContextHandler.addServlet(holderDefault, "/");
            AuthFElectronica authFElectronica = new AuthFElectronica();
            servletContextHandler.addServlet(new ServletHolder((Servlet)authFElectronica), "/emaku/auth");
            JSONInvoice jsonInvoice = new JSONInvoice();
            servletContextHandler.addServlet(new ServletHolder((Servlet)jsonInvoice), "/emaku/setInvoice");
            JSONCloseConnection jsonClose = new JSONCloseConnection();
            servletContextHandler.addServlet(new ServletHolder((Servlet)jsonClose), "/emaku/closeConnection");
            JSONAnnullCreditNote jsonAnnull = new JSONAnnullCreditNote();
            servletContextHandler.addServlet(new ServletHolder((Servlet)jsonAnnull), "/emaku/annullCreditNote");
            JSONReturnCreditNote jsonReturnCreditNote = new JSONReturnCreditNote();
            servletContextHandler.addServlet(new ServletHolder((Servlet)jsonReturnCreditNote), "/emaku/returnCreditNote");
            JSONDebitNote jsonDebitNote = new JSONDebitNote();
            servletContextHandler.addServlet(new ServletHolder((Servlet)jsonDebitNote), "/emaku/debitNote");
            GetXMLDocumentServlet getXMLDocumentServlet = new GetXMLDocumentServlet();
            servletContextHandler.addServlet(new ServletHolder((Servlet)getXMLDocumentServlet), "/xml/*");
            GetResponseDianXML getResponseDian = new GetResponseDianXML();
            servletContextHandler.addServlet(new ServletHolder((Servlet)getResponseDian), "/responsedian/*");
            JSONUnlockElectronicDocument unlockDoc = new JSONUnlockElectronicDocument();
            servletContextHandler.addServlet(new ServletHolder((Servlet)unlockDoc), "/emaku/unlockDocument");
            HandlerCollection handlerCollection = new HandlerCollection();
            if (webservices != null) {
                handlerCollection.addHandler((Handler)servletJerseyContextHandler);
            }
            handlerCollection.addHandler((Handler)servletContextHandler);
            this.server.setHandler((Handler)handlerCollection);
            if (ServerConfigFileHandler.getHttpsCert() != null) {
                this.server.setConnectors(new Connector[]{https});
            }
            System.out.println("jetty iniciado...");
            this.server.start();
            this.server.join();
        }
        catch (FileNotFoundException FNFEe) {
            FNFEe.printStackTrace();
        }
        catch (URISyntaxException URISEe) {
            URISEe.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static WebApplicationContext getWac() {
        AnnotationConfigWebApplicationContext wac = new AnnotationConfigWebApplicationContext();
        wac.register(new Class[]{SpringConfig.class});
        return wac;
    }

    private void enableEmbeddedJspSupport(ServletContextHandler servletContextHandler) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File scratchDir = new File(tempDir.toString(), "embedded-jetty-jsp");
        if (!scratchDir.exists() && !scratchDir.mkdirs()) {
            throw new IOException("Unable to create scratch directory: " + scratchDir);
        }
        servletContextHandler.setAttribute("javax.servlet.context.tempdir", (Object)scratchDir);
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        servletContextHandler.setClassLoader((ClassLoader)jspClassLoader);
        servletContextHandler.addBean((Object)new JspStarter(servletContextHandler));
        ServletHolder holderJsp = new ServletHolder("jsp", JettyJspServlet.class);
        holderJsp.setInitOrder(0);
        holderJsp.setInitParameter("logVerbosityLevel", "DEBUG");
        holderJsp.setInitParameter("fork", "false");
        holderJsp.setInitParameter("xpoweredBy", "false");
        holderJsp.setInitParameter("compilerTargetVM", "1.8");
        holderJsp.setInitParameter("compilerSourceVM", "1.8");
        holderJsp.setInitParameter("keepgenerated", "true");
        servletContextHandler.addServlet(holderJsp, "*.jsp");
    }

    private URI getWebRootResourceUri() throws FileNotFoundException, URISyntaxException {
        URL indexUri = this.getClass().getResource(WEBROOT_INDEX);
        URL rootUri = this.getClass().getResource("/server/");
        System.out.println("rootUri: " + rootUri.toURI());
        if (indexUri == null) {
            throw new FileNotFoundException("No puedo encontrar el recurso /webroot/");
        }
        return indexUri.toURI();
    }

    public static class JspStarter
    extends AbstractLifeCycle
    implements ServletContextHandler.ServletContainerInitializerCaller {
        JettyJasperInitializer sci = new JettyJasperInitializer();
        ServletContextHandler context;

        public JspStarter(ServletContextHandler context) {
            this.context = context;
            this.context.setAttribute("org.apache.tomcat.JarScanner", (Object)new StandardJarScanner());
        }

        protected void doStart() throws Exception {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.context.getClassLoader());
            try {
                this.sci.onStartup(null, (ServletContext)this.context.getServletContext());
                super.doStart();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }
}

