/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.businessrules.LNErrorProcecuteException;
import server.businessrules.LNInventarios;
import server.database.sql.ComboProductos;
import server.database.sql.LinkingCache;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNComboInventarios
extends LNInventarios {
    private String bd;

    public LNComboInventarios(Element parameters, String bd) {
        super(parameters, bd);
        this.bd = bd;
    }

    @Override
    public void movimientos(Element pack) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, InterruptedException {
        super.movimientos(pack);
        System.out.println("-------------");
        try {
            XMLOutputter xmlOutputter = new XMLOutputter();
            xmlOutputter.setFormat(Format.getPrettyFormat());
            xmlOutputter.output(pack, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String idProducto = null;
        double cantidad = 0.0;
        String vunitario = null;
        Object bodegaSaliente = null;
        for (Element field : pack.getChildren()) {
            String nameField = field.getAttributeValue("name");
            if ("idProducto".equals(nameField)) {
                idProducto = field.getValue();
            }
            if ("cantidad".equals(nameField)) {
                cantidad = Double.parseDouble(field.getValue());
            }
            if (!"vunitario".equals(nameField)) continue;
            vunitario = field.getValue();
        }
        System.out.println("-------------------------");
        System.out.println("ancheta: " + idProducto);
        ArrayList<ComboProductos> combos = LinkingCache.getComboProductos(this.bd, idProducto);
        if (combos != null) {
            for (ComboProductos cb : combos) {
                Element comboPack = new Element("subPackage");
                Element fieldProd = new Element("field");
                fieldProd.setAttribute("name", "idProducto");
                fieldProd.setText(String.valueOf(cb.getIdProdServ()));
                comboPack.addContent((Content)fieldProd);
                System.out.println("producto: " + cb.getIdProdServ());
                Element fieldCant = new Element("field");
                fieldCant.setAttribute("name", "cantidad");
                System.out.println("cantidad combo: " + cb.getCantidad() + " cantidad prod: " + cantidad);
                fieldCant.setText(String.valueOf((double)cb.getCantidad() * cantidad));
                comboPack.addContent((Content)fieldCant);
                Element fieldVunit = new Element("field");
                fieldVunit.setAttribute("name", "vunitario");
                fieldVunit.setText(vunitario);
                comboPack.addContent((Content)fieldVunit);
                super.movimientos(comboPack);
            }
        }
    }

    @Override
    public void traslados(Element pack) throws LNErrorProcecuteException, SQLBadArgumentsException, SQLBadArgumentsException, SQLNotFoundException, SQLException {
    }
}

