/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import common.comunications.InfoSocket;
import common.misc.language.Language;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.businessrules.RunTransaction;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNGenericSQL {
    private Element pack;
    private QueryRunner RQtransaction;
    private String[] args;
    private boolean keyfield;
    private boolean finalKey;
    private boolean generable = true;
    private boolean discardBadArgument = false;
    private Map<String, String> keyvalue;
    private boolean saveImage;

    public boolean isSaveImage() {
        return this.saveImage;
    }

    public void setSaveImage(boolean saveImage) {
        this.saveImage = saveImage;
    }

    public LNGenericSQL(SocketChannel sock) {
        this.keyvalue = new LinkedHashMap<String, String>();
        this.RQtransaction = new QueryRunner(InfoSocket.getBd((SocketChannel)sock));
    }

    public LNGenericSQL(String bd) {
        this.keyvalue = new LinkedHashMap<String, String>();
        this.RQtransaction = new QueryRunner(bd);
    }

    public LNGenericSQL(SocketChannel sock, Document doc, Element sn_pack, String id_transaction) {
        this.pack = (Element)sn_pack.getChildren().iterator().next();
        this.keyvalue = new LinkedHashMap<String, String>();
        Iterator i = doc.getRootElement().getChildren().iterator();
        this.RQtransaction = new QueryRunner(InfoSocket.getBd((SocketChannel)sock));
        this.compactarArgumentos();
        this.setSimpleAutoCommit(false);
        try {
            while (i.hasNext()) {
                Element elm = (Element)i.next();
                if ("discardBadArguments".equals(elm.getAttributeValue("attribute"))) {
                    this.discardBadArgument = true;
                }
                this.generarSimpleConnection(elm.getValue());
            }
            this.simpleCommit();
            RunTransaction.successMessage(sock, id_transaction, Language.getWord((String)"TRANSACTION_OK"));
        }
        catch (SQLNotFoundException SQLNFEe) {
            RunTransaction.errorMessage(sock, id_transaction, SQLNFEe.getMessage());
            this.simpleRollback();
        }
        catch (SQLBadArgumentsException SQLBAEe) {
            RunTransaction.errorMessage(sock, id_transaction, SQLBAEe.getMessage());
            this.simpleRollback();
        }
        catch (SQLException SQLe) {
            RunTransaction.errorMessage(sock, id_transaction, SQLe.getMessage());
            this.simpleRollback();
        }
        catch (NullPointerException NPEe) {
            NPEe.printStackTrace();
            this.simpleRollback();
        }
        this.setSimpleAutoCommit(true);
    }

    private void compactarArgumentos() {
        Iterator<String> val2;
        XMLOutputter out = new XMLOutputter();
        out.setFormat(Format.getPrettyFormat());
        try {
            out.output(this.pack, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List lista = this.pack.getChildren();
        Iterator iterador = lista.iterator();
        int countParams = this.pack.getContentSize();
        Element Efirst = (Element)iterador.next();
        String SvalueFirst = Efirst.getValue().trim();
        String SattributeFirst = Efirst.getAttributeValue("attribute");
        String SattributeName = Efirst.getAttributeValue("name");
        if (Efirst.getAttributeValue("nameField") != null && !"".equals(Efirst.getAttributeValue("nameField"))) {
            SattributeName = Efirst.getAttributeValue("nameField");
        }
        if ("".equals(SvalueFirst)) {
            countParams = 0;
        }
        if ("disableKey".equals(SattributeFirst)) {
            this.keyfield = false;
        } else if ("enableKey".equals(SattributeFirst)) {
            this.keyfield = true;
        }
        int j = 0;
        if (this.keyfield) {
            this.args = new String[countParams + this.keyvalue.size()];
            if (!"finalKey".equals(SattributeFirst)) {
                val2 = this.keyvalue.values().iterator();
                while (val2.hasNext()) {
                    this.args[j] = val2.next();
                    ++j;
                }
            } else {
                this.finalKey = true;
            }
        } else {
            this.args = new String[countParams];
        }
        if ("key".equals(SattributeFirst)) {
            this.keyfield = true;
            if (SattributeName == null) {
                SattributeName = new String("");
            }
            this.keyvalue.put(SattributeName, SvalueFirst);
        }
        if (countParams > 0) {
            this.args[j] = SvalueFirst;
        }
        ++j;
        while (iterador.hasNext()) {
            this.pack = (Element)iterador.next();
            if (this.pack.getName().equals("field")) {
                this.args[j] = !this.pack.getValue().equals("") ? this.pack.getValue() : (this.pack.getAttributeValue("attribute") != null && "NULL".equals(this.pack.getAttributeValue("attribute")) ? "NULL" : "");
                try {
                    if ("key".equals(this.pack.getAttribute("attribute").getValue())) {
                        this.keyfield = true;
                        if (SattributeName == null) {
                            SattributeName = new String("");
                        }
                        this.keyvalue.put(SattributeName, this.args[j]);
                    }
                }
                catch (NullPointerException val2) {
                    // empty catch block
                }
            }
            ++j;
        }
        if (this.finalKey) {
            val2 = this.keyvalue.values().iterator();
            int i = 0;
            while (val2.hasNext()) {
                this.args[j] = val2.next();
                ++i;
                ++j;
            }
            this.finalKey = false;
        }
    }

    public void generarSimpleConnection(String sql) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        if (this.generable) {
            try {
                this.RQtransaction.ejecutarSimpleSQL(sql, this.args);
            }
            catch (SQLBadArgumentsException SQLBAEe) {
                if (!this.discardBadArgument) {
                    throw new SQLBadArgumentsException(sql);
                }
                this.discardBadArgument = false;
            }
        }
    }

    public void generarTransacConnection(String sql) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        System.out.println("generable: " + this.generable);
        if (this.generable) {
            try {
                this.RQtransaction.ejecutarTransacSQL(sql, this.args);
            }
            catch (SQLBadArgumentsException SQLBAEe) {
                if (!this.discardBadArgument) {
                    throw new SQLBadArgumentsException(sql);
                }
                this.discardBadArgument = false;
            }
        }
    }

    public void setArgs(Element pack) {
        this.pack = pack;
        this.compactarArgumentos();
    }

    public void setArgs(Element pack, String id_transaction) {
        this.pack = pack;
        this.compactarArgumentos();
    }

    public void setArgs(String[] argUpdate, String id_transaction) {
        this.args = argUpdate;
    }

    public void removeAllKeys() {
        this.keyvalue.clear();
    }

    public String getKey(int index) {
        try {
            Vector<String> vector = new Vector<String>(this.keyvalue.values());
            return vector.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public void removeKey(String key) {
        this.keyvalue.remove(key);
    }

    public void setKey(String key, String value) {
        this.keyvalue.put(key, value);
        this.keyfield = true;
    }

    public Map getKeys() {
        return this.keyvalue;
    }

    public String getArg(int index) {
        return this.args[index];
    }

    public void setAutoCommit(boolean value) {
        this.RQtransaction.setAutoCommit(value);
    }

    public void setSimpleAutoCommit(boolean value) {
        this.RQtransaction.setSimpleAutoCommit(value);
    }

    public boolean getAutoCommit(String bd) throws SQLException {
        return this.RQtransaction.isAutoCommit(bd);
    }

    public void commit() {
        System.out.println("++++++++++++++++++++++++++++++++++++Generando commit");
        this.RQtransaction.commit();
    }

    public void simpleCommit() {
        System.out.println("++++++++++++++++++++++++++++++++++++Generando commit");
        this.RQtransaction.simpleCommit();
    }

    public void rollback() {
        System.out.println("++++++++++++++++++++++++++++++++++++Generando rollback de transaccion");
        this.RQtransaction.rollback();
    }

    public void simpleRollback() {
        System.out.println("++++++++++++++++++++++++++++++++++++Generando rollback de transaccion");
        this.RQtransaction.simpleRollback();
    }

    public boolean isGenerable() {
        return this.generable;
    }

    public void setGenerable(boolean generable) {
        this.generable = generable;
    }

    public void setDiscardBadArgument(boolean discardBadArgument) {
        this.discardBadArgument = discardBadArgument;
    }
}

