/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import common.comunications.InfoSocket;
import common.misc.ZipHandler;
import common.misc.language.Language;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jdom.Document;
import org.jdom.Element;
import server.businessrules.CacheKeys;
import server.businessrules.LNGenericSQL;
import server.businessrules.RunTransaction;
import server.database.sql.LinkingCache;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNMultiPackage {
    private String idTransaction;
    private LNGenericSQL LNGtransaccion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LNMultiPackage(SocketChannel sock, Document doc, Element pack, String idTransaction) {
        this.idTransaction = idTransaction;
        Iterator i = doc.getRootElement().getChildren().iterator();
        Iterator j = pack.getChildren().iterator();
        this.LNGtransaccion = new LNGenericSQL(sock);
        this.LNGtransaccion.setSimpleAutoCommit(false);
        try {
            try {
                while (i.hasNext()) {
                    Element sql = (Element)i.next();
                    Element subpackage = (Element)j.next();
                    try {
                        if (sql.getName().equals("arg")) {
                            if ("addKey".equals(sql.getAttributeValue("attribute"))) {
                                this.LNGtransaccion.setGenerable(false);
                            } else if ("removeKey".equals(sql.getAttributeValue("attribute"))) {
                                this.LNGtransaccion.removeKey(sql.getValue());
                                CacheKeys.removeKey(sql.getValue());
                                this.LNGtransaccion.setGenerable(false);
                            } else if ("saveImage".equals(sql.getAttributeValue("attribute"))) {
                                this.LNGtransaccion.setGenerable(true);
                                this.LNGtransaccion.setSaveImage(true);
                            } else {
                                this.LNGtransaccion.setGenerable(true);
                            }
                        }
                        if (((Element)subpackage.getChildren().iterator().next()).getName().equals("field")) {
                            this.getSimpleTransaction(sql.getValue(), subpackage);
                            continue;
                        }
                        this.getfields(sql.getValue(), subpackage);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                    }
                }
                this.LNGtransaccion.simpleCommit();
                RunTransaction.successMessage(sock, idTransaction, Language.getWord((String)"TRANSACTION_OK"));
                doc = null;
                pack = null;
            }
            catch (SQLNotFoundException SQLNFEe) {
                RunTransaction.errorMessage(sock, idTransaction, SQLNFEe.getMessage());
                this.LNGtransaccion.simpleRollback();
                doc = null;
                pack = null;
            }
            catch (SQLBadArgumentsException SQLBAEe) {
                RunTransaction.errorMessage(sock, idTransaction, SQLBAEe.getMessage());
                this.LNGtransaccion.simpleRollback();
                doc = null;
                pack = null;
            }
            catch (SQLException SQLe) {
                RunTransaction.errorMessage(sock, idTransaction, SQLe.getMessage());
                this.LNGtransaccion.simpleRollback();
                doc = null;
                pack = null;
            }
            catch (NullPointerException NPEe) {
                NPEe.printStackTrace();
                this.LNGtransaccion.simpleRollback();
                doc = null;
                pack = null;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.LNGtransaccion.simpleRollback();
                doc = null;
                pack = null;
            }
        }
        catch (Throwable throwable) {
            doc = null;
            pack = null;
            throw throwable;
        }
        LinkingCache.reloadCombo(InfoSocket.getBd((SocketChannel)sock));
        this.LNGtransaccion.setAutoCommit(true);
        this.LNGtransaccion = null;
        System.gc();
    }

    private void getfields(String sql, Element pack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException, IOException {
        for (Element subpackage : pack.getChildren()) {
            this.getSimpleTransaction(sql, subpackage);
        }
    }

    private void getSimpleTransaction(String sql, Element pack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException, IOException {
        System.out.println("Sentencia: " + sql);
        this.LNGtransaccion.setArgs(pack, this.idTransaction);
        this.LNGtransaccion.generarSimpleConnection(sql);
        if (this.LNGtransaccion.isSaveImage()) {
            List l = pack.getChildren();
            String fileName = ((Element)l.get(0)).getValue();
            ZipHandler zip = new ZipHandler();
            byte[] bytesImage = null;
            try {
                bytesImage = zip.getDataDecode(((Element)l.get(1)).getValue());
            }
            catch (NullPointerException e) {
                fileName = ((Element)l.get(2)).getValue();
                System.out.println("nombre: " + fileName);
                bytesImage = zip.getDataDecode(((Element)l.get(3)).getValue());
            }
            String sdir = this.LNGtransaccion.getKey(0);
            String path = null;
            path = sdir != null ? "/home/emaku/images/" + sdir : "/home/emaku/images/";
            File directory = new File(path);
            if (!directory.exists()) {
                directory.mkdirs();
                System.out.println("El directorio no existe, creando directorio");
            } else {
                System.out.println("directorio existente, guardando foto");
            }
            File fileImage = new File(path + "/" + fileName);
            FileOutputStream fos = new FileOutputStream(fileImage);
            fos.write(bytesImage);
            fos.flush();
            fos.close();
        }
    }
}

