/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import common.comunications.InfoSocket;
import common.misc.language.Language;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import server.businessrules.LNGenericSQL;
import server.businessrules.RunTransaction;
import server.database.sql.LinkingCache;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNUserAdministrator {
    private LNGenericSQL LNGtransaccion;
    private SocketChannel sock;
    private String idTransaction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LNUserAdministrator(SocketChannel sock, Document doc, Element pack, String idTransaction) {
        this.sock = sock;
        this.idTransaction = idTransaction;
        String action = ((Element)doc.getRootElement().getChildren().iterator().next()).getValue();
        Element subpack = (Element)pack.getChildren().iterator().next();
        this.LNGtransaccion = new LNGenericSQL(sock);
        this.LNGtransaccion.setAutoCommit(false);
        try {
            if (action != null) {
                if (action.equals("addUser")) {
                    this.addUser(subpack);
                } else if (action.equals("removeUser")) {
                    this.removeUser(subpack);
                }
            }
            this.LNGtransaccion.simpleCommit();
            RunTransaction.successMessage(sock, idTransaction, Language.getWord((String)"TRANSACTION_OK"));
        }
        catch (SQLNotFoundException SQLNFEe) {
            RunTransaction.errorMessage(sock, idTransaction, SQLNFEe.getMessage());
            this.LNGtransaccion.simpleRollback();
        }
        catch (SQLBadArgumentsException SQLBAEe) {
            RunTransaction.errorMessage(sock, idTransaction, SQLBAEe.getMessage());
            this.LNGtransaccion.simpleRollback();
        }
        catch (SQLException SQLe) {
            RunTransaction.errorMessage(sock, idTransaction, SQLe.getMessage());
            this.LNGtransaccion.simpleRollback();
        }
        catch (NullPointerException NPEe) {
            NPEe.printStackTrace();
            this.LNGtransaccion.simpleRollback();
        }
        finally {
            doc = null;
            pack = null;
        }
        this.LNGtransaccion.setAutoCommit(true);
        this.LNGtransaccion = null;
        System.gc();
    }

    private void addUser(Element subpack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        this.LNGtransaccion.setArgs(subpack, this.idTransaction);
        this.LNGtransaccion.generarSimpleConnection("SCI0019");
        this.LNGtransaccion.setArgs(subpack, this.idTransaction);
        this.LNGtransaccion.generarSimpleConnection("SCI0018");
        List j = subpack.getChildren();
        String login = ((Element)j.get(1)).getValue();
        LinkingCache.setPermisosSQL(InfoSocket.getBd((SocketChannel)this.sock), login);
    }

    private void removeUser(Element subpack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        this.LNGtransaccion.setArgs(subpack, this.idTransaction);
        this.LNGtransaccion.generarSimpleConnection("SCD000000");
        this.LNGtransaccion.setArgs(subpack, this.idTransaction);
        this.LNGtransaccion.generarSimpleConnection("SCD000000");
        List j = subpack.getChildren();
        String login = ((Element)j.get(0)).getValue();
    }
}

