/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules.electronicdocuments;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.KeyStoreException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.transform.TransformerException;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.ItemIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.ItemPropertyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PowerOfAttorneyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PricingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.ResponseType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.TaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.BaseQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.BaseUnitMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.CreditNoteTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.CreditedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.CustomizationIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.DocumentCurrencyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IssueDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IssueTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.LineCountNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PackSizeNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PaymentDueDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PaymentMeansCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PerUnitAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PercentType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PriceAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PriceTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ProfileExecutionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ProfileIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ReferenceIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ResponseCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.RoundingAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.TaxAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.TaxEvidenceIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.TaxableAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.UBLVersionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.UUIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ValueType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_2.UBLExtensionsType;
import oasis.names.specification.ubl.schema.xsd.creditnote_2.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.creditnote_2.ObjectFactory;
import org.jdom.Content;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import server.businessrules.CacheKeys;
import server.businessrules.LNDocuments;
import server.businessrules.electronicdocuments.Crypto;
import server.businessrules.electronicdocuments.DescargaDocumentos;
import server.businessrules.electronicdocuments.ElementsForSigned;
import server.businessrules.electronicdocuments.HeadersNote;
import server.businessrules.electronicdocuments.InfoCliente;
import server.businessrules.electronicdocuments.InfoEmpresa;
import server.businessrules.electronicdocuments.MonetaryTotal;
import server.businessrules.electronicdocuments.PrintXML;
import server.businessrules.electronicdocuments.SaveCUFE;
import server.businessrules.electronicdocuments.SendDianException;
import server.businessrules.electronicdocuments.SignedDocument;
import server.businessrules.electronicdocuments.UtilsXML;
import server.database.connection.ConnectionsPool;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class ReturnCreditNote {
    private static final int ELECTRONIC_INVOICE = 1;
    private static final int DEBIT_NOTE = 2;
    private static final int CREDIT_NOTE = 3;
    private static final int ANNUL_INVOICE_CREDIT_NOTE = 4;
    private static final int RETURN_INVOICE = 5;
    private static final int OBJECT_INVOICE_CREDIT_NOTE = 6;
    private static final int CONTINGENCY_INVOICE = 7;
    private static final int AMBIENTE_HABILITACION = 2;
    private static final int AMBIENTE_PRODUCCION = 1;
    private final int TIPO_CONTADO = 1;
    private final int TIPO_CREDITO = 2;
    private final int PAGO_EFECTIVO = 10;
    private final int PAGO_TDEBITO = 49;
    private final int PAGO_TCREDITO = 48;
    private final int PAGO_CONSIGNACION = 42;
    private final int PAGO_CHEQUE = 20;
    private final int PAGO_TRANSFERENCIA = 47;
    private final int PAGO_CREDITO = 30;
    private String _MONEDA = "COP";
    private int type_document;
    private Date date;
    private Hashtable<String, String> cliente;
    private Hashtable<String, Double> vtotales = new Hashtable();
    private Hashtable<String, TaxTotal> taxTotal = new Hashtable();
    private String fecfac;
    private Connection conn;
    private String idTransaction;
    private String gTimeFormatted;
    private String pin;
    private String idUsuario;
    private String id_registro_software;
    private String id_software_dian;
    private int id_tipo_ambiente;
    private String urlAmbiente;
    private String codigoOR;
    private String descripcionOR;
    private String ndocument_db;
    private String consecutivenc;
    private String CUDE;
    private String bd;
    private String conceptObject;
    private String codigo_tipo;
    private String consecutive;
    private double totalRet;
    private double totalINCBolsa;

    public ReturnCreditNote(String bd, String idTransaction, int type_document, Date date, String codigo_tipo, String consecutive, String idUsuario) {
        this.bd = bd;
        this.idTransaction = idTransaction;
        this.date = date;
        this.type_document = type_document;
        this.codigo_tipo = codigo_tipo;
        this.consecutive = consecutive;
        this.idUsuario = idUsuario;
        this.conn = ConnectionsPool.getConnection(bd);
    }

    public void makeDocument() throws KeyStoreException, UnsupportedOperationException, JAXBException, SQLException, SQLNotFoundException, SQLBadArgumentsException, ParserConfigurationException, TransformerException, IOException, DatatypeConfigurationException, SOAPException, SendDianException, Exception {
        Calendar calendar = Calendar.getInstance();
        long init = calendar.getTimeInMillis();
        CreditNoteType creditNoteType = new CreditNoteType();
        UBLExtensionsType valueUBLExtensions = new UBLExtensionsType();
        IssueDateType creditNoteDate = new IssueDateType();
        String FORMATER = "yyyy-MM-dd";
        SimpleDateFormat format = new SimpleDateFormat(FORMATER);
        XMLGregorianCalendar gDateFormatted = DatatypeFactory.newInstance().newXMLGregorianCalendar(format.format(this.date));
        creditNoteDate.setValue(gDateFormatted);
        IssueTimeType creditNoteTime = new IssueTimeType();
        FORMATER = "HH:mm:ssXXX";
        format = new SimpleDateFormat(FORMATER);
        this.gTimeFormatted = format.format(this.date);
        creditNoteTime.setValue(this.gTimeFormatted);
        String ndocumento = LNDocuments.LNTransaction().getKey(0);
        System.out.println("idDocumento desde facturacion electroncia: " + this.codigo_tipo);
        System.out.println("consecutive desde facturacion electroncia: " + this.consecutive);
        InfoCliente infoCliente = new InfoCliente(this.bd, ndocumento);
        this.cliente = infoCliente.loadCliente();
        creditNoteType.getCreditNoteLine().addAll(this.listProductosCreditNote(ndocumento));
        LineCountNumericType lineCountNumeric = new LineCountNumericType();
        double articulos = this.vtotales.get("articulos");
        BigDecimal bdarticulos = new BigDecimal(articulos);
        bdarticulos = bdarticulos.setScale(0, RoundingMode.HALF_UP);
        lineCountNumeric.setValue(bdarticulos);
        creditNoteType.setLineCountNumeric(lineCountNumeric);
        creditNoteType.setLegalMonetaryTotal(MonetaryTotal.getTotales(this.vtotales, this._MONEDA));
        creditNoteType.getTaxTotal().addAll(this.totalIVAS());
        List<TaxTotalType> incBolsa = this.totalINCBolsa(LNDocuments.LNTransaction().getKey(0));
        if (incBolsa != null) {
            creditNoteType.getTaxTotal().addAll(incBolsa);
        }
        double vbase = this.vtotales.get("base");
        double vbaseex = this.vtotales.get("base_excluida") == null ? 0.0 : this.vtotales.get("base_excluida");
        double iva = this.vtotales.get("iva");
        BigDecimal bdiva = new BigDecimal(iva);
        bdiva = bdiva.setScale(2, RoundingMode.HALF_UP);
        System.out.println("iva: " + bdiva);
        double inc = this.vtotales.get("inc");
        BigDecimal bdinc = new BigDecimal(inc);
        bdinc = bdinc.setScale(2, RoundingMode.HALF_UP);
        System.out.println("inc: " + bdinc);
        double ica = this.vtotales.get("ica");
        BigDecimal bdica = new BigDecimal(ica);
        bdica = bdica.setScale(2, RoundingMode.HALF_UP);
        System.out.println("ica: " + bdica);
        double vtotal = this.vtotales.get("totalsinret");
        BigDecimal bdtotal = new BigDecimal(vtotal);
        bdtotal = bdtotal.setScale(2, RoundingMode.HALF_UP);
        BigDecimal bdbase = new BigDecimal(vbase + vbaseex);
        bdbase = bdbase.setScale(2, RoundingMode.HALF_UP);
        System.out.println("Base de devolucion: " + bdbase);
        SimpleDateFormat ft = new SimpleDateFormat("yyyyMMddHHmmss");
        this.fecfac = ft.format(this.date);
        QueryRunner RQdata3 = new QueryRunner(this.bd, "SCSDE0008");
        ResultSet RSdata3 = RQdata3.ejecutarMTSELECT(this.conn);
        RSdata3.next();
        this.pin = RSdata3.getString("pin");
        this.id_software_dian = RSdata3.getString("identificador_software_dian");
        this.id_tipo_ambiente = RSdata3.getInt("id_tipo_ambiente");
        this.urlAmbiente = RSdata3.getString("url_ambiente");
        this.codigoOR = RSdata3.getString("codigo_obligacion_responsabilidad");
        this.descripcionOR = RSdata3.getString("descripcion_obligacion_responsabilidad");
        this.id_registro_software = RSdata3.getString("id_registro_software");
        RSdata3.close();
        QueryRunner RQdata = null;
        ResultSet RSdata = null;
        IDType creditNoteID = new IDType();
        UUIDType creditNoteUUID = new UUIDType();
        creditNoteUUID.setSchemeName("CUDE-SHA384");
        creditNoteType.setUUID(creditNoteUUID);
        String prefijonc = null;
        this.ndocument_db = ndocumento;
        this.consecutivenc = this.codigo_tipo + this.consecutive;
        creditNoteID.setValue(this.codigo_tipo + this.consecutive);
        creditNoteType.setAccountingCustomerParty(infoCliente.getCliente(prefijonc));
        SimpleDateFormat ftcufe = new SimpleDateFormat("yyyy-MM-dd");
        String fechacufe = ftcufe.format(this.date);
        this.CUDE = this.consecutivenc + " " + fechacufe + " " + this.gTimeFormatted.toString() + " " + bdbase + " 01 " + bdiva + " 04 " + bdinc + " 03 " + bdica + " " + bdtotal + " " + LinkingCache.getNit(this.bd) + " " + this.cliente.get("nit") + " " + this.pin + " " + this.id_tipo_ambiente;
        System.out.println("CUDE: " + this.CUDE);
        this.CUDE = this.CUDE.replaceAll("\\s+", "");
        System.out.println("CUDE REPLACE: " + this.CUDE);
        NoteType notacufe = new NoteType();
        notacufe.setValue(this.CUDE);
        creditNoteType.getNote().add(notacufe);
        RQdata = new QueryRunner(this.bd, "SCSDE0005", new String[]{LNDocuments.LNTransaction().getKey(0)});
        RSdata = RQdata.ejecutarMTSELECT(this.conn);
        ArrayList<String> notes = new ArrayList<String>();
        if (RSdata.next()) {
            int i;
            String note = RSdata.getString("observacion");
            String tmp_note = "";
            for (i = 0; i < note.length(); ++i) {
                if (tmp_note.length() > 50 && tmp_note.substring(tmp_note.length() - 1, tmp_note.length()).equals(" ")) {
                    notes.add(tmp_note.substring(0, tmp_note.length() - 1));
                    tmp_note = "";
                }
                if (i >= note.length()) continue;
                tmp_note = tmp_note + note.substring(i, i + 1);
            }
            notes.add(tmp_note);
            for (i = 0; i < notes.size(); ++i) {
                NoteType nota = new NoteType();
                nota.setValue((String)notes.get(i));
                creditNoteType.getNote().add(nota);
            }
        }
        RSdata.close();
        this.CUDE = Crypto.toSha384(this.CUDE);
        System.out.println("Sha384: " + this.CUDE);
        creditNoteUUID.setSchemeID("" + this.id_tipo_ambiente);
        creditNoteUUID.setValue(this.CUDE);
        SimpleDateFormat ftqr = new SimpleDateFormat("yyyy-MM-dd");
        String fechaqr = ftqr.format(this.date);
        UBLVersionIDType ublVersion = new UBLVersionIDType();
        ublVersion.setValue("UBL 2.1");
        creditNoteType.setUBLVersionID(ublVersion);
        CustomizationIDType customId = new CustomizationIDType();
        customId.setValue("20");
        creditNoteType.setCustomizationID(customId);
        ProfileIDType versionDian = new ProfileIDType();
        versionDian.setValue("DIAN 2.1: Nota Cr\u00e9dito de Factura Electr\u00f3nica de Venta");
        creditNoteType.setProfileID(versionDian);
        creditNoteType.setUBLExtensions(valueUBLExtensions);
        ProfileExecutionIDType profileExcecutionID = new ProfileExecutionIDType();
        profileExcecutionID.setValue(String.valueOf(this.id_tipo_ambiente));
        creditNoteType.setProfileExecutionID(profileExcecutionID);
        CreditNoteTypeCodeType creditNoteTypeCode = new CreditNoteTypeCodeType();
        creditNoteTypeCode.setValue("91");
        creditNoteType.setCreditNoteTypeCode(creditNoteTypeCode);
        valueUBLExtensions.getUBLExtension().add(HeadersNote.getHeaders(this.bd, this.id_software_dian, this.pin, this.consecutivenc, this.cliente.get("nit"), fechaqr, bdtotal, this.CUDE));
        valueUBLExtensions.getUBLExtension().add(ElementsForSigned.getElement(this.date));
        creditNoteType.setID(creditNoteID);
        creditNoteType.setIssueDate(creditNoteDate);
        creditNoteType.setIssueTime(creditNoteTime);
        FORMATER = "yyyyMMddHHmmss";
        format = new SimpleDateFormat(FORMATER);
        this.fecfac = format.format(this.date);
        NoteType nota1 = new NoteType();
        nota1.setValue("Devolucion en venta");
        creditNoteType.getNote().add(nota1);
        DocumentCurrencyCodeType documentCurrency = new DocumentCurrencyCodeType();
        documentCurrency.setValue("COP");
        creditNoteType.setDocumentCurrencyCode(documentCurrency);
        ResponseType discrepancyResponse = new ResponseType();
        ReferenceIDType referenceID = new ReferenceIDType();
        DescriptionType descripcionResponse = new DescriptionType();
        discrepancyResponse.setReferenceID(referenceID);
        ResponseCodeType responseCode = new ResponseCodeType();
        responseCode.setListName("Devoluci\u00f3n de parte de los bienes; no aceptaci\u00f3n de partes del servicio");
        responseCode.setListSchemeURI("http://www.dian.gov.co/micrositios/fac_electronica/documentos/Anexo_Tecnico_001_Formatos_de_los_Documentos_XML_de_Facturacion_Electron.pdf");
        responseCode.setName("1:= Devoluci\u00f3n de parte de los bienes; no aceptaci\u00f3n de partes del servicio");
        responseCode.setValue("1");
        descripcionResponse.setValue("Devoluci\u00f3n en venta de factura electronica");
        discrepancyResponse.setResponseCode(responseCode);
        discrepancyResponse.getDescription().add(descripcionResponse);
        creditNoteType.getDiscrepancyResponse().add(discrepancyResponse);
        BillingReferenceType billingReference = new BillingReferenceType();
        DocumentReferenceType referenceDocument = new DocumentReferenceType();
        IDType idDocumentReference = new IDType();
        UUIDType uuidDocumentReference = new UUIDType();
        uuidDocumentReference.setSchemeName("CUFE-SHA384");
        String fecha_factura = null;
        RQdata = new QueryRunner(this.bd, "SCSDE0017", new String[]{this.codigo_tipo, this.consecutive});
        RSdata = RQdata.ejecutarMTSELECT(this.conn);
        String prefijo = "";
        String ndocumento_fe = null;
        if (RSdata.next()) {
            ndocumento_fe = RSdata.getString("ndocumento");
            fecha_factura = RSdata.getString("fecha");
            prefijo = RSdata.getString("prefijo");
            System.out.println("prefijo retornado por devolucion en venta: " + prefijo);
            if (prefijo == null) {
                prefijo = "";
            }
            creditNoteType.getPaymentMeans().addAll(this.formaPago(ndocumento_fe));
        }
        idDocumentReference.setSchemeName("Numero de la factura afectada");
        idDocumentReference.setValue(prefijo + RSdata.getString("numero"));
        String CUFE = RSdata.getString("cufe");
        uuidDocumentReference.setValue(CUFE);
        RSdata.close();
        IssueDateType invoiceIssueDate = new IssueDateType();
        XMLGregorianCalendar ginvoiceIssueDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(fecha_factura);
        System.out.println("+++++++++++++------issueDateFac: " + ginvoiceIssueDate);
        invoiceIssueDate.setValue(ginvoiceIssueDate);
        referenceDocument.setID(idDocumentReference);
        referenceDocument.setUUID(uuidDocumentReference);
        referenceDocument.setIssueDate(invoiceIssueDate);
        billingReference.setInvoiceDocumentReference(referenceDocument);
        creditNoteType.getBillingReference().add(billingReference);
        InfoEmpresa empresa = new InfoEmpresa(this.bd);
        creditNoteType.setAccountingSupplierParty(empresa.getEmpresa(prefijonc, this.codigoOR));
        creditNoteType.setTaxRepresentativeParty(DescargaDocumentos.getNitDescarga(this.cliente));
        System.out.println("ndocumento para notas credito: " + ndocumento);
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBElement je = objectFactory.createCreditNote(creditNoteType);
        System.out.println("consecutivo antes de marshal: " + this.consecutive);
        this.generateCreditNoteXMLFile((JAXBElement<CreditNoteType>)je, fechacufe, this.consecutive);
        Calendar calendar2 = Calendar.getInstance();
        long end = calendar2.getTimeInMillis();
        System.out.print("Documento electronico generado en " + (end - init) + " milisegundos\n");
    }

    private ArrayList<PaymentMeansType> formaPago(String documento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException {
        ArrayList<PaymentMeansType> listaFormaPago = new ArrayList<PaymentMeansType>();
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0029", new String[]{documento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        RSdata.next();
        double efectivo = RSdata.getDouble("efectivo");
        double tcredito = RSdata.getDouble("tcredito");
        double cheque = RSdata.getDouble("cheque");
        double consignacion = RSdata.getDouble("consignacion");
        double traslado = RSdata.getDouble("traslado");
        double tdebito = RSdata.getDouble("tdebito");
        double cxc = RSdata.getDouble("cxc");
        RSdata.close();
        if (efectivo > 0.0) {
            listaFormaPago.add(this.formaPago(1, 10));
        }
        if (tcredito > 0.0) {
            listaFormaPago.add(this.formaPago(1, 48));
        }
        if (cheque > 0.0) {
            listaFormaPago.add(this.formaPago(1, 20));
        }
        if (consignacion > 0.0) {
            listaFormaPago.add(this.formaPago(1, 42));
        }
        if (traslado > 0.0) {
            listaFormaPago.add(this.formaPago(1, 47));
        }
        if (tdebito > 0.0) {
            listaFormaPago.add(this.formaPago(1, 49));
        }
        if (cxc > 0.0) {
            PaymentMeansType formaPago = this.formaPago(2, 30);
            RQdata = new QueryRunner(this.bd, "SCSDE0022", new String[]{documento});
            RSdata = RQdata.ejecutarMTSELECT(this.conn);
            RSdata.next();
            String vencimiento = RSdata.getString("vencimiento");
            RSdata.close();
            PaymentDueDateType paymentDueDate = new PaymentDueDateType();
            paymentDueDate.setValue(vencimiento);
            formaPago.setPaymentDueDate(paymentDueDate);
            listaFormaPago.add(formaPago);
        }
        return listaFormaPago;
    }

    private PaymentMeansType formaPago(int tipopago, int pago) {
        PaymentMeansType formaPago = new PaymentMeansType();
        IDType tipo = new IDType();
        tipo.setValue("" + tipopago);
        formaPago.setID(tipo);
        PaymentMeansCodeType paymentMeansCode = new PaymentMeansCodeType();
        paymentMeansCode.setValue("" + pago);
        formaPago.setPaymentMeansCode(paymentMeansCode);
        return formaPago;
    }

    private List<TaxTotalType> totalINCBolsa(String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0023", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        ArrayList<TaxTotalType> totalINC = new ArrayList<TaxTotalType>();
        TaxTotalType totalINCBolsa = new TaxTotalType();
        TaxAmountType valorINCBolsa = new TaxAmountType();
        valorINCBolsa.setCurrencyID("COP");
        double unidad = 0.0;
        double total = 0.0;
        if (RSdata.next()) {
            unidad = RSdata.getDouble("unidad_bolsa");
            total = RSdata.getDouble("total_bolsa");
            RSdata.close();
            BigDecimal bdunidad = new BigDecimal(unidad);
            bdunidad = bdunidad.setScale(2, RoundingMode.HALF_UP);
            BigDecimal bdtotal = new BigDecimal(total);
            bdtotal = bdtotal.setScale(2, RoundingMode.HALF_UP);
            valorINCBolsa.setValue(bdtotal);
            TaxEvidenceIndicatorType taxEvidence = new TaxEvidenceIndicatorType();
            taxEvidence.setValue(false);
            totalINCBolsa.setTaxAmount(valorINCBolsa);
            totalINCBolsa.setTaxEvidenceIndicator(taxEvidence);
            TaxSubtotalType subTotalINCBolsa = new TaxSubtotalType();
            subTotalINCBolsa.setTaxAmount(valorINCBolsa);
            BaseUnitMeasureType unidadBolsa = new BaseUnitMeasureType();
            unidadBolsa.setUnitCode("NIU");
            subTotalINCBolsa.setBaseUnitMeasure(unidadBolsa);
            BigDecimal bdunidadBolsa = new BigDecimal(1);
            bdunidadBolsa = bdunidadBolsa.setScale(2, RoundingMode.HALF_UP);
            unidadBolsa.setValue(bdunidadBolsa);
            PerUnitAmountType perUnit = new PerUnitAmountType();
            perUnit.setCurrencyID("COP");
            perUnit.setValue(bdunidad);
            subTotalINCBolsa.setPerUnitAmount(perUnit);
            TaxCategoryType categoriaINC = new TaxCategoryType();
            TaxSchemeType taxSchemeINC = new TaxSchemeType();
            IDType idSchemeINC = new IDType();
            idSchemeINC.setValue("22");
            taxSchemeINC.setID(idSchemeINC);
            NameType nameINC = new NameType();
            nameINC.setValue("INC Bolsas");
            taxSchemeINC.setName(nameINC);
            categoriaINC.setTaxScheme(taxSchemeINC);
            subTotalINCBolsa.setTaxCategory(categoriaINC);
            totalINCBolsa.getTaxSubtotal().add(subTotalINCBolsa);
            totalINC.add(totalINCBolsa);
            System.out.println("total INC Bolsa: " + total);
            return totalINC;
        }
        return null;
    }

    private List<TaxTotalType> totalIVAS() {
        System.out.println("--------------------------------");
        Enumeration<String> porcentajes = this.taxTotal.keys();
        ArrayList<TaxTotalType> totalImpuestos = new ArrayList<TaxTotalType>();
        TaxTotalType totalIVA = new TaxTotalType();
        TaxAmountType valorIVA = new TaxAmountType();
        valorIVA.setCurrencyID(this._MONEDA);
        double viva = 0.0;
        boolean tarifas = false;
        while (porcentajes.hasMoreElements()) {
            String siva = porcentajes.nextElement();
            System.out.println("portentaje: " + siva);
            tarifas = true;
            TaxAmountType svalorIVA = new TaxAmountType();
            svalorIVA.setCurrencyID(this._MONEDA);
            BigDecimal bdpiva = new BigDecimal(siva);
            bdpiva = bdpiva.setScale(2, RoundingMode.HALF_UP);
            TaxTotal totalImp = this.taxTotal.get(bdpiva.toString());
            double sviva = totalImp.getIva();
            viva += sviva;
            BigDecimal bdsiva = new BigDecimal(sviva);
            bdsiva = bdsiva.setScale(2, RoundingMode.HALF_UP);
            svalorIVA.setValue(bdsiva);
            TaxSubtotalType subTotal1 = new TaxSubtotalType();
            TaxableAmountType base1 = new TaxableAmountType();
            base1.setCurrencyID(this._MONEDA);
            double vbase = totalImp.getBase();
            BigDecimal bdbase = new BigDecimal(vbase);
            bdbase = bdbase.setScale(2, RoundingMode.HALF_UP);
            base1.setValue(bdbase);
            subTotal1.setTaxableAmount(base1);
            subTotal1.setTaxAmount(svalorIVA);
            PercentType porcentaje1 = new PercentType();
            porcentaje1.setValue(bdpiva);
            TaxCategoryType taxCategory1 = new TaxCategoryType();
            taxCategory1.setPercent(porcentaje1);
            TaxSchemeType taxSheme1 = new TaxSchemeType();
            IDType idSheme1 = new IDType();
            idSheme1.setValue("01");
            taxSheme1.setID(idSheme1);
            RoundingAmountType redondeo = new RoundingAmountType();
            redondeo.setCurrencyID("COP");
            BigDecimal bdround = new BigDecimal(0);
            bdround = bdround.setScale(2, RoundingMode.HALF_UP);
            redondeo.setValue(bdround);
            totalIVA.setRoundingAmount(redondeo);
            NameType nameImp = new NameType();
            nameImp.setValue("IVA");
            taxSheme1.setName(nameImp);
            taxCategory1.setTaxScheme(taxSheme1);
            subTotal1.setTaxCategory(taxCategory1);
            totalIVA.getTaxSubtotal().add(subTotal1);
        }
        BigDecimal bdiva = new BigDecimal(viva);
        bdiva = bdiva.setScale(2, RoundingMode.HALF_UP);
        valorIVA.setValue(bdiva);
        totalIVA.setTaxAmount(valorIVA);
        if (tarifas) {
            totalImpuestos.add(totalIVA);
        }
        return totalImpuestos;
    }

    private void insertCreditNoteOnDB(Date date) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        System.out.println("Insertando informacion de nota credito por anulacion");
        this.ndocument_db = LNDocuments.LNTransaction().getKey(0);
        org.jdom.Element newPack = new org.jdom.Element("package");
        newPack.addContent((Content)new org.jdom.Element("field").setText(this.codigo_tipo));
        newPack.addContent((Content)new org.jdom.Element("field").setText(date.toString()));
        newPack.addContent((Content)new org.jdom.Element("field").setText(this.idUsuario));
        newPack.addContent((Content)new org.jdom.Element("field").setText(this.ndocument_db));
        this.conceptObject = CacheKeys.getKey("concepto");
        CacheKeys.cleanKeys();
        LNDocuments.LNTransaction().setArgs(newPack, this.idTransaction);
        LNDocuments.LNTransaction().generarTransacConnection("SCSDEIN06");
        System.out.println("registro insertado...");
    }

    private void generateCreditNoteXMLFile(JAXBElement<CreditNoteType> je, String date, String consecutive) throws JAXBException, SQLException, SQLNotFoundException, SQLBadArgumentsException, ParserConfigurationException, KeyStoreException, UnsupportedOperationException, TransformerException, IOException, DatatypeConfigurationException, SOAPException, SendDianException, Exception {
        Element reportNode;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CreditNoteType.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        String FORMATER = "yyyy-MM-dd";
        SimpleDateFormat format = new SimpleDateFormat(FORMATER);
        String year2 = date.substring(2, 4);
        String nit = LinkingCache.getNit(this.bd).trim();
        String nitPath = "0000000000".substring(nit.length()) + nit;
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0025");
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        String envios = "1";
        if (RSdata.next() && (envios = RSdata.getString("consecutivo_envio")) == null) {
            envios = "39";
        }
        RSdata.close();
        String action = "";
        System.out.println("type document: " + this.type_document + " consecutive " + consecutive);
        action = "ReturnInvoice";
        System.out.println("consecutivo para envio: " + consecutive);
        String nenvio = "00000000".substring(envios.length()) + envios;
        String namefile = "nc" + nitPath + "000" + year2 + nenvio + ".xml";
        String fullPath = new String("/home/emaku/ElectronicDocuments/" + LinkingCache.getNit(this.bd) + "/" + date + "/" + action + "/" + this.codigo_tipo + "/" + namefile);
        String bdPath = new String(LinkingCache.getNit(this.bd) + "/" + date + "/" + action + "/" + this.codigo_tipo + "/" + namefile);
        String pathInvoice = new String("/home/emaku/ElectronicDocuments/" + LinkingCache.getNit(this.bd) + "/" + date + "/" + action + "/" + this.codigo_tipo);
        File pathDocument = new File(pathInvoice);
        SaveCUFE saveCUFE = new SaveCUFE(this.bd, this.idTransaction, this.id_registro_software, this.type_document, consecutive, this.consecutivenc, this.vtotales, this.cliente, date, this.CUDE);
        saveCUFE.save(bdPath);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        marshaller.marshal(je, (Node)document);
        long inicio = System.currentTimeMillis();
        document.getElementsByTagName("ns7:CreditNote");
        Element reportElement = reportNode = document.getDocumentElement();
        document.renameNode(reportElement, "urn:oasis:names:specification:ubl:schema:xsd:CreditNote-2", "CreditNote");
        document = UtilsXML.removeNode(document, "sts:SoftwareID", "xmlns:xsi");
        document = UtilsXML.removeNode(document, "sts:SoftwareID", "xsi:type");
        document = UtilsXML.removeNode(document, "sts:SoftwareID", "xsi:type");
        document = UtilsXML.removeRootAttribute(document, "xmlns:fe");
        document = UtilsXML.removeRootAttribute(document, "xmlns:ns7");
        document = UtilsXML.removeRootAttribute(document, "xmlns:xs");
        document = UtilsXML.addRootAttribute(document, "xmlns:xades", "http://uri.etsi.org/01903/v1.3.2#");
        document = UtilsXML.addRootAttribute(document, "xmlns:xades141", "http://uri.etsi.org/01903/v1.4.1#");
        document = UtilsXML.addRootAttribute(document, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        document = UtilsXML.addRootAttribute(document, "xsi:schemaLocation", "urn:oasis:names:specification:ubl:schema:xsd:Invoice-2     http://docs.oasis-open.org/ubl/os-UBL-2.1/xsd/maindoc/UBL-Invoice-2.1.xsd");
        long fin = System.currentTimeMillis();
        double tiempo = (fin - inicio) / 1000L;
        System.out.println("tiempo de re-etiquetado " + tiempo + " segundos");
        System.out.println("------------------inicio nota credito electronica ----------------");
        marshaller.marshal(je, (OutputStream)System.out);
        Document docEpes = PrintXML.parser(document);
        System.out.println("------------------fin nota credito electronica ----------------");
        if (!pathDocument.exists()) {
            pathDocument.mkdirs();
        }
        SignedDocument sign = new SignedDocument(this.bd, this.ndocument_db, this.idTransaction, this.type_document);
        sign.signEpes(this.urlAmbiente, this.id_tipo_ambiente, docEpes, fullPath);
    }

    public void totalizarAnulacionNotaCredito(double valor) {
        this.vtotales.put("subtotal", valor);
        this.vtotales.put("descuento", new Double(0.0));
        this.vtotales.put("base", valor);
        this.vtotales.put("base_excluida", valor);
        this.vtotales.put("taxableAmount", new Double(0.0));
        this.vtotales.put("iva", new Double(0.0));
        this.vtotales.put("inc", new Double(0.0));
        this.vtotales.put("ica", new Double(0.0));
        this.vtotales.put("total", valor);
        this.vtotales.put("totalsinret", valor);
        this.vtotales.put("articulos", new Double(1.0));
    }

    private List<CreditNoteLineType> listProductosCreditNote(String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        ArrayList<CreditNoteLineType> listProductos = new ArrayList<CreditNoteLineType>();
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0003", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        double tsubtotal = 0.0;
        double tdescuento = 0.0;
        double tbase = 0.0;
        double tiva = 0.0;
        int line = 1;
        ResultSetMetaData rsmd = RSdata.getMetaData();
        int columnsNumber = rsmd.getColumnCount();
        while (RSdata.next()) {
            CreditNoteLineType productos = new CreditNoteLineType();
            IDType IDp1 = new IDType();
            IDp1.setValue(String.valueOf(line++));
            productos.setID(IDp1);
            CreditedQuantityType cant1 = new CreditedQuantityType();
            cant1.setUnitCode("NIU");
            cant1.setValue(new BigDecimal(RSdata.getString("cant")));
            productos.setCreditedQuantity(cant1);
            LineExtensionAmountType valorBase1 = new LineExtensionAmountType();
            valorBase1.setCurrencyID(this._MONEDA);
            BigDecimal dvalorBase1 = new BigDecimal(RSdata.getDouble("neto"));
            dvalorBase1 = dvalorBase1.setScale(2, RoundingMode.HALF_UP);
            valorBase1.setValue(dvalorBase1);
            productos.setLineExtensionAmount(valorBase1);
            tsubtotal += dvalorBase1.doubleValue();
            ItemType item1 = new ItemType();
            DescriptionType descripcionPpal = new DescriptionType();
            descripcionPpal.setValue(RSdata.getString("descripcion"));
            item1.getDescription().add(descripcionPpal);
            ItemIdentificationType idItem = new ItemIdentificationType();
            IDType codId = new IDType();
            codId.setValue(RSdata.getString("codigo").trim());
            idItem.setID(codId);
            codId.setSchemeID("999");
            item1.setStandardItemIdentification(idItem);
            double diva = RSdata.getDouble("viva");
            BigDecimal bdiva = new BigDecimal(diva);
            bdiva = bdiva.setScale(2, RoundingMode.HALF_UP);
            tiva += diva;
            double dbase = RSdata.getDouble("neto");
            BigDecimal bdbase = new BigDecimal(dbase);
            bdbase = bdbase.setScale(2, RoundingMode.HALF_UP);
            tbase += dbase;
            TaxTotalType impuestos = new TaxTotalType();
            TaxAmountType iva = new TaxAmountType();
            iva.setValue(bdiva);
            iva.setCurrencyID(this._MONEDA);
            impuestos.setTaxAmount(iva);
            TaxSubtotalType baseImpuesto = new TaxSubtotalType();
            TaxableAmountType base = new TaxableAmountType();
            base.setValue(bdbase);
            base.setCurrencyID(this._MONEDA);
            baseImpuesto.setTaxableAmount(base);
            TaxAmountType viva = new TaxAmountType();
            viva.setValue(bdiva);
            viva.setCurrencyID(this._MONEDA);
            baseImpuesto.setTaxAmount(viva);
            TaxCategoryType taxCategory = new TaxCategoryType();
            PercentType piva = new PercentType();
            String siva = RSdata.getString("piva");
            BigDecimal bdpiva = new BigDecimal(siva);
            bdpiva = bdpiva.setScale(2, RoundingMode.HALF_UP);
            piva.setValue(bdpiva);
            taxCategory.setPercent(piva);
            impuestos.getTaxSubtotal().add(baseImpuesto);
            productos.getTaxTotal().add(impuestos);
            TaxTotal atotales = this.taxTotal.get(bdpiva.toString());
            double nbase = (atotales == null ? 0.0 : atotales.getBase()) + dbase;
            double niva = (atotales == null ? 0.0 : atotales.getIva()) + diva;
            System.out.println("ingresando valores de impuestos: porcentaje: " + siva + " base " + nbase + " niva " + niva);
            this.taxTotal.put(bdpiva.toString(), new TaxTotal(nbase, niva));
            TaxSchemeType taxSheme1 = new TaxSchemeType();
            IDType idSheme1 = new IDType();
            idSheme1.setValue("01");
            taxSheme1.setID(idSheme1);
            NameType taxName1 = new NameType();
            taxName1.setValue("IVA");
            taxSheme1.setName(taxName1);
            taxCategory.setTaxScheme(taxSheme1);
            baseImpuesto.setTaxCategory(taxCategory);
            PartyType informationContent = new PartyType();
            PowerOfAttorneyType powerOf = new PowerOfAttorneyType();
            PartyType agencyParty = new PartyType();
            PartyIdentificationType agencyIdentification = new PartyIdentificationType();
            IDType agencyId = new IDType();
            agencyId.setSchemeAgencyID("195");
            agencyId.setValue(this.cliente.get("nit"));
            agencyId.setSchemeID(this.cliente.get("dv"));
            agencyId.setSchemeName(this.cliente.get("schemeID"));
            agencyIdentification.setID(agencyId);
            agencyParty.getPartyIdentification().add(agencyIdentification);
            powerOf.setAgentParty(agencyParty);
            informationContent.getPowerOfAttorney().add(powerOf);
            item1.setInformationContentProviderParty(informationContent);
            String referencia = RSdata.getString("referencia");
            if (referencia != null) {
                ItemIdentificationType idReferencia = new ItemIdentificationType();
                IDType codRef = new IDType();
                codRef.setSchemeName("referencia");
                codRef.setValue(referencia);
                idReferencia.setID(codRef);
                item1.getAdditionalItemIdentification().add(idReferencia);
            }
            for (int i = 13; i <= columnsNumber; ++i) {
                ItemPropertyType add = new ItemPropertyType();
                NameType nameAddItem = new NameType();
                nameAddItem.setValue(rsmd.getColumnName(i));
                add.setName(nameAddItem);
                ValueType data = new ValueType();
                data.setValue(RSdata.getString(i));
                add.setValue(data);
                item1.getAdditionalItemProperty().add(add);
            }
            PriceType precio = new PriceType();
            PriceAmountType priceAmount = new PriceAmountType();
            double pventa = RSdata.getDouble("pventa");
            BigDecimal bdpventa = new BigDecimal(pventa);
            bdpventa = bdpventa.setScale(2, RoundingMode.HALF_UP);
            priceAmount.setValue(bdpventa);
            priceAmount.setCurrencyID("COP");
            precio.setPriceAmount(priceAmount);
            productos.setPrice(precio);
            productos.setItem(item1);
            PriceType precioItem1 = new PriceType();
            BigDecimal dunitario = new BigDecimal(RSdata.getDouble("pventa"));
            dunitario = dunitario.setScale(2, RoundingMode.HALF_UP);
            PriceAmountType precio1 = new PriceAmountType();
            precio1.setValue(dunitario);
            BaseQuantityType cantUnidad = new BaseQuantityType();
            cantUnidad.setUnitCode("NIU");
            cantUnidad.setValue(new BigDecimal(RSdata.getString("cant")));
            precioItem1.setBaseQuantity(cantUnidad);
            precio1.setCurrencyID(this._MONEDA);
            precioItem1.setPriceAmount(precio1);
            productos.setPrice(precioItem1);
            productos.setItem(item1);
            listProductos.add(productos);
        }
        List<CreditNoteLineType> productosExcluidos = this.listProductosExcluidos(ndocumento, listProductos.size());
        double eSubtotal = 0.0;
        double eDescuento = 0.0;
        double eTbase = 0.0;
        double eTaxableAmount = 0.0;
        double eTotal = 0.0;
        double eTotalsinret = 0.0;
        double eArticulos = 0.0;
        System.out.println("Productos Excluidos: " + productosExcluidos.size());
        if (productosExcluidos.size() > 0) {
            listProductos.addAll(productosExcluidos);
            eSubtotal = this.vtotales.get("subtotal");
            eDescuento = this.vtotales.get("descuento");
            eTbase = this.vtotales.get("base");
            eTaxableAmount = this.vtotales.get("taxableAmount");
            eTotal = this.vtotales.get("total");
            eTotalsinret = this.vtotales.get("totalsinret");
            System.out.println("eSubtotal: " + eSubtotal + "\n eDescuento: " + eDescuento + "\n eTbase " + eTbase + "\n eTaxableAmount " + eTaxableAmount + "\n eTotal " + eTotal + "\n eTotalsinret " + eTotalsinret);
        }
        this.vtotales.put("subtotal", eSubtotal + tsubtotal);
        this.vtotales.put("descuento", eDescuento + tdescuento);
        this.vtotales.put("base", eTbase + tbase);
        this.vtotales.put("taxableAmount", eTaxableAmount + tbase);
        this.vtotales.put("iva", tiva);
        this.vtotales.put("inc", new Double(0.0));
        this.vtotales.put("ica", new Double(0.0));
        System.out.println("-+-+-+-+-+-+-++-+-+-+-Total REtenciones: " + this.totalRet);
        this.vtotales.put("total", eTotal + (tbase + tiva + this.totalINCBolsa - this.totalRet));
        System.out.println("total sin ret desde grabados: " + eTotalsinret + " (tbase+tiva+totalINCBolsa) " + tbase + "+" + tiva + "+" + this.totalINCBolsa + " = " + (eTotalsinret + (tbase + tiva + this.totalINCBolsa)));
        this.vtotales.put("totalsinret", eTotalsinret + (tbase + tiva + this.totalINCBolsa));
        System.out.println("total articulos inc: " + eArticulos + " exentos: " + productosExcluidos.size() + " grabados " + listProductos.size());
        this.vtotales.put("articulos", new Double(listProductos.size()));
        RSdata.close();
        return listProductos;
    }

    private List<CreditNoteLineType> listProductosExcluidos(String ndocumento, int line) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        ArrayList<CreditNoteLineType> listProductos = new ArrayList<CreditNoteLineType>();
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0026", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        double tsubtotal = 0.0;
        double tdescuento = 0.0;
        double tbase = 0.0;
        int id = line;
        ResultSetMetaData rsmd = RSdata.getMetaData();
        int columnsNumber = rsmd.getColumnCount();
        while (RSdata.next()) {
            CreditNoteLineType productos = new CreditNoteLineType();
            IDType IDp1 = new IDType();
            IDp1.setValue(String.valueOf(++id));
            productos.setID(IDp1);
            CreditedQuantityType cant1 = new CreditedQuantityType();
            cant1.setUnitCode("NIU");
            cant1.setValue(new BigDecimal(RSdata.getString("cant")));
            productos.setCreditedQuantity(cant1);
            LineExtensionAmountType valorBase1 = new LineExtensionAmountType();
            valorBase1.setCurrencyID(this._MONEDA);
            BigDecimal dvalorBase1 = new BigDecimal(RSdata.getDouble("neto"));
            dvalorBase1 = dvalorBase1.setScale(2, RoundingMode.HALF_UP);
            valorBase1.setValue(dvalorBase1);
            productos.setLineExtensionAmount(valorBase1);
            tsubtotal += dvalorBase1.doubleValue();
            ItemType item1 = new ItemType();
            DescriptionType descripcionPpal = new DescriptionType();
            descripcionPpal.setValue(RSdata.getString("descripcion"));
            item1.getDescription().add(descripcionPpal);
            ItemIdentificationType idItem = new ItemIdentificationType();
            IDType codId = new IDType();
            codId.setValue(RSdata.getString("codigo").trim());
            idItem.setID(codId);
            codId.setSchemeID("999");
            item1.setStandardItemIdentification(idItem);
            PartyType informationContent = new PartyType();
            PowerOfAttorneyType powerOf = new PowerOfAttorneyType();
            PartyType agencyParty = new PartyType();
            PartyIdentificationType agencyIdentification = new PartyIdentificationType();
            IDType agencyId = new IDType();
            agencyId.setSchemeAgencyID("195");
            agencyId.setValue(this.cliente.get("nit"));
            agencyId.setSchemeID(this.cliente.get("dv"));
            agencyId.setSchemeName(this.cliente.get("schemeID"));
            agencyIdentification.setID(agencyId);
            agencyParty.getPartyIdentification().add(agencyIdentification);
            powerOf.setAgentParty(agencyParty);
            informationContent.getPowerOfAttorney().add(powerOf);
            item1.setInformationContentProviderParty(informationContent);
            String referencia = RSdata.getString("referencia");
            if (referencia != null) {
                ItemIdentificationType idReferencia = new ItemIdentificationType();
                IDType codRef = new IDType();
                codRef.setSchemeName("referencia");
                codRef.setValue(referencia);
                idReferencia.setID(codRef);
                item1.getAdditionalItemIdentification().add(idReferencia);
            }
            for (int i = 13; i <= columnsNumber; ++i) {
                ItemPropertyType add = new ItemPropertyType();
                NameType nameAddItem = new NameType();
                nameAddItem.setValue(rsmd.getColumnName(i));
                add.setName(nameAddItem);
                ValueType data = new ValueType();
                data.setValue(RSdata.getString(i));
                add.setValue(data);
                item1.getAdditionalItemProperty().add(add);
            }
            PriceType precio = new PriceType();
            PriceAmountType priceAmount = new PriceAmountType();
            double pventa = RSdata.getDouble("pventa");
            BigDecimal bdpventa = new BigDecimal(pventa);
            bdpventa = bdpventa.setScale(2, RoundingMode.HALF_UP);
            priceAmount.setValue(bdpventa);
            priceAmount.setCurrencyID("COP");
            precio.setPriceAmount(priceAmount);
            productos.setPrice(precio);
            productos.setItem(item1);
            PriceType precioItem1 = new PriceType();
            BigDecimal dunitario = new BigDecimal(RSdata.getDouble("pventa"));
            dunitario = dunitario.setScale(2, RoundingMode.HALF_UP);
            PriceAmountType precio1 = new PriceAmountType();
            precio1.setValue(dunitario);
            BaseQuantityType cantUnidad = new BaseQuantityType();
            cantUnidad.setUnitCode("NIU");
            cantUnidad.setValue(new BigDecimal(RSdata.getString("cant")));
            precioItem1.setBaseQuantity(cantUnidad);
            precio1.setCurrencyID(this._MONEDA);
            precioItem1.setPriceAmount(precio1);
            productos.setPrice(precioItem1);
            listProductos.add(productos);
        }
        CreditNoteLineType incBolsa = this.incBolsaList(ndocumento, line + listProductos.size());
        if (incBolsa != null) {
            listProductos.add(incBolsa);
            this.vtotales.put("articulos", new Double(1.0));
        }
        this.vtotales.put("subtotal", tsubtotal);
        this.vtotales.put("descuento", tdescuento);
        this.vtotales.put("base", tbase);
        this.vtotales.put("taxableAmount", new Double(0.0));
        this.vtotales.put("iva", new Double(0.0));
        this.vtotales.put("inc", new Double(0.0));
        this.vtotales.put("ica", new Double(0.0));
        System.out.println("-+-+-+-+-+-+-++-+-+-+-Total REtenciones: " + this.totalRet);
        this.vtotales.put("total", tsubtotal);
        this.vtotales.put("totalsinret", tsubtotal);
        this.vtotales.put("base_excluida", tsubtotal);
        RSdata.close();
        return listProductos;
    }

    private CreditNoteLineType incBolsaList(String ndocumento, int id) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        CreditNoteLineType incBolsa = new CreditNoteLineType();
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0024", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        if (RSdata.next()) {
            IDType idBolsa = new IDType();
            idBolsa.setValue(String.valueOf(++id));
            incBolsa.setID(idBolsa);
            CreditedQuantityType quantityBolsa = new CreditedQuantityType();
            BigDecimal bdcantBolsa = new BigDecimal(RSdata.getDouble("cant"));
            bdcantBolsa = bdcantBolsa.setScale(2, RoundingMode.HALF_UP);
            quantityBolsa.setUnitCode("NIU");
            quantityBolsa.setValue(bdcantBolsa);
            incBolsa.setCreditedQuantity(quantityBolsa);
            LineExtensionAmountType lineBolsa = new LineExtensionAmountType();
            lineBolsa.setCurrencyID("COP");
            lineBolsa.setValue(new BigDecimal(0));
            incBolsa.setLineExtensionAmount(lineBolsa);
            PricingReferenceType precioReferencia = new PricingReferenceType();
            PriceType precioAlterno = new PriceType();
            PriceAmountType precioBolsa = new PriceAmountType();
            precioBolsa.setCurrencyID("COP");
            precioBolsa.setValue(new BigDecimal(1));
            precioAlterno.setPriceAmount(precioBolsa);
            PriceTypeCodeType priceType = new PriceTypeCodeType();
            priceType.setValue("01");
            precioAlterno.setPriceTypeCode(priceType);
            precioReferencia.getAlternativeConditionPrice().add(precioAlterno);
            incBolsa.setPricingReference(precioReferencia);
            TaxTotalType taxBolsa = new TaxTotalType();
            TaxAmountType taxAmountBolsa = new TaxAmountType();
            taxAmountBolsa.setCurrencyID("COP");
            BigDecimal bdtotalBolsas = new BigDecimal(RSdata.getDouble("total_bolsas"));
            bdtotalBolsas = bdtotalBolsas.setScale(2, RoundingMode.HALF_UP);
            this.totalINCBolsa = bdtotalBolsas.doubleValue();
            taxAmountBolsa.setValue(bdtotalBolsas);
            taxBolsa.setTaxAmount(taxAmountBolsa);
            TaxSubtotalType subTotalBolsa = new TaxSubtotalType();
            subTotalBolsa.setTaxAmount(taxAmountBolsa);
            BaseUnitMeasureType baseBolsa = new BaseUnitMeasureType();
            baseBolsa.setUnitCode("NIU");
            baseBolsa.setValue(new BigDecimal(1));
            subTotalBolsa.setBaseUnitMeasure(baseBolsa);
            PerUnitAmountType perBolsa = new PerUnitAmountType();
            perBolsa.setCurrencyID("COP");
            BigDecimal bdvunitarioBolsas = new BigDecimal(RSdata.getDouble("vunitario_bolsa"));
            bdvunitarioBolsas = bdvunitarioBolsas.setScale(2, RoundingMode.HALF_UP);
            perBolsa.setValue(bdvunitarioBolsas);
            subTotalBolsa.setPerUnitAmount(perBolsa);
            TaxCategoryType taxCategory = new TaxCategoryType();
            TaxSchemeType taxSheme1 = new TaxSchemeType();
            IDType idSheme1 = new IDType();
            idSheme1.setValue("22");
            taxSheme1.setID(idSheme1);
            NameType taxName1 = new NameType();
            taxName1.setValue("BOLSAS");
            taxSheme1.setName(taxName1);
            taxCategory.setTaxScheme(taxSheme1);
            subTotalBolsa.setTaxCategory(taxCategory);
            taxBolsa.getTaxSubtotal().add(subTotalBolsa);
            incBolsa.getTaxTotal().add(taxBolsa);
            ItemType itemBolsa = new ItemType();
            DescriptionType descripcionBolsa = new DescriptionType();
            descripcionBolsa.setValue("INC Bolsa Plastica");
            itemBolsa.getDescription().add(descripcionBolsa);
            PackSizeNumericType packBolsa = new PackSizeNumericType();
            packBolsa.setValue(new BigDecimal(1));
            itemBolsa.setPackSizeNumeric(packBolsa);
            ItemIdentificationType idItem = new ItemIdentificationType();
            IDType codigoInternoBolsa = new IDType();
            codigoInternoBolsa.setValue(RSdata.getString("codigo").trim());
            idItem.setID(codigoInternoBolsa);
            codigoInternoBolsa.setSchemeID("999");
            itemBolsa.setStandardItemIdentification(idItem);
            incBolsa.setItem(itemBolsa);
            PriceType precioItem1 = new PriceType();
            BigDecimal dunitario = new BigDecimal(0);
            dunitario = dunitario.setScale(2, RoundingMode.HALF_UP);
            PriceAmountType precio1 = new PriceAmountType();
            precio1.setCurrencyID(this._MONEDA);
            precio1.setValue(dunitario);
            precioItem1.setPriceAmount(precio1);
            BaseQuantityType cantUnidad = new BaseQuantityType();
            cantUnidad.setUnitCode("NIU");
            cantUnidad.setValue(new BigDecimal(1));
            precioItem1.setBaseQuantity(cantUnidad);
            incBolsa.setPrice(precioItem1);
            return incBolsa;
        }
        return null;
    }

    public org.jdom.Element getQRCUFE() {
        org.jdom.Element cufe = new org.jdom.Element("CUFE");
        double vbase = this.vtotales.get("base") + this.vtotales.get("base_excluida");
        BigDecimal bdbase = new BigDecimal(vbase);
        bdbase = bdbase.setScale(2, RoundingMode.HALF_UP);
        double viva = this.vtotales.get("iva");
        BigDecimal bdiva = new BigDecimal(viva);
        bdiva = bdiva.setScale(2, RoundingMode.HALF_UP);
        double vtotal = this.vtotales.get("total");
        BigDecimal bdtotal = new BigDecimal(vtotal);
        bdtotal = bdtotal.setScale(2, RoundingMode.HALF_UP);
        cufe.addContent((Content)new org.jdom.Element("numfac").setText(this.consecutivenc));
        cufe.addContent((Content)new org.jdom.Element("fecfac").setText(this.fecfac));
        cufe.addContent((Content)new org.jdom.Element("horfac").setText(this.gTimeFormatted));
        cufe.addContent((Content)new org.jdom.Element("nitfac").setText(LinkingCache.getNit(this.bd)));
        cufe.addContent((Content)new org.jdom.Element("docadq").setText(this.cliente.get("nit")));
        cufe.addContent((Content)new org.jdom.Element("valfac").setText(bdbase.toString()));
        cufe.addContent((Content)new org.jdom.Element("valiva").setText(bdiva.toString()));
        cufe.addContent((Content)new org.jdom.Element("valotroim").setText("0.00"));
        cufe.addContent((Content)new org.jdom.Element("valfacim").setText(bdtotal.toString()));
        cufe.addContent((Content)new org.jdom.Element("cufe").setText("CUDE: " + this.CUDE));
        if (this.id_tipo_ambiente == 2) {
            cufe.addContent((Content)new org.jdom.Element("qr").setText("URL=https://catalogo-vpfe-hab.dian.gov.co/document/searchqr?documentkey=" + this.CUDE));
        } else {
            cufe.addContent((Content)new org.jdom.Element("qr").setText("URL=https://catalogo-vpfe.dian.gov.co/document/searchqr?documentkey=" + this.CUDE));
        }
        return cufe;
    }

    class TaxTotal {
        double base;
        double iva;

        public TaxTotal(double base, double iva) {
            this.base = base;
            this.iva = iva;
        }

        public double getBase() {
            return this.base;
        }

        public double getIva() {
            return this.iva;
        }
    }
}

