/*
 * Decompiled with CFR 0.152.
 */
package server.comunications;

import common.comunications.InfoSocket;
import common.misc.language.Language;
import common.misc.log.LogAdmin;
import common.misc.settings.ServerConfigFileHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import server.control.HeadersValidator;

public class ServerPackageToXML
extends Thread {
    private static Document doc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void work(SocketChannel channel) {
        SocketChannel socketChannel = channel;
        synchronized (socketChannel) {
            ByteBuffer buf = ByteBuffer.allocateDirect(8192);
            try {
                int numRead = 1;
                while (numRead > 0) {
                    buf.rewind();
                    numRead = channel.read(buf);
                    buf.rewind();
                    for (int i = 0; i < numRead; ++i) {
                        byte character = buf.get(i);
                        if (character != 12) {
                            if (character == 0) continue;
                            InfoSocket.getBufferTmp((SocketChannel)channel).write(buf.get(i));
                            continue;
                        }
                        SAXBuilder builder = null;
                        ByteArrayInputStream bufferIn = null;
                        try {
                            builder = new SAXBuilder();
                            bufferIn = new ByteArrayInputStream(InfoSocket.getBufferTmp((SocketChannel)channel).toByteArray());
                            doc = builder.build((InputStream)bufferIn);
                            if (channel.socket().getLocalPort() == ServerConfigFileHandler.getAdminSocket()) {
                                HeadersValidator.ValidAdmin(doc, channel);
                                continue;
                            }
                            HeadersValidator.ValidClient(doc, channel);
                            continue;
                        }
                        catch (JDOMException e1) {
                            String tmp = Language.getWord((String)"ERR_FORMAT_PROTOCOL") + " " + channel.socket();
                            LogAdmin.setMessage((String)("\n--------------------\n" + tmp + "\n" + new String(InfoSocket.getBufferTmp((SocketChannel)channel).toByteArray()) + "\n------------------\n"), (int)0);
                            continue;
                        }
                        catch (NullPointerException e) {
                            e.printStackTrace();
                            System.out.println("Aqui tambien se caia esta mierda...");
                            continue;
                        }
                        finally {
                            try {
                                bufferIn.close();
                                bufferIn = null;
                                builder = null;
                                doc = null;
                                InfoSocket.closeChannel((SocketChannel)channel);
                                InfoSocket.setBufferTmp((SocketChannel)channel, null);
                                InfoSocket.setBufferTmp((SocketChannel)channel, (ByteArrayOutputStream)new ByteArrayOutputStream());
                            }
                            catch (NullPointerException e) {
                                e.printStackTrace();
                                System.out.println("Aqui se caia esta mierda...");
                            }
                        }
                    }
                    if (numRead != -1) continue;
                    InfoSocket.getBufferTmp((SocketChannel)channel).close();
                    channel.close();
                    return;
                }
            }
            catch (ClosedChannelException numRead) {
            }
            catch (IOException numRead) {
            }
            catch (NullPointerException e) {
                System.out.println("Registro NullPointer de caida al leer infoSocket " + e.getMessage());
            }
        }
    }
}

