/*
 * Decompiled with CFR 0.152.
 */
package server.comunications;

import common.comunications.InfoSocket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;
import server.comunications.SocketConnectorServer;
import server.control.HeadersValidator;

public class SocketWriterServer {
    public static int maxClosed = 0;
    private static ByteBuffer myAppData;
    private static ByteBuffer myNetData;
    private static ByteBuffer peerAppData;
    private static ByteBuffer peerNetData;
    private static ExecutorService executor;
    public static int flag;

    public static boolean writing(SocketChannel sock, Document doc, boolean flags) {
        SSLEngine engine = SocketConnectorServer.getEngine();
        if (engine != null) {
            return SocketWriterServer.writing(sock, engine, doc);
        }
        return SocketWriterServer.writingPlainSocket(sock, doc, flags);
    }

    public static boolean writing(SocketChannel sock, Document doc) {
        SSLEngine engine = SocketConnectorServer.getEngine();
        if (engine != null) {
            return SocketWriterServer.writing(sock, engine, doc);
        }
        return SocketWriterServer.writingPlainSocket(sock, doc, true);
    }

    public static void writing(SocketChannel sock, String data) {
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(data.getBytes());
        SSLEngine engine = SocketConnectorServer.getEngine();
        if (engine != null) {
            SocketWriterServer.sendBuffer(sock, engine, bufferIn);
        } else {
            SocketWriterServer.sendBuffer(sock, bufferIn, null);
        }
    }

    public static void writing(SocketChannel sock, ByteArrayOutputStream data, String flags) {
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(data.toByteArray());
        SSLEngine engine = SocketConnectorServer.getEngine();
        if (engine != null) {
            SocketWriterServer.sendBuffer(sock, engine, bufferIn);
        } else {
            try {
                ByteBuffer bflags = ByteBuffer.wrap(flags.getBytes("UTF-8"));
                SocketWriterServer.sendBuffer(sock, bufferIn, bflags);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getFlag() {
        String sflag = null;
        flag = flag > 999 ? 0 : ++flag;
        sflag = "000" + flag;
        sflag = sflag.substring(sflag.length() - 3);
        char f = '\u0007';
        sflag = String.valueOf(f) + sflag;
        return sflag;
    }

    public static boolean writingPlainSocket(SocketChannel sock, Document doc, boolean flags) {
        try {
            String sflag = SocketWriterServer.getFlag();
            ByteBuffer bflags = ByteBuffer.wrap(sflag.getBytes("UTF-8"));
            ByteArrayOutputStream bufferOut = new ByteArrayOutputStream();
            XMLOutputter xmlOutputter = new XMLOutputter();
            xmlOutputter.output(doc, (OutputStream)bufferOut);
            bufferOut.write(new String("\f").getBytes());
            ByteArrayInputStream bufferIn = new ByteArrayInputStream(bufferOut.toByteArray());
            bufferOut.close();
            bufferOut = null;
            SSLEngine engine = SocketConnectorServer.getEngine();
            if (engine != null) {
                return SocketWriterServer.sendBuffer(sock, engine, bufferIn);
            }
            if (flags) {
                return SocketWriterServer.sendBuffer(sock, bufferIn, bflags);
            }
            return SocketWriterServer.sendBuffer(sock, bufferIn, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (ClosedChannelException e) {
            try {
                String bd = InfoSocket.getBd((SocketChannel)sock);
                String login = InfoSocket.getLoging((SocketChannel)sock);
                String ip = InfoSocket.getIp((SocketChannel)sock);
                String mac = InfoSocket.getMac((SocketChannel)sock);
                Socket clientInfo = sock.socket();
                HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                InfoSocket.removeSock((SocketChannel)sock);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean writing(SocketChannel sock, SSLEngine engine, Document doc) {
        try {
            SSLSession session = engine.getSession();
            myAppData = ByteBuffer.allocate(1024);
            myNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            peerAppData = ByteBuffer.allocate(1024);
            peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            myAppData.clear();
            ByteArrayOutputStream bufferOut = new ByteArrayOutputStream();
            XMLOutputter xmlOutputter = new XMLOutputter();
            xmlOutputter.output(doc, (OutputStream)bufferOut);
            bufferOut.write(new String("\f").getBytes());
            myAppData.put(bufferOut.toByteArray());
            myAppData.flip();
            block8: while (myAppData.hasRemaining()) {
                myNetData.clear();
                SSLEngineResult result = engine.wrap(myAppData, myNetData);
                switch (result.getStatus()) {
                    case OK: {
                        myNetData.flip();
                        while (myNetData.hasRemaining()) {
                            sock.write(myNetData);
                        }
                        continue block8;
                    }
                    case BUFFER_OVERFLOW: {
                        myNetData = SocketWriterServer.enlargePacketBuffer(engine, myNetData);
                        continue block8;
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                    }
                    case CLOSED: {
                        SocketWriterServer.closeConnection(sock, engine);
                        return false;
                    }
                }
                throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void closeConnection(SocketChannel socketChannel, SSLEngine engine) throws IOException {
        engine.closeOutbound();
        SocketWriterServer.doHandshake(socketChannel, engine);
        socketChannel.close();
    }

    public static ByteBuffer enlargePacketBuffer(SSLEngine engine, ByteBuffer buffer) {
        return SocketWriterServer.enlargeBuffer(buffer, engine.getSession().getPacketBufferSize());
    }

    public static ByteBuffer enlargeApplicationBuffer(SSLEngine engine, ByteBuffer buffer) {
        return SocketWriterServer.enlargeBuffer(buffer, engine.getSession().getApplicationBufferSize());
    }

    public static ByteBuffer enlargeBuffer(ByteBuffer buffer, int sessionProposedCapacity) {
        buffer = sessionProposedCapacity > buffer.capacity() ? ByteBuffer.allocate(sessionProposedCapacity) : ByteBuffer.allocate(buffer.capacity() * 2);
        return buffer;
    }

    public static boolean doHandshake(SocketChannel socketChannel, SSLEngine engine) throws IOException {
        System.out.println("About to do handshake...");
        int appBufferSize = engine.getSession().getApplicationBufferSize();
        ByteBuffer myAppData = ByteBuffer.allocate(appBufferSize);
        ByteBuffer peerAppData = ByteBuffer.allocate(appBufferSize);
        myNetData.clear();
        peerNetData.clear();
        SSLEngineResult.HandshakeStatus handshakeStatus = engine.getHandshakeStatus();
        block27: while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    SSLEngineResult result;
                    if (socketChannel.read(peerNetData) < 0) {
                        if (engine.isInboundDone() && engine.isOutboundDone()) {
                            return false;
                        }
                        try {
                            engine.closeInbound();
                        }
                        catch (SSLException e) {
                            System.out.println("This engine was forced to close inbound, without having received the proper SSL/TLS close notification message from the peer, due to end of stream.");
                        }
                        engine.closeOutbound();
                        handshakeStatus = engine.getHandshakeStatus();
                        continue block27;
                    }
                    peerNetData.flip();
                    try {
                        result = engine.unwrap(peerNetData, peerAppData);
                        peerNetData.compact();
                        handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException sslException) {
                        System.out.println("A problem was encountered while processing the data that caused the SSLEngine to abort. Will try to properly close connection...");
                        engine.closeOutbound();
                        handshakeStatus = engine.getHandshakeStatus();
                        continue block27;
                    }
                    switch (result.getStatus()) {
                        case OK: {
                            continue block27;
                        }
                        case BUFFER_OVERFLOW: {
                            peerAppData = SocketWriterServer.enlargeApplicationBuffer(engine, peerAppData);
                            continue block27;
                        }
                        case BUFFER_UNDERFLOW: {
                            peerNetData = SocketWriterServer.handleBufferUnderflow(engine, peerNetData);
                            continue block27;
                        }
                        case CLOSED: {
                            if (engine.isOutboundDone()) {
                                return false;
                            }
                            engine.closeOutbound();
                            handshakeStatus = engine.getHandshakeStatus();
                            continue block27;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
                case NEED_WRAP: {
                    SSLEngineResult result;
                    myNetData.clear();
                    try {
                        result = engine.wrap(myAppData, myNetData);
                        handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException sslException) {
                        System.out.println("A problem was encountered while processing the data that caused the SSLEngine to abort. Will try to properly close connection...");
                        engine.closeOutbound();
                        handshakeStatus = engine.getHandshakeStatus();
                        continue block27;
                    }
                    switch (result.getStatus()) {
                        case OK: {
                            myNetData.flip();
                            while (myNetData.hasRemaining()) {
                                socketChannel.write(myNetData);
                            }
                            continue block27;
                        }
                        case BUFFER_OVERFLOW: {
                            myNetData = SocketWriterServer.enlargePacketBuffer(engine, myNetData);
                            continue block27;
                        }
                        case BUFFER_UNDERFLOW: {
                            throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                        }
                        case CLOSED: {
                            try {
                                myNetData.flip();
                                while (myNetData.hasRemaining()) {
                                    socketChannel.write(myNetData);
                                }
                                peerNetData.clear();
                            }
                            catch (Exception e) {
                                System.out.println("Failed to send server's CLOSE message due to socket channel's failure.");
                                handshakeStatus = engine.getHandshakeStatus();
                            }
                            continue block27;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = engine.getDelegatedTask()) != null) {
                        executor.execute(task);
                    }
                    handshakeStatus = engine.getHandshakeStatus();
                    continue block27;
                }
                case FINISHED: {
                    continue block27;
                }
                case NOT_HANDSHAKING: {
                    continue block27;
                }
            }
            throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)handshakeStatus));
        }
        return true;
    }

    public static boolean sendBuffer(SocketChannel sock, SSLEngine engine, ByteArrayInputStream buffer) {
        try {
            SSLSession session = engine.getSession();
            myAppData = ByteBuffer.allocate(1024);
            myNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            peerAppData = ByteBuffer.allocate(1024);
            peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            int count = 0;
            while (count >= 0) {
                myAppData.clear();
                byte[] bytes = new byte[1024];
                count = buffer.read(bytes);
                for (int i = 0; i < count; ++i) {
                    myAppData.put(bytes[i]);
                }
                myAppData.flip();
                block10: while (myAppData.hasRemaining()) {
                    myNetData.clear();
                    SSLEngineResult result = engine.wrap(myAppData, myNetData);
                    switch (result.getStatus()) {
                        case OK: {
                            myNetData.flip();
                            while (myNetData.hasRemaining()) {
                                sock.write(myNetData);
                            }
                            continue block10;
                        }
                        case BUFFER_OVERFLOW: {
                            myNetData = SocketWriterServer.enlargePacketBuffer(engine, myNetData);
                            continue block10;
                        }
                        case BUFFER_UNDERFLOW: {
                            throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                        }
                        case CLOSED: {
                            SocketWriterServer.closeConnection(sock, engine);
                            return false;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean sendBuffer(SocketChannel sock, ByteArrayInputStream buffer, ByteBuffer flags) {
        try {
            ByteBuffer buf = ByteBuffer.allocate(8192);
            byte[] bytes = new byte[8192];
            int count = 0;
            while (count >= 0) {
                buf.clear();
                count = buffer.read(bytes);
                for (int i = 0; i < count; ++i) {
                    buf.put(bytes[i]);
                }
                buf.flip();
                ByteBuffer lastBuf = ByteBuffer.allocate(8192);
                ByteBuffer sameBuf = ByteBuffer.allocate(8192);
                int repeat = 0;
                while (buf.remaining() > 0) {
                    lastBuf = buf;
                    if (flags != null) {
                        sock.write(flags);
                    }
                    sock.write(buf);
                    if (buf.remaining() <= 0) continue;
                    try {
                        Thread.sleep(150L);
                        if (sameBuf.equals(lastBuf)) {
                            System.out.println("mismo paquete " + repeat + " veces, buffer sin enviar: " + buf.remaining());
                            if (++repeat % 10 == 0) {
                                System.out.println("Esperando reestablecer la comunicacion...");
                                Thread.sleep(2000L);
                            }
                            if (repeat > 100) {
                                System.out.println("cerrando socket por problemas de escritura ");
                                String bd = InfoSocket.getBd((SocketChannel)sock);
                                String login = InfoSocket.getLoging((SocketChannel)sock);
                                String ip = InfoSocket.getIp((SocketChannel)sock);
                                String mac = InfoSocket.getMac((SocketChannel)sock);
                                Socket clientInfo = sock.socket();
                                HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                                InfoSocket.removeSock((SocketChannel)sock);
                                return false;
                            }
                        }
                        sameBuf = lastBuf;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (buf.remaining() <= 0) continue;
                System.out.println("Se cancelo escritura por problemas con el socket y se cerrara");
                String bd = InfoSocket.getBd((SocketChannel)sock);
                String login = InfoSocket.getLoging((SocketChannel)sock);
                String ip = InfoSocket.getIp((SocketChannel)sock);
                String mac = InfoSocket.getMac((SocketChannel)sock);
                Socket clientInfo = sock.socket();
                HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                InfoSocket.removeSock((SocketChannel)sock);
                return false;
            }
            return true;
        }
        catch (NotYetConnectedException NYCEe) {
            System.out.println("El canal no tiene enlace de conexion");
            NYCEe.printStackTrace();
            try {
                String bd = InfoSocket.getBd((SocketChannel)sock);
                String login = InfoSocket.getLoging((SocketChannel)sock);
                String ip = InfoSocket.getIp((SocketChannel)sock);
                String mac = InfoSocket.getMac((SocketChannel)sock);
                Socket clientInfo = sock.socket();
                HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                InfoSocket.removeSock((SocketChannel)sock);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            System.out.println("retornando falso por notYet");
            return false;
        }
        catch (ClosedByInterruptException CBIEe) {
            System.out.println("El canal fue interrumpido y se cerro mientras escribia");
            CBIEe.printStackTrace();
            try {
                if (InfoSocket.isNotNull((SocketChannel)sock)) {
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    String login = InfoSocket.getLoging((SocketChannel)sock);
                    String ip = InfoSocket.getIp((SocketChannel)sock);
                    String mac = InfoSocket.getMac((SocketChannel)sock);
                    Socket clientInfo = sock.socket();
                    HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                    InfoSocket.removeSock((SocketChannel)sock);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        catch (AsynchronousCloseException ACEe) {
            System.out.println("El canal fue cerrado mientras escribia");
            ACEe.printStackTrace();
            try {
                if (InfoSocket.isNotNull((SocketChannel)sock)) {
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    String login = InfoSocket.getLoging((SocketChannel)sock);
                    String ip = InfoSocket.getIp((SocketChannel)sock);
                    String mac = InfoSocket.getMac((SocketChannel)sock);
                    Socket clientInfo = sock.socket();
                    HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                    InfoSocket.removeSock((SocketChannel)sock);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        catch (ClosedChannelException e) {
            System.out.println("se a perdido la conexion y el canal estaba cerrado");
            System.out.println("eliminando canal");
            try {
                if (InfoSocket.isNotNull((SocketChannel)sock)) {
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    String login = InfoSocket.getLoging((SocketChannel)sock);
                    String ip = InfoSocket.getIp((SocketChannel)sock);
                    String mac = InfoSocket.getMac((SocketChannel)sock);
                    Socket clientInfo = sock.socket();
                    HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                    InfoSocket.removeSock((SocketChannel)sock);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        catch (IOException e) {
            System.out.println("Error de entrada y salida en escritura de socket socket close");
            e.printStackTrace();
            try {
                if (InfoSocket.isNotNull((SocketChannel)sock)) {
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    String login = InfoSocket.getLoging((SocketChannel)sock);
                    String ip = InfoSocket.getIp((SocketChannel)sock);
                    String mac = InfoSocket.getMac((SocketChannel)sock);
                    Socket clientInfo = sock.socket();
                    HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                    InfoSocket.removeSock((SocketChannel)sock);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            System.out.println("aqui lo cerre...");
            SocketConnectorServer.closeSocket();
            return false;
        }
    }

    public static ByteBuffer handleBufferUnderflow(SSLEngine engine, ByteBuffer buffer) {
        if (buffer.position() < buffer.limit()) {
            return buffer;
        }
        ByteBuffer replaceBuffer = SocketWriterServer.enlargePacketBuffer(engine, buffer);
        buffer.flip();
        replaceBuffer.put(buffer);
        return replaceBuffer;
    }

    static {
        executor = Executors.newSingleThreadExecutor();
        flag = 0;
    }
}

