/*
 * Decompiled with CFR 0.152.
 */
package server.comunications.ssl;

import common.comunications.InfoSocket;
import common.comunications.SocketConnector;
import common.comunications.ssl.NioSslPeer;
import common.misc.language.Language;
import common.misc.log.LogAdmin;
import common.misc.settings.ServerConfigFileHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.security.SecureRandom;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import server.control.HeadersValidator;

public class NioSslServer
extends NioSslPeer {
    private static Document doc;
    private boolean active;
    private SSLContext context;
    private Selector selector;
    private SSLSession session;

    public NioSslServer(String protocol, String hostAddress, int port) throws Exception {
        this.context = SSLContext.getInstance(protocol);
        this.context.init(this.createKeyManagers("/home/felipe/resources/emakuserver.jks", "dfaf0831", "Gr@m@2016"), this.createTrustManagers("/home/felipe/resources/emakutrust.jks", "dfaf0831"), new SecureRandom());
        System.out.println("Cargando firmas ");
        this.session = this.context.createSSLEngine().getSession();
        this.myAppData = ByteBuffer.allocate(this.session.getApplicationBufferSize());
        this.myNetData = ByteBuffer.allocate(this.session.getPacketBufferSize());
        this.peerAppData = ByteBuffer.allocate(this.session.getApplicationBufferSize());
        this.peerNetData = ByteBuffer.allocate(this.session.getPacketBufferSize());
        this.session.invalidate();
        this.selector = SelectorProvider.provider().openSelector();
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.configureBlocking(false);
        serverSocketChannel.socket().bind(new InetSocketAddress(hostAddress, port));
        serverSocketChannel.register(this.selector, 16);
        this.active = true;
        this.work();
    }

    public void work() throws Exception {
        LogAdmin.setMessage((String)(Language.getWord((String)"SOCKET_SERVER_OPEN") + " SSL " + ServerConfigFileHandler.getClientSocket()), (int)2);
        while (this.isActive()) {
            this.selector.select();
            Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
            while (selectedKeys.hasNext()) {
                SelectionKey key = selectedKeys.next();
                selectedKeys.remove();
                if (!key.isValid()) continue;
                if (key.isAcceptable()) {
                    this.accept(key);
                    continue;
                }
                if (!key.isReadable()) continue;
                this.read((SocketChannel)key.channel(), (SSLEngine)key.attachment());
            }
        }
    }

    public void stop() {
        System.out.println("Will now close server...");
        this.active = false;
        this.executor.shutdown();
        this.selector.wakeup();
    }

    private void accept(SelectionKey key) throws Exception {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        socketChannel.configureBlocking(false);
        LogAdmin.setMessage((String)(Language.getWord((String)"NEW_SOCKET_CLIENT SSL") + " " + socketChannel.socket() + " " + InfoSocket.setIncrementSocketsCount()), (int)2);
        SSLEngine engine = this.context.createSSLEngine();
        SocketConnector.setEngine((SSLEngine)engine);
        engine.setUseClientMode(false);
        engine.beginHandshake();
        if (this.doHandshake(socketChannel, engine)) {
            socketChannel.register(this.selector, 1, engine);
        } else {
            socketChannel.close();
            LogAdmin.setMessage((String)("Coneccion cerrada por fallo y handshake " + socketChannel.socket() + " " + InfoSocket.setIncrementSocketsCount()), (int)2);
        }
        if (InfoSocket.getSocketsCount() < ServerConfigFileHandler.getMaxClients()) {
            InfoSocket.put((SocketChannel)socketChannel, (InfoSocket)new InfoSocket(socketChannel.socket()));
            LogAdmin.setMessage((String)(Language.getWord((String)"NEW_SOCKET_CLIENT") + " " + socketChannel.socket() + " " + InfoSocket.setIncrementSocketsCount()), (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(SocketChannel socketChannel, SSLEngine engine) {
        SocketChannel socketChannel2 = socketChannel;
        synchronized (socketChannel2) {
            try {
                this.peerNetData.clear();
                int bytesRead = socketChannel.read(this.peerNetData);
                if (bytesRead > 0) {
                    this.peerNetData.flip();
                    block11: while (this.peerNetData.hasRemaining()) {
                        this.peerAppData = ByteBuffer.allocate(this.session.getApplicationBufferSize());
                        SSLEngineResult result = engine.unwrap(this.peerNetData, this.peerAppData);
                        switch (result.getStatus()) {
                            case OK: {
                                this.peerAppData.flip();
                                this.readXML(bytesRead, socketChannel, this.peerAppData.array());
                                continue block11;
                            }
                            case BUFFER_OVERFLOW: {
                                this.peerAppData = this.enlargeApplicationBuffer(engine, this.peerAppData);
                                continue block11;
                            }
                            case BUFFER_UNDERFLOW: {
                                this.peerNetData = this.handleBufferUnderflow(engine, this.peerNetData);
                                continue block11;
                            }
                            case CLOSED: {
                                System.out.println("Client wants to close connection...");
                                this.closeConnection(socketChannel, engine);
                                System.out.println("Goodbye client!");
                                return;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                    }
                } else if (bytesRead < 0) {
                    System.out.println("Received end of stream. Will try to close connection with client...");
                    this.handleEndOfStream(socketChannel, engine);
                    System.out.println("Goodbye client!");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXML(int bytesRead, SocketChannel channel, byte[] readBuffer) {
        int i;
        SAXBuilder builder = null;
        ByteArrayInputStream bufferIn = null;
        try {
            for (i = 0; i < readBuffer.length; ++i) {
                byte character = readBuffer[i];
                if (character != 12) {
                    if (character != 0) {
                        InfoSocket.getBufferTmp((SocketChannel)channel).write(readBuffer[i]);
                        continue;
                    }
                    break;
                }
                builder = new SAXBuilder();
                bufferIn = new ByteArrayInputStream(InfoSocket.getBufferTmp((SocketChannel)channel).toByteArray());
                doc = builder.build((InputStream)bufferIn);
                if (channel.socket().getLocalPort() == ServerConfigFileHandler.getAdminSocket()) {
                    HeadersValidator.ValidAdmin(doc, channel);
                    continue;
                }
                HeadersValidator.ValidClient(doc, channel);
            }
        }
        catch (JDOMException e1) {
            String tmp = Language.getWord((String)"ERR_FORMAT_PROTOCOL") + " " + channel.socket();
            LogAdmin.setMessage((String)("\n------- " + i + " -------------\n" + tmp + "\n" + new String(InfoSocket.getBufferTmp((SocketChannel)channel).toByteArray()) + "\n------------------\n"), (int)0);
            e1.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            System.out.println("Aqui tambien se caia esta mierda...");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException IOEe) {
            IOEe.printStackTrace();
        }
        finally {
            try {
                bufferIn.close();
                bufferIn = null;
                builder = null;
                doc = null;
                InfoSocket.getBufferTmp((SocketChannel)channel).close();
                InfoSocket.setBufferTmp((SocketChannel)channel, null);
                InfoSocket.setBufferTmp((SocketChannel)channel, (ByteArrayOutputStream)new ByteArrayOutputStream());
            }
            catch (NullPointerException e1) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void write(SocketChannel socketChannel, SSLEngine engine, String message) throws IOException {
        this.myAppData.clear();
        this.myAppData.put(message.getBytes());
        this.myAppData.flip();
        block6: while (this.myAppData.hasRemaining()) {
            this.myNetData.clear();
            SSLEngineResult result = engine.wrap(this.myAppData, this.myNetData);
            switch (result.getStatus()) {
                case OK: {
                    this.myNetData.flip();
                    while (this.myNetData.hasRemaining()) {
                        socketChannel.write(this.myNetData);
                    }
                    System.out.println("Message sent to the client: " + message);
                    continue block6;
                }
                case BUFFER_OVERFLOW: {
                    this.myNetData = this.enlargePacketBuffer(engine, this.myNetData);
                    continue block6;
                }
                case BUFFER_UNDERFLOW: {
                    throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                }
                case CLOSED: {
                    this.closeConnection(socketChannel, engine);
                    return;
                }
            }
            throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
        }
    }

    private boolean isActive() {
        return this.active;
    }
}

