/*
 * Decompiled with CFR 0.152.
 */
package server.control;

import common.comunications.InfoSocket;
import common.misc.language.Language;
import common.misc.log.LogAdmin;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.businessrules.LNGenericSQL;
import server.businessrules.LNInventarios;
import server.businessrules.RunTransaction;
import server.businessrules.electronicdocuments.GetNumberingRange;
import server.comunications.AcpFailure;
import server.comunications.CacheXML;
import server.comunications.ErrorXML;
import server.comunications.ResultSetToXML;
import server.comunications.SocketWriterServer;
import server.comunications.WStoXML;
import server.control.ACPSender;
import server.control.DATESender;
import server.control.QueryValidator;
import server.control.UPDATECODESender;
import server.control.UserDataStructure;
import server.database.caches.WebServicesCaches;
import server.database.connection.ConnectionsPool;
import server.database.sql.AccountsTotalCalculator;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import server.printer.ServerPrinter;
import server.reports.ReportMaker;
import server.reports.XLSReportMaker;
import server.webserver.rndc.RequestRNDC;

public class HeadersValidator {
    private static final int MAIL_PRINTER = 0;
    private static final int RETURN_PDF_PRINTER = 1;
    private static final int SAVE_PRINT_ON_SERVER = 3;
    public static final int DESKTOP_CONNECTION = 1;
    public static final int MOVIL_CONNECTION = 2;
    public static final int CLOSE_SESSION = 3;
    public static final int SHUTDOWN_CONNECTION = 4;
    public static final int RECONNECT = 5;
    public static final int SHUTDOWN_INACTIVITY = 6;
    public static final int SHUTDOWN_SERVER = 7;
    public static final byte[] KEY = "QUIEROUNMERCEDESAMG".getBytes();
    public static Document pong = new Document().setRootElement(new Element("PONG"));

    public static void ValidClient(Document doc, SocketChannel sock) {
        Element raiz;
        block112: {
            raiz = doc.getRootElement();
            String nom_raiz = raiz.getName();
            if (InfoSocket.isLoged((SocketChannel)sock)) {
                if (nom_raiz.equals("TRANSACTION")) {
                    System.out.println("Paquete TRANSACCION");
                    XMLOutputter xmlOutputter = new XMLOutputter();
                    xmlOutputter.setFormat(Format.getPrettyFormat());
                    try {
                        xmlOutputter.output(doc, (OutputStream)System.out);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    new RunTransaction(sock, doc).start();
                } else if (nom_raiz.equals("GET-WEBSERVICE")) {
                    String codigo;
                    String user;
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    if (WebServicesCaches.accessVerification(bd, user = InfoSocket.getLoging((SocketChannel)sock), codigo = raiz.getChild("ws").getValue())) {
                        try {
                            XMLOutputter xmlOutputter = new XMLOutputter();
                            xmlOutputter.setFormat(Format.getPrettyFormat());
                            xmlOutputter.output(doc, (OutputStream)System.out);
                            WStoXML wstoxml = new WStoXML(bd, codigo, doc, sock);
                            new Thread(wstoxml).start();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        ErrorXML error = new ErrorXML();
                        String message = "Permiso denegado para ejecutar el webservices " + codigo + " " + sock.socket();
                        LogAdmin.setMessage((String)message, (int)2);
                        SocketWriterServer.writing(sock, error.returnError(0, bd, user, message));
                    }
                } else if (nom_raiz.equals("QUERY")) {
                    String jwt = raiz.getChild("jwt").getValue();
                    String codigo = null;
                    String bd = null;
                    String login = null;
                    String ip = null;
                    String mac = null;
                    try {
                        Claims claim = HeadersValidator.validToken(jwt);
                        bd = (String)claim.get((Object)"bd");
                        login = (String)claim.get((Object)"login");
                        ip = (String)claim.get((Object)"ip");
                        mac = (String)claim.get((Object)"mac");
                        QueryValidator valida = new QueryValidator(bd, login, raiz);
                        codigo = raiz.getChild("sql").getValue();
                        if (codigo.equals("WSSCSSEL1")) {
                            valida.isValid();
                            GetNumberingRange getNumberingRange = new GetNumberingRange(bd, sock, valida.getId());
                            new Thread(getNumberingRange).start();
                            break block112;
                        }
                        if (valida.isValid()) {
                            ResultSetToXML answer = valida.changeStructParam() ? new ResultSetToXML(bd, codigo, valida.getArgs(), sock, valida.getId()) : new ResultSetToXML(bd, codigo, sock, valida.getId());
                            System.out.println("LLEGO QUERY .......");
                            new Thread(answer).start();
                            break block112;
                        }
                        ErrorXML error = new ErrorXML();
                        String tmp = Language.getWord((String)"SQL_ACCESS_DENIED") + " " + valida.getQuery() + " " + sock.socket();
                        LogAdmin.setMessage((String)tmp, (int)2);
                        SocketWriterServer.writing(sock, error.returnError(0, bd, valida.getId(), tmp));
                    }
                    catch (SignatureException e) {
                        ErrorXML error = new ErrorXML();
                        String message = "Token invalido para ejecutar la sentencia " + codigo + " " + sock.socket();
                        LogAdmin.setMessage((String)message, (int)2);
                        SocketWriterServer.writing(sock, error.returnError(0, bd, login, message));
                    }
                    catch (ExpiredJwtException e) {
                        ErrorXML error = new ErrorXML();
                        String message = "Sesion expirada, por favor salga y vuelva a ingresar al aplicativo " + codigo + " " + sock.socket();
                        LogAdmin.setMessage((String)message, (int)2);
                        SocketWriterServer.writing(sock, error.returnError(0, bd, login, message));
                    }
                } else if (nom_raiz.equals("CACHE-QUERY")) {
                    String codigo = raiz.getValue();
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    CacheXML cache_answer = new CacheXML(bd, codigo);
                    cache_answer.transmition(sock);
                } else if (nom_raiz.equals("RELOADDATA")) {
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    String transaction = null;
                    String sqlCode = null;
                    Element elm = raiz.getChild("package");
                    for (Element e : elm.getChildren()) {
                        if (e.getAttributeValue("attribute").equals("sentence")) {
                            sqlCode = e.getValue();
                            continue;
                        }
                        if (!e.getAttributeValue("attribute").equals("transaction")) continue;
                        transaction = e.getValue();
                    }
                    try {
                        if (sqlCode != null) {
                            LinkingCache.setSentenciaSQL(bd, sqlCode);
                        }
                        if (transaction != null) {
                            LinkingCache.reloadTransaction(bd, transaction);
                            Iterator keys = InfoSocket.getSocketKeys();
                            while (keys.hasNext()) {
                                SocketChannel sockConnection = (SocketChannel)keys.next();
                                String bdSocket = InfoSocket.getBd((SocketChannel)sockConnection);
                                if (!bdSocket.equals(bd)) continue;
                                String loginSocket = InfoSocket.getLoging((SocketChannel)sockConnection);
                                ACPSender docacp = new ACPSender(sockConnection, null, bd, loginSocket, transaction);
                                docacp.start();
                            }
                        }
                        RunTransaction.successMessage(sock, "T-756", "Parametrizaciones actualizadas");
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    catch (SQLNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (SQLBadArgumentsException e) {
                        e.printStackTrace();
                    }
                } else if (nom_raiz.equals("DATE")) {
                    SocketWriterServer.writing(sock, DATESender.getPackage());
                } else if (nom_raiz.equals("PING")) {
                    SocketWriterServer.writing(sock, pong);
                } else if (nom_raiz.endsWith("TOTALACCOUNT")) {
                    new AccountsTotalCalculator(InfoSocket.getBd((SocketChannel)sock), raiz);
                } else if (nom_raiz.equals("UPDATECODE")) {
                    final String bd = InfoSocket.getBd((SocketChannel)sock);
                    String key = raiz.getChild("idDocument").getValue();
                    System.out.println("Solicitud de updateCode desde el ST para " + key);
                    final Document pack_update = UPDATECODESender.getPackage(key, LinkingCache.getConsecutive(bd, key), null);
                    Hashtable clientes = InfoSocket.getHchannelclients();
                    final Enumeration sockets = clientes.keys();
                    new Thread(){

                        @Override
                        public void run() {
                            while (sockets.hasMoreElements()) {
                                SocketChannel sock = (SocketChannel)sockets.nextElement();
                                if (!bd.equals(InfoSocket.getBd((SocketChannel)sock)) || !InfoSocket.isTransactional((SocketChannel)sock)) continue;
                                SocketWriterServer.writing(sock, pack_update);
                            }
                        }
                    }.start();
                } else if (nom_raiz.equals("JEXCELREPORTREQUEST")) {
                    System.out.println("Nueva solicitud de un reporte excel de Jasper");
                    new ReportMaker(raiz, sock, true, false).start();
                } else if (nom_raiz.equals("REPORTREQUEST") || nom_raiz.equals("EMBEDDEDREPORTREQUEST")) {
                    System.out.println("Nueva solicitud de un reporte");
                    XMLOutputter xmlOutputter = new XMLOutputter();
                    xmlOutputter.setFormat(Format.getPrettyFormat());
                    try {
                        xmlOutputter.output(doc, (OutputStream)System.out);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    new ReportMaker(raiz, sock, false, false).start();
                } else if (nom_raiz.equals("EMAILREPORTREQUEST")) {
                    System.out.println("Nueva solicitud de un reporte para correo electronico");
                    XMLOutputter xmlOutputter = new XMLOutputter();
                    xmlOutputter.setFormat(Format.getPrettyFormat());
                    try {
                        xmlOutputter.output(doc, (OutputStream)System.out);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    new ReportMaker(raiz, sock, false, true).start();
                } else if (nom_raiz.equals("MAILPRINTER")) {
                    System.out.println("recibiendo mail...");
                    new ServerPrinter(0, raiz, sock);
                } else if (nom_raiz.equals("RNDC-WS")) {
                    XMLOutputter xmlOutputter = new XMLOutputter();
                    xmlOutputter.setFormat(Format.getPrettyFormat());
                    try {
                        xmlOutputter.output(doc, (OutputStream)System.out);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    new RequestRNDC(raiz, sock).start();
                } else if (nom_raiz.equals("SAVEPRINTONSERVER")) {
                    System.out.println("recibiendo para guardar copia en server");
                    System.out.println("Paquete TRANSACCION");
                    XMLOutputter xmlOutputter = new XMLOutputter();
                    xmlOutputter.setFormat(Format.getPrettyFormat());
                    try {
                        xmlOutputter.output(doc, (OutputStream)System.out);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    String nitcc = LinkingCache.getNit(bd);
                    new ServerPrinter(3, raiz, sock, nitcc);
                } else if (nom_raiz.equals("SERVERPRINTER")) {
                    new ServerPrinter(1, raiz, sock);
                } else if ("XLSREPORTREQUEST".equals(nom_raiz)) {
                    new XLSReportMaker(raiz, sock);
                } else if (nom_raiz.equals("DCNX")) {
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    String login = InfoSocket.getLoging((SocketChannel)sock);
                    String ip = InfoSocket.getIp((SocketChannel)sock);
                    String mac = InfoSocket.getMac((SocketChannel)sock);
                    Socket clientInfo = sock.socket();
                    HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 3);
                    try {
                        InfoSocket.removeSock((SocketChannel)sock);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    ErrorXML error = new ErrorXML();
                    String tmp = Language.getWord((String)"ERR_FORMAT_PROTOCOL") + " " + sock.socket();
                    LogAdmin.setMessage((String)tmp, (int)0);
                    System.out.println("ERROR FORMATO PROTOCOLO");
                    XMLOutputter xmlOutputter = new XMLOutputter();
                    xmlOutputter.setFormat(Format.getPrettyFormat());
                    try {
                        xmlOutputter.output(doc, (OutputStream)System.out);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    SocketWriterServer.writing(sock, error.returnError(0, "", tmp));
                }
            } else if (nom_raiz.equals("CNX")) {
                System.out.println("CNX..." + raiz.getChild("db").getValue());
                if (ConnectionsPool.chekDataBase(raiz.getChild("db").getValue())) {
                    UserDataStructure loguser = new UserDataStructure(raiz);
                    if (loguser.valid()) {
                        String bd = loguser.getBD();
                        String login = loguser.getLogin();
                        String ip = loguser.getIp();
                        String mac = loguser.getMac();
                        System.out.println("ip: " + ip);
                        System.out.println("mac: " + mac);
                        InfoSocket.setLogin((SocketChannel)sock, (String)bd, (String)login, (String)ip, (String)mac);
                        Socket clientInfo = sock.socket();
                        HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 1);
                        String jwt = HeadersValidator.issueToken(bd, login, ip, mac);
                        ACPSender docacp = new ACPSender(sock, jwt, bd, login);
                        docacp.start();
                    } else {
                        SocketWriterServer.writing(sock, new AcpFailure(Language.getWord((String)"ACPFAILURE")));
                    }
                } else {
                    LogAdmin.setMessage((String)(Language.getWord((String)"DBNFEX") + raiz.getChild("db").getValue()), (int)0);
                    SocketWriterServer.writing(sock, new AcpFailure(Language.getWord((String)"ACPFAILURE")));
                }
            } else if (nom_raiz.equals("MCNX")) {
                System.out.println("conexion movil...");
                if (ConnectionsPool.chekDataBase(raiz.getChild("db").getValue())) {
                    UserDataStructure loguser = new UserDataStructure(raiz);
                    if (loguser.valid()) {
                        System.out.println("logeado...");
                        String bd = loguser.getBD();
                        String login = loguser.getLogin();
                        String ip = loguser.getIp();
                        String mac = loguser.getMac();
                        InfoSocket.setLogin((SocketChannel)sock, (String)bd, (String)login, (String)ip, (String)mac);
                        Socket clientInfo = sock.socket();
                        HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 2);
                        String jwt = HeadersValidator.issueToken(bd, login, ip, mac);
                        ACPSender docacp = new ACPSender(sock, jwt, bd, login, true);
                        docacp.start();
                    } else {
                        SocketWriterServer.writing(sock, new AcpFailure(Language.getWord((String)"ACPFAILURE")));
                    }
                } else {
                    LogAdmin.setMessage((String)(Language.getWord((String)"DBNFEX") + raiz.getChild("db").getValue()), (int)0);
                    SocketWriterServer.writing(sock, new AcpFailure(Language.getWord((String)"ACPFAILURE")));
                }
            } else if (nom_raiz.equals("RCNX")) {
                System.out.println("Reconectando...");
                if (ConnectionsPool.chekDataBase(raiz.getChild("db").getValue())) {
                    UserDataStructure loguser = new UserDataStructure(raiz);
                    if (loguser.valid()) {
                        String bd = loguser.getBD();
                        String login = loguser.getLogin();
                        String ip = loguser.getIp();
                        String mac = loguser.getMac();
                        InfoSocket.setLogin((SocketChannel)sock, (String)bd, (String)login, (String)ip, (String)mac);
                        Socket clientInfo = sock.socket();
                        HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 5);
                        String jwt = HeadersValidator.issueToken(bd, login, ip, mac);
                    } else {
                        SocketWriterServer.writing(sock, new AcpFailure(Language.getWord((String)"ACPFAILURE")));
                    }
                } else {
                    LogAdmin.setMessage((String)(Language.getWord((String)"DBNFEX") + raiz.getChild("db").getValue()), (int)0);
                    SocketWriterServer.writing(sock, new AcpFailure(Language.getWord((String)"ACPFAILURE")));
                }
            } else if (nom_raiz.equals("RELOADPROD")) {
                if (ConnectionsPool.chekDataBase(raiz.getChild("db").getValue())) {
                    UserDataStructure loguser = new UserDataStructure(raiz);
                    if (loguser.valid()) {
                        String bd = loguser.getBD();
                        String login = loguser.getLogin();
                        String code = loguser.getCode();
                        String ip = loguser.getIp();
                        String mac = loguser.getMac();
                        InfoSocket.setLogin((SocketChannel)sock, (String)bd, (String)login, (String)ip, (String)mac);
                        System.out.println("Recargando producto {" + code + "} en " + raiz.getChild("db").getValue());
                        try {
                            LinkingCache.removeAsientosPr(InfoSocket.getBd((SocketChannel)sock), "SCS0110", new String[]{code});
                            LinkingCache.reloadAsientosPr(InfoSocket.getBd((SocketChannel)sock), "SCS0062", new String[]{code});
                            RunTransaction.successMessage(sock, "T-756", "Actualizacion remota exitosa");
                        }
                        catch (SQLNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (SQLBadArgumentsException e) {
                            e.printStackTrace();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    } else {
                        SocketWriterServer.writing(sock, new AcpFailure(Language.getWord((String)"ACPFAILURE")));
                    }
                } else {
                    LogAdmin.setMessage((String)(Language.getWord((String)"DBNFEX") + raiz.getChild("db").getValue()), (int)0);
                    SocketWriterServer.writing(sock, new AcpFailure(Language.getWord((String)"ACPFAILURE")));
                }
            } else if (nom_raiz.equals("RELOAD")) {
                if (ConnectionsPool.chekDataBase(raiz.getChild("db").getValue())) {
                    UserDataStructure loguser = new UserDataStructure(raiz);
                    if (loguser.valid()) {
                        String bd = loguser.getBD();
                        String login = loguser.getLogin();
                        String tipoDoc = loguser.getTipoDoc();
                        String numero = loguser.getNumero();
                        String ip = loguser.getIp();
                        String mac = loguser.getMac();
                        InfoSocket.setLogin((SocketChannel)sock, (String)bd, (String)login, (String)ip, (String)mac);
                        System.out.println("Voy por reload.. " + raiz.getChild("db").getValue());
                        System.out.println("documento: " + tipoDoc + ' ' + numero);
                        try {
                            QueryRunner RQtransaction = new QueryRunner(raiz.getChild("db").getValue(), "SCS0093");
                            ResultSet rs = RQtransaction.ejecutarSELECT();
                            String initProdServ = "0";
                            if (rs.next()) {
                                initProdServ = rs.getString(1);
                            }
                            String db = InfoSocket.getBd((SocketChannel)sock);
                            LinkingCache.reloadAsientosPr(raiz.getChild("db").getValue(), "SCS0092", new String[]{initProdServ});
                            new LNInventarios(db, raiz, tipoDoc, numero);
                            LinkingCache.reloadConsecutive(db, tipoDoc);
                            RunTransaction.successMessage(sock, "T-755", "Actualizacion remota exitosa");
                        }
                        catch (SQLNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (SQLBadArgumentsException e) {
                            e.printStackTrace();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } else {
                        SocketWriterServer.writing(sock, new AcpFailure(Language.getWord((String)"ACPFAILURE")));
                    }
                } else {
                    LogAdmin.setMessage((String)(Language.getWord((String)"DBNFEX") + raiz.getChild("db").getValue()), (int)0);
                    SocketWriterServer.writing(sock, new AcpFailure(Language.getWord((String)"ACPFAILURE")));
                }
            } else if (nom_raiz.equals("ERROR")) {
                System.out.println("Paquete ERROR");
            } else {
                System.out.println("paquete no autorizado");
            }
        }
        doc = null;
        raiz = null;
    }

    private static Claims validToken(String jwt) throws SignatureException, ExpiredJwtException {
        Claims claims = (Claims)Jwts.parser().setSigningKey(KEY).parseClaimsJws(jwt).getBody();
        return claims;
    }

    private static String issueToken(String bd, String login, String ip, String mac) {
        System.out.println("Hoy: " + HeadersValidator.toDate(LocalDateTime.now()));
        System.out.println("Expira: " + HeadersValidator.toDate(LocalDateTime.now().plusMinutes(720L)));
        String jwtToken = Jwts.builder().setSubject("JWT User").setIssuedAt(new Date()).setExpiration(HeadersValidator.toDate(LocalDateTime.now().plusMinutes(720L))).signWith(SignatureAlgorithm.HS512, KEY).claim("bd", (Object)bd).claim("login", (Object)login).claim("ip", (Object)ip).claim("mac", (Object)mac).compact();
        return jwtToken;
    }

    private static Date toDate(LocalDateTime ldt) {
        return Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static void saveLoginLog(String bd, String login, String ip, String mac, int port, int id_tipo_actividad) {
        Element newPack = new Element("package");
        newPack.addContent((Content)new Element("field").setText(login));
        newPack.addContent((Content)new Element("field").setText(ip));
        newPack.addContent((Content)new Element("field").setText(mac));
        newPack.addContent((Content)new Element("field").setText(String.valueOf(port)));
        newPack.addContent((Content)new Element("field").setText(String.valueOf(id_tipo_actividad)));
        LNGenericSQL LNGTransaccion = new LNGenericSQL(bd);
        LNGTransaccion.setArgs(newPack);
        try {
            LNGTransaccion.generarSimpleConnection("SCI0026");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
    }

    public static void shutdownServerRegisterLog() {
        Hashtable clientes = InfoSocket.getHchannelclients();
        Enumeration sockets = clientes.keys();
        System.out.println("Preparando registro apagado del sistema");
        while (sockets.hasMoreElements()) {
            SocketChannel sock = (SocketChannel)sockets.nextElement();
            String bd = InfoSocket.getBd((SocketChannel)sock);
            String login = InfoSocket.getLoging((SocketChannel)sock);
            String ip = InfoSocket.getIp((SocketChannel)sock);
            String mac = InfoSocket.getMac((SocketChannel)sock);
            Socket clientInfo = sock.socket();
            HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 7);
        }
        System.out.println("Registro finalizado");
        System.out.println("Bye..");
    }

    public static void ValidAdmin(Document doc, SocketChannel sock) {
        Element raiz = doc.getRootElement();
        if (InfoSocket.isLoged((SocketChannel)sock)) {
            if (raiz.getName().equals("TRANSACCION")) {
                System.out.println("Paquete TRANSACCION");
            } else if (raiz.getName().equals("ERROR")) {
                System.out.println("Paquete ERROR");
            } else {
                ErrorXML error = new ErrorXML();
                String tmp = Language.getWord((String)"ERR_FORMAT_PROTOCOL") + " " + sock.socket();
                LogAdmin.setMessage((String)tmp, (int)0);
                SocketWriterServer.writing(sock, error.returnError(0, "", tmp));
            }
        } else if (raiz.getName().equals("CNX")) {
            System.out.println("Paquete CNX");
        } else {
            System.out.println("paquete no autorizado");
        }
    }
}

