/*
 * Decompiled with CFR 0.152.
 */
package server.database.sql;

import common.comunications.InfoSocket;
import common.misc.language.Language;
import common.misc.log.LogAdmin;
import common.misc.settings.ServerConfigFileHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import server.comunications.SocketWriterServer;
import server.control.UPDATECODESender;
import server.database.beans.BusinessRulesStructure;
import server.database.beans.InfoInventario;
import server.database.beans.PerfilCta;
import server.database.beans.WebServicesExternos;
import server.database.caches.WebServicesCaches;
import server.database.connection.ConnectionsPool;
import server.database.sql.ComboProductos;
import server.database.sql.DontHaveKeyException;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLFormatAgent;
import server.database.sql.SQLNotFoundException;
import server.database.sql.StatementsClosingHandler;
import server.printer.TagPrinterServerDB;

public class LinkingCache {
    private static Hashtable<String, String> HcompanyData = new Hashtable();
    private static Hashtable<String, Object> Hinstrucciones = new Hashtable();
    private static Hashtable<String, Object> Htransacciones = new Hashtable();
    private static Hashtable<String, Object> Hpermisos = new Hashtable();
    private static Hashtable<String, Object> Hasientos_pr = new Hashtable();
    private static Hashtable<String, Object> Hctas_asientos = new Hashtable();
    private static Hashtable<String, BusinessRulesStructure> Hlogica_drivers = new Hashtable();
    private static Hashtable<String, InfoInventario> Hinventarios = new Hashtable();
    private static Hashtable<String, ArrayList> HcombosProd = new Hashtable();
    private static Hashtable<String, String> Hconsecutive = new Hashtable();
    private static Hashtable<String, PerfilCta> Hperfil_cta = new Hashtable();
    private static Hashtable<String, Date> lockDate = new Hashtable();
    private static Hashtable<String, Integer> Helectronic_document = new Hashtable();

    public static void cargar() {
        int max = ServerConfigFileHandler.getDBSize();
        LogAdmin.setMessage((String)Language.getWord((String)"LOADING_SL"), (int)2);
        for (int i = 0; i < max; ++i) {
            LinkingCache.loadCaches(ServerConfigFileHandler.getDBName((int)i));
            TagPrinterServerDB tags = new TagPrinterServerDB(ServerConfigFileHandler.getDBName((int)i));
            tags.start();
        }
    }

    private static void loadCaches(String bd) {
        Statement st = null;
        try {
            LogAdmin.setMessage((String)(Language.getWord((String)"LOADING_CACHE") + " " + bd), (int)2);
            st = ConnectionsPool.getConnection(bd).createStatement();
            LogAdmin.setMessage((String)Language.getWord((String)"INIT_BDS"), (int)2);
            LogAdmin.setMessage((String)(Language.getWord((String)"LOADING_ST") + " " + bd), (int)2);
            LinkingCache.loadingQuerys(bd, st);
            Htransacciones.putAll(LinkingCache.loadCache(bd, "SCS0001", new String[]{"login", "codigo", "password"}, "ok"));
            Hpermisos.putAll(LinkingCache.loadCache(bd, "SCS0002", new String[]{"login", "codigo", "password"}, "ok"));
            LinkingCache.loadinTransactionDrivers(bd, st);
            LinkingCache.loadingInfoCompany(bd, st);
            LinkingCache.loadingLockDocuments(bd, st);
            LinkingCache.loadingConsecutives(bd, st);
            LinkingCache.loadingInfoInventory(bd, st);
            LinkingCache.loadPerfilCta(bd, "SCS0038", null);
            LinkingCache.loadAsientosPredefinidos(bd);
            LinkingCache.loadingInfoCombos(bd, st);
            LinkingCache.loadingInfoElectronicDocument(bd, st);
            LinkingCache.loadingWebServices(bd, st);
            LinkingCache.loadingWebservicesPermissions(bd, st);
        }
        catch (SQLException SQLEe) {
            SQLEe.printStackTrace();
            LogAdmin.setMessage((String)("SQLEe: " + Language.getWord((String)"ERROR_LOADING_SL") + " " + bd + SQLEe.getMessage()), (int)0);
        }
        catch (SQLNotFoundException SQLNFEe) {
            SQLNFEe.printStackTrace();
            LogAdmin.setMessage((String)(Language.getWord((String)"ERROR_LOADING_SL") + " " + bd + SQLNFEe.getMessage()), (int)0);
        }
        catch (SQLBadArgumentsException SQLBAEe) {
            SQLBAEe.printStackTrace();
            LogAdmin.setMessage((String)(Language.getWord((String)"ERROR_LOADING_SL") + " " + bd + SQLBAEe.getMessage()), (int)0);
        }
        StatementsClosingHandler.close(st);
        st = null;
    }

    private static synchronized void loadingWebservicesPermissions(String bd, Statement st) throws SQLException {
        System.out.println("Cargando permisos de webservices...");
        try {
            ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCSWS0002"));
            while (rs.next()) {
                WebServicesExternos ws = new WebServicesExternos();
                String user = "K-" + bd + "-" + rs.getString("login") + "-" + rs.getString("codigo");
                WebServicesCaches.addPermission(user);
            }
            rs.close();
        }
        catch (SQLNotFoundException sqlnfee) {
            System.out.println("sin permisos para webservice externos pendiente sql SCSWS0002");
        }
    }

    private static synchronized void loadingWebServices(String bd, Statement st) throws SQLException {
        System.out.println("Cargando webservices...");
        try {
            ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCSWS0001"));
            while (rs.next()) {
                WebServicesExternos ws = new WebServicesExternos();
                String code = "K-" + bd + "-" + rs.getString("codigo");
                ws.setMethod(rs.getString("metodo"));
                ws.setUrl(rs.getString("url"));
                ws.setWebservice_class(rs.getString("webservice_class"));
                ws.setWebservice_method(rs.getString("webservice_method"));
                WebServicesCaches.put(code, ws);
            }
            rs.close();
        }
        catch (SQLNotFoundException sqlnfee) {
            System.out.println("Sin sentencias para webservices externos ...");
        }
    }

    private static synchronized void loadingQuerys(String bd, Statement st) throws SQLException {
        ResultSet rs = st.executeQuery("SELECT trim(codigo) as codigo,sentencia FROM sentencia_sql ORDER BY codigo desc");
        while (rs.next()) {
            Hinstrucciones.put("K-" + bd + "-" + rs.getString("codigo"), rs.getString("sentencia"));
        }
        rs.close();
    }

    private static synchronized void loadingInfoElectronicDocument(String bd, Statement st) throws SQLException, SQLNotFoundException {
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCSDE0001"));
        while (rs.next()) {
            Helectronic_document.put("K-" + bd + "-" + rs.getString("codigo_tipo"), rs.getInt("id_documento_electronico"));
        }
        rs.close();
    }

    private static synchronized void loadingInfoCombos(String bd, Statement st) throws SQLException, SQLNotFoundException {
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0096"));
        int lastcb = -1;
        ArrayList<ComboProductos> cb = null;
        boolean data = false;
        while (rs.next()) {
            data = true;
            int id_cb_prod_serv = rs.getInt("id_cb_prod_serv");
            if (id_cb_prod_serv == lastcb) {
                cb.add(new ComboProductos(rs.getInt("id_prod_serv"), rs.getInt("cantidad")));
                continue;
            }
            if (lastcb != -1) {
                HcombosProd.put("K-" + bd + "-" + lastcb, cb);
            }
            lastcb = id_cb_prod_serv;
            cb = new ArrayList<ComboProductos>();
            cb.add(new ComboProductos(rs.getInt("id_prod_serv"), rs.getInt("cantidad")));
        }
        if (data) {
            HcombosProd.put("K-" + bd + "-" + lastcb, cb);
        }
        rs.close();
    }

    private static synchronized void loadingInfoInventory(String bd, Statement st) throws SQLException, SQLNotFoundException {
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0037"));
        while (rs.next()) {
            Hinventarios.put("K-" + bd + "-" + rs.getInt("id_bodega") + "-" + rs.getInt("id_prod_serv"), new InfoInventario(rs.getDouble("pinventario"), rs.getDouble("saldo"), rs.getDouble("valor_saldo")));
        }
        rs.close();
    }

    private static synchronized void loadingConsecutives(String bd, Statement st) throws SQLException, SQLNotFoundException {
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0023"));
        while (rs.next()) {
            Hconsecutive.put("K-" + bd + "-" + rs.getString("codigo_tipo").trim(), LinkingCache.consecutive(bd, rs.getString("max")));
        }
        rs.close();
    }

    private static synchronized void loadingLockDocuments(String bd, Statement st) throws SQLException, SQLNotFoundException {
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0088"));
        while (rs.next()) {
            lockDate.put("K-" + bd, rs.getTimestamp("fecha"));
        }
        rs.close();
    }

    private static synchronized void loadingInfoCompany(String bd, Statement st) throws SQLException, SQLNotFoundException {
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0054"));
        String url_ambiente = null;
        while (rs.next()) {
            HcompanyData.put("K-" + bd + "-company", String.valueOf(rs.getString("nombre")));
            HcompanyData.put("K-" + bd + "-companyID", String.valueOf(rs.getString("id_char")));
            HcompanyData.put("K-" + bd + "-dv", String.valueOf(rs.getString("dv")));
            HcompanyData.put("K-" + bd + "-schemeID", String.valueOf(rs.getString("schemeid")));
            HcompanyData.put("K-" + bd + "-address", String.valueOf(rs.getString("direccion")));
            HcompanyData.put("K-" + bd + "-phone", String.valueOf(rs.getString("numero")));
            HcompanyData.put("K-" + bd + "-city", String.valueOf(rs.getString("ciudad")));
            HcompanyData.put("K-" + bd + "-depto", String.valueOf(rs.getString("departamento")));
            HcompanyData.put("K-" + bd + "-email", String.valueOf(rs.getString("email")));
            HcompanyData.put("K-" + bd + "-id_tipo_contribuyente", String.valueOf(rs.getString("id_tipo_contribuyente")));
            HcompanyData.put("K-" + bd + "-establecimiento", String.valueOf(rs.getString("establecimiento")));
            HcompanyData.put("K-" + bd + "-codigo_municipio", String.valueOf(rs.getString("codigo_municipio")));
            HcompanyData.put("K-" + bd + "-codigo_departamento", String.valueOf(rs.getString("codigo_departamento")));
            HcompanyData.put("K-" + bd + "-nombre_contacto", String.valueOf(rs.getString("nombre_contacto")));
            HcompanyData.put("K-" + bd + "-telefono_contacto", String.valueOf(rs.getString("telefono_contacto")));
            HcompanyData.put("K-" + bd + "-actividad", String.valueOf(rs.getString("actividad")));
            HcompanyData.put("K-" + bd + "-email_contacto", String.valueOf(rs.getString("email_contacto")));
            HcompanyData.put("K-" + bd + "-nota_contacto", String.valueOf(rs.getString("nota_contacto")));
            HcompanyData.put("K-" + bd + "-test_sed_id", String.valueOf(rs.getString("test_sed_id")));
            HcompanyData.put("K-" + bd + "-url_ambiente", String.valueOf(rs.getString("url_ambiente")));
            HcompanyData.put("K-" + bd + "-nombre1", String.valueOf(rs.getString("nombre1")));
            HcompanyData.put("K-" + bd + "-nombre2", String.valueOf(rs.getString("nombre2")));
            HcompanyData.put("K-" + bd + "-apellido1", String.valueOf(rs.getString("apellido1")));
            HcompanyData.put("K-" + bd + "-apellido2", String.valueOf(rs.getString("apellido2")));
            url_ambiente = rs.getString("url_ambiente");
        }
        if (!"".equals(url_ambiente)) {
            LinkingCache.loadSoapInfo(bd, url_ambiente);
        }
        rs.close();
    }

    private static synchronized void loadinTransactionDrivers(String bd, Statement st) throws SQLException, SQLNotFoundException {
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0015"));
        SAXBuilder builder = new SAXBuilder(false);
        while (rs.next()) {
            try {
                Document docDrv = null;
                Document docMth = null;
                try {
                    ByteArrayInputStream bufferInDrv = new ByteArrayInputStream(rs.getString("args_driver").getBytes());
                    docDrv = builder.build((InputStream)bufferInDrv);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    ByteArrayInputStream bufferInMth = new ByteArrayInputStream(rs.getString("args_metodo").getBytes());
                    docMth = builder.build((InputStream)bufferInMth);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                Hlogica_drivers.put("K-" + bd + "-" + rs.getString("codigo").trim(), new BusinessRulesStructure(rs.getString("driver"), docDrv, rs.getString("metodo"), docMth));
            }
            catch (IOException IOEe) {
                IOEe.printStackTrace();
                LogAdmin.setMessage((String)("IOEe: " + Language.getWord((String)"ERR_LOADING_LG") + " " + bd + " " + rs.getString("codigo") + " " + IOEe.getMessage()), (int)0);
            }
            catch (JDOMException JDOMEe) {
                JDOMEe.printStackTrace();
                LogAdmin.setMessage((String)("JDOMEe: " + Language.getWord((String)"ERR_LOADING_LG") + " " + bd + " " + rs.getString("codigo") + " " + JDOMEe.getMessage()), (int)0);
            }
        }
        rs.close();
    }

    public static void loadSoapInfo(String bd, String url_ambiente) {
        try {
            URL u = new URL(url_ambiente);
            System.out.println("host: " + u.getHost());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            org.w3c.dom.Document doc = db.parse(u.openStream());
            NodeList nodes = doc.getElementsByTagName("wsdl:portType");
            NodeList nodesAddress = doc.getElementsByTagName("soap12:address");
            Element address = (Element)nodesAddress.item(0);
            String urlAddress = address.getAttribute("location");
            System.out.println("address: " + urlAddress);
            HcompanyData.put("K-" + bd + "-url_address", urlAddress);
            Element el = (Element)nodes.item(0);
            NodeList operations = el.getChildNodes();
            Element elm = null;
            String soapAction = null;
            String soapActionTest = null;
            for (int i = 0; i < operations.getLength(); ++i) {
                Element child;
                int j;
                NodeList operation;
                elm = (Element)operations.item(i);
                String name = elm.getAttribute("name");
                if (name.equals("SendBillSync")) {
                    operation = elm.getChildNodes();
                    for (j = 0; j < operation.getLength(); ++j) {
                        child = (Element)operation.item(j);
                        if (!child.getNodeName().equals("wsdl:input")) continue;
                        soapAction = child.getAttribute("wsaw:Action");
                    }
                }
                if (!name.equals("SendTestSetAsync")) continue;
                operation = elm.getChildNodes();
                for (j = 0; j < operation.getLength(); ++j) {
                    child = (Element)operation.item(j);
                    if (!child.getNodeName().equals("wsdl:input")) continue;
                    soapActionTest = child.getAttribute("wsaw:Action");
                }
            }
            HcompanyData.put("K-" + bd + "-soap_action", soapAction);
            HcompanyData.put("K-" + bd + "-soap_action_test", soapActionTest);
            System.out.println("soapAction: " + soapAction + "\nSoapActionTest: " + soapActionTest);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void removePerfilCta(String bd, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Statement st = ConnectionsPool.getConnection(bd).createStatement();
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0057", args));
        while (rs.next()) {
            String key = "K-" + bd + "-" + rs.getString(1).trim();
            Hperfil_cta.remove(key);
        }
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
    }

    public static void reloadElectronicDocument(String bd) {
        try {
            Statement st = ConnectionsPool.getConnection(bd).createStatement();
            ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCSDE0001"));
            while (rs.next()) {
                Helectronic_document.put("K-" + bd + "-" + rs.getString("codigo_tipo"), rs.getInt("id_documento_electronico"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void reloadCombo(String bd) {
        try {
            Statement st = ConnectionsPool.getConnection(bd).createStatement();
            ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0096"));
            int lastcb = -1;
            ArrayList<ComboProductos> cb = null;
            while (rs.next()) {
                int id_cb_prod_serv = rs.getInt("id_cb_prod_serv");
                if (id_cb_prod_serv == lastcb) {
                    cb.add(new ComboProductos(rs.getInt("id_prod_serv"), rs.getInt("cantidad")));
                } else {
                    if (lastcb != -1) {
                        HcombosProd.put("K-" + bd + "-" + rs.getInt("id_cb_prod_serv"), cb);
                    }
                    lastcb = id_cb_prod_serv;
                    cb = new ArrayList<ComboProductos>();
                    cb.add(new ComboProductos(rs.getInt("id_prod_serv"), rs.getInt("cantidad")));
                }
                HcombosProd.put("K-" + bd + "-" + rs.getInt("id_cb_prod_serv"), cb);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void removeAsientosPr(String bd, String sql, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Statement st = ConnectionsPool.getConnection(bd).createStatement();
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, sql, args));
        while (rs.next()) {
            String key = "K-" + bd + "-" + rs.getString(1).trim() + "-" + rs.getString(2).trim();
            Hasientos_pr.remove(key);
        }
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
    }

    public static void removeCtasAsientos(String bd, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Statement st = ConnectionsPool.getConnection(bd).createStatement();
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0055", args));
        while (rs.next()) {
            String key = "K-" + bd + "-" + rs.getString(1).trim() + "-" + rs.getString(2).trim();
            Hctas_asientos.remove(key);
        }
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
    }

    public static void reloadAsientosPr(String bd, String sql, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Hasientos_pr.putAll(LinkingCache.loadCache(bd, sql, args, new String[]{"id_prod_serv", "id_asientos_prod_serv"}, "id_asientos_pr"));
    }

    public static void reloadInventarios(String bd, String sql, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Statement st = ConnectionsPool.getConnection(bd).createStatement();
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, sql, args));
        int id_bodega = 0;
        int id_prod_serv = 0;
        String key = null;
        while (rs.next()) {
            id_bodega = rs.getInt("id_bodega");
            id_prod_serv = rs.getInt("id_prod_serv");
            key = "K-" + bd + "-" + id_bodega + "-" + id_prod_serv;
            if (Hinventarios.containsKey(key)) {
                Hinventarios.remove(key);
            }
            Hinventarios.put(key, new InfoInventario(rs.getDouble("pinventario"), rs.getDouble("saldo"), rs.getDouble("valor_saldo")));
        }
        st.execute(SQLFormatAgent.getSentencia(bd, "SCU0008"));
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
    }

    public static void reloadCtasAsientos(String bd, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Hctas_asientos.putAll(LinkingCache.loadCache(bd, "SCS0055", args, new String[]{"id_asientos_pr", "char_cta"}, "naturaleza"));
    }

    public static void loadAsientosPredefinidos(String bd) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Hasientos_pr.putAll(LinkingCache.loadCache(bd, "SCS0039", new String[]{"id_prod_serv", "id_asientos_prod_serv"}, "id_asientos_pr"));
        Hctas_asientos.putAll(LinkingCache.loadCache(bd, "SCS0040", new String[]{"id_asientos_pr", "char_cta"}, "naturaleza"));
    }

    public static void loadPerfilCta(String bd, String sqlPerfil, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Statement st = ConnectionsPool.getConnection(bd).createStatement();
        ResultSet rs = args == null ? st.executeQuery(SQLFormatAgent.getSentencia(bd, sqlPerfil)) : st.executeQuery(SQLFormatAgent.getSentencia(bd, sqlPerfil, args));
        while (rs.next()) {
            Hperfil_cta.put("K-" + bd + "-" + rs.getString("char_cta").trim(), new PerfilCta(rs.getString("id_cta"), rs.getBoolean("naturaleza"), rs.getBoolean("terceros"), rs.getBoolean("activos"), rs.getBoolean("inventarios"), rs.getBoolean("centro"), rs.getBoolean("scentro"), rs.getBoolean("edocumento"), rs.getBoolean("vinculada"), rs.getBoolean("ajuste"), rs.getBoolean("depreciacion"), rs.getDouble("base"), rs.getDouble("porcentaje")));
        }
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
    }

    private static synchronized void loadWebservicesExternos(String bd, String sql) {
    }

    private static synchronized Hashtable<String, Object> loadCache(String bd, String sql, String[] key, String rsValue) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        return LinkingCache.loadCache(bd, sql, null, key, rsValue);
    }

    private static synchronized Hashtable<String, Object> loadCache(String bd, String sql, String[] args, String[] key, String rsValue) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Statement st = ConnectionsPool.getConnection(bd).createStatement();
        ResultSet rs = args != null ? st.executeQuery(SQLFormatAgent.getSentencia(bd, sql, args)) : st.executeQuery(SQLFormatAgent.getSentencia(bd, sql));
        Hashtable<String, Object> tabla = new Hashtable<String, Object>();
        while (rs.next()) {
            String subkey = "";
            for (String subData : key) {
                subkey = subkey + rs.getString(subData).trim() + "-";
            }
            tabla.put("K-" + bd + "-" + subkey.substring(0, subkey.length() - 1), rs.getObject(rsValue));
        }
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        return tabla;
    }

    public static int getIdDocumentoElectronico(String bd, String codigo_tipo) {
        System.out.println("bd: " + bd + " codigo_tipo: " + codigo_tipo);
        try {
            return Helectronic_document.get("K-" + bd + "-" + codigo_tipo);
        }
        catch (NullPointerException e) {
            LinkingCache.reloadElectronicDocument(bd);
            return Helectronic_document.get("K-" + bd + "-" + codigo_tipo);
        }
    }

    public static String getCompanyData(String key) {
        return HcompanyData.get(key);
    }

    public static String getNit(String bd) {
        return HcompanyData.get("K-" + bd + "-companyID");
    }

    public static String getSchemeID(String bd) {
        return HcompanyData.get("K-" + bd + "-schemeID");
    }

    public static String getNameCompany(String bd) {
        return HcompanyData.get("K-" + bd + "-company");
    }

    public static String getAddress(String bd) {
        return HcompanyData.get("K-" + bd + "-address");
    }

    public static String getURLAmbiente(String bd) {
        return HcompanyData.get("K-" + bd + "-url_ambiente");
    }

    public static String getPhone(String bd) {
        return HcompanyData.get("K-" + bd + "-phone");
    }

    public static String getCity(String bd) {
        return HcompanyData.get("K-" + bd + "-city");
    }

    public static String getDepto(String bd) {
        return HcompanyData.get("K-" + bd + "-depto");
    }

    public static String getEmail(String bd) {
        return HcompanyData.get("K-" + bd + "-email");
    }

    public static String getDV(String bd) {
        return HcompanyData.get("K-" + bd + "-dv");
    }

    public static String getTipoContribuyente(String bd) {
        return HcompanyData.get("K-" + bd + "-id_tipo_contribuyente");
    }

    public static String getCodigoMunicipio(String bd) {
        return HcompanyData.get("K-" + bd + "-codigo_municipio");
    }

    public static String getCodigoDepartamento(String bd) {
        return HcompanyData.get("K-" + bd + "-codigo_departamento");
    }

    public static String getEstablecimiento(String bd) {
        return HcompanyData.get("K-" + bd + "-establecimiento");
    }

    public static String getActividad(String bd) {
        return HcompanyData.get("K-" + bd + "-actividad");
    }

    public static String getNameContact(String bd) {
        return HcompanyData.get("K-" + bd + "-nombre_contacto");
    }

    public static String getPhoneContact(String bd) {
        return HcompanyData.get("K-" + bd + "-telefono_contacto");
    }

    public static String getEMailContact(String bd) {
        return HcompanyData.get("K-" + bd + "-email_contacto");
    }

    public static String getNoteContact(String bd) {
        return HcompanyData.get("K-" + bd + "-nota_contacto");
    }

    public static String getSoapAction(String bd) {
        return HcompanyData.get("K-" + bd + "-soap_action");
    }

    public static String getSoapActionTest(String bd) {
        return HcompanyData.get("K-" + bd + "-soap_action_test");
    }

    public static String getTestSedId(String bd) {
        return HcompanyData.get("K-" + bd + "-test_sed_id");
    }

    public static String getUrlAddress(String bd) {
        return HcompanyData.get("K-" + bd + "-url_address");
    }

    public static String getNombre1(String bd) {
        return HcompanyData.get("K-" + bd + "-nombre1");
    }

    public static String getNombre2(String bd) {
        return HcompanyData.get("K-" + bd + "-nombre2");
    }

    public static String getApellido1(String bd) {
        return HcompanyData.get("K-" + bd + "-apellido1");
    }

    public static String getApellido2(String bd) {
        return HcompanyData.get("K-" + bd + "-apellido2");
    }

    private static String consecutive(String nombreBD, String value) {
        if (value != null && !value.equals("")) {
            try {
                long nextValue = Long.parseLong(value.trim()) + 1L;
                String sNextValue = String.valueOf(nextValue);
                return sNextValue;
            }
            catch (NumberFormatException NFEe) {
                LogAdmin.setMessage((String)(Language.getWord((String)"ERR_CONSECUTIVE") + " " + nombreBD + NFEe.getMessage()), (int)0);
                return "1";
            }
        }
        return "1";
    }

    public static ArrayList<ComboProductos> getComboProductos(String bd, String id_prod_serv) {
        if (HcombosProd.containsKey("K-" + bd + "-" + id_prod_serv)) {
            return HcombosProd.get("K-" + bd + "-" + id_prod_serv);
        }
        return null;
    }

    public static void setSaldoInventario(String bd, String bodega, String id_prod_serv, double saldo) {
        String ktmp = "K-" + bd + "-" + bodega + "-" + id_prod_serv;
        try {
            Statement st = ConnectionsPool.getConnection(bd).createStatement();
            if (Hinventarios.containsKey(ktmp)) {
                Hinventarios.get(ktmp).setSaldo(saldo);
                st.execute(SQLFormatAgent.getSentencia(bd, "SCS0064", new String[]{id_prod_serv, bodega}));
                st.execute(SQLFormatAgent.getSentencia(bd, "SCS0065", new String[]{String.valueOf(saldo), id_prod_serv, bodega}));
            } else {
                Hinventarios.put(ktmp, new InfoInventario(0.0, saldo, 0.0));
                st.execute(SQLFormatAgent.getSentencia(bd, "SCS0065", new String[]{String.valueOf(saldo), id_prod_serv, bodega}));
            }
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
    }

    public static double getVSaldoInventario(String bd, String bodega, String id_prod_serv) {
        if (Hinventarios.containsKey("K-" + bd + "-" + bodega + "-" + id_prod_serv)) {
            return Hinventarios.get("K-" + bd + "-" + bodega + "-" + id_prod_serv).getVsaldo();
        }
        return 0.0;
    }

    public static double getSaldoInventario(String bd, String bodega, String id_prod_serv) {
        if (Hinventarios.containsKey("K-" + bd + "-" + bodega + "-" + id_prod_serv)) {
            return Hinventarios.get("K-" + bd + "-" + bodega + "-" + id_prod_serv).getSaldo();
        }
        return 0.0;
    }

    public static Date getLockDate(String bd) {
        return lockDate.get("K-" + bd);
    }

    public static void setLockDate(String bd, String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:SS");
        lockDate.remove("K-" + bd);
        try {
            lockDate.put("K-" + bd, sdf.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static void reloadLockDate(String bd) {
        lockDate.remove("k-" + bd);
        try {
            Statement st = ConnectionsPool.getConnection(bd).createStatement();
            ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0088"));
            while (rs.next()) {
                lockDate.put("K-" + bd, rs.getTimestamp("fecha"));
            }
            StatementsClosingHandler.close(st);
            StatementsClosingHandler.close(rs);
            st = null;
            rs = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void setVSaldoInventario(String bd, String bodega, String id_prod_serv, double saldo) {
        String ktmp = "K-" + bd + "-" + bodega + "-" + id_prod_serv;
        if (Hinventarios.containsKey(ktmp)) {
            Hinventarios.get(ktmp).setVsaldo(saldo);
        } else {
            Hinventarios.put(ktmp, new InfoInventario(0.0, 0.0, saldo));
        }
    }

    public static void setVSaldoInventario(String key, double saldo) {
        if (Hinventarios.containsKey(key)) {
            Hinventarios.get(key).setVsaldo(saldo);
        } else {
            Hinventarios.put(key, new InfoInventario(0.0, 0.0, saldo));
        }
    }

    public static void setInventario(String key, InfoInventario saldo) {
        Hinventarios.put(key, saldo);
    }

    public static double getPCosto(String bd, String bodega, String id_prod_serv) {
        System.out.println("key PCosto: K-" + bd + "-" + bodega + "-" + id_prod_serv);
        if (Hinventarios.containsKey("K-" + bd + "-" + bodega + "-" + id_prod_serv)) {
            System.out.println("valor: " + Hinventarios.get("K-" + bd + "-" + bodega + "-" + id_prod_serv).getPcosto());
            return Hinventarios.get("K-" + bd + "-" + bodega + "-" + id_prod_serv).getPcosto();
        }
        System.out.print("llave no existente retorno 0");
        return 0.0;
    }

    public static void setPCosto(String bd, String bodega, String id_prod_serv, double saldo) {
        String ktmp = "K-" + bd + "-" + bodega + "-" + id_prod_serv;
        if (Hinventarios.containsKey(ktmp)) {
            Hinventarios.get(ktmp).setPcosto(saldo);
        } else {
            Hinventarios.put(ktmp, new InfoInventario(saldo, 0.0, 0.0));
        }
    }

    public static BusinessRulesStructure getDriver(String bd, String id_transaction) {
        return Hlogica_drivers.get("K-" + bd + "-" + id_transaction);
    }

    public static void reloadTransaction(String bd, String code) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Connection cn = ConnectionsPool.getConnection(bd);
        Statement st = cn.createStatement();
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0099", new String[]{code}));
        SAXBuilder builder = new SAXBuilder(false);
        while (rs.next()) {
            try {
                Document docDrv = null;
                Document docMth = null;
                try {
                    ByteArrayInputStream bufferInDrv = new ByteArrayInputStream(rs.getString("args_driver").getBytes());
                    docDrv = builder.build((InputStream)bufferInDrv);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    ByteArrayInputStream bufferInMth = new ByteArrayInputStream(rs.getString("args_metodo").getBytes());
                    docMth = builder.build((InputStream)bufferInMth);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                Hlogica_drivers.remove("K-" + bd + "-" + code);
                Hlogica_drivers.put("K-" + bd + "-" + code, new BusinessRulesStructure(rs.getString("driver"), docDrv, rs.getString("metodo"), docMth));
            }
            catch (IOException IOEe) {
                IOEe.printStackTrace();
                LogAdmin.setMessage((String)("IOEe: " + Language.getWord((String)"ERR_LOADING_LG") + " " + bd + " " + rs.getString("codigo") + " " + IOEe.getMessage()), (int)0);
            }
            catch (JDOMException JDOMEe) {
                JDOMEe.printStackTrace();
                LogAdmin.setMessage((String)("JDOMEe: " + Language.getWord((String)"ERR_LOADING_LG") + " " + bd + " " + rs.getString("codigo") + " " + JDOMEe.getMessage()), (int)0);
            }
        }
    }

    public static String getSentenciaSQL(String key) {
        return (String)Hinstrucciones.get(key);
    }

    public static void setSentenciaSQL(String bd, String code) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Connection cn = ConnectionsPool.getConnection(bd);
        Statement st = cn.createStatement();
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0098", new String[]{code}));
        Hinstrucciones.remove("K-" + bd + "-" + code);
        while (rs.next()) {
            Hinstrucciones.put("K-" + bd + "-" + code, rs.getString("sentencia"));
            Hpermisos.putAll(LinkingCache.loadCache(bd, "SCS0101", new String[]{code}, new String[]{"login", "codigo", "password"}, "ok"));
        }
    }

    public static boolean getPermisosSQL(String key) {
        return Hpermisos.containsKey(key);
    }

    public static void setPermisosSQL(String bd, String login) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Hpermisos.putAll(LinkingCache.loadCache(bd, "SCS0091", new String[]{login}, new String[]{"login", "codigo", "password"}, "ok"));
    }

    public static void removePermisosSQL(String key) {
        Hpermisos.remove(key);
    }

    public static boolean getPermisosTransaccion(String key) {
        return Htransacciones.containsKey(key);
    }

    public static void setPermisosTransacciones(String key) {
        System.out.println(key);
        Htransacciones.put(key, true);
    }

    public static void removePermisosTransacciones(String key) {
        Htransacciones.remove(key);
    }

    public static void setConsecutive(String bd, String key, String value) {
        String ktmp = "K-" + bd + "-" + key;
        Hconsecutive.remove(ktmp);
        Hconsecutive.put(ktmp, value);
    }

    public static void reloadConsecutive(String bd, String key) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Connection cn = ConnectionsPool.getConnection(bd);
        Statement st = cn.createStatement();
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCS0046", new String[]{key}));
        String consecutive = "";
        while (rs.next()) {
            consecutive = rs.getString(1);
        }
        Hconsecutive.remove("K-" + bd + "-" + key);
        if (consecutive != null) {
            Hconsecutive.put("K-" + bd + "-" + key, consecutive);
        }
        LinkingCache.incrementeConsecutive(bd, key, null);
        StatementsClosingHandler.close(st);
        StatementsClosingHandler.close(rs);
        st = null;
        rs = null;
    }

    public static Hashtable<String, String> getInfoCliente(String bd, String ndocumento) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Hashtable<String, String> infoCliente = new Hashtable<String, String>();
        Connection cn = ConnectionsPool.getConnection(bd);
        Statement st = cn.createStatement();
        System.out.println("ndocumento para tercero: " + ndocumento);
        ResultSet rs = st.executeQuery(SQLFormatAgent.getSentencia(bd, "SCSDE0002", new String[]{ndocumento}));
        String nombre1 = null;
        String nombre2 = null;
        String apellido1 = null;
        String apellido2 = null;
        String razon_social = null;
        while (rs.next()) {
            nombre1 = rs.getString("nombre1");
            nombre2 = rs.getString("nombre2");
            apellido1 = rs.getString("apellido1");
            apellido2 = rs.getString("apellido2");
            razon_social = rs.getString("razon_social");
            infoCliente.put("nombre1", nombre1);
            infoCliente.put("nombre2", nombre2);
            infoCliente.put("apellido1", apellido1);
            infoCliente.put("apellido2", apellido2);
            infoCliente.put("razon_social", razon_social);
            infoCliente.put("nit", String.valueOf(rs.getString("id_char")));
            infoCliente.put("dv", String.valueOf(rs.getString("dv")).trim());
            infoCliente.put("schemeID", String.valueOf(rs.getString("schemeID")));
            infoCliente.put("direccion", String.valueOf(rs.getString("direccion")));
            infoCliente.put("telefono", String.valueOf(rs.getString("numero")));
            infoCliente.put("ciudad", String.valueOf(rs.getString("ciudad")));
            infoCliente.put("depto", String.valueOf(rs.getString("departamento")));
            infoCliente.put("email", String.valueOf(rs.getString("email")));
            infoCliente.put("codigo_responsabilidad", String.valueOf(rs.getString("codigo_responsabilidad")).trim());
            infoCliente.put("descripcion_responsabilidad", String.valueOf(rs.getString("descripcion_responsabilidad")));
            infoCliente.put("id_tipo_contribuyente", String.valueOf(rs.getString("id_tipo_contribuyente")).trim());
            infoCliente.put("id_dep", String.valueOf(rs.getString("id_dep")).trim());
            infoCliente.put("id_mun", String.valueOf(rs.getString("id_mun")).trim());
            infoCliente.put("nombreContacto", String.valueOf(rs.getString("nombre_contacto")).trim());
            infoCliente.put("telefonoContacto", String.valueOf(rs.getString("telefono_contacto")).trim());
            infoCliente.put("emailContacto", String.valueOf(rs.getString("email_contacto")).trim());
            infoCliente.put("notaContacto", String.valueOf(rs.getString("nota_contacto")).trim());
            infoCliente.put("taxLevelCode", String.valueOf(rs.getString("tax_level_code")).trim());
        }
        String nombres = null;
        nombres = razon_social != null && !"".equals(razon_social) ? razon_social : nombre1 + " " + nombre2 + " " + apellido1 + " " + apellido2;
        System.out.println("-------- nombre del cliente: " + nombres);
        infoCliente.put("nombres", nombres);
        rs.close();
        st.close();
        rs = null;
        st = null;
        return infoCliente;
    }

    public static void incrementeConsecutive(final String bd, final String key, final String idActivo) {
        String consecutive = LinkingCache.getConsecutive(bd, key);
        try {
            System.out.println("Incrementado consecutivo...");
            long nextValue = Long.parseLong(consecutive.trim()) + 1L;
            String sNextValue = String.valueOf(nextValue);
            System.out.println("actualizando hashtable de consecutivo");
            LinkingCache.setConsecutive(bd, key, sNextValue);
            System.out.println("Cargando lista de clientes conectados para broadcast");
            Hashtable clientes = InfoSocket.getHchannelclients();
            System.out.println("Enumerando..");
            final Enumeration sockets = clientes.keys();
            System.out.println("preparando para replicar..");
            new Thread(){

                @Override
                public void run() {
                    while (sockets.hasMoreElements()) {
                        SocketChannel sock = (SocketChannel)sockets.nextElement();
                        System.out.println("---- getBD() ----");
                        if (!bd.equals(InfoSocket.getBd((SocketChannel)sock)) || !InfoSocket.isTransactional((SocketChannel)sock)) continue;
                        System.out.println("++++ escribiendo replica de consecutivo ++++");
                        SocketWriterServer.writing(sock, UPDATECODESender.getPackage(key, LinkingCache.getConsecutive(bd, key), idActivo));
                        System.out.println("--- Cliente actualizado ---");
                    }
                }
            }.start();
            System.out.println("Clientes Actualizados");
        }
        catch (NumberFormatException NFEe) {
            NFEe.printStackTrace();
            LogAdmin.setMessage((String)(Language.getWord((String)"ERR_CONSECUTIVE") + " " + bd + NFEe.getMessage()), (int)0);
        }
        System.out.println("Fin incrementConsecutive");
    }

    public static String getConsecutive(String bd, String key) {
        if (Hconsecutive.containsKey("K-" + bd + "-" + key)) {
            return Hconsecutive.get("K-" + bd + "-" + key);
        }
        return "1";
    }

    public static boolean isPCTerceros(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isTerceros();
        }
        throw new DontHaveKeyException(account);
    }

    public static boolean isPCCentro(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isCentro();
        }
        LinkingCache.reloadPerfilCta(bd);
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isCentro();
        }
        throw new DontHaveKeyException(account);
    }

    public static boolean isPCSCentro(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isSCentro();
        }
        LinkingCache.reloadPerfilCta(bd);
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isSCentro();
        }
        throw new DontHaveKeyException(account);
    }

    public static boolean isPCVinculo(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isVinculo();
        }
        LinkingCache.reloadPerfilCta(bd);
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isVinculo();
        }
        throw new DontHaveKeyException(account);
    }

    public static boolean isPCInventarios(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isInventarios();
        }
        LinkingCache.reloadPerfilCta(bd);
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isInventarios();
        }
        throw new DontHaveKeyException(account);
    }

    public static boolean isPCActivos(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isActivos();
        }
        LinkingCache.reloadPerfilCta(bd);
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isActivos();
        }
        throw new DontHaveKeyException(account);
    }

    public static boolean isPCAjuste(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isAjuste();
        }
        LinkingCache.reloadPerfilCta(bd);
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isAjuste();
        }
        throw new DontHaveKeyException(account);
    }

    public static boolean isPCNaturaleza(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isNaturaleza();
        }
        LinkingCache.reloadPerfilCta(bd);
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).isNaturaleza();
        }
        throw new DontHaveKeyException(account);
    }

    public static double getPCBase(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).getBase();
        }
        LinkingCache.reloadPerfilCta(bd);
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).getBase();
        }
        throw new DontHaveKeyException(account);
    }

    public static double getPCPorcentaje(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).getPorcentaje();
        }
        LinkingCache.reloadPerfilCta(bd);
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).getPorcentaje();
        }
        throw new DontHaveKeyException(account);
    }

    public static String getPCIdCta(String bd, String account) throws DontHaveKeyException {
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).getId_cta();
        }
        LinkingCache.reloadPerfilCta(bd);
        if (Hperfil_cta.containsKey("K-" + bd + "-" + account)) {
            return Hperfil_cta.get("K-" + bd + "-" + account).getId_cta();
        }
        throw new DontHaveKeyException(account);
    }

    public static String getIdAsientosPr(String bd, String id_prod_serv, String id_asientos_prod_serv) throws DontHaveKeyException, SQLException, SQLNotFoundException, SQLBadArgumentsException {
        if (Hasientos_pr.containsKey("K-" + bd + "-" + id_prod_serv + "-" + id_asientos_prod_serv)) {
            return String.valueOf(Hasientos_pr.get("K-" + bd + "-" + id_prod_serv + "-" + id_asientos_prod_serv));
        }
        System.out.println("Recargando por verificacion...");
        LinkingCache.loadAsientosPredefinidos(bd);
        if (Hasientos_pr.containsKey("K-" + bd + "-" + id_prod_serv + "-" + id_asientos_prod_serv)) {
            return String.valueOf(Hasientos_pr.get("K-" + bd + "-" + id_prod_serv + "-" + id_asientos_prod_serv));
        }
        throw new DontHaveKeyException("K-" + bd + "-" + id_prod_serv + "-" + id_asientos_prod_serv);
    }

    public static boolean isAsientoDebito(String bd, String id_asiento_pr, String cta) throws DontHaveKeyException {
        if (Hctas_asientos.containsKey("K-" + bd + "-" + id_asiento_pr + "-" + cta)) {
            return (Boolean)Hctas_asientos.get("K-" + bd + "-" + id_asiento_pr + "-" + cta);
        }
        throw new DontHaveKeyException("K-" + bd + "-" + id_asiento_pr + "-" + cta);
    }

    private static void reloadPerfilCta(String bd) {
        try {
            LinkingCache.loadPerfilCta(bd, "SCS0038", null);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
    }
}

