/*
 * Decompiled with CFR 0.152.
 */
package server.database.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jdom.Element;
import server.database.connection.ConnectionsPool;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLFormatAgent;
import server.database.sql.SQLNotFoundException;
import server.database.sql.StatementsClosingHandler;

public class QueryRunner
extends Element {
    private static final long serialVersionUID = -5369073295276204778L;
    private String bd;
    private String cod_sql;
    private Statement st;
    private String sql;
    private ResultSet rsdata;

    public QueryRunner(String bd, String cod_sql) throws SQLNotFoundException, SQLBadArgumentsException {
        this.bd = bd;
        this.cod_sql = cod_sql;
        this.sql = SQLFormatAgent.getSentencia(bd, cod_sql);
    }

    public QueryRunner(String bd, String cod_sql, String[] args) throws SQLNotFoundException, SQLBadArgumentsException {
        this.bd = bd;
        this.cod_sql = cod_sql;
        this.sql = SQLFormatAgent.getSentencia(bd, cod_sql, args);
    }

    public QueryRunner(String bd, String cache, String sql) {
        this.bd = bd;
        this.cod_sql = cache;
        this.sql = sql;
    }

    public QueryRunner(String bd) {
        this.bd = bd;
    }

    public ResultSet getQuery(String sql, String[] args) {
        try {
            QueryRunner RQdata = args != null ? new QueryRunner(this.bd, sql, args) : new QueryRunner(this.bd, sql);
            Connection conn = ConnectionsPool.getSimpleConnection(this.bd);
            this.rsdata = RQdata.ejecutarMTSELECT(conn);
            return this.rsdata;
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ResultSet getQuery(Connection conn, String sql, String[] args) {
        try {
            QueryRunner RQdata = args != null ? new QueryRunner(this.bd, sql, args) : new QueryRunner(this.bd, sql);
            this.rsdata = RQdata.ejecutarMTSELECT(conn);
            return this.rsdata;
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void closeQuery() {
        try {
            this.rsdata.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ResultSet getQuery(String sql) {
        return this.getQuery(sql, null);
    }

    public ResultSet ejecutarSELECT() throws SQLException {
        try {
            int rowCount;
            this.st = ConnectionsPool.getConnection(this.bd).createStatement();
            ResultSet rs = null;
            this.st.execute(this.sql);
            while ((rs = this.st.getResultSet()) == null && (rowCount = this.st.getUpdateCount()) != -1) {
                this.st.getMoreResults();
            }
            return rs;
        }
        catch (SQLException SQLEe) {
            throw new SQLException(this.cod_sql + " " + SQLEe.getMessage());
        }
    }

    public ResultSet ejecutarMTSELECT(Connection conn) throws SQLException {
        try {
            int rowCount;
            Statement st = conn.createStatement();
            ResultSet rs = null;
            st.execute(this.sql);
            while ((rs = st.getResultSet()) == null && (rowCount = st.getUpdateCount()) != -1) {
                st.getMoreResults();
            }
            return rs;
        }
        catch (SQLException SQLEe) {
            throw new SQLException(this.cod_sql + " " + SQLEe.getMessage() + " " + SQLEe.getErrorCode());
        }
    }

    public boolean ejecutarSimpleSQL(String cod_sql, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        try {
            this.cod_sql = cod_sql;
            this.sql = SQLFormatAgent.getSentencia(this.bd, cod_sql, args);
            this.st = ConnectionsPool.getSimpleConnection(this.bd).createStatement();
            boolean status = this.st.execute(this.sql);
            this.st.close();
            this.st = null;
            return status;
        }
        catch (SQLException SQLEe) {
            throw new SQLException(cod_sql + " " + SQLEe.getMessage());
        }
    }

    public boolean ejecutarSimpleSQLCommit(String cod_sql, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        try {
            this.cod_sql = cod_sql;
            this.sql = SQLFormatAgent.getSentencia(this.bd, cod_sql, args);
            Connection con = ConnectionsPool.getSimpleConnection(this.bd);
            boolean autoCommit = con.getAutoCommit();
            con.setAutoCommit(true);
            this.st = con.createStatement();
            boolean status = this.st.execute(this.sql);
            con.setAutoCommit(autoCommit);
            this.st.close();
            this.st = null;
            return status;
        }
        catch (SQLException SQLEe) {
            throw new SQLException(cod_sql + " " + SQLEe.getMessage());
        }
    }

    public boolean ejecutarTransacSQL(String cod_sql, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        try {
            this.cod_sql = cod_sql;
            this.sql = SQLFormatAgent.getSentencia(this.bd, cod_sql, args);
            this.st = ConnectionsPool.getConnection(this.bd).createStatement();
            boolean status = this.st.execute(this.sql);
            this.st.close();
            this.st = null;
            return status;
        }
        catch (SQLException SQLEe) {
            throw new SQLException(cod_sql + " " + SQLEe.getMessage());
        }
    }

    public boolean ejecutarSQL(Connection conn, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        try {
            this.sql = SQLFormatAgent.getSentencia(this.bd, this.cod_sql, args);
            Statement st = conn.createStatement();
            boolean status = st.execute(this.sql);
            st.close();
            st = null;
            return status;
        }
        catch (SQLException SQLEe) {
            throw new SQLException("SQL " + this.sql + " code " + this.cod_sql + " " + SQLEe.getMessage());
        }
    }

    public boolean ejecutarSQL(String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        try {
            this.sql = SQLFormatAgent.getSentencia(this.bd, this.cod_sql, args);
            this.st = ConnectionsPool.getConnection(this.bd).createStatement();
            boolean status = this.st.execute(this.sql);
            this.st.close();
            this.st = null;
            return status;
        }
        catch (SQLException SQLEe) {
            throw new SQLException("SQL " + this.sql + " code " + this.cod_sql + " " + SQLEe.getMessage());
        }
    }

    public boolean ejecutarSQL() throws SQLException {
        try {
            this.st = ConnectionsPool.getConnection(this.bd).createStatement();
            boolean status = this.st.execute(this.sql);
            this.st.close();
            this.st = null;
            return status;
        }
        catch (SQLException SQLEe) {
            throw new SQLException(this.cod_sql + " " + SQLEe.getMessage());
        }
    }

    public void closeStatement() {
        StatementsClosingHandler.close(this.st);
        this.st = null;
    }

    public boolean isAutoCommit(String bd) throws SQLException {
        Connection con = ConnectionsPool.getConnection(bd);
        return con.getAutoCommit();
    }

    public void setAutoCommit(boolean autoCommit) {
        try {
            ConnectionsPool.getConnection(this.bd).setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setSimpleAutoCommit(boolean autoCommit) {
        try {
            ConnectionsPool.getSimpleConnection(this.bd).setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void commit() {
        System.out.println("++++++++++Commit+++++++++++++++++++++++");
        try {
            ConnectionsPool.getConnection(this.bd).commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void simpleCommit() {
        System.out.println("++++++++++Commit Simple Connection+++++++++++++++++++++++");
        try {
            ConnectionsPool.getSimpleConnection(this.bd).commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void rollback() {
        try {
            System.out.println("++++++++++Rollback+++++++++++++++++++++++");
            ConnectionsPool.getConnection(this.bd).rollback();
        }
        catch (SQLException e) {
            System.out.println("Error generando rollback");
            e.printStackTrace();
        }
    }

    public void simpleRollback() {
        try {
            System.out.println("++++++++++Simple Rollback+++++++++++++++++++++++");
            ConnectionsPool.getSimpleConnection(this.bd).rollback();
        }
        catch (SQLException e) {
            System.out.println("Error generando rollback");
            e.printStackTrace();
        }
    }
}

