/*
 * Decompiled with CFR 0.152.
 */
package server.webserver;

import common.comunications.InfoSocket;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.comunications.ResultSetToHtmlTable;
import server.control.UserDataStructure;
import server.database.connection.ConnectionsPool;

public class WebHandler
extends AbstractHandler {
    String greeting = null;
    String body = null;
    SocketChannel sockWeb;
    Element raiz = null;

    public WebHandler() {
        this.greeting = "Servicio web emaku escuchando";
        this.raiz = this.getWebLogin().getRootElement();
        try {
            this.sockWeb = SocketChannel.open();
            this.sockWeb.connect(new InetSocketAddress("localhost", 9117));
            if (ConnectionsPool.chekDataBase(this.raiz.getChild("db").getValue())) {
                UserDataStructure loguser = new UserDataStructure(this.raiz);
                if (loguser.valid()) {
                    String bd = loguser.getBD();
                    String login = loguser.getLogin();
                    String ip = loguser.getIp();
                    String mac = loguser.getMac();
                    System.out.println("ip: " + ip);
                    System.out.println("mac: " + mac);
                    InfoSocket.setLogin((SocketChannel)this.sockWeb, (String)bd, (String)login, (String)ip, (String)mac);
                } else {
                    System.out.println("El usuario web no se pudo logear");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public WebHandler(String greeting) {
        this.greeting = greeting;
    }

    public WebHandler(String greeting, String body) {
        this.greeting = greeting;
        this.body = body;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html;charset=utf-8");
        response.setStatus(200);
        baseRequest.setHandled(true);
        response.getWriter().println("<h1>" + this.greeting + "</h1>");
        ResultSetToHtmlTable table = new ResultSetToHtmlTable("jgomez2017", "XLSEL0007", new String[]{"2018-10-01"}, this.sockWeb);
        Element tabla = table.getTable();
        try {
            XMLOutputter xmlOutputter = new XMLOutputter();
            xmlOutputter.setFormat(Format.getPrettyFormat());
            xmlOutputter.output(tabla, (Writer)response.getWriter());
            xmlOutputter.output(tabla, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        response.getWriter().println(table.getTable().toString());
        if (this.body != null) {
            response.getWriter().println(this.body);
        }
    }

    public Document getWebLogin() {
        Element rootNode = new Element("CNX");
        Document doc = new Document(rootNode);
        rootNode.addContent((Content)new Element("ip").setText("localhost"));
        rootNode.addContent((Content)new Element("mac").setText("00:00:00:00:00:00"));
        rootNode.addContent((Content)new Element("db").setText("intertrans"));
        rootNode.addContent((Content)new Element("login").setText("emaku"));
        rootNode.addContent((Content)new Element("password").setText("123"));
        return doc;
    }
}

