/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.felectronica;

import common.comunications.ArrivedPackageEvent;
import common.comunications.ArrivedPackageListener;
import common.comunications.PackageToXML;
import common.comunications.SocketConnector;
import common.comunications.SocketWriterClient;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.json.JSONObject;
import org.json.JSONTokener;
import server.comunications.WebSocketConnection;
import server.database.connection.ConnectionsPool;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import server.webserver.felectronica.NotifyTransactionEvent;
import server.webserver.felectronica.NotifyTransactionListener;

public class AuthFElectronica
extends HttpServlet
implements ArrivedPackageListener {
    private static final long serialVersionUID = 1L;
    public static final byte[] KEY = "QUIEROUNVOLVOS60".getBytes();
    private static ArrayList<String> idmil;
    private String errMsg;
    private String bd;
    private String login;
    private String password;
    private PackageToXML packageXML = new PackageToXML();
    private Thread socketThread;
    private SocketConnector socketConnector;
    private static Vector<NotifyTransactionListener> notifyTransactionListener;
    private JSONObject ret;

    public AuthFElectronica() {
        idmil = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        BufferedReader reader = request.getReader();
        JSONTokener tokener = new JSONTokener((Reader)reader);
        JSONObject json = new JSONObject(tokener);
        System.out.println("url request: " + request.getRequestURI());
        this.bd = json.getString("bd");
        this.login = json.getString("login");
        this.password = json.getString("password");
        this.ret = new JSONObject();
        System.out.println("Autenticando....");
        System.out.println(json.toString());
        System.out.println("--------------------");
        PrintWriter out = response.getWriter();
        response.setContentType("application/json");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setCharacterEncoding("UTF-8");
        try {
            Connection conn = ConnectionsPool.getConnection(this.bd);
            boolean isloged = false;
            QueryRunner RQdata = new QueryRunner(this.bd, "DESEL0003", new String[]{this.login, this.password});
            ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
            if (RSdata.next() && (isloged = RSdata.getBoolean("isloged"))) {
                this.sendDocument();
                JSONObject jSONObject = this.ret;
                synchronized (jSONObject) {
                    try {
                        this.ret.wait();
                        System.out.println("conectado ...");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                String toauth = this.issueToken(this.bd, this.login);
                this.ret.put("apikey", (Object)toauth);
                out.print(this.ret.toString());
                out.flush();
                return;
            }
            RSdata.close();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        response.setStatus(401);
        JSONObject ret = new JSONObject();
        ret.put("error", (Object)"autentiacion fallida");
        out.print(ret.toString());
        out.flush();
    }

    private String issueToken(String bd, String login) {
        System.out.println("Hoy: " + AuthFElectronica.toDate(LocalDateTime.now()));
        System.out.println("Expira: " + AuthFElectronica.toDate(LocalDateTime.now().plusMinutes(720L)));
        String jwtToken = Jwts.builder().setSubject("JWT User").setIssuedAt(new Date()).setExpiration(AuthFElectronica.toDate(LocalDateTime.now().plusMinutes(720L))).signWith(SignatureAlgorithm.HS512, KEY).claim("bd", (Object)bd).claim("login", (Object)login).compact();
        return jwtToken;
    }

    public static Claims validToken(String jwt) throws SignatureException {
        Claims claims = (Claims)Jwts.parser().setSigningKey(KEY).parseClaimsJws(jwt).getBody();
        return claims;
    }

    private static Date toDate(LocalDateTime ldt) {
        return Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
    }

    private void sendDocument() {
        this.packageXML.addArrivePackageListener((ArrivedPackageListener)this);
        System.out.println("Guardando notificacion...");
        this.socketConnector = WebSocketConnection.getConnection(this.packageXML, this.bd, this.login, this.password, "localhost", false);
        this.socketThread = new Thread((Runnable)this.socketConnector);
        this.socketThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validPackage(ArrivedPackageEvent APe) {
        System.out.println("desde jetty ..................................");
        JSONObject jSONObject = this.ret;
        synchronized (jSONObject) {
            Document doc = APe.getDoc();
            Element raiz = doc.getRootElement();
            String nombre = raiz.getName();
            String ndocument = null;
            XMLOutputter out = new XMLOutputter();
            out.setFormat(Format.getPrettyFormat());
            NotifyTransactionEvent event = null;
            try {
                if (!nombre.equals("ACPZip")) {
                    out.output(doc, (OutputStream)System.out);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("nombre " + nombre);
            if (nombre.equals("ACPZip")) {
                System.out.println("Conectado al ST..");
                this.ret.notifyAll();
            }
            if (nombre.equals("SUCCESS")) {
                String id = raiz.getChildText("id");
                if (idmil.contains(id)) {
                    idmil.remove(id);
                    Element EsuccessMessage = raiz.getChild("successMessage");
                    Element Endocument = raiz.getChild("ndocument");
                    ndocument = Endocument != null ? Endocument.getValue() : "";
                    Element einternal_document = raiz.getChild("internaldocument");
                    Element enotedocument = raiz.getChild("notedocument");
                    Element eprocessDate = raiz.getChild("processDate");
                    String internal_document = einternal_document != null ? einternal_document.getValue() : "";
                    String notedocument = enotedocument != null ? enotedocument.getValue() : "";
                    String processDate = eprocessDate != null ? eprocessDate.getValue() : "";
                    System.out.println("Almacenamiento de notificacion exitoso " + einternal_document);
                    Element cufe = raiz.getChild("CUFE");
                    String text_cufe = "";
                    String text_qr = "";
                    if (cufe != null) {
                        text_cufe = cufe.getChildText("cufe");
                        text_qr = cufe.getChildText("qr");
                    }
                    event = new NotifyTransactionEvent((Object)this, ndocument, internal_document, notedocument, text_cufe, text_qr, processDate);
                }
            } else if (nombre.equals("ERROR")) {
                String internaldocument;
                String id = raiz.getChildText("id");
                Element EerrorMessage = raiz.getChild("errorMsg");
                Element Einternal = raiz.getChild("internaldocument");
                this.errMsg = EerrorMessage != null ? this.toUTF8(EerrorMessage.getText()) : "";
                String string = internaldocument = Einternal != null ? Einternal.getText() : "";
                if (id != null && idmil.equals(id)) {
                    Element Endocument = raiz.getChild("ndocument");
                    ndocument = Endocument != null ? Endocument.getValue() : "";
                    System.out.println("numero del documento: " + ndocument + " id transaccion: " + id);
                    System.out.println("error " + this.errMsg);
                    try {
                        SocketConnector.getSock().close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                event = new NotifyTransactionEvent((Object)this, this.errMsg, internaldocument);
                this.ret.notifyAll();
            }
            AuthFElectronica.notifyTransaction(event);
        }
        System.out.println("fin jetty ..................................");
    }

    private String toUTF8(String text) {
        return text.replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u");
    }

    public static void sendTransaction(Document doc) {
        SocketWriterClient.writing((SocketChannel)SocketConnector.getSock(), (Document)doc);
    }

    public static void closeConnection() throws IOException {
        Element rootNode = new Element("DCNX");
        Document doc = new Document(rootNode);
        if (SocketConnector.isOpen()) {
            SocketWriterClient.writing((SocketChannel)SocketConnector.getSock(), (Document)doc);
            SocketConnector.getSock().close();
        }
        SocketConnector.closeSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyTransaction(NotifyTransactionEvent event) {
        if (event != null) {
            Vector<NotifyTransactionListener> vector = notifyTransactionListener;
            synchronized (vector) {
                for (NotifyTransactionListener l : notifyTransactionListener) {
                    try {
                        l.notifyTransactionEvent(event);
                    }
                    catch (NullPointerException NPEe) {
                        System.out.println("UPs...");
                    }
                }
            }
        }
    }

    public static void addNotifyTransactionListener(NotifyTransactionListener listener) {
        notifyTransactionListener.addElement(listener);
        System.out.println("---------------Numero de oyentes: " + notifyTransactionListener.size());
    }

    public static void removeNotifyTransactionListener(NotifyTransactionListener listener) {
        notifyTransactionListener.removeElement(listener);
    }

    public static void setIdmil(String mil) {
        idmil.add(mil);
    }

    static {
        notifyTransactionListener = new Vector();
    }
}

