/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.felectronica;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.channels.NotYetConnectedException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import server.webserver.felectronica.AuthFElectronica;
import server.webserver.felectronica.NotifyTransactionEvent;
import server.webserver.felectronica.NotifyTransactionListener;

public class JSONAnnullCreditNote
extends HttpServlet
implements NotifyTransactionListener {
    private static final long serialVersionUID = 1L;
    private HttpServletResponse response;
    private Element rootElement;
    private JSONObject ret;
    private String bd;
    private String idmil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.response = response;
        System.out.println("url request: " + request.getRequestURI());
        AuthFElectronica.addNotifyTransactionListener(this);
        BufferedReader reader = request.getReader();
        JSONTokener tokener = new JSONTokener((Reader)reader);
        JSONObject json = new JSONObject(tokener);
        System.out.println("Recibiendo paquete de documento electronico...");
        System.out.println(json.toString());
        System.out.println("------------------------------");
        this.ret = new JSONObject();
        String apikey = json.getString("apikey");
        try {
            Claims claim = AuthFElectronica.validToken(apikey);
            this.bd = (String)claim.get((Object)"bd");
            String login = (String)claim.get((Object)"login");
            this.makeAnnullCreditNote(this.bd, login, json);
            JSONObject jSONObject = this.ret;
            synchronized (jSONObject) {
                this.ret.wait();
                this.responseJson(this.ret);
            }
            System.out.println("data del token: " + this.bd + " login: " + login);
        }
        catch (MalformedJwtException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"TokenInvalido");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (SignatureException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"TokenInvalido");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (InterruptedException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"TokenInvalido");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (JSONException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)e.getMessage());
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (NotYetConnectedException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)e.getMessage());
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (NullPointerException e) {
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"eror escribiendo la transaccion, el socket estaba cerrado");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        AuthFElectronica.removeNotifyTransactionListener(this);
        System.out.println("fin doPost");
    }

    private void responseJson(JSONObject ret) {
        try {
            PrintWriter out = this.response.getWriter();
            this.response.setContentType("application/json");
            this.response.setHeader("Access-Control-Allow-Origin", "*");
            this.response.setCharacterEncoding("UTF-8");
            System.out.println("response: " + ret.toString());
            out.print(ret.toString());
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void makeAnnullCreditNote(String bd, String login, JSONObject json) {
        String numero = json.getString("reference");
        String nnota = json.getString("ID");
        this.rootElement = new Element("TRANSACTION");
        Element driver = new Element("driver");
        driver.setText("WSFETR002");
        this.rootElement.addContent((Content)driver);
        Element id = new Element("id");
        this.idmil = "TB" + System.currentTimeMillis();
        id.setText(this.idmil);
        this.rootElement.addContent((Content)id);
        AuthFElectronica.setIdmil(this.idmil);
        Element enumero = new Element("package");
        enumero.addContent((Content)new Element("field").setText(numero));
        this.rootElement.addContent((Content)enumero);
        Element codigo_tipo = new Element("package");
        codigo_tipo.addContent((Content)new Element("field").setText(json.getJSONObject("InvoiceControl").getString("internal_prefix")));
        this.rootElement.addContent((Content)codigo_tipo);
        Element ennota = new Element("package");
        Element fnnota = new Element("field");
        fnnota.setText(nnota);
        fnnota.setAttribute("name", "nnota");
        fnnota.setAttribute("attribute", "key");
        ennota.addContent((Content)fnnota);
        this.rootElement.addContent((Content)ennota);
        this.rootElement.addContent((Content)this.getNote(json.getJSONArray("note")));
        Document doc = new Document();
        doc.addContent((Content)this.rootElement);
        System.out.println("Escribiendo paquete...");
        AuthFElectronica.sendTransaction(doc);
    }

    private Element getNote(JSONArray note) {
        int length_notes = note.length();
        String full_note = "";
        for (int i = 0; i < length_notes; ++i) {
            full_note = full_note + note.getString(i) + ". ";
        }
        Element enote = new Element("package");
        if (!full_note.equals("")) {
            Element obs = new Element("field");
            obs.setAttribute("name", "obsnota");
            obs.setAttribute("attribute", "key");
            obs.setText(full_note);
            enote.addContent((Content)obs);
        }
        return enote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTransactionEvent(NotifyTransactionEvent e) {
        System.out.println("notificando en JSONAnnullCreditNote ...");
        JSONObject jSONObject = this.ret;
        synchronized (jSONObject) {
            System.out.println("Notificando paquete recibido " + e.getError());
            if (e.getError() != null) {
                System.out.print("Error notificado: " + e.getError());
                this.response.setHeader("Access-Control-Allow-Origin", "*");
                this.response.setStatus(401);
                this.ret.put("error", (Object)e.getError());
                this.ret.put("internaldocument", (Object)e.getInternal_document());
            } else {
                this.response.setHeader("Access-Control-Allow-Origin", "*");
                this.response.setStatus(200);
                this.ret.put("qr", (Object)e.getQr());
                this.ret.put("cude", (Object)e.getCufe());
                this.ret.put("processDate", (Object)e.getProcessDate());
                String xml_path = "/xml/" + this.bd + "/" + e.getNoteDocument();
                System.out.println("ruta xml: " + xml_path);
                this.ret.put("xml", (Object)xml_path);
            }
            this.ret.notify();
        }
    }
}

