/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.felectronica;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.channels.NotYetConnectedException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import server.database.connection.ConnectionsPool;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import server.webserver.felectronica.AuthFElectronica;

public class JSONUnlockElectronicDocument
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private HttpServletResponse response;
    private String bd;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.response = response;
        System.out.println("url request: " + request.getRequestURI());
        BufferedReader reader = request.getReader();
        JSONTokener tokener = new JSONTokener((Reader)reader);
        JSONObject json = new JSONObject(tokener);
        System.out.println("Recibiendo paquete de desbloqueo");
        System.out.println(json.toString());
        System.out.println("------------------------------");
        String apikey = json.getString("apikey");
        try {
            Claims claim = AuthFElectronica.validToken(apikey);
            this.bd = (String)claim.get((Object)"bd");
            String ndocument = json.getString("ndocument");
            this.sendUnlock(this.bd, ndocument);
            response.setStatus(200);
            JSONObject retok = new JSONObject();
            retok.put("message", (Object)"Documento desbloqueado exitosamente");
            this.responseJson(retok);
        }
        catch (MalformedJwtException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"TokenInvalido");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (SignatureException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"TokenInvalido");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (JSONException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)e.getMessage());
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (NotYetConnectedException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)e.getMessage());
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (NullPointerException e) {
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"eror escribiendo la transaccion, el socket estaba cerrado");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (SQLNotFoundException e) {
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"no existe la sentencia invocada");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (SQLBadArgumentsException e) {
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"argumentos invalidos al ejectuar la actualizacion");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (SQLException e) {
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"error actualizando estado de bloqueo");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        System.out.println("fin doPost");
    }

    private void sendUnlock(String bd, String ndocument) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        Connection conn = ConnectionsPool.getConnection(bd);
        QueryRunner RQdata = new QueryRunner(bd, "SIUPD0001", new String[]{ndocument});
        RQdata.ejecutarMTSELECT(conn);
        this.response.setStatus(200);
    }

    private void responseJson(JSONObject ret) {
        try {
            PrintWriter out = this.response.getWriter();
            this.response.setContentType("application/json");
            this.response.setHeader("Access-Control-Allow-Origin", "*");
            this.response.setCharacterEncoding("UTF-8");
            System.out.println("response: " + ret.toString());
            out.print(ret.toString());
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

