/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.rndc;

import common.misc.language.Language;
import common.misc.parameters.ParametersRNDC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.ParseException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;
import server.businessrules.RunTransaction;
import server.database.connection.ConnectionsPool;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import server.webserver.rndc.ElementInfoCarga;
import server.webserver.rndc.ElementInfoViaje;
import server.webserver.rndc.ElementManifiestoCarga;
import server.webserver.rndc.ElementRemesaTerrestre;
import server.webserver.rndc.ElementTercero;
import server.webserver.rndc.ElementVehiculo;
import server.webserver.rndc.SendRNDCWS;

public class ConsumerRNDCWS {
    private final int TIPO_REGISTRO = 1;
    private final int TIPO_CONSULTA_MAESTROS = 2;
    private final int TIPO_CONSULTA_PROCESOS = 3;
    private final int PR_REGISTRO_INFO_CARGA = 1;
    private final int PR_REGISTRO_INFO_VIAJE = 2;
    private final int PR_EXPIDE_REMESA = 3;
    private final int PR_EXPIDE_MANIFIESTO = 4;
    private final int PR_CUMPLIR_REMESA = 5;
    private final int PR_CUMPLIR_MANIFIESTO = 6;
    private final int PR_ANULA_INFO_CARGA = 7;
    private final int PR_ANULA_INFO_VIAJE = 8;
    private final int PR_ANULA_REMESA = 9;
    private final int PR_UDPATE_TERCERO = 11;
    private final int PR_UPDATE_VEHICULO = 12;
    private final int PR_DICCIONARIO_DATOS = 17;
    private final int PR_DICCIONARIO_ERRORES = 27;
    private final int PR_ANULA_MANIFIESTO = 32;
    private String bd;
    private SocketChannel sock;
    private Element subargs;
    private boolean silence;
    private String idTransaction;

    public ConsumerRNDCWS(String bd, Element subargs, SocketChannel sock, String idTransaction) {
        this.bd = bd;
        this.sock = sock;
        this.subargs = subargs;
        this.idTransaction = idTransaction;
    }

    public ConsumerRNDCWS(String bd, SocketChannel sock, boolean silence) {
        this.bd = bd;
        this.sock = sock;
        this.silence = silence;
    }

    public void sendUpdateTercero(String query, String[] args) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException, ParseException, ParserConfigurationException, SAXException, JDOMException {
        Element root = new Element("root");
        root.addContent((Content)this.getAcceso());
        root.addContent((Content)this.getSolicitud(1, 11));
        ElementTercero tercero = new ElementTercero(this.bd);
        root.addContent((Content)tercero.getUPDTercero(query, args));
        ByteArrayOutputStream out = this.ElementToByteArray(root);
        SendRNDCWS sendRNDCWS = new SendRNDCWS(this.bd);
        String response = sendRNDCWS.sendRequest(out);
        System.out.println(response);
        this.getInfoResponse(response);
    }

    public void sendUpdateTercero() throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException, ParseException, ParserConfigurationException, SAXException, JDOMException {
        System.out.println("Creando paquete para updateTercero en RNDC");
        String nitcc = this.subargs.getChildText("arg");
        this.sendUpdateTercero("SCSRN0001", new String[]{nitcc});
    }

    public void sendUpdateVehiculo() throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException, ParseException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        Element root = new Element("root");
        root.addContent((Content)this.getAcceso());
        root.addContent((Content)this.getSolicitud(1, 12));
        String placa = this.subargs.getChildText("arg");
        ElementVehiculo vehiculo = new ElementVehiculo(this.bd);
        root.addContent((Content)vehiculo.getUPDVehiculo(placa));
        ByteArrayOutputStream out = this.ElementToByteArray(root);
        SendRNDCWS sendRNDCWS = new SendRNDCWS(this.bd);
        String response = sendRNDCWS.sendRequest(out);
        System.out.println(response);
        this.getInfoResponse(response);
    }

    public void sendInfoCarga() throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException, ParseException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        String ndocumento = this.subargs.getChildText("arg");
        Connection conn = ConnectionsPool.getConnection(this.bd);
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSRN0003", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
        Element root = new Element("root");
        root.addContent((Content)this.getAcceso());
        root.addContent((Content)this.getSolicitud(1, 1));
        ElementInfoCarga infocarga = new ElementInfoCarga(this.bd, this.sock);
        root.addContent((Content)infocarga.getInfoCarga(RSdata, ndocumento));
        RSdata.close();
        ByteArrayOutputStream out = this.ElementToByteArray(root);
        SendRNDCWS sendRNDCWS = new SendRNDCWS(this.bd);
        String response = sendRNDCWS.sendRequest(out);
        System.out.println(response);
        this.saveUpdateResponse(response, "SCSRN0004", ndocumento, false, null);
    }

    public void sendInfoViaje(ResultSet RSdata, String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException, ParseException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        Element root = new Element("root");
        root.addContent((Content)this.getAcceso());
        root.addContent((Content)this.getSolicitud(1, 2));
        ElementInfoViaje infoviaje = new ElementInfoViaje(this.bd, this.sock);
        root.addContent((Content)infoviaje.getInfoViaje(RSdata, ndocumento));
        ByteArrayOutputStream out = this.ElementToByteArray(root);
        SendRNDCWS sendRNDCWS = new SendRNDCWS(this.bd);
        String response = sendRNDCWS.sendRequest(out);
        System.out.println(response);
        this.saveUpdateResponse(response, "SCSRN0007", ndocumento, true, "Informacion de Viaje");
    }

    public void sendRemesaTerrestre() throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException, ParseException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        String ndocumento = this.subargs.getChildText("arg");
        Connection conn = ConnectionsPool.getConnection(this.bd);
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSRN0003", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
        Element root = new Element("root");
        root.addContent((Content)this.getAcceso());
        root.addContent((Content)this.getSolicitud(1, 3));
        ElementRemesaTerrestre remesaTerrestre = new ElementRemesaTerrestre(this.bd);
        root.addContent((Content)remesaTerrestre.getRemesaTerrestre(RSdata, ndocumento, this.sock));
        ByteArrayOutputStream out = this.ElementToByteArray(root);
        RSdata.close();
        SendRNDCWS sendRNDCWS = new SendRNDCWS(this.bd);
        String response = sendRNDCWS.sendRequest(out);
        System.out.println(response);
        this.saveUpdateResponse(response, "SCSRN0008", ndocumento, true, "Remesa Terrestre");
    }

    public void sendAnulaRemesaTerrestre() throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException, ParseException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        String ndocumento = this.subargs.getChildText("arg");
        Connection conn = ConnectionsPool.getConnection(this.bd);
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSRN0003", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
        Element root = new Element("root");
        root.addContent((Content)this.getAcceso());
        root.addContent((Content)this.getSolicitud(1, 9));
        ElementRemesaTerrestre remesaTerrestre = new ElementRemesaTerrestre(this.bd);
        root.addContent((Content)remesaTerrestre.getAnulaRemesaTerrestre(RSdata, ndocumento));
        ByteArrayOutputStream out = this.ElementToByteArray(root);
        RSdata.close();
        SendRNDCWS sendRNDCWS = new SendRNDCWS(this.bd);
        String response = sendRNDCWS.sendRequest(out);
        System.out.println(response);
        this.saveUpdateResponse(response, "SCSRN0010", ndocumento, true, "Remesa Terrestre");
    }

    public void sendCumplirRemesaTerrestre() throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException, ParseException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        String ndocumento = this.subargs.getChildText("arg");
        Connection conn = ConnectionsPool.getConnection(this.bd);
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSRN0003", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
        Element root = new Element("root");
        root.addContent((Content)this.getAcceso());
        root.addContent((Content)this.getSolicitud(1, 5));
        ElementRemesaTerrestre remesaTerrestre = new ElementRemesaTerrestre(this.bd);
        root.addContent((Content)remesaTerrestre.getCumplirRemesaTerrestre(RSdata, ndocumento));
        ByteArrayOutputStream out = this.ElementToByteArray(root);
        RSdata.close();
        SendRNDCWS sendRNDCWS = new SendRNDCWS(this.bd);
        String response = sendRNDCWS.sendRequest(out);
        System.out.println(response);
        this.saveUpdateResponse(response, "SCSRN0012", ndocumento, true, "Remesa Terrestre");
    }

    public void sendManifiestoCarga() throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException, ParseException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        String ndocumento = this.subargs.getChildText("arg");
        Connection conn = ConnectionsPool.getConnection(this.bd);
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSRN0005", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
        Element root = new Element("root");
        root.addContent((Content)this.getAcceso());
        root.addContent((Content)this.getSolicitud(1, 4));
        ElementManifiestoCarga manifiestoCarga = new ElementManifiestoCarga(this.bd);
        root.addContent((Content)manifiestoCarga.getManifiestoCarga(RSdata, ndocumento));
        RSdata.close();
        ByteArrayOutputStream out = this.ElementToByteArray(root);
        SendRNDCWS sendRNDCWS = new SendRNDCWS(this.bd);
        String response = sendRNDCWS.sendRequest(out);
        System.out.println(response);
        this.saveUpdateResponseWithTime(response, "SCSRN0009", ndocumento, true, "Manifiesto Electronico");
    }

    public void sendAnulaManifiestoCarga() throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException, ParseException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        String ndocumento = this.subargs.getChildText("arg");
        Connection conn = ConnectionsPool.getConnection(this.bd);
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSRN0005", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
        Element root = new Element("root");
        root.addContent((Content)this.getAcceso());
        root.addContent((Content)this.getSolicitud(1, 32));
        ElementManifiestoCarga manifiestoCarga = new ElementManifiestoCarga(this.bd);
        root.addContent((Content)manifiestoCarga.getAnulaManifiestoCarga(RSdata, ndocumento));
        RSdata.close();
        ByteArrayOutputStream out = this.ElementToByteArray(root);
        SendRNDCWS sendRNDCWS = new SendRNDCWS(this.bd);
        String response = sendRNDCWS.sendRequest(out);
        System.out.println(response);
        this.saveUpdateResponse(response, "SCSRN0011", ndocumento, true, "Manifiesto Electronico");
    }

    public void sendCumplirManifiestoCarga() throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException, ParseException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        String ndocumento = this.subargs.getChildText("arg");
        Connection conn = ConnectionsPool.getConnection(this.bd);
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSRN0005", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
        Element root = new Element("root");
        root.addContent((Content)this.getAcceso());
        root.addContent((Content)this.getSolicitud(1, 6));
        ElementManifiestoCarga manifiestoCarga = new ElementManifiestoCarga(this.bd);
        root.addContent((Content)manifiestoCarga.getCumplirManifiestoCarga(RSdata, ndocumento));
        RSdata.close();
        ByteArrayOutputStream out = this.ElementToByteArray(root);
        SendRNDCWS sendRNDCWS = new SendRNDCWS(this.bd);
        String response = sendRNDCWS.sendRequest(out);
        System.out.println(response);
        this.saveUpdateResponse(response, "SCSRN0013", ndocumento, true, "Manifiesto Electronico");
    }

    private ByteArrayOutputStream ElementToByteArray(Element root) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLOutputter xmlOutputter = new XMLOutputter();
        xmlOutputter.setFormat(Format.getPrettyFormat());
        xmlOutputter.output(root, (OutputStream)out);
        System.out.println("-----------------------------------------------");
        xmlOutputter.output(root, (OutputStream)System.out);
        System.out.println("-----------------------------------------------");
        return out;
    }

    private void saveUpdateResponse(String response, String query, String ndocumento, boolean cancelProcess, String nameProccess) throws JDOMException, IOException, SQLException, SQLNotFoundException, SQLBadArgumentsException {
        SAXBuilder sax = new SAXBuilder();
        ByteArrayInputStream data = new ByteArrayInputStream(response.getBytes("UTF-8"));
        Document responseDocument = sax.build((InputStream)data);
        Element root = responseDocument.getRootElement().getChild("ingresoid");
        if (root != null) {
            String aut = root.getText();
            System.out.println("Informacion de carga registrada exitosamente en RNDC, id: " + aut);
            System.out.println("ndocumento: " + ndocumento);
            System.out.println("query: " + query);
            QueryRunner RQdata = new QueryRunner(this.bd);
            RQdata.ejecutarSimpleSQLCommit(query, new String[]{aut, ndocumento});
            System.out.print("Registro actualizado");
            RunTransaction.successMessage(this.sock, this.idTransaction, Language.getWord((String)"TRANSACTION_OK"));
        } else {
            System.out.println("Error registrando la informacion de carga en RNDC....");
            RunTransaction.errorMessage(this.sock, this.idTransaction, response);
            if (cancelProcess) {
                throw new SQLException("Error registrando " + nameProccess);
            }
        }
    }

    private void saveUpdateResponseWithTime(String response, String query, String ndocumento, boolean cancelProcess, String nameProccess) throws JDOMException, IOException, SQLException, SQLNotFoundException, SQLBadArgumentsException {
        SAXBuilder sax = new SAXBuilder();
        ByteArrayInputStream data = new ByteArrayInputStream(response.getBytes("UTF-8"));
        Document responseDocument = sax.build((InputStream)data);
        Element root = responseDocument.getRootElement().getChild("ingresoid");
        Element seguridadqr = responseDocument.getRootElement().getChild("seguridadqr");
        if (root != null) {
            String aut = root.getText();
            System.out.println("Informacion de carga registrada exitosamente en RNDC, id: " + aut);
            QueryRunner RQdata = new QueryRunner(this.bd);
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            RQdata.ejecutarSimpleSQLCommit(query, new String[]{root.getText(), seguridadqr.getText(), formatter.format(date), ndocumento});
            System.out.print("Registro actualizado");
            String seg = seguridadqr.getText();
            formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            Connection conn = ConnectionsPool.getConnection(this.bd);
            QueryRunner RQqr = new QueryRunner(this.bd, "SCSRN0014", new String[]{ndocumento});
            ResultSet RSdata = RQqr.ejecutarMTSELECT(conn);
            if (RSdata.next()) {
                RunTransaction.successMessage(this.sock, this.idTransaction, Language.getWord((String)"TRANSACTION_OK"), aut, seg, formatter.format(date), RSdata.getString("qr"));
                RSdata.close();
            }
        } else {
            System.out.println("Error registrando la informacion de carga en RNDC....");
            RunTransaction.errorMessage(this.sock, this.idTransaction, response);
            if (cancelProcess) {
                throw new SQLException("Error registrando " + nameProccess);
            }
        }
    }

    private void getInfoResponse(String response) throws JDOMException, IOException {
        SAXBuilder sax = new SAXBuilder();
        ByteArrayInputStream data = new ByteArrayInputStream(response.getBytes("UTF-8"));
        Document responseDocument = sax.build((InputStream)data);
        Element root = responseDocument.getRootElement().getChild("ingresoid");
        if (root != null) {
            System.out.println("Infomacion registrada exitosamente en RNDC, id: " + root.getText());
            if (!this.silence) {
                RunTransaction.successMessage(this.sock, this.idTransaction, Language.getWord((String)"TRANSACTION_OK"));
            }
        } else {
            System.out.println("Error registrando infomacion en RNDC....");
            RunTransaction.errorMessage(this.sock, this.idTransaction, response);
        }
    }

    private Element getAcceso() {
        Element acceso = new Element("acceso");
        Element username = new Element("username");
        username.setText(ParametersRNDC.getUsername());
        Element password = new Element("password");
        password.setText(ParametersRNDC.getPassword());
        acceso.addContent((Content)username);
        acceso.addContent((Content)password);
        return acceso;
    }

    private Element getSolicitud(int _tipo, int _procesoid) {
        Element solicitud = new Element("solicitud");
        Element tipo = new Element("tipo");
        tipo.setText(String.valueOf(_tipo));
        Element procesoid = new Element("procesoid");
        procesoid.setText(String.valueOf(_procesoid));
        solicitud.addContent((Content)tipo);
        solicitud.addContent((Content)procesoid);
        return solicitud;
    }
}

