/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.rndc;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.ParseException;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;
import server.database.sql.LinkingCache;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import server.webserver.rndc.ConsumerRNDCWS;

public class ElementRemesaTerrestre {
    private String bd;

    public ElementRemesaTerrestre(String bd) {
        this.bd = bd;
    }

    public Element getRemesaTerrestre(ResultSet RSdata, String ndocumento, SocketChannel sock) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException, IOException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        if (RSdata.next()) {
            String radicado_remesa = RSdata.getString("radicado_remesa");
            boolean estado = RSdata.getBoolean("estado");
            String numero = RSdata.getString("numero");
            String cod_operacion = RSdata.getString("cod_operacion");
            String cod_empaque = RSdata.getString("cod_empaque");
            String cod_natu_carga = RSdata.getString("cod_nat_carga");
            String descripcion = RSdata.getString("descripcion");
            String cod_descripcion = RSdata.getString("cod_descripcion");
            String peso = RSdata.getString("peso");
            String und_peso = RSdata.getString("und_peso");
            String tipo_doc_remitente = RSdata.getString("tipo_doc_remitente");
            String nitcc_remitente = RSdata.getString("nitcc_remitente");
            String tipo_doc_destinatario = RSdata.getString("tipo_doc_destinatario");
            String nitcc_destinatario = RSdata.getString("nitcc_destinatario");
            String horas_cargue = RSdata.getString("horas_cargue");
            String mins_cargue = RSdata.getString("mins_cargue");
            String horas_descargue = RSdata.getString("horas_descargue");
            String mins_descargue = RSdata.getString("mins_descargue");
            String duenopoliza = RSdata.getString("duenopoliza");
            String numpolizatransporte = RSdata.getString("numpolizatransporte");
            String companiaseguro = RSdata.getString("companiaseguro");
            String fechavencimientopolizacarga = RSdata.getString("fechavencimientopolizacarga");
            String fechallegadacargue = RSdata.getString("fechallegadacargue");
            String horallegadacargueremesa = RSdata.getString("horallegadacargueremesa");
            String fechaentradacargue = RSdata.getString("fechaentradacargue");
            String horaentradacargueremesa = RSdata.getString("horaentradacargueremesa");
            String horasalidacargueremesa = RSdata.getString("horasalidacargueremesa");
            String fechasalidacargue = RSdata.getString("fechasalidacargue");
            String fecha_cargue = RSdata.getString("fecha_cargue");
            String fecha_descargue = RSdata.getString("fecha_descargue");
            String hcita_descargue = RSdata.getString("hcita_descargue");
            String cita_cargue = RSdata.getString("cita_cargue");
            RSdata.close();
            if (radicado_remesa != null) {
                throw new SQLException("La Informaci\u00f3n de carga ya se encuentra exportada");
            }
            if (!estado) {
                RSdata.close();
                throw new SQLException("La remesa terrestre de carga " + numero + " se encuentra anulada por tanto no puede ser exportada");
            }
            ConsumerRNDCWS sendTerceros = new ConsumerRNDCWS(this.bd, sock, true);
            sendTerceros.sendUpdateTercero("SCSRN0015", new String[]{ndocumento});
            sendTerceros.sendUpdateTercero("SCSRN0016", new String[]{ndocumento});
            Element variables = new Element("variables");
            variables.addContent((Content)this.addElement("NUMNITEMPRESATRANSPORTE", LinkingCache.getNit(this.bd) + LinkingCache.getDV(this.bd)));
            variables.addContent((Content)this.addElement("CONSECUTIVOREMESA", numero));
            variables.addContent((Content)this.addElement("CODOPERACIONTRANSPORTE", cod_operacion));
            variables.addContent((Content)this.addElement("CODNATURALEZACARGA", cod_natu_carga));
            variables.addContent((Content)this.addElement("CANTIDADCARGADA", peso));
            variables.addContent((Content)this.addElement("UNIDADMEDIDACAPACIDAD", und_peso));
            variables.addContent((Content)this.addElement("CODTIPOEMPAQUE", cod_empaque));
            variables.addContent((Content)this.addElement("MERCANCIAREMESA", cod_descripcion));
            variables.addContent((Content)this.addElement("DESCRIPCIONCORTAPRODUCTO", descripcion));
            variables.addContent((Content)this.addElement("CODTIPOIDREMITENTE", tipo_doc_remitente));
            variables.addContent((Content)this.addElement("NUMIDREMITENTE", nitcc_remitente));
            variables.addContent((Content)this.addElement("CODTIPOIDDESTINATARIO", tipo_doc_destinatario));
            variables.addContent((Content)this.addElement("NUMIDDESTINATARIO", nitcc_destinatario));
            variables.addContent((Content)this.addElement("DUENOPOLIZA", duenopoliza));
            variables.addContent((Content)this.addElement("NUMPOLIZATRANSPORTE", numpolizatransporte));
            variables.addContent((Content)this.addElement("COMPANIASEGURO", companiaseguro));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            Date date = format.parse(fechavencimientopolizacarga);
            variables.addContent((Content)this.addElement("FECHAVENCIMIENTOPOLIZACARGA", formatter.format(date)));
            variables.addContent((Content)this.addElement("HORACITAPACTADACARGUE", cita_cargue));
            variables.addContent((Content)this.addElement("HORASPACTOCARGA", horas_cargue));
            variables.addContent((Content)this.addElement("MINUTOSPACTOCARGA", mins_cargue));
            variables.addContent((Content)this.addElement("HORASPACTODESCARGUE", horas_descargue));
            variables.addContent((Content)this.addElement("MINUTOSPACTODESCARGUE", mins_descargue));
            variables.addContent((Content)this.addElement("CODTIPOIDPROPIETARIO", tipo_doc_remitente));
            variables.addContent((Content)this.addElement("NUMIDPROPIETARIO", nitcc_remitente));
            date = format.parse(fechallegadacargue);
            variables.addContent((Content)this.addElement("FECHALLEGADACARGUE", formatter.format(date)));
            variables.addContent((Content)this.addElement("HORALLEGADACARGUEREMESA", horallegadacargueremesa));
            date = format.parse(fechaentradacargue);
            variables.addContent((Content)this.addElement("FECHAENTRADACARGUE", formatter.format(date)));
            variables.addContent((Content)this.addElement("HORAENTRADACARGUEREMESA", horaentradacargueremesa));
            date = format.parse(fechasalidacargue);
            variables.addContent((Content)this.addElement("FECHASALIDACARGUE", formatter.format(date)));
            variables.addContent((Content)this.addElement("HORASALIDACARGUEREMESA", horasalidacargueremesa));
            date = format.parse(fecha_cargue);
            variables.addContent((Content)this.addElement("FECHACITAPACTADACARGUE", formatter.format(date)));
            variables.addContent((Content)this.addElement("HORACITAPACTADADESCARGUEREMESA", hcita_descargue));
            date = format.parse(fecha_descargue);
            variables.addContent((Content)this.addElement("FECHACITAPACTADADESCARGUE", formatter.format(date)));
            return variables;
        }
        RSdata.close();
        throw new SQLException("La consulta con argumento " + ndocumento + " no retorno informacion para ser procesada");
    }

    public Element getAnulaRemesaTerrestre(ResultSet RSdata, String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException, IOException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        if (RSdata.next()) {
            String radicado_anula_remesa = RSdata.getString("radicado_anula_remesa");
            String cumplido_remesa = RSdata.getString("cumplido_remesa");
            String numero = RSdata.getString("numero");
            boolean estado = RSdata.getBoolean("estado");
            RSdata.close();
            if (radicado_anula_remesa != null) {
                throw new SQLException("La remesa terrestre numero " + numero + " ya se encontraba anulada");
            }
            if (cumplido_remesa != null) {
                throw new SQLException("La remesa terrestre numero " + numero + " ya se encontraba cumplida en RNDC, por tanto no puede ser anulada");
            }
            if (estado) {
                throw new SQLException("Primero debe anular el documento de forma local");
            }
            Element variables = new Element("variables");
            variables.addContent((Content)this.addElement("NUMNITEMPRESATRANSPORTE", LinkingCache.getNit(this.bd) + LinkingCache.getDV(this.bd)));
            variables.addContent((Content)this.addElement("CONSECUTIVOREMESA", numero));
            variables.addContent((Content)this.addElement("MOTIVOREVERSAREMESA", "A"));
            variables.addContent((Content)this.addElement("MOTIVOANULACIONREMESA", "D"));
            return variables;
        }
        RSdata.close();
        throw new SQLException("La consulta con argumento " + ndocumento + " no retorno informacion para ser procesada");
    }

    public Element getCumplirRemesaTerrestre(ResultSet RSdata, String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException, IOException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        if (RSdata.next()) {
            String radicado_anula_remesa = RSdata.getString("radicado_anula_remesa");
            String cumplido_remesa = RSdata.getString("cumplido_remesa");
            String numero = RSdata.getString("numero");
            String peso = RSdata.getString("peso");
            String fechallegadacargue = RSdata.getString("fechallegadacargue");
            boolean estado = RSdata.getBoolean("estado");
            RSdata.close();
            if (radicado_anula_remesa != null) {
                throw new SQLException("La remesa terrestre numero " + numero + " ya se encontraba anulada");
            }
            if (cumplido_remesa != null) {
                throw new SQLException("La remesa terrestre numero " + numero + " ya se encontraba cumplida en RNDC");
            }
            if (!estado) {
                throw new SQLException("No puede generar cumplido de una remesa anulada localmente");
            }
            Element variables = new Element("variables");
            variables.addContent((Content)this.addElement("NUMNITEMPRESATRANSPORTE", LinkingCache.getNit(this.bd) + LinkingCache.getDV(this.bd)));
            variables.addContent((Content)this.addElement("CONSECUTIVOREMESA", numero));
            variables.addContent((Content)this.addElement("TIPOCUMPLIDOREMESA", "C"));
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            Date date = new Date();
            Date hora = new Date();
            SimpleDateFormat formathora = new SimpleDateFormat("HH:mm");
            long t = hora.getTime();
            Date horaLlegada = new Date(t - 9000000L);
            Date horaEntrada = new Date(t - 8900000L);
            Date horaSalida = new Date(t - 8700000L);
            Date horaLlegadaCumplido = new Date(t - 190000L);
            Date horaEntradaCumplido = new Date(t - 100000L);
            variables.addContent((Content)this.addElement("FECHALLEGADADESCARGUE", formatter.format(date)));
            variables.addContent((Content)this.addElement("FECHASALIDADESCARGUE", formatter.format(date)));
            variables.addContent((Content)this.addElement("HORALLEGADACARGUEREMESA", formathora.format(horaLlegada)));
            variables.addContent((Content)this.addElement("HORAENTRADACARGUEREMESA", formathora.format(horaEntrada)));
            variables.addContent((Content)this.addElement("HORASALIDACARGUEREMESA", formathora.format(horaSalida)));
            variables.addContent((Content)this.addElement("FECHAENTRADADESCARGUE", formatter.format(date)));
            variables.addContent((Content)this.addElement("HORALLEGADADESCARGUECUMPLIDO", formathora.format(horaLlegadaCumplido)));
            variables.addContent((Content)this.addElement("HORAENTRADADESCARGUECUMPLIDO", formathora.format(horaEntradaCumplido)));
            variables.addContent((Content)this.addElement("HORASALIDADESCARGUECUMPLIDO", formathora.format(hora)));
            variables.addContent((Content)this.addElement("CANTIDADENTREGADA", peso));
            variables.addContent((Content)this.addElement("OBSERVACIONES", "Ninguna"));
            return variables;
        }
        RSdata.close();
        throw new SQLException("La consulta con argumento " + ndocumento + " no retorno informacion para ser procesada");
    }

    public Element addElement(String nameElement, String value) {
        Element elm = new Element(nameElement);
        elm.setText(value);
        return elm;
    }
}

