/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.servlets.felectronica;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import server.database.connection.ConnectionsPool;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class ListObjectInvoiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String bd;

    public ListObjectInvoiceServlet(String bd) {
        this.bd = bd;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession misession = request.getSession();
        String id = (String)misession.getAttribute("id");
        Connection conn = ConnectionsPool.getConnection(this.bd);
        try {
            QueryRunner RQdata = new QueryRunner(this.bd, "DESEL0008", new String[]{id});
            ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
            RSdata.next();
            String nombre = RSdata.getString("nombre");
            String razon_social = RSdata.getString("razon_social");
            String id_char = RSdata.getString("id_char");
            response.getWriter().print("<div class=\"row\"><div class=\"col s12 m12\"><div class=\"card\"><center><br/><h5>Listado de facturas objetables (menores a 48 horas de expedicion)</h5></center>");
            if (razon_social.equals("")) {
                response.getWriter().print("<center><h5>" + nombre + "</h5></center>");
            } else {
                response.getWriter().print("<center><h5>" + razon_social + "</h5></center>");
            }
            response.getWriter().print("<center><h5>" + id_char + "</h5></center>");
            response.getWriter().print("<br></br>");
            RQdata = new QueryRunner(this.bd, "DESEL0007", new String[]{id});
            RSdata = RQdata.ejecutarMTSELECT(conn);
            response.getWriter().print("<div class=\"tabledata\">");
            response.getWriter().print("<table class=\"centered\"><thead><tr><th>Numero</th><th>Fecha</th><th>Cufe</th><th>No. Headecimal</th><th>Valor</th></tr></thead>");
            response.getWriter().print("<tbody>");
            ResultSetMetaData RSMDinfo = RSdata.getMetaData();
            int columnas = RSMDinfo.getColumnCount();
            boolean records = false;
            while (RSdata.next()) {
                records = true;
                response.getWriter().print("<tr>");
                String params = "";
                for (int j = 1; j <= columnas; ++j) {
                    if (j != 1) {
                        response.getWriter().print("<td>");
                    }
                    if (j == 1) {
                        params = RSdata.getString("params");
                    } else if (j == 2) {
                        String number = RSdata.getString(j);
                        response.getWriter().print("<a href=\"?page=object-efactura.jsp?nombre=" + nombre + "&rs=" + razon_social + "&nitcc=" + id_char + "&" + params + "\" class=\"btn-flat descargar\" id=\"dwlink\" name=\"" + number + "\">" + number + "</a>");
                    } else if (j == 6) {
                        DecimalFormat df2 = new DecimalFormat("#,###,###,##0.00");
                        response.getWriter().print(df2.format(RSdata.getDouble(j)));
                    } else {
                        response.getWriter().print(RSdata.getString(j));
                    }
                    if (j == 1) continue;
                    response.getWriter().println("</td>");
                }
                response.getWriter().print("<tr>");
            }
            response.getWriter().print("</tbody></table>");
            if (!records) {
                response.getWriter().print("<center><br><span class=\"error-text\">No se encontraron registros</span></br></center>");
            }
            response.getWriter().print("</div></div></div></div>");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
    }
}

