/*
 * Decompiled with CFR 0.152.
 */
package common.control;

import common.control.DateEvent;
import common.control.DateListener;
import common.control.ErrorEvent;
import common.control.ErrorListener;
import common.control.ErrorMessageException;
import common.control.ReportEvent;
import common.control.ReportListener;
import common.control.SuccessEvent;
import common.control.SuccessListener;
import common.control.UpdateCodeEvent;
import common.control.UpdateCodeListener;
import common.transactions.Cache;
import common.transactions.TransactionServerResultSet;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;

public class ClientHeaderValidator {
    private static Element raiz;
    private static Vector<DateListener> dateListener;
    private static Vector<UpdateCodeListener> updateCodeListener;
    private static Vector<ReportListener> reportListener;
    private static Vector<SuccessListener> successListener;
    private static Vector<ErrorListener> errorListener;

    public static boolean validGeneral(Document doc) throws ErrorMessageException {
        raiz = doc.getRootElement();
        String nombre = raiz.getName();
        if (nombre.equals("ANSWER")) {
            String id = raiz.getChildText("id");
            TransactionServerResultSet.putSpoolQuery(id, doc);
            return true;
        }
        if (nombre.equals("MESSAGE")) {
            System.out.println("Recibi un paquete MESSAGE");
            return true;
        }
        if (nombre.equals("UPDATECODE")) {
            String key = raiz.getChildText("idDocument");
            String consecutive = raiz.getChildText("consecutive");
            UpdateCodeEvent event = new UpdateCodeEvent(new ClientHeaderValidator(), key, consecutive);
            ClientHeaderValidator.notifyUpdateCode(event);
            return true;
        }
        if (nombre.equals("DATE")) {
            String systemDate = raiz.getChildText("systemDate");
            DateEvent event = new DateEvent(new ClientHeaderValidator(), systemDate);
            ClientHeaderValidator.notifyDate(event);
            return true;
        }
        if (nombre.equals("PLAINREPORT") || nombre.equals("REPORT")) {
            Element element = null;
            element = raiz.getChild("data");
            boolean plain = false;
            if (nombre.equals("PLAINREPORT")) {
                plain = true;
            }
            ReportEvent report = new ReportEvent(new ClientHeaderValidator(), raiz.getChildText("idReport"), raiz.getChildText("titleReport"), element, plain);
            ClientHeaderValidator.notifyReport(report);
            return true;
        }
        if (nombre.equals("SUCCESS")) {
            String id = raiz.getChildText("id");
            String ndocument = "";
            String message = "";
            if ("Q".equals(id.substring(0, 1))) {
                TransactionServerResultSet.putSpoolQuery(id, doc);
            } else if ("T".equals(id.substring(0, 1))) {
                Element EsuccessMessage = raiz.getChild("successMessage");
                Element Endocument = raiz.getChild("ndocument");
                message = EsuccessMessage.getText();
                ndocument = Endocument != null ? Endocument.getValue() : "";
            }
            SuccessEvent event = new SuccessEvent(new ClientHeaderValidator(), id, ndocument, message);
            ClientHeaderValidator.notifySuccess(event);
            System.gc();
            return true;
        }
        if (nombre.equals("CACHE-ANSWER")) {
            new Cache(doc);
            return true;
        }
        if (nombre.equals("ERROR")) {
            String id = raiz.getChildText("id");
            String ndocument = "";
            String message = "";
            if (id != null && "Q".equals(id.substring(0, 1))) {
                TransactionServerResultSet.putSpoolQuery(id, doc);
            } else if (id != null && "T".equals(id.substring(0, 1))) {
                Element EerrorMessage = raiz.getChild("errorMessage");
                Element Endocument = raiz.getChild("ndocument");
                message = EerrorMessage != null ? EerrorMessage.getText() : "";
                ndocument = Endocument != null ? Endocument.getValue() : "";
                System.out.println("numero del documento: " + ndocument + " id transaccion: " + id);
            }
            ErrorEvent event = new ErrorEvent(new ClientHeaderValidator(), id, ndocument, message);
            ClientHeaderValidator.notifyError(event);
            throw new ErrorMessageException(id);
        }
        return false;
    }

    private static void notifyReport(ReportEvent event) {
        for (ReportListener l : reportListener) {
            l.arriveReport(event);
        }
    }

    public static void addReportListener(ReportListener listener) {
        reportListener.add(listener);
    }

    public static void removeReportListener(ReportListener listener) {
        reportListener.add(listener);
    }

    public static void addDateListener(DateListener listener) {
        dateListener.addElement(listener);
    }

    public static void removeDateListener(DateListener listener) {
        dateListener.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyDate(DateEvent event) {
        Vector<DateListener> vector = dateListener;
        synchronized (vector) {
            for (DateListener l : dateListener) {
                if (l != null) {
                    l.cathDateEvent(event);
                    continue;
                }
                dateListener.remove(l);
            }
        }
    }

    public static void addUpdateCodeListener(UpdateCodeListener listener) {
        updateCodeListener.addElement(listener);
    }

    public static void removeUpdateCodeListener(UpdateCodeListener listener) {
        updateCodeListener.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyUpdateCode(UpdateCodeEvent event) {
        Vector<UpdateCodeListener> vector = updateCodeListener;
        synchronized (vector) {
            for (UpdateCodeListener l : updateCodeListener) {
                l.cathUpdateCodeEvent(event);
            }
        }
    }

    public static void addSuccessListener(SuccessListener listener) {
        successListener.addElement(listener);
    }

    public static void removeSuccessListener(SuccessListener listener) {
        successListener.removeElement(listener);
    }

    private static void notifySuccess(SuccessEvent event) {
        for (SuccessListener l : successListener) {
            l.cathSuccesEvent(event);
        }
    }

    public static void addErrorListener(ErrorListener listener) {
        errorListener.addElement(listener);
    }

    public static void removeErrorListener(ErrorListener listener) {
        errorListener.removeElement(listener);
    }

    private static synchronized void notifyError(ErrorEvent event) {
        for (ErrorListener l : errorListener) {
            l.cathErrorEvent(event);
        }
    }

    static {
        dateListener = new Vector();
        updateCodeListener = new Vector();
        reportListener = new Vector();
        successListener = new Vector();
        errorListener = new Vector();
    }
}

