/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import common.comunications.DateSender;
import common.control.ClientHeaderValidator;
import common.control.ErrorEvent;
import common.control.ErrorListener;
import common.control.SuccessEvent;
import common.control.SuccessListener;
import common.gui.components.Components;
import common.gui.components.MalformedProfileException;
import common.gui.forms.GenericForm;
import common.gui.forms.NotFoundComponentException;
import common.gui.forms.XLSReceiver;
import common.misc.Icons;
import common.misc.language.Language;
import common.misc.parameters.EmakuParametersStructure;
import common.pdf.pdfviewer.PDFViewer;
import common.printer.PlainPrintingManager;
import common.printer.PostScriptManager;
import common.printer.PrintingManager;
import common.printer.plainViewer.TextReportViewer;
import common.transactions.TransactionServerResultSet;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.print.PrintException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ButtonsPanel
extends JPanel
implements ActionListener,
KeyListener,
SuccessListener,
ErrorListener {
    private static final long serialVersionUID = 8883108186183650115L;
    private GenericForm GFforma;
    private Hashtable<String, Vector<?>> Heventos;
    private Hashtable<String, Vector> Hform;
    private Hashtable<String, JButton> Hbuttons;
    private String idTransaction;
    private String accel = "";
    private String idReport;
    private PlainPrintingManager plainManager = new PlainPrintingManager();
    private PostScriptManager postScriptManager = new PostScriptManager();
    private String typePackage = "TRANSACTION";
    private String lastNumber;
    private boolean actionFinish;
    private boolean badActionFinish;

    public ButtonsPanel(GenericForm GFforma, Document doc) {
        this.GFforma = GFforma;
        this.setLayout(new FlowLayout(4));
        ClientHeaderValidator.addSuccessListener(this);
        ClientHeaderValidator.addErrorListener(this);
        this.Heventos = new Hashtable();
        this.Hbuttons = new Hashtable();
        this.Hform = new Hashtable();
        Element args = doc.getRootElement();
        for (Element e : args.getChildren()) {
            JButton button;
            String name = e.getValue();
            String label = null;
            String icon = null;
            String keyStroke = null;
            boolean enabled = true;
            if ("false".equals(e.getAttributeValue("enabled"))) {
                enabled = false;
            }
            if ("subarg".equals(e.getName())) {
                for (Element el : e.getChildren()) {
                    if ("label".equals(el.getAttributeValue("attribute"))) {
                        label = el.getValue();
                    }
                    if ("icon".equals(el.getAttributeValue("attribute"))) {
                        icon = el.getValue();
                    }
                    if ("enabled".equals(el.getAttributeValue("attribute"))) {
                        enabled = Boolean.parseBoolean(el.getValue());
                    }
                    if ("keyStroke".equals(el.getAttributeValue("attribute"))) {
                        keyStroke = el.getValue();
                    }
                    if ("typePackage".equals(el.getAttributeValue("attribute"))) {
                        this.typePackage = el.getValue();
                    }
                    if (!"idReport".equals(el.getAttributeValue("attribute"))) continue;
                    this.idReport = el.getValue();
                }
            }
            if (label != null) {
                button = this.buildButton(label, icon, enabled, keyStroke);
                name = label;
            } else {
                button = this.buildButton(name, enabled);
            }
            this.Hbuttons.put(name, button);
            this.add(button);
        }
    }

    private JButton buildButton(String label, String icon, boolean enabled, String keyStroke) {
        JButton button = new JButton();
        try {
            button.setIcon(new ImageIcon(this.getClass().getResource(Icons.getIcon(icon))));
        }
        catch (NullPointerException NPEe) {
            try {
                button.setIcon(new ImageIcon(this.getClass().getResource(icon)));
            }
            catch (NullPointerException NPEe2) {
                // empty catch block
            }
        }
        button.setActionCommand(label);
        button.setEnabled(enabled);
        this.setAccelerators(button, keyStroke);
        return button;
    }

    private JButton buildButton(String name, boolean enabled) {
        JButton button = new JButton();
        try {
            button.setEnabled(enabled);
            button.setActionCommand(name);
            button.setIcon(new ImageIcon(this.getClass().getResource(Icons.getIcon(name))));
        }
        catch (NullPointerException NPEe) {
            // empty catch block
        }
        this.setAccelerators(button, null);
        return button;
    }

    public void setAccelerators(JButton button, String keyStroke) {
        button.addActionListener(this);
        button.addKeyListener(this);
        String name = button.getActionCommand();
        if (keyStroke != null) {
            this.accel = keyStroke;
        } else if (name.equals("NEW")) {
            this.accel = "F5";
        } else if (name.equals("SAVE") || name.equals("SAVEAS")) {
            this.accel = "F7";
        } else if (name.equals("PRINT")) {
            this.accel = "F9";
        } else if (name.equals("EXIT")) {
            this.accel = "F4";
        }
        button.getInputMap(2).put(KeyStroke.getKeyStroke(this.accel), "answer");
        button.getActionMap().put("answer", new AbstractAction("answer"){
            private static final long serialVersionUID = 7031745964120299130L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((JButton)evt.getSource()).doClick();
            }
        });
    }

    public void setEnabled(String name, boolean bool) {
        if (this.Hbuttons.containsKey(name)) {
            this.Hbuttons.get(name).setEnabled(bool);
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public void setEvents(Document doc) {
        Element args = doc.getRootElement();
        for (Element e : args.getChildren()) {
            this.loadEvent(e);
        }
    }

    private void loadEvent(Element elm) {
        Iterator i = elm.getChildren().iterator();
        String key = "";
        Vector<Components> componentes = new Vector<Components>();
        Vector<Element> actions = new Vector<Element>();
        Vector<Element> formularios = new Vector<Element>();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (name.equals("name")) {
                key = e.getValue();
                continue;
            }
            if (name.equals("component")) {
                componentes.add(this.loadComponent(e));
                continue;
            }
            if (name.equals("FORM")) {
                formularios.add(e);
                continue;
            }
            if (!name.equals("action")) continue;
            actions.add(e);
        }
        if (componentes.size() > 0) {
            this.Heventos.put(key, componentes);
        }
        if (actions.size() > 0) {
            this.Heventos.put(key, actions);
        }
        if (formularios.size() > 0) {
            this.Hform.put(key, formularios);
        }
    }

    private Components loadComponent(Element elm) {
        Iterator i = elm.getChildren().iterator();
        Components comp = new Components();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (name.equals("driver")) {
                if (e.getAttributeValue("id") != null) {
                    comp.setDriver(e.getValue() + e.getAttributeValue("id"));
                    continue;
                }
                comp.setDriver(e.getValue());
                continue;
            }
            if (name.equals("method")) {
                comp.setMethod(e.getValue());
                continue;
            }
            if (!name.equals("parameters")) continue;
            comp.setArgs(e);
        }
        return comp;
    }

    private void close() {
        this.GFforma.close();
    }

    private void callEvent(String action) throws InvocationTargetException, NotFoundComponentException, IOException {
        Vector<Components> vec = this.Heventos.get(action);
        Object obj = vec.get(0);
        if (obj instanceof Components) {
            this.builTransaction(vec, action, null, null);
        } else if (obj instanceof Element) {
            for (Object obj2 : vec) {
                this.actionFinish = false;
                this.badActionFinish = false;
                Element element = (Element)obj2;
                String type = element.getChildText("type");
                String idManualTransaction = element.getChildText("idManualTransaction");
                Iterator it = element.getChildren("component").iterator();
                Vector<Components> vector = new Vector<Components>();
                while (it.hasNext()) {
                    Components comp = this.loadComponent((Element)it.next());
                    vector.add(comp);
                }
                if ("transaction".equals(type)) {
                    this.builTransaction(vector, action, null, null);
                    continue;
                }
                if ("manualTransaction".equals(type)) {
                    this.builTransaction(vector, action, null, idManualTransaction);
                    continue;
                }
                if (!"printer".equals(type)) continue;
                Document doc = new Document();
                Element printJob = new Element("printjob");
                doc.setRootElement(printJob);
                this.builTransaction(vector, action, printJob, null);
                String pathTemplate = element.getChildText("printerTemplate");
                String jarDirTemplates = EmakuParametersStructure.getJarDirectoryTemplates();
                try {
                    SAXBuilder sax = new SAXBuilder(false);
                    Document template = null;
                    URL url = new URL(jarDirTemplates + pathTemplate);
                    if (url != null) {
                        template = sax.build(url);
                        Element rootTemplate = template.getRootElement();
                        Attribute ATType = rootTemplate.getAttribute("type");
                        Attribute ATSilent = rootTemplate.getAttribute("silent");
                        Attribute ATCopies = rootTemplate.getAttribute("copies");
                        Attribute ATprinter = rootTemplate.getAttribute("printer");
                        boolean silent = ATSilent != null ? ATSilent.getBooleanValue() : false;
                        int copies = ATCopies != null ? ATCopies.getIntValue() : 1;
                        String typePrinter = ATType.getValue();
                        String printer = ATprinter != null && !ATprinter.getValue().trim().equals("") ? ATprinter.getValue() : null;
                        System.out.println("template path: " + jarDirTemplates + pathTemplate);
                        if ("PLAIN".equals(typePrinter)) {
                            this.plainManager.setNdocument(this.lastNumber);
                            this.plainManager.process(rootTemplate, printJob);
                            if (this.plainManager.isSuccessful()) {
                                System.out.println("========================================");
                                System.out.println(this.plainManager.toString());
                                System.out.println("========================================");
                                PrintingManager.ImpresionType IType = this.plainManager.getImpresionType();
                                ByteArrayInputStream IStream = this.plainManager.getStream();
                                new PrintingManager(IType, IStream, silent, copies, printer, 0, 0);
                            }
                            this.plainManager = new PlainPrintingManager(this.lastNumber);
                        }
                        if (!"GRAPHIC".equals(typePrinter)) continue;
                        this.postScriptManager.setNdocument(this.lastNumber);
                        this.postScriptManager.process(rootTemplate, printJob);
                        ByteArrayInputStream IStream = this.postScriptManager.getStream();
                        PrintingManager.ImpresionType IType = this.postScriptManager.getImpresionType();
                        int width = this.postScriptManager.getWidth();
                        int height = this.postScriptManager.getHeight();
                        new PrintingManager(IType, IStream, silent, copies, printer, width, height);
                        this.postScriptManager = new PostScriptManager(this.lastNumber);
                        continue;
                    }
                    System.out.println("Plantilla " + jarDirTemplates + pathTemplate + " no encontrada");
                    JOptionPane.showInternalMessageDialog(this.GFforma, "NO SE ENCONTRO LA PLANTILLA DE IMPRESION");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    System.out.println("Plantilla " + jarDirTemplates + pathTemplate + " no encontrada");
                    JOptionPane.showInternalMessageDialog(this.GFforma, "NO SE ENCONTRO LA PLANTILLA DE IMPRESION");
                }
                catch (PrintException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (JDOMException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private synchronized void builTransaction(Vector<Components> vec, String action, Element printJob, String idManualTransaction) throws InvocationTargetException, NotFoundComponentException, IOException {
        int i;
        Vector<Element> pack = new Vector<Element>();
        Element[] multielementos = null;
        Element elementos = null;
        for (i = 0; i < vec.size(); ++i) {
            Components comp = vec.get(i);
            if ("getMultiPackage".equals(comp.getMethod())) {
                multielementos = comp.isContainsArgs() ? (Element[])this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod(), new Class[]{Element.class}, new Object[]{comp.getArgs()}) : (Element[])this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod());
                for (int j = 0; j < multielementos.length; ++j) {
                    pack.addElement(multielementos[j]);
                }
                continue;
            }
            elementos = comp.isContainsArgs() ? (Element)this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod(), new Class[]{Element.class}, new Object[]{comp.getArgs()}) : (Element)this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod());
            if (elementos == null) continue;
            pack.addElement(elementos);
        }
        if (printJob == null) {
            String namePackage = !"REPORT".equals(action) ? "TRANSACTION" : this.typePackage;
            if (pack.size() > 0 || !namePackage.equals("TRANSACTION")) {
                try {
                    this.formatPackageStructure(pack, this.typePackage, idManualTransaction);
                }
                catch (MalformedProfileException e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (i = 0; i < pack.size(); ++i) {
                printJob.addContent((Content)((Element)((Element)pack.elementAt(i)).clone()));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionEvent(e.getActionCommand());
    }

    private void actionEvent(String action) {
        this.actionThread(action);
    }

    private void actionThread(String action) {
        class ActionThread
        extends Thread {
            String action;

            ActionThread(String action) {
                this.action = action;
            }

            @Override
            public void run() {
                if (this.action.equals("EXIT")) {
                    ButtonsPanel.this.close();
                } else {
                    try {
                        if (ButtonsPanel.this.Heventos.containsKey(this.action)) {
                            ButtonsPanel.this.callEvent(this.action);
                        }
                        if (ButtonsPanel.this.Hform.containsKey(this.action)) {
                            Vector vforms = (Vector)ButtonsPanel.this.Hform.get(this.action);
                            for (int i = 0; i < vforms.size(); ++i) {
                                new GenericForm(ButtonsPanel.this.GFforma, (Element)vforms.get(i));
                            }
                        }
                        JButton button = null;
                        if (this.action.equals("NEW")) {
                            button = (JButton)ButtonsPanel.this.Hbuttons.get("SAVE");
                            if (button != null) {
                                button.setEnabled(true);
                            }
                            if ((button = (JButton)ButtonsPanel.this.Hbuttons.get("SAVEAS")) != null) {
                                button.setEnabled(true);
                            }
                            button = (JButton)ButtonsPanel.this.Hbuttons.get(this.action);
                        } else if (this.action.equals("SAVE") || this.action.equals("SAVEAS")) {
                            button = (JButton)ButtonsPanel.this.Hbuttons.get("NEW");
                            if (button != null) {
                                button.setEnabled(true);
                            }
                            if ((button = (JButton)ButtonsPanel.this.Hbuttons.get("SAVEAS")) != null) {
                                button.setEnabled(true);
                            }
                            if ((button = (JButton)ButtonsPanel.this.Hbuttons.get("PRINT")) != null) {
                                button.setEnabled(true);
                            }
                            button = (JButton)ButtonsPanel.this.Hbuttons.get(this.action);
                            button.setEnabled(false);
                        }
                    }
                    catch (InvocationTargetException ITEe) {
                        ITEe.printStackTrace();
                        JOptionPane.showInternalMessageDialog(ButtonsPanel.this.GFforma.getDesktopPane(), ITEe.getCause().getMessage(), Language.getWord("ERROR_MESSAGE"), 0);
                        ((JButton)ButtonsPanel.this.Hbuttons.get(this.action)).setEnabled(true);
                    }
                    catch (NotFoundComponentException NFCEe) {
                        NFCEe.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        new ActionThread(action).start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void formatPackageStructure(Vector pack, String packageName, String idManualTransaction) throws MalformedProfileException, IOException {
        JInternalFrame jiframe;
        Document transaction = new Document();
        transaction.setRootElement(new Element(packageName));
        Element id = new Element("id");
        this.idTransaction = "T" + TransactionServerResultSet.getId();
        System.out.println("Id Transaccion :" + this.idTransaction);
        id.setText(this.idTransaction);
        Element driver = new Element("driver");
        if ("TRANSACTION".equals(packageName)) {
            if (idManualTransaction == null) {
                driver.setText(this.GFforma.getIdTransaction());
            } else {
                driver.setText(idManualTransaction);
            }
        } else if ("REPORTREQUEST".equals(packageName)) {
            if (this.idReport == null) throw new MalformedProfileException(Language.getWord("MALFORMED_PROFILE") + this.GFforma.getIdTransaction());
            driver.setText(this.idReport);
            PDFViewer pdf = new PDFViewer(this.GFforma, this.idReport);
            jiframe = pdf.getGUI().getFrame();
            this.GFforma.getJDPpanel().add(jiframe);
            try {
                jiframe.setVisible(true);
                jiframe.setSelected(true);
            }
            catch (PropertyVetoException PVEe) {
                PVEe.printStackTrace();
            }
        } else if ("XLSREPORTREQUEST".equals(packageName)) {
            if (this.idReport == null) throw new MalformedProfileException(Language.getWord("MALFORMED_PROFILE") + this.GFforma.getIdTransaction());
            Element jarFile = new Element("jarFile");
            Element jarDirectory = new Element("jarDirectory");
            jarFile.setText(EmakuParametersStructure.getParameter("jarFile"));
            jarDirectory.setText(EmakuParametersStructure.getParameter("jarDirectory"));
            transaction.getRootElement().addContent((Content)jarFile);
            transaction.getRootElement().addContent((Content)jarDirectory);
            driver.setText(this.idReport);
            XLSReceiver xlsReceiver = new XLSReceiver(this.GFforma, this.idTransaction);
            this.GFforma.getJDPpanel().add(xlsReceiver);
            try {
                xlsReceiver.setVisible(true);
                xlsReceiver.setSelected(true);
            }
            catch (PropertyVetoException PVEe) {
                PVEe.printStackTrace();
            }
        } else {
            if (!"PLAINREPORTREQUEST".equals(packageName)) throw new MalformedProfileException(Language.getWord("MALFORMED_PROFILE") + this.GFforma.getIdTransaction());
            if (this.idReport == null) throw new MalformedProfileException(Language.getWord("MALFORMED_PROFILE") + this.GFforma.getIdTransaction());
            driver.setText(this.idReport);
            TextReportViewer plainViewer = new TextReportViewer(this.GFforma, this.idReport);
            plainViewer.openViewer();
            jiframe = plainViewer;
            this.GFforma.getJDPpanel().add(jiframe);
            try {
                jiframe.setVisible(true);
                jiframe.setSelected(true);
            }
            catch (PropertyVetoException PVEe) {
                PVEe.printStackTrace();
            }
        }
        this.plainManager.setIdTransaction(this.idTransaction);
        this.postScriptManager.setIdTransaction(this.idTransaction);
        transaction.getRootElement().addContent((Content)driver);
        transaction.getRootElement().addContent((Content)id);
        if (this.GFforma.getPassword() != null) {
            Element password = new Element("password");
            password.setText(this.GFforma.getPassword());
            transaction.getRootElement().addContent((Content)password);
        }
        for (int i = 0; i < pack.size(); ++i) {
            transaction.getRootElement().addContent((Content)((Element)pack.elementAt(i)));
        }
        this.GFforma.sendTransaction(DateSender.getPackage());
        this.GFforma.sendTransaction(transaction);
        int times = 0;
        while (!this.actionFinish && !this.badActionFinish && "TRANSACTION".equals(packageName)) {
            try {
                if (times > 5000) {
                    throw new IOException();
                }
                Thread.sleep(100L);
                ++times;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!this.badActionFinish) return;
        System.out.println("Accion terminada por error ...");
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.actionEvent(((JButton)e.getSource()).getActionCommand());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public String getIdTransaction() {
        return this.idTransaction;
    }

    public void setEnabled(Element args) {
        Iterator it = args.getChildren().iterator();
        String name = null;
        String state = null;
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String value = element.getTextTrim();
            if ("button".equals(element.getAttributeValue("attribute"))) {
                name = value;
                continue;
            }
            if (!"state".equals(element.getAttributeValue("attribute"))) continue;
            state = value;
        }
        if (name != null && !"".equals(name) && state != null && !"".equals(state)) {
            if (this.Hbuttons.containsKey(name)) {
                this.Hbuttons.get(name).setEnabled(Boolean.parseBoolean(state));
            } else {
                JOptionPane.showInternalMessageDialog(this.GFforma.getDesktopPane(), Language.getWord("ERROR_BUTTON_NOT_FOUND") + name, Language.getWord("ERROR_MESSAGE"), 0);
            }
        } else {
            JOptionPane.showInternalMessageDialog(this.GFforma.getDesktopPane(), Language.getWord("ERROR_PARAMETERS_BUTTONS"), Language.getWord("ERROR_MESSAGE"), 0);
        }
    }

    public Element getLastNumber() {
        Element pack = new Element("package");
        if (this.lastNumber != null && !this.lastNumber.equals("")) {
            Element field = new Element("field");
            field.setText(this.lastNumber);
            pack.addContent((Content)field);
        }
        return pack;
    }

    @Override
    public void cathSuccesEvent(SuccessEvent e) {
        String numeration = e.getNdocument();
        if (e.getIdPackage().equals(this.idTransaction)) {
            this.lastNumber = numeration;
            this.actionFinish = true;
        }
    }

    @Override
    public void cathErrorEvent(ErrorEvent e) {
        String numeration = e.getNdocument();
        if (this.idTransaction != null && this.idTransaction.equals(e.getIdPackage())) {
            this.lastNumber = numeration;
            this.badActionFinish = true;
        }
    }
}

