/*
 * Decompiled with CFR 0.152.
 */
package common.misc.language;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Language {
    private static Hashtable<String, messageStructure> glossary = new Hashtable();

    public void loadLanguage(String lang) {
        this.loadLanguage(null, lang);
    }

    private void loadWords(Document doc) {
        Element root = doc.getRootElement();
        List words = root.getChildren("sentence");
        for (Element fields : words) {
            String message = fields.getChildText("value");
            if (fields.getChild("key").getAttribute("errorCode") != null) {
                String codeError = fields.getChild("key").getAttribute("errorCode").getValue();
                glossary.put(fields.getChildText("key"), new messageStructure(codeError, message));
                continue;
            }
            glossary.put(fields.getChildText("key"), new messageStructure(null, message));
        }
    }

    public void loadLanguage(String directory, String lang) {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            if (directory != null) {
                System.out.println("directorio: " + directory + lang + ".xml");
                this.loadWords(builder.build(directory + lang + ".xml"));
            } else {
                System.out.println("language: " + lang + ".xml");
                URL url = this.getClass().getResource("/lang/" + lang + ".xml");
                File file = new File(url.getFile());
                this.loadWords(builder.build(file));
            }
        }
        catch (JDOMException JDOMEe) {
            JDOMEe.printStackTrace();
        }
        catch (FileNotFoundException FNFEe) {
            FNFEe.printStackTrace();
        }
        catch (IOException IOEe) {
            IOEe.printStackTrace();
        }
    }

    public static String getWord(String key) {
        if (glossary.containsKey(key)) {
            return glossary.get(key).getMessage();
        }
        return key;
    }

    public static char getNemo(String key) {
        if (glossary.containsKey(key)) {
            return glossary.get(key).getMessage().charAt(0);
        }
        return ' ';
    }

    public static String getErrorCode(String key) {
        if (glossary.containsKey(key)) {
            return glossary.get(key).getErrorCode();
        }
        return key;
    }

    class messageStructure {
        private String message = null;
        private String errorCode = null;

        private messageStructure(String errorCode, String message) {
            this.errorCode = errorCode;
            this.message = message;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

