/*
 * Decompiled with CFR 0.152.
 */
package common.pdf.pdfviewer;

import common.control.ClientHeaderValidator;
import common.control.ReportEvent;
import common.control.ReportListener;
import common.gui.forms.GenericForm;
import common.misc.ZipHandler;
import common.misc.language.Language;
import common.pdf.pdfviewer.Commands;
import common.pdf.pdfviewer.Values;
import common.pdf.pdfviewer.gui.SwingGUI;
import common.pdf.pdfviewer.utils.Printer;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.ResourceBundle;
import org.jdom.Element;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfFontException;

public class PDFViewer
implements ReportListener {
    protected Values commonValues = new Values();
    protected Printer currentPrinter = new Printer();
    protected final PdfDecoder decode_pdf = new PdfDecoder();
    protected SwingGUI currentGUI = new SwingGUI(this.decode_pdf, this.commonValues);
    protected Commands currentCommands = new Commands(this.commonValues, this.currentGUI, this.decode_pdf, this.currentPrinter);
    protected String[] scalingValues;
    private Element data;
    private ZipHandler zip = new ZipHandler();
    private String idReport;

    public PDFViewer(GenericForm GFforma, String idReport) {
        this.idReport = idReport;
        this.init(null);
        this.currentGUI.init(this.scalingValues, this.currentCommands, this.currentPrinter);
        this.currentGUI.addCombo(Language.getWord("ESCALA"), Language.getWord("AUVISTA"), 252);
        this.createButtons();
        this.currentGUI.initStatus();
        ClientHeaderValidator.addReportListener(this);
    }

    private void openReport(String reportTitle, byte[] bytes) {
        String memFlag;
        String hiresFlag = System.getProperty("hires");
        if (hiresFlag != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((memFlag = System.getProperty("memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        this.commonValues.setUseHiresImage(false);
        this.commonValues.maxViewY = 0;
        if (bytes != null) {
            this.commonValues.setPdfArray(bytes);
            this.commonValues.setFileSize(bytes.length);
            this.currentGUI.setViewerTitle(reportTitle);
            String page = System.getProperty("Page");
            if (page != null) {
                int pageNum = -1;
                try {
                    pageNum = Integer.parseInt(page);
                    if (pageNum < 1) {
                        pageNum = -1;
                        System.err.println(page + " must be 1 or larger. Opening on page 1");
                    }
                }
                catch (Exception e) {
                    System.err.println(page + "is not a valid number for a page number. Opening on page 1");
                }
            } else {
                this.currentCommands.openFile();
            }
            bytes = null;
        }
    }

    protected void init(ResourceBundle bundle) {
        try {
            this.scalingValues = new String[]{Language.getWord("LARGO"), Language.getWord("ANCHO"), "25", "50", "75", "100", "125", "150", "200", "250", "500", "750", "1000"};
            this.decode_pdf.setDefaultDisplayFont("SansSerif");
        }
        catch (PdfFontException e) {
            System.out.println(e.getMessage());
            String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            System.out.println(Language.getWord("POSTSCRIPT"));
            System.out.println("=====================\n");
            int count = fontList.length;
            for (int i = 0; i < count; ++i) {
                Font f = new Font(fontList[i], 1, 10);
                System.out.println(fontList[i] + " (" + Language.getWord("FUENTESDISP") + "=" + f.getPSName() + ")");
            }
        }
    }

    private void createButtons() {
        this.currentGUI.addButton(0, Language.getWord("IMPRIREP"), "/icons/ico_impresora.png", 6);
        this.currentGUI.addButton(0, Language.getWord("GUARDARCO"), "/icons/ico_guardar.png", 5);
        this.currentGUI.addButton(0, Language.getWord("CERRAR"), "/icons/ico_cancelar.png", 7);
    }

    public SwingGUI getGUI() {
        return this.currentGUI;
    }

    @Override
    public void arriveReport(ReportEvent e) {
        if (e.getIdReport().equals(this.idReport) && !e.isPlainReport()) {
            try {
                this.data = e.getData();
                Cursor cursor = Cursor.getPredefinedCursor(0);
                this.currentGUI.getFrame().setCursor(cursor);
                if (this.data != null) {
                    byte[] bytesReport = this.zip.getDataDecode(this.data.getValue());
                    this.openReport(e.getTitleReport(), bytesReport);
                }
            }
            catch (IOException IOEe) {
                IOEe.printStackTrace();
            }
        }
    }
}

