/*
 * Decompiled with CFR 0.152.
 */
package common.pdf.printing;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.lang.reflect.Array;
import java.util.HashMap;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import org.jpedal.PdfDecoder;
import org.jpedal.utils.LogWriter;

public class SilentPrint {
    private static boolean debugCode = true;
    private final String separator = System.getProperty("file.separator");
    private PdfDecoder decode_pdf = null;
    private int copiesToPrint = 1;
    private String printer = "FinePrint";
    private String tray = null;

    public SilentPrint(String file_name) {
        if (file_name.toLowerCase().endsWith(".pdf")) {
            this.decodeAndPrintFile(file_name);
        } else {
            String[] files = null;
            File inputFiles = null;
            if (!file_name.endsWith(this.separator)) {
                file_name = file_name + this.separator;
            }
            try {
                inputFiles = new File(file_name);
                if (!inputFiles.isDirectory()) {
                    System.err.println(file_name + " is not a directory. Exiting program");
                }
                files = inputFiles.list();
            }
            catch (Exception ee) {
                LogWriter.writeLog((String)("Exception trying to access file " + ee.getMessage()));
            }
            long fileCount = files.length;
            int i = 0;
            while ((long)i < fileCount) {
                if (files[i].toLowerCase().endsWith(".pdf")) {
                    SilentPrint.logMessage(file_name + files[i]);
                    this.decodeAndPrintFile(file_name + files[i]);
                }
                ++i;
            }
        }
    }

    private void decodeAndPrintFile(String file_name) {
        try {
            SilentPrint.logMessage("Opening file :" + file_name + " to print.");
            this.decode_pdf = new PdfDecoder(true);
            this.decode_pdf.openPdfFile(file_name);
        }
        catch (Exception e) {
            this.reportError("Exception " + e + " in pdf code");
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isExtractionAllowed()) {
            SilentPrint.logMessage("Encrypted settings");
        } else {
            this.printAllCopies();
        }
        this.decode_pdf.closePdfFile();
    }

    private final void printAllCopies() {
        for (int currentCopy = 0; currentCopy < this.copiesToPrint; ++currentCopy) {
            SilentPrint.logMessage("========================");
            SilentPrint.logMessage("\nPrinting copy " + (currentCopy + 1));
            SilentPrint.logMessage("========================");
            this.printPages();
        }
    }

    private void printPages() {
        try {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            PageFormat pf = printJob.defaultPage();
            HashPrintRequestAttributeSet attributeSet = new HashPrintRequestAttributeSet();
            PrintService[] service = PrinterJob.lookupPrintServices();
            boolean matchFound = false;
            int count = service.length;
            for (int i = 0; i < count; ++i) {
                if (service[i].getName().indexOf(this.printer) == -1) continue;
                printJob.setPrintService(service[i]);
                i = count;
                matchFound = true;
            }
            if (!matchFound) {
                String list = "";
                for (int i = 0; i < count; ++i) {
                    list = list + service[i].getName() + ",";
                }
                this.reportError("Printer " + this.printer + " not supported. Options=" + list);
            } else {
                if (this.tray != null) {
                    boolean hasTrayValues = printJob.getPrintService().isAttributeCategorySupported(Media.class);
                    if (hasTrayValues) {
                        HashMap<String, Object> possibleValues = new HashMap<String, Object>();
                        Object o = printJob.getPrintService().getSupportedAttributeValues(Media.class, null, null);
                        if (o == null) {
                            SilentPrint.logMessage("Attribute Media.class not supported");
                        } else if (o.getClass().isArray()) {
                            for (int i = 0; i < Array.getLength(o); ++i) {
                                Object v = Array.get(o, i);
                                possibleValues.put(v.toString(), v);
                                SilentPrint.logMessage("Atribute values " + v.toString());
                            }
                        }
                        Object trayValue = possibleValues.get(this.tray);
                        if (trayValue != null) {
                            attributeSet.add((Attribute)trayValue);
                        }
                    } else {
                        SilentPrint.logMessage("Tray " + this.tray + " not implemented");
                        SilentPrint.logMessage("Atributes implemented are ");
                        Class<?>[] c = printJob.getPrintService().getSupportedAttributeCategories();
                        for (int j = 0; j < c.length; ++j) {
                            SilentPrint.logMessage(">>" + c[j].getName());
                        }
                    }
                }
                if (debugCode) {
                    Attribute[] attribs = attributeSet.toArray();
                    int count1 = attribs.length;
                    for (int i = 0; i < count1; ++i) {
                        SilentPrint.logMessage(i + " " + attribs[i].getName() + " " + attribs[i].toString());
                    }
                }
                Paper paper = new Paper();
                paper.setSize(595.0, 842.0);
                paper.setImageableArea(0.0, 0.0, 595.0, 842.0);
                pf.setPaper(paper);
                printJob.setCopies(1);
                this.decode_pdf.setPageFormat(pf);
                this.decode_pdf.setPagePrintRange(1, this.decode_pdf.getPageCount());
                printJob.setPageable((Pageable)this.decode_pdf);
                printJob.print();
            }
        }
        catch (Exception ee) {
            LogWriter.writeLog((String)("Exception " + ee + " printing"));
        }
        catch (Error err) {
            LogWriter.writeLog((String)("Error " + err + " printing"));
        }
    }

    private static void logMessage(String message) {
        if (debugCode) {
            System.out.println(message);
            LogWriter.writeLog((String)message);
        }
    }

    private void reportError(String message) {
        System.err.println(message);
        LogWriter.writeLog((String)message);
    }

    public static void main(String[] args) {
        SilentPrint.logMessage("Simple demo to print pages");
        if (args.length != 1) {
            SilentPrint.logMessage("File name or directory must be supplied");
        }
        String file_name = args[0];
        SilentPrint.logMessage("File :" + file_name);
        File pdf_file = new File(file_name);
        if (!pdf_file.exists()) {
            SilentPrint.logMessage("File " + file_name + " not found");
        }
    }
}

