/*
 * Decompiled with CFR 0.152.
 */
package common.printer.plainViewer;

import common.printer.plainViewer.PrinterViewsArray;
import common.printer.plainViewer.TextReportUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextReportGenerator {
    private int charactersPerLine = 80;
    private int columnsNum = 0;
    private int pagesNum = 0;
    private Vector<String> fieldsTypes = new Vector();
    private Vector<ByteArrayOutputStream> reportViews = new Vector();
    private ByteArrayOutputStream byteArray;
    private String header = "";
    private String htmlHeader = "";
    private String blankLine = "";
    private String nit = "";
    private String today = "";
    private String bar = "";
    private Vector<String> columnsNames = new Vector();
    private int[] maxlong;
    private String columnsTitle = "";
    private String htmlColumnsTitle = "";
    private String reportTitle = "";
    private String company = "";
    private int totalPages = 0;
    private PrinterViewsArray printerViews;
    private String input = "";
    private int linesPerPage = 52;
    private int fieldMax = 0;
    private boolean isComplex = false;

    public TextReportGenerator(int charactersPerLine, byte[] bytes) {
        this.charactersPerLine = charactersPerLine;
        this.input = new String(bytes);
        this.scanFirstPage();
        this.processCsv();
    }

    public void scanFirstPage() {
        int i;
        StringTokenizer tokens = new StringTokenizer(this.input, "\n");
        String line = "";
        this.bar = TextReportUtils.getBar(this.charactersPerLine) + "\n";
        line = tokens.nextToken();
        StringTokenizer varTypes = new StringTokenizer(line, "\t");
        this.columnsNum = varTypes.countTokens();
        while (varTypes.hasMoreTokens()) {
            String type = varTypes.nextToken();
            this.fieldsTypes.add(type);
        }
        this.fieldMax = this.fieldsTypes.size();
        int[] maxColumnsLength = new int[this.columnsNum];
        this.maxlong = new int[this.columnsNum];
        int lineNumber = 0;
        while (tokens.hasMoreTokens()) {
            String[] data;
            line = tokens.nextToken();
            if (++lineNumber == 1) {
                String date;
                data = TextReportUtils.getLineVars(line, 2);
                this.company = data[1];
                line = tokens.nextToken();
                data = TextReportUtils.getLineVars(line, 1);
                this.header = this.header + data[0] + "\n";
                this.nit = data[0];
                line = tokens.nextToken();
                this.today = date = this.getDate();
                this.header = this.header + date + "\n";
                this.header = this.header + this.bar;
                this.htmlHeader = this.htmlHeader + this.bar + "<br>";
                line = tokens.nextToken();
                data = TextReportUtils.getLineVars(line, 1);
                this.reportTitle = data[0];
                this.header = this.header + TextReportUtils.getCenteredString(data[0], this.charactersPerLine);
                this.htmlHeader = this.htmlHeader + "<center><b>" + this.reportTitle + "</b></center>";
                line = tokens.nextToken();
                this.columnsNames = TextReportUtils.getColumnNames(line);
                this.columnsNum = this.columnsNames.size();
                for (int i2 = 0; i2 < this.columnsNum; ++i2) {
                    String columnName = this.columnsNames.get(i2);
                    maxColumnsLength[i2] = columnName.length();
                }
                continue;
            }
            if (line.contains("eMaku")) {
                data = TextReportUtils.getLineVars(line, 3);
                this.totalPages = Integer.valueOf(data[2].trim());
                break;
            }
            Vector<String> info = TextReportUtils.getRecords(line);
            int size = info.size();
            if (size < this.fieldMax) {
                this.isComplex = true;
            }
            for (int i3 = 0; i3 < size; ++i3) {
                String field = info.get(i3);
                if (field.length() <= this.maxlong[i3]) continue;
                this.maxlong[i3] = field.length();
            }
        }
        for (i = 0; i < this.columnsNum; ++i) {
            if (maxColumnsLength[i] <= this.maxlong[i]) continue;
            this.maxlong[i] = maxColumnsLength[i];
        }
        this.blankLine = "<tr>";
        for (i = 0; i < this.columnsNum; ++i) {
            String value = TextReportUtils.getLeftAlignedString(this.columnsNames.get(i), maxColumnsLength[i]);
            String htmlValue = this.columnsNames.get(i);
            this.columnsTitle = this.columnsTitle + value + "   ";
            this.htmlColumnsTitle = this.htmlColumnsTitle + "<td><b>" + htmlValue + "</b></td><td> </td>";
            this.blankLine = this.blankLine + "<td> </td><td> </td>";
        }
        this.blankLine = this.blankLine + "</tr>";
    }

    private void processCsv() {
        try {
            this.printerViews = new PrinterViewsArray();
            String line = "";
            StringTokenizer tokens = new StringTokenizer(this.input, "\n");
            line = tokens.nextToken();
            int lineNumber = 0;
            int currentInputPage = 0;
            this.pagesNum = 0;
            int currentLines = 0;
            this.printPageHeader();
            while (tokens.hasMoreTokens()) {
                line = tokens.nextToken();
                if (++lineNumber == 1) {
                    for (int i = 0; i < 4; ++i) {
                        line = tokens.nextToken();
                    }
                    lineNumber = 4;
                    ++currentInputPage;
                    continue;
                }
                if (line.contains("eMaku")) {
                    lineNumber = 0;
                    if (currentInputPage != this.totalPages) continue;
                    if (currentLines < this.linesPerPage) {
                        int blankSpaces = this.linesPerPage - currentLines;
                        for (int i = 0; i < blankSpaces; ++i) {
                            this.printStringToReportViewer("<tr>");
                            this.printerViews.addStringToPrinterView("\n");
                            for (int j = 0; j < this.columnsNum; ++j) {
                                this.printStringToReportViewer("<td>");
                                this.printStringToReportViewer("&nbsp;");
                                this.printStringToReportViewer("</td><td>&nbsp;</td>");
                            }
                            this.printStringToReportViewer("</tr>\n");
                        }
                    }
                    this.printStringToReportViewer("</table>");
                    this.byteArray.close();
                    this.reportViews.add(this.pagesNum, this.byteArray);
                    this.printerViews.closePrinterPage();
                    break;
                }
                ++currentLines;
                Vector<String> info = TextReportUtils.getRecords(line);
                int size = info.size();
                this.printStringToReportViewer("<tr>");
                for (int i = 0; i < size; ++i) {
                    String value = "";
                    int maxlength = this.maxlong[i];
                    String field = info.get(i);
                    String side = "left";
                    if (field.startsWith("\"") && field.endsWith("\"")) {
                        field = field.substring(1, field.length() - 1);
                    }
                    if (!this.isComplex) {
                        String type = this.fieldsTypes.get(i);
                        if (type.equals("java.lang.String")) {
                            if (field.length() > maxlength) {
                                field = field.substring(0, maxlength);
                            }
                            value = TextReportUtils.getLeftAlignedString(field, maxlength);
                        }
                        if (type.equals("java.lang.Integer") || type.equals("java.lang.Float")) {
                            value = TextReportUtils.getRightAlignedString(field, maxlength);
                            side = "right";
                        }
                    } else if (TextReportUtils.isNumber(field)) {
                        value = TextReportUtils.getRightAlignedString(field, maxlength);
                        side = "right";
                    }
                    this.printStringToReportViewer("<td align=\"" + side + "\">");
                    this.printStringToReportViewer(field + "&nbsp;&nbsp;&nbsp;");
                    this.printStringToReportViewer("</td><td>|</td>");
                    this.printerViews.addStringToPrinterView(value + " | ");
                }
                if (size < this.fieldMax) {
                    int loop = this.fieldMax - size;
                    for (int i = 0; i < loop; ++i) {
                        this.printStringToReportViewer("<td></td><td></td>");
                    }
                }
                this.printStringToReportViewer("</tr>\n");
                this.printerViews.addStringToPrinterView("\n");
                if (currentLines != this.linesPerPage) continue;
                this.printStringToReportViewer("</table>");
                currentLines = 0;
                this.byteArray.close();
                this.reportViews.add(this.pagesNum, this.byteArray);
                this.printerViews.closePrinterPage();
                ++this.pagesNum;
                this.printPageHeader();
            }
        }
        catch (IOException ex) {
            System.out.println("Error: No se pudo leer el archivo");
        }
    }

    private void printPageHeader() {
        String pageLabel = "P\u00e1gina ";
        if (this.pagesNum < 10) {
            pageLabel = pageLabel + " ";
        }
        pageLabel = pageLabel + (this.pagesNum + 1);
        int length = this.charactersPerLine - (this.company.length() + pageLabel.length());
        String space = "";
        for (int i = 0; i < length; ++i) {
            space = space + " ";
        }
        this.byteArray = new ByteArrayOutputStream();
        this.printerViews.initPrinterPage(this.pagesNum);
        this.printStringToReportViewer("<body bgcolor=\"#FFFFFF\"><center><table border=\"0\" bgcolor=\"#FFFFFF\" width=\"900\"><tr></td><br>" + this.bar + "<br><table border=\"0\" width=\"882\"><tr><td>" + this.company + "</td><td align=\"right\">" + pageLabel + "</td></tr><tr><td>" + this.nit + "</td><td> </td></tr><tr><td>" + this.today + "</td><td> </td></tr></table>\n" + this.htmlHeader + this.bar + "<table border=0><tr>" + this.htmlColumnsTitle + "</tr>" + this.blankLine);
        this.printerViews.addStringToPrinterView(this.bar + this.company + space + pageLabel + "\n");
        this.printerViews.addStringToPrinterView(this.header);
        this.printerViews.activeBold();
        this.printerViews.addStringToPrinterView(this.reportTitle);
        this.printerViews.disableBold();
        this.printerViews.addStringToPrinterView("\n" + this.bar + "\n");
        this.printerViews.activeBold();
        this.printerViews.addStringToPrinterView(this.columnsTitle);
        this.printerViews.disableBold();
        this.printerViews.addStringToPrinterView("\n\n");
    }

    private void printStringToReportViewer(String textString) {
        try {
            StringBuffer buffer = new StringBuffer("");
            buffer.append(textString);
            byte[] text = buffer.toString().getBytes();
            this.byteArray.write(text, 0, text.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector<ByteArrayOutputStream> getReportViews() {
        return this.reportViews;
    }

    public Vector<ByteArrayOutputStream> getPrinterViews() {
        return this.printerViews.getReportFile();
    }

    private String getDate() {
        String newDate = "Fecha: ";
        Date now = new Date();
        SimpleDateFormat textDate = new SimpleDateFormat("dd/MM/yyyy");
        newDate = newDate + textDate.format(now);
        return newDate;
    }
}

