/*
 * Decompiled with CFR 0.152.
 */
package common.printer.plainViewer;

import java.util.StringTokenizer;
import java.util.Vector;

public class TextReportUtils {
    public static String[] getLineVars(String line, int items) {
        String[] array = new String[items];
        StringTokenizer tokens = new StringTokenizer(line, "\t");
        int i = 0;
        while (tokens.hasMoreTokens()) {
            array[i] = tokens.nextToken();
            ++i;
        }
        return array;
    }

    public static Vector<String> getRecords(String line) {
        Vector<String> records = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(line, "\t");
        while (tokens.hasMoreTokens()) {
            String data = tokens.nextToken();
            if (data == null) continue;
            records.addElement(data);
        }
        return records;
    }

    public static Vector<String> getColumnNames(String line) {
        Vector<String> columns = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(line, "\t");
        while (tokens.hasMoreTokens()) {
            columns.addElement(tokens.nextToken());
        }
        return columns;
    }

    public static String getCenteredString(String text, int maxWidth) {
        String centered = "";
        int titleLength = text.length();
        int spaces = (maxWidth - titleLength) / 2;
        for (int i = 0; i < spaces; ++i) {
            centered = centered + " ";
        }
        return centered;
    }

    public static String getRightAlignedString(String text, int maxWidth) {
        String right = "";
        int wordLength = text.length();
        int spaces = maxWidth - wordLength;
        for (int i = 0; i < spaces; ++i) {
            right = right + " ";
        }
        right = right + text;
        return right;
    }

    public static String getLeftAlignedString(String text, int maxWidth) {
        String left = "";
        int wordLength = text.length();
        int spaces = maxWidth - wordLength;
        left = left + text;
        for (int i = 0; i < spaces; ++i) {
            left = left + " ";
        }
        return left;
    }

    public static String getBar(int charactersPerLine) {
        String bar = "";
        for (int i = 0; i < charactersPerLine; ++i) {
            bar = bar + "=";
        }
        return bar;
    }

    public static boolean isNumber(String s) {
        if (s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c) || c == ',' || c == '.') continue;
            return false;
        }
        return true;
    }
}

