/*
 * Decompiled with CFR 0.152.
 */
package common.transactions;

import common.comunications.SocketConnector;
import common.comunications.SocketWriter;
import common.transactions.Cache;
import common.transactions.TransactionServerException;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class TransactionServerResultSet {
    private static Hashtable<String, Document> HspoolTransactions = new Hashtable();
    private static long id = 0L;

    public static Document getResultSetSTCache(String sql, String[] args) throws TransactionServerException {
        String total_argumentos = "";
        if (args != null) {
            for (String argumento : args) {
                total_argumentos = total_argumentos + argumento;
            }
        }
        return Cache.getAnswer(sql, total_argumentos);
    }

    private static Document getResultSetST(Document doc) throws TransactionServerException {
        String id = "Q" + TransactionServerResultSet.getId();
        doc.getRootElement().addContent((Content)new Element("id").setText(id));
        SocketChannel socket = SocketConnector.getSock();
        SocketWriter.writing(socket, doc);
        int i = 0;
        while (!HspoolTransactions.containsKey(id)) {
            try {
                Thread.sleep(10L);
                if (++i <= 90000) continue;
                throw new TransactionServerException();
            }
            catch (InterruptedException e) {
                doc = new Document();
                doc.setRootElement(new Element("ERROR"));
                SocketWriter.writing(socket, doc);
                throw new TransactionServerException();
            }
        }
        Document retorno = HspoolTransactions.get(id);
        HspoolTransactions.remove(id);
        return retorno;
    }

    public static Document getResultSetST(String codigo) throws TransactionServerException {
        return TransactionServerResultSet.getResultSetST(codigo, null);
    }

    public static Document getResultSetST(String codigo, String[] args) throws TransactionServerException {
        if (Cache.containsKey(codigo)) {
            return TransactionServerResultSet.getResultSetSTCache(codigo, args);
        }
        Document doc = new Document();
        doc.setRootElement(new Element("QUERY"));
        doc.getRootElement().addContent((Content)new Element("sql").setText(codigo));
        if (args != null) {
            Element params = new Element("params");
            for (String argumento : args) {
                params.addContent((Content)new Element("arg").setText(argumento));
            }
            doc.getRootElement().addContent((Content)params);
        }
        return TransactionServerResultSet.getResultSetST(doc);
    }

    public static void putSpoolQuery(String id, Document doc) {
        HspoolTransactions.put(id, doc);
    }

    public static synchronized String getId() {
        return String.valueOf(++id);
    }
}

