/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.misc.formulas.BeanShell;
import common.misc.language.Language;
import common.misc.log.LogAdmin;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import server.comunications.EmakuServerSocket;
import server.control.ReportsStore;
import server.database.connection.ConnectionsPool;
import server.database.connection.ConnectionsPoolException;
import server.database.sql.LinkingCache;
import server.misc.ServerConstants;
import server.misc.settings.ConfigFileHandler;
import server.misc.settings.ConfigFileNotLoadException;

public class Run {
    public Run() {
        String owner;
        String os = System.getProperty("os.name");
        if (os.equals("Linux") && (owner = System.getProperty("user.name")).equals("root")) {
            System.out.println("*** Excepci\u00f3n de Seguridad: El Servidor de Transacciones no puede ser");
            System.out.println("    ejecutado por el usuario root.");
            System.out.println("    El usuario indicado para iniciar este servicio es \"emaku\".");
            System.exit(0);
        }
        if (ServerConstants.EMAKU_HOME == null) {
            System.out.println("ERROR: Variable EMAKU_HOME is undefined! Please set it up!");
            return;
        }
        String emakuConfigFile = ServerConstants.CONF + ServerConstants.SEPARATOR + "server.conf";
        boolean existsConfigFile = new File(emakuConfigFile).exists();
        if (!existsConfigFile) {
            ConfigFileHandler.newConfigFile(emakuConfigFile);
            System.out.println("INFO: Archivo de configuracion no encontrado... creando uno nuevo...");
        }
        try {
            ConfigFileHandler.loadConfigFile(emakuConfigFile);
            ConnectionsPool.CargarBD();
            ReportsStore.Load(this.getClass().getResource("/reports"));
            LinkingCache.cargar();
            new BeanShell();
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        new EmakuServerSocket();
                    }
                    catch (IOException IOEe) {
                        LogAdmin.setMessage((String)(Language.getWord((String)"UNLOADING_ST") + " " + IOEe.getMessage()), (int)2);
                        Run.this.killServer();
                    }
                }
            };
            t.start();
        }
        catch (ConfigFileNotLoadException e) {
            ConfigFileHandler.newConfigFile(emakuConfigFile);
            if (os.startsWith("Windows")) {
                JOptionPane.showMessageDialog(new JFrame(), "El archivo de configuracion estaba corrupto y ha sido corregido. Por favor, revise el archivo server.conf y reinicie el servicio.", "Error!", 0);
            } else {
                System.out.println("ERROR #003: El archivo de configuracion estaba corrupto y ha sido corregido. Por favor, revise el archivo server.conf y reinicie el servicio.\n(" + ServerConstants.CONF + ServerConstants.SEPARATOR + "server.conf)\n");
            }
            this.killServer();
        }
        catch (ConnectionsPoolException e) {
            LogAdmin.setMessage((String)e.getErrorCode(), (String)e.getMessage(), (String)Language.getWord((String)"NODEBUG"), (int)0);
            this.killServer();
        }
    }

    public void killServer() {
        System.exit(0);
    }

    public static void main(String[] args) {
        new Run();
    }
}

