/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import common.misc.language.Language;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import server.businessrules.RunTransaction;
import server.comunications.EmakuServerSocket;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNGenericSQL {
    private Element pack;
    private QueryRunner RQtransaction;
    private String[] args;
    private boolean keyfield;
    private boolean finalKey;
    private boolean generable = true;
    private boolean discardBadArgument = false;
    private Map<String, String> keyvalue;

    public LNGenericSQL(SocketChannel sock) {
        this.keyvalue = new LinkedHashMap<String, String>();
        this.RQtransaction = new QueryRunner(EmakuServerSocket.getBd(sock));
    }

    public LNGenericSQL(SocketChannel sock, Document doc, Element sn_pack, String id_transaction) {
        this.pack = (Element)sn_pack.getChildren().iterator().next();
        this.keyvalue = new LinkedHashMap<String, String>();
        Iterator i = doc.getRootElement().getChildren().iterator();
        this.RQtransaction = new QueryRunner(EmakuServerSocket.getBd(sock));
        this.compactarArgumentos();
        this.setAutoCommit(false);
        try {
            while (i.hasNext()) {
                Element elm = (Element)i.next();
                if ("discardBadArguments".equals(elm.getAttributeValue("attribute"))) {
                    this.discardBadArgument = true;
                }
                this.generar(elm.getValue());
            }
            this.commit();
            RunTransaction.successMessage(sock, id_transaction, Language.getWord((String)"TRANSACTION_OK"));
        }
        catch (SQLNotFoundException SQLNFEe) {
            RunTransaction.errorMessage(sock, id_transaction, SQLNFEe.getMessage());
            this.rollback();
        }
        catch (SQLBadArgumentsException SQLBAEe) {
            RunTransaction.errorMessage(sock, id_transaction, SQLBAEe.getMessage());
            this.rollback();
        }
        catch (SQLException SQLe) {
            RunTransaction.errorMessage(sock, id_transaction, SQLe.getMessage());
            this.rollback();
        }
        catch (NullPointerException NPEe) {
            NPEe.printStackTrace();
            this.rollback();
        }
        this.setAutoCommit(true);
    }

    private void compactarArgumentos() {
        Iterator<String> val;
        List lista = this.pack.getChildren();
        Iterator iterador = lista.iterator();
        int countParams = this.pack.getContentSize();
        Element Efirst = (Element)iterador.next();
        String SvalueFirst = Efirst.getValue().trim();
        String SattributeFirst = Efirst.getAttributeValue("attribute");
        String SattributeName = Efirst.getAttributeValue("name");
        if (Efirst.getAttributeValue("nameField") != null && !"".equals(Efirst.getAttributeValue("nameField"))) {
            SattributeName = Efirst.getAttributeValue("nameField");
        }
        if ("".equals(SvalueFirst)) {
            countParams = 0;
        }
        if ("disableKey".equals(SattributeFirst)) {
            this.keyfield = false;
        } else if ("enableKey".equals(SattributeFirst)) {
            this.keyfield = true;
        }
        int j = 0;
        if (this.keyfield) {
            this.args = new String[countParams + this.keyvalue.size()];
            if (!"finalKey".equals(SattributeFirst)) {
                val = this.keyvalue.values().iterator();
                while (val.hasNext()) {
                    this.args[j] = val.next();
                    ++j;
                }
            } else {
                this.finalKey = true;
            }
        } else {
            this.args = new String[countParams];
        }
        if ("key".equals(SattributeFirst)) {
            this.keyfield = true;
            if (SattributeName == null) {
                SattributeName = new String("");
            }
            this.keyvalue.put(SattributeName, SvalueFirst);
        }
        if (countParams > 0) {
            this.args[j] = SvalueFirst;
        }
        ++j;
        while (iterador.hasNext()) {
            this.pack = (Element)iterador.next();
            if (this.pack.getName().equals("field")) {
                this.args[j] = !this.pack.getValue().equals("") ? this.pack.getValue() : (this.pack.getAttributeValue("attribute") != null && "NULL".equals(this.pack.getAttributeValue("attribute")) ? "NULL" : "");
                try {
                    if ("key".equals(this.pack.getAttribute("attribute").getValue())) {
                        this.keyfield = true;
                        if (SattributeName == null) {
                            SattributeName = new String("");
                        }
                        this.keyvalue.put(SattributeName, this.args[j]);
                    }
                }
                catch (NullPointerException NPEe) {
                    // empty catch block
                }
            }
            ++j;
        }
        if (this.finalKey) {
            val = this.keyvalue.values().iterator();
            int i = 0;
            while (val.hasNext()) {
                this.args[j] = val.next();
                ++i;
                ++j;
            }
            this.finalKey = false;
        }
    }

    public void generar(String sql) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        if (this.generable) {
            try {
                this.RQtransaction.ejecutarSQL(sql, this.args);
            }
            catch (SQLBadArgumentsException SQLBAEe) {
                if (!this.discardBadArgument) {
                    throw new SQLBadArgumentsException(sql);
                }
                this.discardBadArgument = false;
            }
        }
    }

    public void setArgs(Element pack, String id_transaction) {
        this.pack = pack;
        this.compactarArgumentos();
    }

    public void setArgs(String[] argUpdate, String id_transaction) {
        this.args = argUpdate;
    }

    public String getKey(int index) {
        Vector<String> vector = new Vector<String>(this.keyvalue.values());
        return vector.get(index);
    }

    public void removeKey(String key) {
        this.keyvalue.remove(key);
    }

    public void setKey(String key, String value) {
        this.keyvalue.put(key, value);
        this.keyfield = true;
    }

    public Map getKeys() {
        return this.keyvalue;
    }

    public String getArg(int index) {
        return this.args[index];
    }

    public void setAutoCommit(boolean value) {
        this.RQtransaction.setAutoCommit(value);
    }

    public void commit() {
        this.RQtransaction.commit();
    }

    public void rollback() {
        this.RQtransaction.rollback();
    }

    public boolean isGenerable() {
        return this.generable;
    }

    public void setGenerable(boolean generable) {
        this.generable = generable;
    }

    public void setDiscardBadArgument(boolean discardBadArgument) {
        this.discardBadArgument = discardBadArgument;
    }
}

