/*
 * Decompiled with CFR 0.152.
 */
package server.comunications;

import common.comunications.SocketWriter;
import common.misc.language.Language;
import common.misc.log.LogAdmin;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;
import server.comunications.EmakuServerSocket;
import server.comunications.ErrorXML;
import server.database.connection.ConnectionsPool;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLFormatAgent;
import server.database.sql.SQLNotFoundException;
import server.database.sql.StatementsClosingHandler;
import server.misc.ServerConstants;

public class ResultSetToXML
extends Document
implements Runnable {
    private static final long serialVersionUID = 6067284901344862308L;
    private String bd;
    private String sql;
    private String[] args;
    private SocketChannel sock;
    private String id;
    private ByteArrayOutputStream bufferSocket = null;

    public ResultSetToXML(String bd, String sql, SocketChannel sock, String id) {
        this.bd = bd;
        this.sql = sql;
        this.sock = sock;
        this.id = id;
    }

    public ResultSetToXML(String bd, String sql, String[] args, SocketChannel sock, String id) {
        this.bd = bd;
        this.sql = sql;
        this.args = args;
        this.sock = sock;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Connection conn = null;
        Statement st = null;
        ResultSet RSdatos = null;
        try {
            String sqlCode = null;
            while (true) {
                try {
                    while ((conn = ConnectionsPool.getMultiConnection(this.bd)) == null) {
                        System.out.println("Dio null :S");
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            st = conn.createStatement();
            this.bufferSocket = new ByteArrayOutputStream();
            XMLOutputter XMLformat = new XMLOutputter();
            sqlCode = this.args == null ? SQLFormatAgent.getSentencia(this.bd, this.sql) : SQLFormatAgent.getSentencia(this.bd, this.sql, this.args);
            System.out.println("ejecutando " + this.sql);
            RSdatos = st.executeQuery(sqlCode);
            ResultSetMetaData RSMDinfo = RSdatos.getMetaData();
            int columnas = RSMDinfo.getColumnCount();
            System.out.println("preparando para transmitir");
            SocketChannel socketChannel = this.sock;
            synchronized (socketChannel) {
                System.out.println("Transmitiendo");
                this.writeBufferSocket(this.sock, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + ServerConstants.TAGS_ANSWER[0] + ServerConstants.TAGS_ID[0] + this.id + ServerConstants.TAGS_ID[1] + ServerConstants.TAGS_HEAD[0]);
                for (int i = 1; i <= columnas; ++i) {
                    this.writeBufferSocket(this.sock, ServerConstants.TAGS_COL_HEAD[0] + XMLformat.escapeAttributeEntities(RSMDinfo.getColumnTypeName(i)) + ServerConstants.TAGS_COL_HEAD[1] + this.escapeCharacters(RSMDinfo.getColumnName(i)) + ServerConstants.TAGS_COL[1]);
                }
                this.writeBufferSocket(this.sock, ServerConstants.TAGS_HEAD[1]);
                while (RSdatos.next()) {
                    this.writeBufferSocket(this.sock, ServerConstants.TAGS_ROW[0]);
                    for (int j = 1; j <= columnas; ++j) {
                        byte[] res = RSdatos.getBytes(j);
                        if (res == null) {
                            res = new String("").getBytes();
                        }
                        this.writeBufferSocket(this.sock, ServerConstants.TAGS_COL[0] + this.escapeCharacters(new String(res, "UTF-8")) + ServerConstants.TAGS_COL[1]);
                    }
                    this.writeBufferSocket(this.sock, ServerConstants.TAGS_ROW[1]);
                }
                this.writeBufferSocket(this.sock, ServerConstants.TAGS_ANSWER[1]);
                this.bufferSocket.write(new String("\n\r\f").getBytes());
                SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)this.sock, (ByteArrayOutputStream)this.bufferSocket);
                this.bufferSocket.close();
                StatementsClosingHandler.close(RSdatos);
            }
        }
        catch (SQLNotFoundException QNFEe) {
            String err = QNFEe.getMessage();
            LogAdmin.setMessage((String)err, (int)0);
            ErrorXML error = new ErrorXML();
            SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)this.sock, (Document)error.returnError(0, this.bd, this.id, err));
            QNFEe.printStackTrace();
        }
        catch (SQLException SQLEe) {
            String err = Language.getWord((String)"ERR_RS") + " " + this.sql + " " + SQLEe.getMessage();
            LogAdmin.setMessage((String)err, (int)0);
            ErrorXML error = new ErrorXML();
            SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)this.sock, (Document)error.returnError(0, this.bd, this.id, err));
            SQLEe.printStackTrace();
        }
        catch (SQLBadArgumentsException QBAEe) {
            String err = QBAEe.getMessage();
            LogAdmin.setMessage((String)err, (int)0);
            ErrorXML error = new ErrorXML();
            SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)this.sock, (Document)error.returnError(0, this.bd, this.id, err));
            QBAEe.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            String err = e.getMessage();
            e.printStackTrace();
            LogAdmin.setMessage((String)err, (int)0);
            ErrorXML error = new ErrorXML();
            SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)this.sock, (Document)error.returnError(0, this.bd, this.id, err));
        }
        catch (IOException e) {
            String err = e.getMessage();
            e.printStackTrace();
            LogAdmin.setMessage((String)err, (int)0);
            ErrorXML error = new ErrorXML();
            SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)this.sock, (Document)error.returnError(0, this.bd, this.id, err));
        }
        finally {
            try {
                if (RSdatos != null) {
                    RSdatos.close();
                }
                if (st != null) {
                    st.close();
                }
                ConnectionsPool.freeMultiConnection(this.bd, conn);
                System.out.println("Fin de la transmision");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private String escapeCharacters(String word) {
        word = word.replaceAll("&", "&amp;");
        word = word.replaceAll("\u00f1", "&#241;");
        word = word.replaceAll("\u00d1", "&#209;");
        word = word.replaceAll("\u00e1", "&#225;");
        word = word.replaceAll("\u00e9", "&#233;");
        word = word.replaceAll("\u00ed", "&#237;");
        word = word.replaceAll("\u00f3", "&#243;");
        word = word.replaceAll("\u00fa", "&#250;");
        word = word.replaceAll("\u00c1", "&#201;");
        word = word.replaceAll("\u00c9", "&#241;");
        word = word.replaceAll("\u00cd", "&#205;");
        word = word.replaceAll("\u00d3", "&#211;");
        word = word.replaceAll("\u00da", "&#218;");
        word = word.replaceAll("<", "&lt;");
        word = word.replaceAll(">", "&gt;");
        word = word.replaceAll("'", "&apos;");
        word = word.replaceAll("\"", "&quot;");
        return word;
    }

    private void writeBufferSocket(SocketChannel sock, String data) {
        byte[] bytes = data.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (this.bufferSocket.size() < 8192) {
                this.bufferSocket.write(bytes[i]);
                continue;
            }
            SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (ByteArrayOutputStream)this.bufferSocket);
            this.bufferSocket = new ByteArrayOutputStream();
            --i;
        }
    }
}

