/*
 * Decompiled with CFR 0.152.
 */
package server.control;

import common.comunications.SocketWriter;
import common.misc.language.Language;
import common.misc.log.LogAdmin;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.businessrules.RunTransaction;
import server.comunications.AcpFailure;
import server.comunications.CacheXML;
import server.comunications.EmakuServerSocket;
import server.comunications.ErrorXML;
import server.comunications.ResultSetToXML;
import server.control.ACPSender;
import server.control.DATESender;
import server.control.QueryValidator;
import server.control.UPDATECODESender;
import server.control.UserDataStructure;
import server.database.connection.ConnectionsPool;
import server.database.sql.AccountsTotalCalculator;
import server.database.sql.LinkingCache;
import server.reports.ReportMaker;
import server.reports.XLSReportMaker;

public class HeadersValidator {
    public static void ValidClient(Document doc, SocketChannel sock) {
        Element raiz = doc.getRootElement();
        String nom_raiz = raiz.getName();
        if (EmakuServerSocket.isLoged(sock)) {
            if (nom_raiz.equals("TRANSACTION")) {
                System.out.println("Paquete TRANSACCION");
                XMLOutputter xmlOutputter = new XMLOutputter();
                xmlOutputter.setFormat(Format.getPrettyFormat());
                try {
                    xmlOutputter.output(doc, (OutputStream)System.out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                new RunTransaction(sock, doc).start();
            } else if (nom_raiz.equals("QUERY")) {
                String bd = EmakuServerSocket.getBd(sock);
                QueryValidator valida = new QueryValidator(bd, EmakuServerSocket.getLoging(sock), raiz);
                String codigo = "";
                if (valida.isValid()) {
                    codigo = raiz.getChild("sql").getValue();
                    ResultSetToXML answer = valida.changeStructParam() ? new ResultSetToXML(bd, codigo, valida.getArgs(), sock, valida.getId()) : new ResultSetToXML(bd, codigo, sock, valida.getId());
                    new Thread(answer).start();
                } else {
                    ErrorXML error = new ErrorXML();
                    String tmp = Language.getWord((String)"SQL_ACCESS_DENIED") + " " + valida.getQuery() + " " + sock.socket();
                    LogAdmin.setMessage((String)tmp, (int)2);
                    SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (Document)error.returnError(0, EmakuServerSocket.getBd(sock), valida.getId(), tmp));
                }
            } else if (nom_raiz.equals("CACHE-QUERY")) {
                String codigo = raiz.getValue();
                String bd = EmakuServerSocket.getBd(sock);
                CacheXML cache_answer = new CacheXML(bd, codigo);
                cache_answer.transmition(sock);
            } else if (nom_raiz.equals("DATE")) {
                SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (Document)DATESender.getPackage());
            } else if (nom_raiz.endsWith("TOTALACCOUNT")) {
                new AccountsTotalCalculator(EmakuServerSocket.getBd(sock), raiz);
            } else if (nom_raiz.equals("UPDATECODE")) {
                String bd = EmakuServerSocket.getBd(sock);
                String key = raiz.getChild("idDocument").getValue();
                SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (Document)UPDATECODESender.getPackage(key, LinkingCache.getConsecutive(bd, key)));
            } else if (nom_raiz.equals("PLAINREPORTREQUEST")) {
                System.out.println("Nueva solicitud de un reporte plano");
                new ReportMaker(raiz, sock, true);
            } else if (nom_raiz.equals("REPORTREQUEST")) {
                System.out.println("Nueva solicitud de un reporte");
                XMLOutputter xmlOutputter = new XMLOutputter();
                xmlOutputter.setFormat(Format.getPrettyFormat());
                try {
                    xmlOutputter.output(doc, (OutputStream)System.out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                new ReportMaker(raiz, sock, false).start();
            } else if ("XLSREPORTREQUEST".equals(nom_raiz)) {
                new XLSReportMaker(raiz, sock);
            } else {
                ErrorXML error = new ErrorXML();
                String tmp = Language.getWord((String)"ERR_FORMAT_PROTOCOL") + " " + sock.socket();
                LogAdmin.setMessage((String)tmp, (int)0);
                System.out.println("ERROR FORMATO PROTOCOLO");
                XMLOutputter xmlOutputter = new XMLOutputter();
                xmlOutputter.setFormat(Format.getPrettyFormat());
                try {
                    xmlOutputter.output(doc, (OutputStream)System.out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (Document)error.returnError(0, "", tmp));
            }
        } else if (nom_raiz.equals("CNX")) {
            if (ConnectionsPool.chekDataBase(raiz.getChild("db").getValue())) {
                UserDataStructure loguser = new UserDataStructure(raiz);
                if (loguser.valid()) {
                    String bd = loguser.getBD();
                    String login = loguser.getLogin();
                    EmakuServerSocket.setLogin(sock, bd, login);
                    ACPSender docacp = new ACPSender(sock, bd, login);
                    docacp.start();
                } else {
                    SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (Document)new AcpFailure(Language.getWord((String)"ACPFAILURE")));
                }
            } else {
                LogAdmin.setMessage((String)(Language.getWord((String)"DBNFEX") + raiz.getChild("db").getValue()), (int)0);
                SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (Document)new AcpFailure(Language.getWord((String)"ACPFAILURE")));
            }
        } else if (nom_raiz.equals("ERROR")) {
            System.out.println("Paquete ERROR");
        } else {
            System.out.println("paquete no autorizado");
        }
        doc = null;
        raiz = null;
    }

    public static void ValidAdmin(Document doc, SocketChannel sock) {
        Element raiz = doc.getRootElement();
        if (EmakuServerSocket.isLoged(sock)) {
            if (raiz.getName().equals("TRANSACCION")) {
                System.out.println("Paquete TRANSACCION");
            } else if (raiz.getName().equals("ERROR")) {
                System.out.println("Paquete ERROR");
            } else {
                ErrorXML error = new ErrorXML();
                String tmp = Language.getWord((String)"ERR_FORMAT_PROTOCOL") + " " + sock.socket();
                LogAdmin.setMessage((String)tmp, (int)0);
                SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (Document)error.returnError(0, "", tmp));
            }
        } else if (raiz.getName().equals("CNX")) {
            System.out.println("Paquete CNX");
        } else {
            System.out.println("paquete no autorizado");
        }
    }
}

