/*
 * Decompiled with CFR 0.152.
 */
package server.database.sql;

import java.util.StringTokenizer;
import server.database.sql.LinkingCache;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class SQLFormatAgent {
    public static String getSentencia(String bd, String codigo, String[] args) throws SQLNotFoundException, SQLBadArgumentsException {
        String sentencia = "";
        args = SQLFormatAgent.addSlashes(args);
        String sql = LinkingCache.getSentenciaSQL("K-" + bd + "-" + codigo);
        if (sql != null) {
            StringTokenizer STsql = new StringTokenizer(sql, "?");
            if (STsql.countTokens() - 1 == args.length) {
                boolean nulo = false;
                for (int i = 0; i < args.length; ++i) {
                    String salto = SQLFormatAgent.nullToken(STsql.nextToken(), nulo);
                    if (nulo) {
                        nulo = false;
                    }
                    if (!args[i].equals("NULL")) {
                        sentencia = sentencia + salto + args[i];
                        continue;
                    }
                    sentencia = sentencia + salto.substring(0, salto.length() - 1) + "NULL";
                    nulo = true;
                }
                sentencia = sentencia + SQLFormatAgent.nullToken(STsql.nextToken(), nulo);
                return sentencia;
            }
            System.out.println("[" + codigo + "] numero de tokens: " + (STsql.countTokens() - 1) + " numero de args: " + args.length);
            for (int i = 0; i < args.length; ++i) {
                System.out.println("argumento " + i + ": " + args[i]);
            }
            throw new SQLBadArgumentsException(codigo);
        }
        throw new SQLNotFoundException(codigo);
    }

    public static String[] addSlashes(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].replace("'", "\\'");
        }
        return args;
    }

    private static String nullToken(String value, boolean nulo) {
        if (nulo) {
            return value.substring(1);
        }
        return value;
    }

    public static String getSentencia(String bd, String codigo) throws SQLNotFoundException {
        String Query = LinkingCache.getSentenciaSQL("K-" + bd + "-" + codigo);
        if (Query != null) {
            return Query;
        }
        throw new SQLNotFoundException(codigo);
    }

    public static boolean permisoSentencia(String bd, String login, String query, String password) {
        return LinkingCache.getPermisosSQL("K-" + bd + "-" + login + "-" + query + "-" + password);
    }

    public static boolean permisoTransaccion(String bd, String login, String id_transaction, String password) {
        return LinkingCache.getPermisosTransaccion("K-" + bd + "-" + login + "-" + id_transaction + "-" + password);
    }
}

