/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import common.comunications.InfoSocket;
import common.misc.ZipHandler;
import common.misc.language.Language;
import common.misc.settings.ServerConfigFileHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.channels.SocketChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.datatype.DatatypeConfigurationException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.businessrules.AnnulDocumentException;
import server.businessrules.CacheKeys;
import server.businessrules.DontHaveBalanceException;
import server.businessrules.ElectronicDocumentException;
import server.businessrules.InvalidDateException;
import server.businessrules.LNComboInventarios;
import server.businessrules.LNContabilidad;
import server.businessrules.LNElectronicDocumentEC;
import server.businessrules.LNElectronicDocumentV21;
import server.businessrules.LNErrorProcecuteException;
import server.businessrules.LNGenericSQL;
import server.businessrules.LNInventarios;
import server.businessrules.LNSelectedField;
import server.businessrules.LNUndoSaldos;
import server.businessrules.RunTransaction;
import server.businessrules.electronicdocuments.SendDianException;
import server.comunications.SocketWriterServer;
import server.control.UPDATECODESender;
import server.database.sql.DontHaveKeyException;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNDocuments {
    private static SocketChannel sock;
    private static String idTransaction;
    private static Document doc;
    private static Element pack;
    private static LNGenericSQL LNGtransaccion;
    private static LNGenericSQL LNGdblink;
    private static double partidaDoble;
    private static String date;
    private static String minDate;
    private static boolean objectDocument;
    private static String idDocument;
    private static String linkDocument;
    private static String multiDocument;
    private static String rfDocument;
    private static String consecutive;
    private static boolean cash;
    private static boolean lockDocument;
    private static boolean notRetryDuplicate;
    private static final int D2649 = 1;
    private static final int NIIFS = 2;
    private static final int NOT_ELECTRONIC_DOCUMENT = 0;
    private static final int ELECTRONIC_INVOICE = 1;
    private static final int DEBIT_NOTE = 2;
    private static final int CREDIT_NOTE = 3;
    private static final int ANNUL_INVOICE_CREDIT_NOTE = 4;
    private static final int RETURN_INVOICE = 5;
    private static final int OBJECT_INVOICE_CREDIT_NOTE = 6;
    private static final int CONTINGECY_INVOICE = 7;
    private static final int NOMINA_ELECTRONICA = 8;
    private static final int NOMINA_AJUSTE_ELECTRONICA = 9;
    private static int dblinkID;
    private static String dblinkRandomID;
    private static String actionDocument;
    private static String bd;
    private static String ip;
    private static String mac;
    private static final String CREATE_DOCUMENT = "createDocument";
    private static final String ANNUL_DOCUMENT = "annulDocument";
    public static final String DELETE_DOCUMENT = "deleteDocument";
    public static final String EDIT_DOCUMENT = "editDocument";
    public static String ndocument;
    public static String notedocument;
    public static boolean reloadProdServ;
    public static String initProdServ;

    public static LNGenericSQL LNTransaction() {
        return LNGtransaccion;
    }

    public LNDocuments(SocketChannel sock, Document doc, Element pack, String idTransaction) {
        LNDocuments.makeTransaction(sock, doc, pack, idTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static synchronized void makeTransaction(SocketChannel _sock, Document _doc, Element _pack, String _idTransaction) {
        LNDocuments.idDocument = null;
        LNDocuments.linkDocument = null;
        LNDocuments.multiDocument = null;
        LNDocuments.rfDocument = null;
        LNDocuments.consecutive = null;
        LNDocuments.cash = false;
        LNDocuments.lockDocument = false;
        LNDocuments.reloadProdServ = false;
        LNDocuments.dblinkID = 0;
        LNDocuments.dblinkRandomID = "dblink" + System.currentTimeMillis();
        LNDocuments.objectDocument = false;
        LNDocuments.notRetryDuplicate = false;
        LNDocuments.sock = _sock;
        LNDocuments.doc = _doc;
        LNDocuments.pack = _pack;
        LNDocuments.idTransaction = _idTransaction;
        LNDocuments.partidaDoble = 0.0;
        LNUndoSaldos.clearSaldosAnteriores();
        LNDocuments.bd = InfoSocket.getBd((SocketChannel)LNDocuments.sock);
        LNDocuments.ip = InfoSocket.getIp((SocketChannel)LNDocuments.sock);
        LNDocuments.mac = InfoSocket.getMac((SocketChannel)LNDocuments.sock);
        i = LNDocuments.doc.getRootElement().getChildren().iterator();
        j = LNDocuments.pack.getChildren().iterator();
        LNDocuments.LNGtransaccion = new LNGenericSQL(LNDocuments.sock);
        LNDocuments.LNGtransaccion.setAutoCommit(false);
        CacheKeys.cleanKeys();
        try {
            m = 0;
            while (i.hasNext()) {
                block178: {
                    block179: {
                        block182: {
                            sql = (Element)i.next();
                            subpackage = (Element)j.next();
                            if (m != 0) break block182;
                            LNDocuments.getDocumentConfig(sql);
                            if (!LNDocuments.actionDocument.equals("createDocument")) ** GOTO lbl119
                            parameters = true;
                            if (LNDocuments.consecutive == null) {
                                parameters = LNDocuments.getParameters(subpackage);
                            }
                            if (parameters) {
                                if (LNDocuments.idDocument == null) {
                                    LNDocuments.idDocument = subpackage.getValue();
                                    System.out.println("idDocument: " + LNDocuments.idDocument);
                                    bd = InfoSocket.getBd((SocketChannel)LNDocuments.sock);
                                    subpackage = (Element)j.next();
                                    if (LNDocuments.consecutive != null) {
                                        LNDocuments.consecutive = LinkingCache.getConsecutive(bd, LNDocuments.idDocument);
                                    } else {
                                        LNDocuments.consecutive = subpackage.getValue();
                                        System.out.println("consecutivo: " + LNDocuments.consecutive);
                                        subpackage = (Element)j.next();
                                    }
                                }
                                if ("".equals(CacheKeys.getDate())) {
                                    dateDocument = subpackage.getValue();
                                    System.out.println("Fecha: " + dateDocument);
                                    CacheKeys.setDate(dateDocument);
                                    CacheKeys.setMinDate(dateDocument);
                                    if (i.hasNext()) {
                                        subpackage = (Element)j.next();
                                    }
                                }
                                sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:SS");
                                if (!LNDocuments.lockDocument && LinkingCache.getLockDate(LNDocuments.bd) != null && LinkingCache.getLockDate(LNDocuments.bd).getTime() > sdf.parse(CacheKeys.getDate()).getTime()) {
                                    throw new InvalidDateException();
                                }
                                if (LNDocuments.lockDocument) {
                                    LNDocuments.lockDocument = false;
                                    dateDocument = subpackage.getValue();
                                    LinkingCache.setLockDate(LNDocuments.bd, dateDocument);
                                }
                                LNDocuments.createDocument(LNDocuments.idDocument.trim());
                                LNDocuments.ndocument = LNDocuments.getDocumentKey(LNDocuments.idDocument, LNDocuments.consecutive);
                                newPack = new Element("package");
                                newPack.addContent((Content)new Element("field").setText(LNDocuments.ndocument));
                                newPack.addContent((Content)new Element("field").setText(InfoSocket.getLoging((SocketChannel)LNDocuments.sock)));
                                newPack.addContent((Content)new Element("field").setText("0"));
                                newPack.addContent((Content)new Element("field").setText(LNDocuments.ip));
                                newPack.addContent((Content)new Element("field").setText(LNDocuments.mac));
                                LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0022", newPack);
                                if (LNDocuments.linkDocument != null) {
                                    consecutiveLinkDocument = LinkingCache.getConsecutive(LNDocuments.bd, LNDocuments.linkDocument);
                                    LNDocuments.createDocument(LNDocuments.linkDocument.trim(), consecutiveLinkDocument);
                                    infoDocumentPack = new Element("package");
                                    infoDocumentPack.addContent((Content)new Element("field").setText(LNDocuments.getDocumentKey(LNDocuments.linkDocument, consecutiveLinkDocument)));
                                    infoDocumentPack.addContent((Content)new Element("field").setText(LNDocuments.ndocument));
                                    infoDocumentPack.addContent((Content)new Element("field").setText(InfoSocket.getLoging((SocketChannel)LNDocuments.sock)));
                                    if (LNDocuments.cash) {
                                        infoDocumentPack.addContent((Content)new Element("field").setText(InfoSocket.getLoging((SocketChannel)LNDocuments.sock)));
                                        LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0016", infoDocumentPack);
                                    } else {
                                        LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0017", infoDocumentPack);
                                    }
                                    newlPack = new Element("package");
                                    newlPack.addContent((Content)new Element("field").setText(LNDocuments.getDocumentKey(LNDocuments.linkDocument, consecutiveLinkDocument)));
                                    newlPack.addContent((Content)new Element("field").setText(InfoSocket.getLoging((SocketChannel)LNDocuments.sock)));
                                    newlPack.addContent((Content)new Element("field").setText("0"));
                                    newlPack.addContent((Content)new Element("field").setText(LNDocuments.ip));
                                    newlPack.addContent((Content)new Element("field").setText(LNDocuments.mac));
                                    LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0022", newlPack);
                                }
                                LNDocuments.LNGtransaccion.setKey("ndocumento", LNDocuments.ndocument);
                                infoDocumentPack = new Element("package");
                                infoDocumentPack.addContent((Content)new Element("field").setText(InfoSocket.getLoging((SocketChannel)LNDocuments.sock)));
                                if (LNDocuments.cash) {
                                    infoDocumentPack.addContent((Content)new Element("field").setText(InfoSocket.getLoging((SocketChannel)LNDocuments.sock)));
                                    LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI00O3", infoDocumentPack);
                                } else {
                                    LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI00O2", infoDocumentPack);
                                }
                            } else {
                                LNDocuments.undoTransaction(Language.getWord((String)"ERR_PARAMETERS_DOCUMENT"));
                                return;
lbl119:
                                // 1 sources

                                if (LNDocuments.actionDocument.equals("annulDocument")) {
                                    numero = subpackage.getValue();
                                    System.out.println("verificando idDocument: " + LNDocuments.idDocument);
                                    if (LNDocuments.idDocument == null) {
                                        if (!j.hasNext()) break;
                                        subpackage = (Element)j.next();
                                        LNDocuments.idDocument = subpackage.getValue();
                                        bd = InfoSocket.getBd((SocketChannel)LNDocuments.sock);
                                        if (LNDocuments.consecutive != null) {
                                            LNDocuments.consecutive = LinkingCache.getConsecutive(bd, LNDocuments.idDocument);
                                        }
                                    }
                                    primaryKey = LNDocuments.getPrimaryKey(numero);
                                    LNDocuments.consecutive = numero;
                                    if (primaryKey == null) {
                                        LNDocuments.undoTransaction(Language.getWord((String)"ERR_ANNUL_DOCUMENT_NOT_FOUND"));
                                        break;
                                    }
                                    if (!LNDocuments.isAnnullDocument(primaryKey)) {
                                        throw new AnnulDocumentException(LNDocuments.idDocument, numero);
                                    }
                                    if (LNDocuments.rfDocument != null && !LNDocuments.rfDocument.equals("")) {
                                        RQrfkey = new QueryRunner(LNDocuments.bd, "SCS0053", new String[]{primaryKey});
                                        RSrfkey = RQrfkey.ejecutarSELECT();
                                        rfKey = "";
                                        while (RSrfkey.next()) {
                                            rfKey = RSrfkey.getString(1);
                                        }
                                        if ("".equals(rfKey)) {
                                            LNDocuments.undoTransaction(Language.getWord((String)"ERR_ANNUL_RF_DOCUMENT_NOT_FOUND"));
                                            break;
                                        }
                                        tmpKey = LNDocuments.LNGtransaccion.getKey(0);
                                        LNDocuments.LNGtransaccion.removeKey("ndocumento");
                                        documentPack = new Element("package");
                                        documentPack.addContent((Content)new Element("field").setText(rfKey));
                                        LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCU0001", documentPack);
                                        LNDocuments.LNGtransaccion.setKey("ndocumento", tmpKey);
                                    }
                                    if (LNDocuments.lockDocument) {
                                        LinkingCache.reloadLockDate(LNDocuments.bd);
                                    }
                                    anullPack = new Element("package");
                                    anullPack.addContent((Content)new Element("field").setText(InfoSocket.getLoging((SocketChannel)LNDocuments.sock)));
                                    anullPack.addContent((Content)new Element("field").setText("2"));
                                    anullPack.addContent((Content)new Element("field").setText(LNDocuments.ip));
                                    anullPack.addContent((Content)new Element("field").setText(LNDocuments.mac));
                                    LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0022", anullPack);
                                    documentPack = new Element("package");
                                    documentPack.addContent((Content)new Element("field"));
                                    LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCU0001", documentPack);
                                    if (!i.hasNext()) break;
                                    subpackage = (Element)j.next();
                                    LNDocuments.ndocument = LNDocuments.LNGtransaccion.getKey(0);
                                } else if (LNDocuments.actionDocument.equals("deleteDocument")) {
                                    numero = subpackage.getValue();
                                    if (!i.hasNext()) break;
                                    subpackage = (Element)j.next();
                                    if (LNDocuments.idDocument == null) {
                                        LNDocuments.idDocument = subpackage.getValue();
                                        bd = InfoSocket.getBd((SocketChannel)LNDocuments.sock);
                                        if (LNDocuments.consecutive != null) {
                                            LNDocuments.consecutive = LinkingCache.getConsecutive(bd, LNDocuments.idDocument);
                                        }
                                    }
                                    key = LNDocuments.getPrimaryKey(numero);
                                    anullPack = new Element("package");
                                    anullPack.addContent((Content)new Element("field").setText(InfoSocket.getLoging((SocketChannel)LNDocuments.sock)));
                                    anullPack.addContent((Content)new Element("field").setText("3"));
                                    anullPack.addContent((Content)new Element("field").setText(LNDocuments.ip));
                                    anullPack.addContent((Content)new Element("field").setText(LNDocuments.mac));
                                    LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0023", anullPack);
                                    if ("".equals(CacheKeys.getDate())) {
                                        dateDocument = subpackage.getValue();
                                        CacheKeys.setDate(dateDocument);
                                        CacheKeys.setMinDate(dateDocument);
                                        if (i.hasNext()) {
                                            subpackage = (Element)j.next();
                                        }
                                    }
                                    if (key == null) {
                                        LNDocuments.undoTransaction(Language.getWord((String)"ERR_DELETE_DOCUMENT_NOT_FOUND"));
                                        break;
                                    }
                                } else if (LNDocuments.actionDocument.equals("editDocument")) {
                                    numero = subpackage.getValue();
                                    if (!i.hasNext()) break;
                                    subpackage = (Element)j.next();
                                    System.out.println("idDocument: " + LNDocuments.idDocument + " consecutive " + LNDocuments.consecutive);
                                    if (LNDocuments.idDocument == null) {
                                        LNDocuments.idDocument = subpackage.getValue();
                                        bd = InfoSocket.getBd((SocketChannel)LNDocuments.sock);
                                        if (i.hasNext()) {
                                            subpackage = (Element)j.next();
                                        }
                                        if (LNDocuments.consecutive != null) {
                                            LNDocuments.consecutive = LinkingCache.getConsecutive(bd, LNDocuments.idDocument);
                                        }
                                    }
                                    key = LNDocuments.getPrimaryKey(numero);
                                    editPack = new Element("package");
                                    editPack.addContent((Content)new Element("field").setText(InfoSocket.getLoging((SocketChannel)LNDocuments.sock)));
                                    editPack.addContent((Content)new Element("field").setText("1"));
                                    editPack.addContent((Content)new Element("field").setText(LNDocuments.ip));
                                    editPack.addContent((Content)new Element("field").setText(LNDocuments.mac));
                                    LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0022", editPack);
                                    if ("".equals(CacheKeys.getDate())) {
                                        dateDocument = subpackage.getValue();
                                        CacheKeys.setDate(dateDocument);
                                        CacheKeys.setMinDate(dateDocument);
                                        if (i.hasNext()) {
                                            subpackage = (Element)j.next();
                                        }
                                    }
                                    LNDocuments.updateDateDocument(key, CacheKeys.getDate());
                                }
                            }
                            try {
                                sql = (Element)i.next();
                            }
                            catch (NoSuchElementException NEEe) {
                                break;
                            }
                            System.out.println("pasando al LN");
                        }
                        if (sql.getName().equals("arg")) {
                            System.out.println("SQL: " + sql.getValue());
                            if ("addKey".equals(sql.getAttributeValue("attribute"))) {
                                LNDocuments.LNGtransaccion.setGenerable(false);
                            } else if ("removeKey".equals(sql.getAttributeValue("attribute"))) {
                                LNDocuments.LNGtransaccion.removeKey(sql.getValue());
                                CacheKeys.removeKey(sql.getValue());
                                LNDocuments.LNGtransaccion.setGenerable(false);
                            } else if ("saveImage".equals(sql.getAttributeValue("attribute"))) {
                                System.out.println("tiene una imagen...");
                                LNDocuments.LNGtransaccion.setGenerable(true);
                                LNDocuments.LNGtransaccion.setSaveImage(true);
                            } else {
                                LNDocuments.LNGtransaccion.setGenerable(true);
                            }
                            if (((Element)subpackage.getChildren().iterator().next()).getName().equals("field")) {
                                out = new XMLOutputter();
                                out.setFormat(Format.getPrettyFormat());
                                if ("discardBadArguments".equals(sql.getAttributeValue("attribute"))) {
                                    LNDocuments.LNGtransaccion.setDiscardBadArgument(true);
                                }
                                LNDocuments.getTransaction(LNDocuments.LNGtransaccion, sql.getValue(), subpackage);
                            } else {
                                LNDocuments.getfields(LNDocuments.LNGtransaccion, sql.getValue(), subpackage);
                            }
                            break block178;
                        }
                        if (!sql.getName().equals("subarg")) break block179;
                        for (Element subargs : sql.getChildren()) {
                            if ("addKey".equals(subargs.getAttributeValue("attribute"))) {
                                LNDocuments.LNGtransaccion.setGenerable(false);
                            } else if ("removeKey".equals(subargs.getAttributeValue("attribute"))) {
                                LNDocuments.LNGtransaccion.removeKey(subargs.getValue());
                                CacheKeys.removeKey(subargs.getValue());
                                LNDocuments.LNGtransaccion.setGenerable(false);
                            } else {
                                LNDocuments.LNGtransaccion.setGenerable(true);
                            }
                            System.out.println("SQL: " + subargs.getValue());
                            if (subargs.getName().equals("arg")) {
                                if (((Element)subpackage.getChildren().iterator().next()).getName().equals("field")) {
                                    LNDocuments.getTransaction(LNDocuments.LNGtransaccion, subargs.getValue(), subpackage);
                                    continue;
                                }
                                LNDocuments.getfields(LNDocuments.LNGtransaccion, subargs.getValue(), subpackage);
                                continue;
                            }
                            if (subargs.getName().equals("LNData")) {
                                if (((Element)subpackage.getChildren().iterator().next()).getName().equals("field")) {
                                    LNDocuments.validLNData(subargs, subpackage);
                                    continue;
                                }
                                for (Element epack : subpackage.getChildren()) {
                                    LNDocuments.validLNData(subargs, epack);
                                }
                                continue;
                            }
                            LNDocuments.undoTransaction(Language.getWord((String)"ERR_PACKAGE_NOT_FOUND") + " " + subargs.getValue());
                            return;
                        }
                    }
                    if (sql.getName().equals("LNData")) {
                        System.out.println("SQL: " + sql.getValue());
                        if (((Element)subpackage.getChildren().iterator().next()).getName().equals("field")) {
                            LNDocuments.validLNData(sql, subpackage);
                        } else {
                            for (Element epack : subpackage.getChildren()) {
                                LNDocuments.validLNData(sql, epack);
                            }
                        }
                    } else if (sql.getName().equals("multiDocument")) {
                        repeat = Integer.parseInt(subpackage.getValue());
                        e = new Element("multipackage");
                        n = 0;
                        while (j.hasNext()) {
                            sb = (Element)((Element)j.next()).clone();
                            e.addContent((Content)sb);
                            System.out.println("paquete " + n++ + " valor " + sb.getValue());
                        }
                        LNDocuments.LNGtransaccion.setGenerable(true);
                        for (h = 0; h < repeat; ++h) {
                            CacheKeys.cleanKeys();
                            CacheKeys.setDate(LNDocuments.date);
                            CacheKeys.setDate(LNDocuments.minDate);
                            LNDocuments.LNGtransaccion.setGenerable(true);
                            System.out.println("Documento " + h);
                            LNDocuments.LNGtransaccion.removeKey("ndocumento");
                            consecutiveLinkDocument = LinkingCache.getConsecutive(LNDocuments.bd, LNDocuments.multiDocument);
                            LNDocuments.createDocument(LNDocuments.multiDocument.trim(), consecutiveLinkDocument);
                            keyDocument = LNDocuments.getDocumentKey(LNDocuments.multiDocument, consecutiveLinkDocument);
                            infoDocumentPack = new Element("package");
                            infoDocumentPack.addContent((Content)new Element("field").setText(LNDocuments.getDocumentKey(LNDocuments.multiDocument, consecutiveLinkDocument)));
                            infoDocumentPack.addContent((Content)new Element("field").setText(LNDocuments.ndocument));
                            infoDocumentPack.addContent((Content)new Element("field").setText(InfoSocket.getLoging((SocketChannel)LNDocuments.sock)));
                            if (LNDocuments.cash) {
                                infoDocumentPack.addContent((Content)new Element("field").setText(InfoSocket.getLoging((SocketChannel)LNDocuments.sock)));
                                LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0016", infoDocumentPack);
                            } else {
                                LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0017", infoDocumentPack);
                            }
                            LNDocuments.LNGtransaccion.setKey("ndocumento", keyDocument);
                            isubargs = sql.getChildren().iterator();
                            ipackage = e.getChildren().iterator();
                            while (isubargs.hasNext()) {
                                subargs = (Element)isubargs.next();
                                msubpackage = (Element)ipackage.next();
                                if ("addKey".equals(subargs.getAttributeValue("attribute"))) {
                                    LNDocuments.LNGtransaccion.setGenerable(false);
                                } else if ("removeKey".equals(subargs.getAttributeValue("attribute"))) {
                                    LNDocuments.LNGtransaccion.removeKey(subargs.getValue());
                                    CacheKeys.removeKey(subargs.getValue());
                                    LNDocuments.LNGtransaccion.setGenerable(false);
                                } else {
                                    LNDocuments.LNGtransaccion.setGenerable(true);
                                }
                                if (subargs.getName().equals("arg")) {
                                    if (((Element)msubpackage.getChildren().iterator().next()).getName().equals("field")) {
                                        LNDocuments.getTransaction(LNDocuments.LNGtransaccion, subargs.getValue(), msubpackage);
                                        continue;
                                    }
                                    LNDocuments.getfields(LNDocuments.LNGtransaccion, subargs.getValue(), msubpackage);
                                    continue;
                                }
                                if (subargs.getName().equals("LNData")) {
                                    if (((Element)msubpackage.getChildren().iterator().next()).getName().equals("field")) {
                                        LNDocuments.validLNData(subargs, msubpackage);
                                        continue;
                                    }
                                    for (Element epack : msubpackage.getChildren()) {
                                        LNDocuments.validLNData(subargs, epack);
                                    }
                                    continue;
                                }
                                LNDocuments.undoTransaction(Language.getWord((String)"ERR_PACKAGE_NOT_FOUND") + " " + subargs.getValue());
                                return;
                            }
                            idActivo = CacheKeys.getKey("idActivo");
                            LinkingCache.incrementeConsecutive(LNDocuments.bd, LNDocuments.multiDocument, idActivo);
                        }
                        LNDocuments.multiDocument = null;
                    } else {
                        LNDocuments.undoTransaction(Language.getWord((String)"ERR_PACKAGE_NOT_FOUND") + " " + sql.getName());
                        return;
                        catch (NoSuchElementException NSEEe) {
                            NSEEe.printStackTrace();
                        }
                    }
                }
                ++m;
            }
            if (LNDocuments.partidaDoble == 0.0) {
                type_document = LinkingCache.getIdDocumentoElectronico(LNDocuments.bd, LNDocuments.idDocument);
                ElectronicDocument = null;
                ElectronicDocumentEC = null;
                id_codigo_retorno_dian = "00";
                if ("createDocument".equals(LNDocuments.actionDocument)) {
                    if (!ServerConfigFileHandler.isSendBashElectronicDocuments((String)LNDocuments.bd) && type_document != 0 && ServerConfigFileHandler.getLocation().equals("es_CO")) {
                        RQdata = new QueryRunner(LNDocuments.bd, "SCSDE0019", new String[]{LNDocuments.idDocument, LNDocuments.consecutive});
                        RSdata = RQdata.ejecutarSELECT();
                        RSdata.next();
                        id_codigo_retorno_dian = RSdata.getString("codigo_retorno_dian").trim();
                        salto = RSdata.getInt("salto");
                        RSdata.close();
                        System.out.println("Codigo de retorno dian: " + id_codigo_retorno_dian);
                        if (!id_codigo_retorno_dian.trim().equals("00")) {
                            if (id_codigo_retorno_dian.trim().equals("EE")) {
                                System.out.println("Con error anterior pero con verificacion");
                            } else {
                                throw new ElectronicDocumentException(id_codigo_retorno_dian);
                            }
                        }
                        if (salto != 0) {
                            throw new ElectronicDocumentException(null, "Error en consecutivos de documentos");
                        }
                    } else if (ServerConfigFileHandler.isSendBashElectronicDocuments((String)LNDocuments.bd) || type_document == 0 || ServerConfigFileHandler.getLocation().equals("es_EC")) {
                        // empty if block
                    }
                    System.out.println("-------------------------------verificando " + LNDocuments.bd + " - " + LNDocuments.idDocument);
                    if (type_document != 0 && ServerConfigFileHandler.getLocation().equals("es_CO")) {
                        ElectronicDocument = new LNElectronicDocumentV21<E>(LNDocuments.bd, LinkingCache.getIdDocumentoElectronico(LNDocuments.bd, LNDocuments.idDocument), LNDocuments.idDocument, LNDocuments.consecutive, LNDocuments.idTransaction);
                        ElectronicDocument.generateElectronicDocument();
                    } else if (type_document != 0 && ServerConfigFileHandler.getLocation().equals("es_EC")) {
                        ElectronicDocumentEC = new LNElectronicDocumentEC(LNDocuments.bd);
                    }
                } else if ("annulDocument".equals(LNDocuments.actionDocument)) {
                    System.out.println("SCSDE0020 args: " + LNDocuments.idDocument);
                    RQdata = new QueryRunner(LNDocuments.bd, "SCSDE0020", new String[]{LNDocuments.idDocument});
                    RSdata = RQdata.ejecutarSELECT();
                    if (RSdata.next()) {
                        id_codigo_retorno_dian = RSdata.getString("codigo_retorno_dian");
                        id_codigo_retorno_dian = id_codigo_retorno_dian != null ? id_codigo_retorno_dian.trim() : "00";
                        RSdata.close();
                    }
                    if ((1 == LinkingCache.getIdDocumentoElectronico(LNDocuments.bd, LNDocuments.idDocument) || 7 == LinkingCache.getIdDocumentoElectronico(LNDocuments.bd, LNDocuments.idDocument)) && ServerConfigFileHandler.getLocation().equals("es_CO")) {
                        id_usuario = InfoSocket.getLoging((SocketChannel)LNDocuments.sock);
                        System.out.println("Codigo de retorno dian: " + id_codigo_retorno_dian);
                        if ("00".equals(id_codigo_retorno_dian) || "EE".equals(id_codigo_retorno_dian)) {
                            if (LNDocuments.objectDocument) {
                                System.out.println("Se fue por object");
                                ElectronicDocument = new LNElectronicDocumentV21<E>(LNDocuments.bd, 6, LNDocuments.consecutive, LNDocuments.idTransaction, id_usuario, LNDocuments.idDocument);
                            } else {
                                System.out.println("Se fue por anular desktop");
                                ElectronicDocument = new LNElectronicDocumentV21<E>(LNDocuments.bd, 4, LNDocuments.consecutive, LNDocuments.idTransaction, id_usuario, LNDocuments.idDocument);
                            }
                            ElectronicDocument.generateElectronicDocument();
                        } else {
                            System.out.println("No se genera nota credito por objetacion, se procede a realizar anulacion local");
                            updateIdRetornoDian = new Element("package");
                            updateIdRetornoDian.addContent((Content)new Element("field").setText(LNDocuments.ndocument));
                            LNDocuments.LNGtransaccion.removeAllKeys();
                            LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCSDEU001", updateIdRetornoDian);
                        }
                    } else if (1 != LinkingCache.getIdDocumentoElectronico(LNDocuments.bd, LNDocuments.idDocument) && 7 != LinkingCache.getIdDocumentoElectronico(LNDocuments.bd, LNDocuments.idDocument) || ServerConfigFileHandler.getLocation().equals("es_EC")) {
                        // empty if block
                    }
                }
                if (LNDocuments.dblinkID != 0) {
                    LNDocuments.dblinkCommit();
                    System.out.println("commit paralelo ok..");
                }
                LNDocuments.LNGtransaccion.commit();
                econsecutive = new Element("ndocument");
                endocument = new Element("internaldocument");
                enotedocument = new Element("notedocument");
                date = new Element("date");
                fechadoc = CacheKeys.getDate();
                date.setText(fechadoc);
                econsecutive.setText(LNDocuments.consecutive);
                endocument.setText(LNDocuments.ndocument);
                enotedocument.setText(LNDocuments.notedocument);
                System.out.println("tipo de documento: " + type_document + " id_codigo_retorno_dian: " + id_codigo_retorno_dian);
                if (type_document == 0 || !"00".equals(id_codigo_retorno_dian)) {
                    System.out.println("transaccion documento no electronico.....");
                    RunTransaction.successMessage(LNDocuments.sock, LNDocuments.idTransaction, Language.getWord((String)"TRANSACTION_OK"), econsecutive, endocument, date);
                } else if (ServerConfigFileHandler.getLocation().equals("es_CO")) {
                    System.out.println("transaccion con cufe.....");
                    RunTransaction.successMessage(LNDocuments.sock, LNDocuments.idTransaction, Language.getWord((String)"TRANSACTION_OK"), econsecutive, endocument, enotedocument, date, ElectronicDocument.getQRCUFE(), ElectronicDocument.getProcessDate());
                } else if (ServerConfigFileHandler.getLocation().equals("es_EC")) {
                    System.out.println("transaccion con clave de Acceso.....");
                    RunTransaction.successMessage(LNDocuments.sock, LNDocuments.idTransaction, Language.getWord((String)"TRANSACTION_OK"), econsecutive, endocument, date, ElectronicDocumentEC.getClaveAcceso());
                }
                if ("createDocument".equals(LNDocuments.actionDocument)) {
                    System.out.println("Se creo un documento, avanzando consecutivo...");
                    idActivo = CacheKeys.getKey("idActivo");
                    LinkingCache.incrementeConsecutive(LNDocuments.bd, LNDocuments.idDocument, idActivo);
                    if (LNDocuments.linkDocument != null) {
                        System.out.println("Se creo un documento enlace, avanzando consecutivo...");
                        LinkingCache.incrementeConsecutive(LNDocuments.bd, LNDocuments.linkDocument, idActivo);
                    }
                } else if ("deleteDocument".equals(LNDocuments.actionDocument)) {
                    LinkingCache.reloadConsecutive(LNDocuments.bd, LNDocuments.idDocument);
                    if (LNDocuments.linkDocument != null) {
                        idActivo = CacheKeys.getKey("idActivo");
                        LinkingCache.incrementeConsecutive(LNDocuments.bd, LNDocuments.linkDocument, idActivo);
                    }
                }
                if (LNDocuments.reloadProdServ) {
                    System.out.println("Recargando asientos predefinidos...");
                    LinkingCache.reloadAsientosPr(InfoSocket.getBd((SocketChannel)LNDocuments.sock), "SCS0092", new String[]{LNDocuments.initProdServ});
                    LNDocuments.reloadProdServ = false;
                    System.out.println("asientos predefinidos recargados...");
                }
                if ("annulDocument".equals(LNDocuments.actionDocument)) {
                    idActivo = CacheKeys.getKey("idActivo");
                    SocketWriterServer.writing(LNDocuments.sock, UPDATECODESender.getPackage(LNDocuments.idDocument, LNDocuments.consecutive, idActivo));
                }
            } else {
                LNDocuments.undoTransaction(Language.getWord((String)"ERR_DONT_HAVE_BALANCE_EXCEPTION") + " " + LNDocuments.partidaDoble);
            }
        }
        catch (SQLNotFoundException SQLNFEe) {
            SQLNFEe.printStackTrace();
            LNDocuments.undoTransaction(SQLNFEe.getMessage());
        }
        catch (SQLBadArgumentsException SQLBAEe) {
            SQLBAEe.printStackTrace();
            LNDocuments.undoTransaction(SQLBAEe.getMessage());
        }
        catch (SQLException SQLe) {
            System.out.println("por sqlException e");
            SQLe.printStackTrace();
            LNDocuments.undoTransaction(SQLe.getMessage());
        }
        catch (NullPointerException NPEe) {
            NPEe.printStackTrace();
            LNDocuments.undoTransaction(NPEe.getMessage());
        }
        catch (SecurityException SEe) {
            SEe.printStackTrace();
            LNDocuments.undoTransaction(SEe.getMessage());
        }
        catch (IllegalArgumentException IAEe) {
            IAEe.printStackTrace();
            LNDocuments.undoTransaction(IAEe.getMessage());
        }
        catch (ClassNotFoundException CNFEe) {
            CNFEe.printStackTrace();
            LNDocuments.undoTransaction(CNFEe.getMessage());
        }
        catch (NoSuchMethodException NSMEe) {
            NSMEe.printStackTrace();
            LNDocuments.undoTransaction(NSMEe.getMessage());
        }
        catch (InstantiationException IEe) {
            IEe.printStackTrace();
            LNDocuments.undoTransaction(IEe.getMessage());
        }
        catch (IllegalAccessException IAEe) {
            IAEe.printStackTrace();
            LNDocuments.undoTransaction(IAEe.getMessage());
        }
        catch (InvocationTargetException ITEe) {
            ITEe.printStackTrace();
            LNDocuments.undoTransaction(ITEe.getLocalizedMessage());
        }
        catch (LNErrorProcecuteException LNEPEe) {
            LNEPEe.printStackTrace();
            LNDocuments.undoTransaction(LNEPEe.getMessage());
        }
        catch (DontHaveKeyException DHEe) {
            DHEe.printStackTrace();
            LNDocuments.undoTransaction(DHEe.getMessage());
        }
        catch (DontHaveBalanceException DHBEe) {
            DHBEe.printStackTrace();
            LNDocuments.undoTransaction(DHBEe.getMessage());
        }
        catch (AnnulDocumentException ADEe) {
            LNDocuments.undoTransaction(ADEe.getMessage());
        }
        catch (ParseException e) {
            LNDocuments.undoTransaction(e.getMessage());
        }
        catch (InvalidDateException IDEe) {
            LNDocuments.undoTransaction(IDEe.getMessage());
        }
        catch (InterruptedException e) {
            LNDocuments.undoTransaction(e.getMessage());
        }
        catch (IOException e) {
            LNDocuments.undoTransaction(e.getMessage());
        }
        catch (DatatypeConfigurationException e) {
            LNDocuments.undoTransaction(e.getMessage());
        }
        catch (ElectronicDocumentException e) {
            LNDocuments.undoTransaction(e.getMessage());
        }
        catch (SendDianException e) {
            try {
                if (LNDocuments.dblinkID != 0) {
                    LNDocuments.dblinkCommit();
                }
                LNDocuments.LNGtransaccion.commit();
                System.out.println("Almacenada con errores de validacion en la Dian");
                System.out.println("Documento con errores de validacion, no se avanza consecutivo y se reemplaza codigo_tipo");
                LNDocuments.failSendDianException(e.getMessage());
            }
            catch (SQLException e1) {
                e1.printStackTrace();
                LNDocuments.undoTransaction(e.getMessage());
            }
            catch (SQLNotFoundException e1) {
                e1.printStackTrace();
                LNDocuments.undoTransaction(e.getMessage());
            }
            catch (SQLBadArgumentsException e1) {
                e1.printStackTrace();
                LNDocuments.undoTransaction(e.getMessage());
            }
            System.out.println("commit paralelo ok..");
        }
        catch (Exception e) {
            e.printStackTrace();
            LNDocuments.undoTransaction(e.getMessage());
        }
        finally {
            System.out.println("Limpiando llaves exportadas..");
            CacheKeys.setKeys(new Hashtable<K, V>());
            System.out.println("llaves limpias...");
        }
        System.out.println("autoCommit en true..");
        LNDocuments.LNGtransaccion.setAutoCommit(true);
        System.out.println("Liberando metodo sincronizado");
    }

    private static void updateDateDocument(String key, String date) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        QueryRunner RQupdateDateDocument = new QueryRunner(bd, "SCU0004", new String[]{date, key});
        RQupdateDateDocument.ejecutarSQL();
        RQupdateDateDocument.closeStatement();
    }

    private static boolean isAnnullDocument(String keyDocument) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        boolean annul = true;
        QueryRunner RQkey = new QueryRunner(bd, "SCS0045", new String[]{keyDocument});
        ResultSet RSdatos = RQkey.ejecutarSELECT();
        while (RSdatos.next()) {
            annul = RSdatos.getBoolean(1);
        }
        RSdatos.close();
        RQkey.closeStatement();
        return annul;
    }

    private static String getPrimaryKey(String numero) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        String primaryKey = null;
        QueryRunner RQkey = new QueryRunner(bd, "SCS0024", new String[]{idDocument, numero});
        ResultSet RSdatos = RQkey.ejecutarSELECT();
        while (RSdatos.next()) {
            primaryKey = RSdatos.getString(1);
        }
        LNGtransaccion.setKey("ndocumento", primaryKey);
        CacheKeys.setKeys(LNGtransaccion.getKeys());
        RSdatos.close();
        RQkey.closeStatement();
        return primaryKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void validLNData(Element args, Element pack) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, LNErrorProcecuteException, SQLBadArgumentsException, SQLNotFoundException, SQLException, DontHaveKeyException, DontHaveBalanceException, InterruptedException {
        LNInventarios LNIprocesar;
        Iterator i = args.getChildren().iterator();
        String driver = null;
        String method = null;
        Element parameters = null;
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (name.equals("driver")) {
                driver = e.getValue();
                continue;
            }
            if (name.equals("method")) {
                method = e.getValue();
                continue;
            }
            if (!name.equals("parameters")) continue;
            parameters = e;
        }
        if ("LNInventarios".equals(driver)) {
            LNIprocesar = new LNInventarios(parameters, InfoSocket.getBd((SocketChannel)sock));
            if (method.equals("movimientos")) {
                LNIprocesar.movimientos(pack);
                return;
            } else {
                if (!method.equals("traslados")) throw new NoSuchMethodException(method);
                LNIprocesar.traslados(pack);
            }
            return;
        } else if ("LNContabilidad".equals(driver) || "LNContabilidadD2649".equals(driver) || "LNContabilidadNIIFS".equals(driver)) {
            LNContabilidad LNCprocesar = parameters != null ? ("LNContabilidad".equals(driver) ? new LNContabilidad(parameters, InfoSocket.getBd((SocketChannel)sock)) : ("LNContabilidadD2649".equals(driver) ? new LNContabilidad(parameters, InfoSocket.getBd((SocketChannel)sock), 1) : new LNContabilidad(parameters, InfoSocket.getBd((SocketChannel)sock), 2))) : ("LNContabilidad".equals(driver) ? new LNContabilidad(InfoSocket.getBd((SocketChannel)sock)) : ("LNContabilidadD2649".equals(driver) ? new LNContabilidad(InfoSocket.getBd((SocketChannel)sock), 1) : new LNContabilidad(InfoSocket.getBd((SocketChannel)sock), 2)));
            if ("columnData".equals(method)) {
                partidaDoble += LNCprocesar.columnData(pack);
            } else if ("fieldData".equals(method)) {
                partidaDoble += LNCprocesar.fieldData(pack);
            } else if ("columnDataAccount".equals(method)) {
                partidaDoble += LNCprocesar.columDataAccount(pack);
            } else if ("rowDataAccount".equals(method)) {
                partidaDoble += LNCprocesar.rowDataAccount(pack);
            } else if ("rowDataAccountSC".equals(method)) {
                partidaDoble += LNCprocesar.rowDataAccountSC(pack);
            } else if ("anular".equals(method)) {
                LNCprocesar.anular();
            } else if ("recover".equals(method)) {
                LNCprocesar.recover();
            } else if (!"recoverDocument".equals(method) && !"recoverCost".equals(method)) {
                if (!DELETE_DOCUMENT.equals(method)) throw new NoSuchMethodException(Language.getWord((String)"NO_SUCH_METHOD") + method);
                LNCprocesar.deleteDocument();
            }
            try {
                BigDecimal bigDecimal = new BigDecimal(partidaDoble);
                bigDecimal = bigDecimal.setScale(2, 4);
                partidaDoble = bigDecimal.doubleValue();
                return;
            }
            catch (NumberFormatException numberFormatException) {}
            return;
        } else if ("LNSelectedField".equals(driver)) {
            LNSelectedField LNSprocesar = new LNSelectedField(parameters, InfoSocket.getBd((SocketChannel)sock));
            LNSprocesar.getFields(pack);
            return;
        } else if ("LNComboInventarios".equals(driver)) {
            LNIprocesar = new LNComboInventarios(parameters, InfoSocket.getBd((SocketChannel)sock));
            if (method.equals("movimientos")) {
                ((LNComboInventarios)LNIprocesar).movimientos(pack);
                return;
            } else {
                if (!method.equals("traslados")) throw new NoSuchMethodException(method);
                ((LNComboInventarios)LNIprocesar).traslados(pack);
            }
            return;
        } else {
            LNDocuments.validExternalClass(driver, method, parameters, pack);
        }
    }

    private static void validExternalClass(String driver, String method, Element parameters, Element pack) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> cls = Class.forName(driver);
        Class[] type_args_constructor = new Class[]{LNGenericSQL.class};
        Object[] args_constructor = new Object[]{LNGtransaccion};
        if (method != null) {
            type_args_constructor = new Class[]{Element.class, String.class, String.class};
            args_constructor = new Object[]{parameters, InfoSocket.getBd((SocketChannel)sock), idTransaction};
        }
        Constructor<?> cons = cls.getConstructor(type_args_constructor);
        Object obj = cons.newInstance(args_constructor);
        Method meth = cls.getMethod(method, Element.class);
        meth.invoke(obj, pack);
    }

    private static void getTransactionWithOutKeys(LNGenericSQL LNGtransaccion, String sql, Element pack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        System.out.println("SQL: " + sql);
        LNGtransaccion.removeAllKeys();
        LNGtransaccion.setArgs(pack, idTransaction);
        LNGtransaccion.generarTransacConnection(sql);
    }

    private static void getTransaction(LNGenericSQL LNGtransaccion, String sql, Element pack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException, IOException {
        System.out.println("SQL: " + sql);
        LNGtransaccion.setArgs(pack, idTransaction);
        LNGtransaccion.generarTransacConnection(sql);
        CacheKeys.setKeys(LNGtransaccion.getKeys());
        if (LNGtransaccion.isSaveImage()) {
            System.out.println("guardando imagen desde get...");
            List l = pack.getChildren();
            String fileName = ((Element)l.get(0)).getValue();
            ZipHandler zip = new ZipHandler();
            byte[] bytesImage = null;
            try {
                bytesImage = zip.getDataDecode(((Element)l.get(1)).getValue());
                System.out.println("fue por label");
            }
            catch (NullPointerException e) {
                fileName = ((Element)l.get(2)).getValue();
                System.out.println("nombre: " + fileName);
                bytesImage = zip.getDataDecode(((Element)l.get(3)).getValue());
                System.out.println("fue por table");
            }
            String path = "/home/emaku/images/" + LNGtransaccion.getKey(1);
            File directory = new File(path);
            if (!directory.exists()) {
                directory.mkdirs();
                System.out.println("El directorio no existe, creando directorio");
            } else {
                System.out.println("directorio existente, guardando foto");
            }
            System.out.println("guardando archivo");
            File fileImage = new File(path + "/" + fileName);
            FileOutputStream fos = new FileOutputStream(fileImage);
            fos.write(bytesImage);
            fos.flush();
            fos.close();
        }
    }

    private static void getfields(LNGenericSQL LNGtransaccion, String sql, Element pack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException, IOException {
        for (Element subpackage : pack.getChildren()) {
            LNDocuments.getTransaction(LNGtransaccion, sql, subpackage);
        }
    }

    private static String getDocumentKey(String idDocument, String consecutive) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        String primaryKey = null;
        System.out.println("argumentos SCS0024: " + idDocument + "," + consecutive);
        QueryRunner RQkey = new QueryRunner(bd, "SCS0024", new String[]{idDocument, consecutive});
        ResultSet RSdatos = RQkey.ejecutarSELECT();
        while (RSdatos.next()) {
            primaryKey = RSdatos.getString(1);
        }
        RSdatos.close();
        RQkey.closeStatement();
        return primaryKey;
    }

    private static void createDocument(String idDocument) throws SQLException, SQLNotFoundException, SQLBadArgumentsException, IOException {
        Element documentPack = new Element("package");
        documentPack.addContent((Content)new Element("field").setText(idDocument));
        documentPack.addContent((Content)new Element("field").setText(consecutive.trim()));
        documentPack.addContent((Content)new Element("field").setText(CacheKeys.getDate().trim()));
        try {
            LNDocuments.getTransaction(LNGtransaccion, "SCI00O1", documentPack);
        }
        catch (SQLException sqle) {
            if (!notRetryDuplicate) {
                System.out.println("-------------------------------------------------");
                System.out.println("reintentando insercion de documento por SQLException");
                System.out.println("--------------------------------------------------");
                sqle.printStackTrace();
                System.out.println("--------------------------------------------------");
                LNGtransaccion.rollback();
                LinkingCache.reloadConsecutive(bd, idDocument);
                consecutive = LinkingCache.getConsecutive(bd, idDocument).trim();
                System.out.println("Recargando consecutivo por error de duplicacion");
                Element documentPackreload = new Element("package");
                documentPackreload.addContent((Content)new Element("field").setText(idDocument));
                documentPackreload.addContent((Content)new Element("field").setText(consecutive));
                documentPackreload.addContent((Content)new Element("field").setText(CacheKeys.getDate().trim()));
                LNDocuments.getTransaction(LNGtransaccion, "SCI00O1", documentPackreload);
            }
            throw new SQLException("Numeraci\u00f3n de documento duplicada");
        }
    }

    private static void createDocument(String idDocument, String consecutive) throws SQLException, SQLNotFoundException, SQLBadArgumentsException, IOException {
        Element documentPack = new Element("package");
        documentPack.addContent((Content)new Element("field").setText(idDocument));
        documentPack.addContent((Content)new Element("field").setText(consecutive.trim()));
        documentPack.addContent((Content)new Element("field").setText(CacheKeys.getDate().trim()));
        LNDocuments.getTransaction(LNGtransaccion, "SCI00O1", documentPack);
    }

    private static void dblinkBegin() throws SQLException, SQLNotFoundException, SQLBadArgumentsException, IOException {
        Element documentPack = new Element("package");
        documentPack.addContent((Content)new Element("field").setText(dblinkRandomID));
        documentPack.addContent((Content)new Element("field").setText(String.valueOf(dblinkID)));
        System.out.println("randomid: " + dblinkRandomID);
        LNDocuments.getTransaction(LNGtransaccion, "SCSDBLNK1", documentPack);
    }

    private static void dblinkCommit() throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Element documentPack = new Element("package");
        System.out.println("randomid: " + dblinkRandomID);
        documentPack.addContent((Content)new Element("field").setText(dblinkRandomID));
        LNDocuments.getTransactionWithOutKeys(LNGtransaccion, "SCSDBLNK2", documentPack);
    }

    private static void dblinkRollback() throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        System.out.println("randomid: " + dblinkRandomID);
        Element documentPack = new Element("package");
        documentPack.addContent((Content)new Element("field").setText(dblinkRandomID));
        documentPack.addContent((Content)new Element("field").setText(dblinkRandomID));
        LNDocuments.getTransactionWithOutKeys(LNGtransaccion, "SCSDBLNK3", documentPack);
    }

    private static boolean getParameters(Element config) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException {
        for (Element subpackage : config.getChildren()) {
            String value = subpackage.getValue();
            if (!"consecutive".equals(subpackage.getAttributeValue("attribute"))) continue;
            consecutive = value;
        }
        return true;
    }

    private static void getDocumentConfig(Element config) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException {
        for (Element subpackage : config.getChildren()) {
            String value = subpackage.getValue();
            if (subpackage.getAttributeValue("attribute").equals("idDocument")) {
                idDocument = value;
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("linkDocument")) {
                linkDocument = value;
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("multiDocument")) {
                multiDocument = value;
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("rfDocument")) {
                rfDocument = value;
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("consecutive")) {
                String bd = InfoSocket.getBd((SocketChannel)sock);
                consecutive = LinkingCache.getConsecutive(bd, idDocument);
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("date")) {
                GregorianCalendar fecha = new GregorianCalendar();
                SimpleDateFormat formato = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                date = formato.format(fecha.getTime());
                minDate = formato.format(fecha.getTime());
                CacheKeys.setDate(formato.format(fecha.getTime()));
                CacheKeys.setMinDate(formato.format(fecha.getTime()));
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("actionDocument")) {
                actionDocument = subpackage.getValue();
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("cash")) {
                cash = true;
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("objectDocument")) {
                objectDocument = true;
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("lockDocument")) {
                lockDocument = true;
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("reloadProdServ")) {
                reloadProdServ = true;
                System.out.println("Voy por reload..");
                QueryRunner RQtransaction = new QueryRunner(InfoSocket.getBd((SocketChannel)sock), "SCS0093");
                ResultSet rs = RQtransaction.ejecutarSELECT();
                initProdServ = "85000";
                if (!rs.next()) continue;
                initProdServ = rs.getString(1);
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("dblinkID")) {
                dblinkID = Integer.valueOf(subpackage.getValue());
                System.out.println("Almacenamiento Paralelo a id: " + dblinkID);
                System.out.println("identificador: " + dblinkRandomID);
                try {
                    LNDocuments.dblinkBegin();
                    System.out.println("begin para almacenamiento paralelo...");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (SQLNotFoundException e) {
                    e.printStackTrace();
                }
                catch (SQLBadArgumentsException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!subpackage.getAttributeValue("attribute").equals("notRetryDuplicate")) continue;
            notRetryDuplicate = true;
        }
    }

    private static void failSendDianException(String message) {
        Element error = new Element("error");
        Element ndocument = new Element("ndocument");
        Element endocument = new Element("internaldocument");
        ndocument.setText(consecutive);
        error.addContent((Content)ndocument);
        error.addContent((Content)endocument);
        endocument.setText(LNDocuments.ndocument);
        System.out.println("consecutivo: " + consecutive + " transaccion " + idTransaction + " internal_ndocument: " + LNDocuments.ndocument);
        RunTransaction.errorMessage(sock, idTransaction, message, error);
    }

    private static void undoTransaction(String message) {
        try {
            System.out.println("en undo commit es ? " + LNGtransaccion.getAutoCommit(bd));
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        LNGtransaccion.rollback();
        System.out.println("Transaccion rollbackeada");
        if (dblinkID != 0) {
            try {
                LNDocuments.dblinkRollback();
                System.out.println("Rollback paralelo ok..");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (SQLNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLBadArgumentsException e) {
                e.printStackTrace();
            }
        }
        LNUndoSaldos.undoSaldos();
        Element ndocument = new Element("ndocument");
        ndocument.setText(consecutive);
        System.out.println("consecutivo: " + consecutive + " transaccion " + idTransaction);
        RunTransaction.errorMessage(sock, idTransaction, message, ndocument);
    }

    public static String getActionDocument() {
        return actionDocument;
    }

    public static void setActionDocument(String actionDocument) {
        LNDocuments.actionDocument = actionDocument;
    }

    static {
        partidaDoble = 0.0;
    }
}

