/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import common.comunications.InfoSocket;
import common.misc.language.Language;
import java.io.File;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import server.businessrules.CacheKeys;
import server.businessrules.LNGenericSQL;
import server.businessrules.RunTransaction;
import server.businessrules.electronicdocuments.PrintXML;
import server.businessrules.electronicdocuments.SendDianException;
import server.businessrules.electronicdocuments.SignedDocument;
import server.database.connection.ConnectionsPool;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNSendWSDIAN {
    private static SocketChannel sock;
    private static String idTransaction;
    private static Document doc;
    private static Element pack;
    private static String idDocument;
    private static String consecutive;
    private static String bd;
    private static String ip;
    private static String mac;
    private static String ndocument;
    private static String urlAmbiente;
    private static Connection conn;
    private static int id_tipo_ambiente;
    private static final int ELECTRONIC_INVOICE = 1;
    private static final String AMBIENTE_PRODUCCION = "1";
    private static final String AMBIENTE_PRUEBAS = "2";
    private static LNGenericSQL LNGtransaccion;

    public LNSendWSDIAN(SocketChannel sock, Document doc, Element pack, String idTransaction) throws SendDianException {
        System.out.println("Procesando envio de ws");
        LNSendWSDIAN.makeTransaction(sock, doc, pack, idTransaction);
    }

    private static synchronized void makeTransaction(SocketChannel _sock, Document _doc, Element _pack, String _idTransaction) throws SendDianException {
        sock = _sock;
        doc = _doc;
        pack = _pack;
        idTransaction = _idTransaction;
        Iterator i = doc.getRootElement().getChildren().iterator();
        Iterator j = pack.getChildren().iterator();
        bd = InfoSocket.getBd((SocketChannel)sock);
        ip = InfoSocket.getIp((SocketChannel)sock);
        mac = InfoSocket.getMac((SocketChannel)sock);
        LNGtransaccion = new LNGenericSQL(sock);
        LNGtransaccion.setAutoCommit(false);
        CacheKeys.cleanKeys();
        LNSendWSDIAN.getDate();
        try {
            int m = 0;
            while (i.hasNext()) {
                Element config = (Element)i.next();
                Element subpackage = (Element)j.next();
                if (m == 0) {
                    LNSendWSDIAN.getDocumentConfig(config);
                    if (idDocument.equals("multi")) {
                        idDocument = subpackage.getChildText("field");
                        System.out.println("idDocument es multi, viene del perfil, valor de perfil: " + idDocument);
                        subpackage = (Element)j.next();
                    }
                    consecutive = LinkingCache.getConsecutive(bd, idDocument);
                    LNSendWSDIAN.createDocument(idDocument.trim(), consecutive.trim());
                    ndocument = LNSendWSDIAN.getDocumentKey(idDocument, consecutive);
                    LNSendWSDIAN.saveLogRegister();
                    String fecha = subpackage.getChildText("field");
                    System.out.println("fecha a procesar: " + fecha + " ndocument " + ndocument);
                    LNSendWSDIAN.sendRequest(fecha, ndocument);
                }
                ++m;
            }
            LNSendWSDIAN.sendOk();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
    }

    private static boolean sendRequest(String date, String ndocumentows) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException, CertificateException, UnsupportedOperationException, IOException, DatatypeConfigurationException, SOAPException, SendDianException {
        ResultSet RSdata = null;
        conn = ConnectionsPool.getConnection(bd);
        QueryRunner RQdata = new QueryRunner(bd, "SCSDE0008");
        RSdata = RQdata.ejecutarMTSELECT(conn);
        RSdata.next();
        urlAmbiente = RSdata.getString("url_ambiente");
        id_tipo_ambiente = RSdata.getInt("id_tipo_ambiente");
        RSdata.close();
        RQdata = new QueryRunner(bd, "SCSDE0010", new String[]{date});
        RSdata = RQdata.ejecutarMTSELECT(conn);
        while (RSdata.next()) {
            try {
                String file = RSdata.getString("file");
                file = "/home/emaku/ElectronicDocuments/" + file;
                String ndocumento = RSdata.getString("ndocumento");
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                File f = new File(file);
                org.w3c.dom.Document document = db.parse(f);
                org.w3c.dom.Document docEpes = PrintXML.parser(document);
                SignedDocument sign = new SignedDocument(bd, ndocumento, idTransaction, 1, LNGtransaccion);
                sign.signEpes(urlAmbiente, id_tipo_ambiente, docEpes, file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        RSdata.close();
        return true;
    }

    private static String getDocumentKey(String idDocument, String consecutive) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        String primaryKey = null;
        QueryRunner RQkey = new QueryRunner(bd, "SCS0024", new String[]{idDocument, consecutive});
        ResultSet RSdatos = RQkey.ejecutarSELECT();
        while (RSdatos.next()) {
            primaryKey = RSdatos.getString(1);
        }
        RSdatos.close();
        RQkey.closeStatement();
        return primaryKey;
    }

    private static void saveLogRegister() throws SQLException, SQLNotFoundException, SQLBadArgumentsException, IOException {
        Element newPack = new Element("package");
        newPack.addContent((Content)new Element("field").setText(ndocument));
        newPack.addContent((Content)new Element("field").setText(InfoSocket.getLoging((SocketChannel)sock)));
        newPack.addContent((Content)new Element("field").setText("0"));
        newPack.addContent((Content)new Element("field").setText(ip));
        newPack.addContent((Content)new Element("field").setText(mac));
        LNSendWSDIAN.getTransaction(LNGtransaccion, "SCI0022", newPack);
    }

    private static void sendOk() {
        LNGtransaccion.commit();
        System.out.println("Se creo un documento enlace, avanzando consecutivo del prefijo: " + idDocument);
        LinkingCache.incrementeConsecutive(bd, idDocument, null);
        Element econsecutive = new Element("ndocument");
        Element endocument = new Element("internalndocument");
        Element date = new Element("date");
        String fechadoc = CacheKeys.getDate();
        date.setText(fechadoc);
        econsecutive.setText(consecutive);
        endocument.setText(ndocument);
        RunTransaction.successMessage(sock, idTransaction, Language.getWord((String)"TRANSACTION_OK"), econsecutive, endocument, date);
    }

    private static void getDate() {
        GregorianCalendar fecha = new GregorianCalendar();
        SimpleDateFormat formato = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        CacheKeys.setDate(formato.format(fecha.getTime()));
        CacheKeys.setMinDate(formato.format(fecha.getTime()));
    }

    private static void createDocument(String idDocument, String consecutive) throws SQLException, SQLNotFoundException, SQLBadArgumentsException, IOException {
        Element documentPack = new Element("package");
        documentPack.addContent((Content)new Element("field").setText(idDocument));
        documentPack.addContent((Content)new Element("field").setText(consecutive));
        documentPack.addContent((Content)new Element("field").setText(CacheKeys.getDate().trim()));
        try {
            LNSendWSDIAN.getTransaction(LNGtransaccion, "SCI00O1", documentPack);
        }
        catch (SQLException sqle) {
            System.out.println("-------------------------------------------------");
            System.out.println("reintentando insercion de documento por SQLException");
            System.out.println("--------------------------------------------------");
            sqle.printStackTrace();
            System.out.println("--------------------------------------------------");
            LNGtransaccion.rollback();
            LinkingCache.reloadConsecutive(bd, idDocument);
            consecutive = LinkingCache.getConsecutive(bd, idDocument);
            System.out.println("Recargando consecutivo por error de duplicacion");
            Element documentPackreload = new Element("package");
            documentPackreload.addContent((Content)new Element("field").setText(idDocument));
            documentPackreload.addContent((Content)new Element("field").setText(consecutive));
            documentPackreload.addContent((Content)new Element("field").setText(CacheKeys.getDate().trim()));
            LNSendWSDIAN.getTransaction(LNGtransaccion, "SCI00O1", documentPackreload);
        }
    }

    private static void getTransaction(LNGenericSQL LNGtransaccion, String sql, Element pack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException, IOException {
        System.out.println("SQL: " + sql);
        LNGtransaccion.setArgs(pack, idTransaction);
        LNGtransaccion.generarTransacConnection(sql);
        CacheKeys.setKeys(LNGtransaccion.getKeys());
    }

    private static void getDocumentConfig(Element config) {
        for (Element subpackage : config.getChildren()) {
            String value = subpackage.getValue();
            if (!subpackage.getAttributeValue("attribute").equals("idDocument")) continue;
            idDocument = value;
        }
    }
}

